/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.image.sc;

import java.io.File;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.dataimport.AbstractImportInfo;
import se.prediktera.map.dataimport.AbstractImportPanel;
import se.prediktera.map.dataimport.ImportInterface;
import se.prediktera.map.dataimport.image.sc.ScDataSource;
import se.prediktera.map.dataimport.image.sc.ScImportPanel;

public class ScImportInfo
extends AbstractImportInfo {
    public static final String[] extArray = new String[]{"sc"};
    public static final String DESCRIPTION = "Telops Files (*.sc)";

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String[] getExt() {
        return extArray;
    }

    @Override
    public boolean requireHeaderFile() {
        return false;
    }

    @Override
    public boolean supportCalibration() {
        return false;
    }

    @Override
    public boolean supportDataSource() {
        return false;
    }

    @Override
    public String toString() {
        return "SC";
    }

    @Override
    protected AbstractImportPanel createImportPanel(ImportInterface importInterface) throws Exception {
        return new ScImportPanel(importInterface);
    }

    @Override
    public boolean isMultiLayer() {
        return true;
    }

    @Override
    public String getPreviewDescription(File file) {
        try {
            ScDataSource.ScImage scImage = ScDataSource.parse(ProgressManager.createEmpty(), file, false);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html><body><b>");
            stringBuffer.append(jopensaveDialog.getFileName(file));
            stringBuffer.append("</b><br>");
            stringBuffer.append("<table cellpadding=\"0\">");
            this.addRow(stringBuffer, "Pixels", scImage.width);
            this.addRow(stringBuffer, "Lines", scImage.height);
            this.addRow(stringBuffer, "Bands", scImage.numBands);
            stringBuffer.append("</table>");
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return super.getPreviewDescription(file);
        }
    }

    private void addRow(StringBuffer stringBuffer, String string, double d) {
        this.addRow(stringBuffer, string, NiceDataFormat.toString(d));
    }

    private void addRow(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append("<tr><td><font size=\"3\">");
        stringBuffer.append(string);
        stringBuffer.append("</font></td><td><font size=\"3\">");
        stringBuffer.append(string2);
        stringBuffer.append("</font></td></tr>");
    }
}

