/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.image.sif;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.SortedMap;
import java.util.TreeMap;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataimport.AbstractDataSource;
import se.prediktera.map.dataimport.FastDecimal;

public class SifDataSource
extends AbstractDataSource {
    private SifImage image;
    private int currentLayer;
    private final File file;

    public SifDataSource(File[] fileArray, byte by) {
        super(by);
        this.file = fileArray[0];
        this.setForceMultiLayer(true);
    }

    @Override
    public void init(ProgressManager progressManager) {
        if (this.image != null) {
            return;
        }
        this.image = SifDataSource.parse(progressManager, this.file, true);
        this.rows = this.image.height;
        this.columns = this.image.width;
        this.dataType = this.image.getDataSize() == 1 ? 0 : 1;
    }

    @Override
    public String getInformation() {
        return null;
    }

    @Override
    public byte getNodeType() {
        return 5;
    }

    @Override
    public byte getTreeType() {
        return 17;
    }

    @Override
    public String getName() {
        return "SIF";
    }

    @Override
    public void refreshDataSourceLocal(ProgressManager progressManager) throws IOException {
    }

    @Override
    public Object getValueAt_Transpose(int n, int n2) {
        return null;
    }

    @Override
    public FastDecimal getDoubleAt_Transpose(int n, int n2, FastDecimal fastDecimal) {
        return fastDecimal.setValue(this.image.pixels[n][n2][this.currentLayer]);
    }

    @Override
    public double getDirectDoubleAtNoMissing(int n, int n2, int n3) {
        return this.image.pixels[n][n2][n3];
    }

    @Override
    public final void setCurrentLayer(int n) {
        this.currentLayer = n;
    }

    @Override
    public int[] getDataOrder() {
        return new int[]{0, 1, 2};
    }

    @Override
    public final int getLayerCount() {
        return this.image.depth;
    }

    @Override
    public String getLayerName(int n) {
        if (this.image.wavelength != null && n < this.image.wavelength.length) {
            return this.image.wavelength[n];
        }
        return NiceDataFormat.toString(n + 1);
    }

    @Override
    public int[] getDefaultBand() {
        return this.image.defaultband;
    }

    @Override
    public void setDefaultBand(int[] nArray) {
        this.image.defaultband = nArray;
    }

    @Override
    public boolean hasMissing() {
        return false;
    }

    @Override
    public boolean supportMultiThread() {
        return true;
    }

    public static SifImage parse(ProgressManager progressManager, File file, boolean bl) {
        SifImage sifImage;
        block15: {
            FileChannel fileChannel = FileChannel.open(file.toPath(), StandardOpenOption.READ);
            try {
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1024);
                StringBuilder stringBuilder = new StringBuilder();
                long l = 0L;
                boolean bl2 = false;
                while (fileChannel.read(byteBuffer) > 0 && !bl2) {
                    byteBuffer.flip();
                    while (byteBuffer.hasRemaining()) {
                        char c = (char)byteBuffer.get();
                        ++l;
                        stringBuilder.append(c);
                        if (stringBuilder.length() < 8 || !stringBuilder.substring(0, 8).equals("SS1.6.MD")) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) continue;
                    byteBuffer.compact();
                }
                if (!bl2) {
                    throw new IOException("Invalid file format. Expected header 'SS1.6.MD' not found.");
                }
                SifImage sifImage2 = new SifImage();
                ByteBuffer byteBuffer2 = ByteBuffer.allocate(512);
                fileChannel.read(byteBuffer2);
                byteBuffer2.flip();
                sifImage2.width = byteBuffer2.getInt();
                sifImage2.height = byteBuffer2.getInt();
                sifImage2.depth = byteBuffer2.getInt();
                sifImage2.maxval = byteBuffer2.getInt();
                byte[] byArray = new byte[256];
                byteBuffer2.get(byArray);
                String string = new String(byArray).trim();
                sifImage2.wavelength = string.split(";");
                sifImage2.depth = (int)Math.max((long)sifImage2.depth, (file.length() - l) / (long)sifImage2.width / (long)sifImage2.height / (long)sifImage2.getDataSize());
                if (bl) {
                    progressManager.setInfoText("Reading data");
                    sifImage2.pixels = new int[sifImage2.height][sifImage2.width][sifImage2.depth];
                    fileChannel.position(l);
                    boolean bl3 = sifImage2.maxval <= 255;
                    progressManager.setMaximumAndReset(sifImage2.height);
                    ByteBuffer byteBuffer3 = ByteBuffer.allocate(sifImage2.width * sifImage2.depth * sifImage2.getDataSize());
                    for (int i = 0; i < sifImage2.height; ++i) {
                        int[][] nArray = sifImage2.pixels[i];
                        byteBuffer3.clear();
                        fileChannel.read(byteBuffer3);
                        byteBuffer3.flip();
                        for (int j = 0; j < sifImage2.width; ++j) {
                            int[] nArray2 = nArray[j];
                            for (int k = 0; k < sifImage2.depth; ++k) {
                                nArray2[k] = bl3 ? byteBuffer3.get() & 0xFF : byteBuffer3.getShort() & 0xFFFF;
                            }
                        }
                        progressManager.incStep();
                    }
                }
                sifImage = sifImage2;
                if (fileChannel == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (fileChannel != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
            fileChannel.close();
        }
        return sifImage;
    }

    static void main() {
        File file = new File("Z:\\Upload\\SIF file format (oskar)\\IR.sif");
        SifImage sifImage = SifDataSource.parse(ProgressManager.createEmpty(), file, true);
        System.out.println("Width: " + sifImage.width);
        System.out.println("Height: " + sifImage.height);
        System.out.println("Depth: " + sifImage.depth);
    }

    public static class SifImage {
        public int width;
        public int height;
        public int depth;
        public int maxval;
        public int[][][] pixels;
        public SortedMap<String, String> metadata = new TreeMap<String, String>();
        public int[] defaultband;
        public String[] wavelength;

        public int getDataSize() {
            return this.maxval <= 255 ? 1 : 2;
        }
    }
}

