/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.image.sif;

import java.io.File;
import java.util.Map;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.dataimport.AbstractImportInfo;
import se.prediktera.map.dataimport.AbstractImportPanel;
import se.prediktera.map.dataimport.ImportInterface;
import se.prediktera.map.dataimport.image.sif.SifDataSource;
import se.prediktera.map.dataimport.image.sif.SifImportPanel;
import se.prediktera.map.datasetcontainer.DataTreeInterface;

public class SifImportInfo
extends AbstractImportInfo {
    public static final String[] extArray = new String[]{"sif"};
    public static final String DESCRIPTION = "Sif file format (*.sif)";

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String[] getExt() {
        return extArray;
    }

    @Override
    public boolean supportData(DataTreeInterface dataTreeInterface) {
        return false;
    }

    @Override
    public String toString() {
        return "SIF";
    }

    @Override
    protected AbstractImportPanel createImportPanel(ImportInterface importInterface) throws Exception {
        return new SifImportPanel(importInterface);
    }

    @Override
    public boolean isMultiLayer() {
        return true;
    }

    @Override
    public String getPreviewDescription(File file) {
        try {
            SifDataSource.SifImage sifImage = SifDataSource.parse(ProgressManager.createEmpty(), file, false);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html><body><b>");
            stringBuffer.append(jopensaveDialog.getFileName(file));
            stringBuffer.append("</b><br>");
            stringBuffer.append("<table cellpadding=\"0\">");
            this.addRow(stringBuffer, "Pixels", sifImage.width);
            this.addRow(stringBuffer, "Lines", sifImage.height);
            this.addRow(stringBuffer, "Bands", sifImage.depth);
            this.addRow(stringBuffer, "Max", sifImage.maxval);
            for (Map.Entry<String, String> entry : sifImage.metadata.entrySet()) {
                this.addRow(stringBuffer, entry.getKey(), entry.getValue());
            }
            stringBuffer.append("</table>");
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return super.getPreviewDescription(file);
        }
    }

    private void addRow(StringBuffer stringBuffer, String string, double d) {
        this.addRow(stringBuffer, string, NiceDataFormat.toString(d));
    }

    private void addRow(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append("<tr><td><font size=\"3\">");
        stringBuffer.append(string);
        stringBuffer.append("</font></td><td><font size=\"3\">");
        stringBuffer.append(string2);
        stringBuffer.append("</font></td></tr>");
    }
}

