/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.jdf;

import java.io.IOException;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.dataimport.ImportInterface;
import se.prediktera.map.dataimport.jdf.JdfReader;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class JdfDataSource
extends CellIdentifierModel {
    private final JdfReader.Observations obs;
    private String[] titles = null;

    public JdfDataSource(JdfReader.Observations observations, ImportInterface importInterface) throws IOException, IndexOutOfBoundsException {
        super(observations.getObservationCount() + 1, observations.getWavelengthCount(0) + (importInterface.includeFileNames() ? 1 : 0));
        this.obs = observations;
        if (importInterface.includeFileNames()) {
            this.titles = new String[observations.getObservationCount()];
            for (int i = 0; i < observations.getObservationCount(); ++i) {
                this.titles[i] = observations.getHeaderValue(i, "TITLE");
                if (this.titles[i] != null) continue;
                this.titles[i] = "Obs: " + i;
            }
        }
    }

    @Override
    public void autoIdentifyData(ProgressManager progressManager, int n) {
        this.addInterval(0, 0, (byte)0);
        this.setPrimaryRow(0);
        if (this.titles != null) {
            this.addInterval(1, 0, (byte)1);
            this.setPrimaryCol(0);
        }
    }

    @Override
    public FastDecimal getDoubleAt_Transpose(int n, int n2, FastDecimal fastDecimal) {
        if (n == 0) {
            return fastDecimal.error();
        }
        if (this.titles != null) {
            if (n2 == 0) {
                return fastDecimal.error();
            }
            --n2;
        }
        fastDecimal.setValue(this.obs.getValueAt(n - 1, n2));
        return fastDecimal;
    }

    @Override
    public Object getValueAt_Transpose(int n, int n2) {
        if (this.titles != null) {
            if (n2 == 0) {
                if (n > 0) {
                    return this.titles[n - 1];
                }
                return "";
            }
            --n2;
        }
        if (n == 0) {
            return Double.toString(this.obs.getWavelength(0, n2));
        }
        return Double.toString(this.obs.getValueAt(n - 1, n2));
    }
}

