/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.jdf;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JdfReader {
    public static Observations readJdf(File[] fileArray) throws IOException, IndexOutOfBoundsException {
        BufferedReader bufferedReader = null;
        Observations observations = new Observations(new JdfReader());
        for (File file : fileArray) {
            String string;
            bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.matches("^((##)|(\\$\\$)).*")) {
                    if (!JdfReader.handleHeaderInformation(string, observations)) continue;
                    observations.createNewObservation();
                    continue;
                }
                if (string.length() <= 0) continue;
                JdfReader.handleData(string, observations);
            }
            bufferedReader.close();
        }
        observations.trim();
        return observations;
    }

    private static void handleData(String string, Observations observations) {
        double d = 0.0;
        String[] stringArray = string.split("(?<=[0-9])[\\s+]");
        if (stringArray.length < 2) {
            return;
        }
        for (int i = 1; i < stringArray.length; ++i) {
            try {
                d = Double.parseDouble(stringArray[i]);
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            Observation observation = observations.getCurrentObservation();
            String string2 = observation.getHeaderValue("YFACTOR");
            double d2 = 1.0;
            if (string2 != null) {
                try {
                    d2 = Double.parseDouble(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
            }
            observation.data.add(d * d2);
        }
    }

    private static boolean handleHeaderInformation(String string, Observations observations) {
        if (string.matches("^[\\s]*##END=[\\s]*$")) {
            return true;
        }
        Pattern pattern = Pattern.compile("^(##|\\$\\$)(.*)[=][ ]*(.*)[ ]*$");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            observations.getCurrentObservation().addPair(matcher.group(2), matcher.group(3));
        }
        return false;
    }

    public class Observations {
        private final LinkedList<Observation> observations = new LinkedList();

        public Observations(JdfReader jdfReader) {
            this.observations.add(new Observation());
        }

        public void createNewObservation() {
            this.observations.add(new Observation());
        }

        public Observation getCurrentObservation() {
            return this.observations.getLast();
        }

        public String getHeaderValue(int n, String string) {
            return this.getObservation(n).getHeaderValue(string);
        }

        public int getObservationCount() {
            return this.observations.size();
        }

        public double getValueAt(int n, int n2) {
            Observation observation = this.getObservation(n);
            return observation.getValue(n2);
        }

        public double getWavelength(int n, int n2) {
            Observation observation = this.getObservation(n);
            if (n2 < 0 || n2 >= observation.getWavelengthCount()) {
                throw new IndexOutOfBoundsException("Incorrect wavelength requested");
            }
            String string = observation.getHeaderValue("STARTING WAVELENGTH");
            String string2 = observation.getHeaderValue("INCREMENT");
            try {
                double d = Double.parseDouble(string);
                double d2 = Double.parseDouble(string2);
                return d + d2 * (double)n2;
            }
            catch (Exception exception) {
                String string3 = observation.getHeaderValue("FIRSTX");
                String string4 = observation.getHeaderValue("LASTX");
                String string5 = observation.getHeaderValue("NPOINTS");
                try {
                    double d = Double.parseDouble(string3);
                    double d3 = Double.parseDouble(string4);
                    double d4 = Double.parseDouble(string5);
                    double d5 = (d3 - d) / (d4 - 1.0);
                    return d + d5 * (double)n2;
                }
                catch (Exception exception2) {
                    return 0.0;
                }
            }
        }

        public int getWavelengthCount(int n) {
            Observation observation = this.getObservation(n);
            return observation.getWavelengthCount();
        }

        public void trim() {
            for (int i = this.observations.size() - 1; i >= 0; --i) {
                if (!this.observations.get(i).isEmpty()) continue;
                this.observations.remove(i);
            }
        }

        private Observation getObservation(int n) {
            if (n < 0 || n > this.getObservationCount() - 1) {
                throw new ArrayIndexOutOfBoundsException("Incorrect observation number!");
            }
            return this.observations.get(n);
        }
    }

    public static class Observation {
        private final HashMap<String, String> header;
        private final LinkedList<Double> data = new LinkedList();

        public Observation() {
            this.header = new HashMap();
        }

        public boolean addPair(String string, String string2) {
            if (this.header.containsKey(string)) {
                return false;
            }
            this.header.put(string, string2);
            return true;
        }

        public String getHeaderValue(String string) {
            if (!this.header.containsKey(string)) {
                return null;
            }
            return this.header.get(string);
        }

        public double getValue(int n) {
            if (n < 0 || n >= this.getWavelengthCount()) {
                throw new ArrayIndexOutOfBoundsException("Incorrect wavelength number!");
            }
            return this.data.get(n);
        }

        public int getWavelengthCount() {
            return this.data.size();
        }

        public boolean isEmpty() {
            return this.data.isEmpty();
        }
    }
}

