/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.map;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.dataimport.AbstractImportPanel;
import se.prediktera.map.dataimport.ImportInterface;
import se.prediktera.map.datasetcontainer.nodecase.ProjectDataSource;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class MapImportPanel
extends AbstractImportPanel {
    private ProjectDataSource projectDataSource;
    private final JTable dataSetTable = new JTable();
    private String dataSetName = "Average";

    public MapImportPanel(ImportInterface importInterface, boolean bl) throws IOException {
        super(importInterface.getFiles());
        File file = importInterface.getFiles()[0];
        if (bl) {
            this.projectDataSource = new ProjectDataSource(file.getParentFile());
        } else {
            this.projectDataSource = new ProjectDataSource(file);
            this.dataSetName = "Sample";
        }
        this.jbInit();
        ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(){

            @Override
            public Object doWork() {
                String[] stringArray = MapImportPanel.this.projectDataSource.setupProjectStructure(this);
                MapImportPanel.this.dataSetTable.setModel(new DataSetModel(stringArray));
                if (stringArray != null) {
                    MapImportPanel.this.setSelectedRow();
                }
                return null;
            }
        };
        progressManagerImpl.invokeNow();
    }

    @Override
    public CellIdentifierModel getTableModel(ProgressManager progressManager, boolean bl) {
        int n = this.dataSetTable.getSelectedRow();
        String string = this.dataSetName;
        if (n >= 0) {
            string = (String)this.dataSetTable.getValueAt(n, 0);
        }
        this.projectDataSource.initiateDataSet(progressManager, string);
        return this.projectDataSource;
    }

    @Override
    public String getType() {
        return "Design Of Experiment";
    }

    @Override
    public boolean hasSettings() {
        return true;
    }

    @Override
    public void pageShown() {
        this.ciModel = null;
        super.pageShown();
    }

    public void setDataSetName(String string) {
        this.dataSetName = string;
        this.setSelectedRow();
    }

    @Override
    protected void cleanUpChild() {
        this.projectDataSource = null;
    }

    protected boolean preLoadData() {
        return false;
    }

    private void jbInit() {
        this.dataSetTable.setSelectionMode(0);
        this.dataSetTable.getSelectionModel().addListSelectionListener(listSelectionEvent -> {
            this.ciModel = null;
        });
        JLabel jLabel = new JLabel(this.filenames.length > 1 ? "File Names:" : "File Name:");
        jLabel.setFont(new Font("SansSerif", 1, 12));
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel2 = new JLabel("Select Data");
        jLabel2.setFont(new Font("SansSerif", 1, 12));
        jPanel.setBorder(null);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 12, 0, 0), 0, 0));
        StringBuilder stringBuilder = new StringBuilder(this.filenames[0].getName());
        for (int i = 1; i < this.filenames.length; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(this.filenames[i].getName());
        }
        jPanel.add((Component)new JLabel(stringBuilder.toString()), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 18, 0, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        jPanel.add((Component)new JScrollPane(this.dataSetTable), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 13, 1, new Insets(6, 18, 12, 12), 0, 0));
    }

    private void setSelectedRow() {
        for (int i = 0; i < this.dataSetTable.getRowCount(); ++i) {
            String string;
            Object object = this.dataSetTable.getValueAt(i, 0);
            if (object == null || !this.dataSetName.equalsIgnoreCase(string = String.valueOf(object))) continue;
            this.dataSetTable.setRowSelectionInterval(i, i);
            break;
        }
    }

    private static class DataSetModel
    extends DefaultTableModel {
        private final String[] names;

        public DataSetModel(String[] stringArray) {
            this.names = stringArray;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n) {
            return switch (n) {
                case 0 -> "Name";
                case 1 -> "Description";
                default -> "";
            };
        }

        @Override
        public int getRowCount() {
            if (this.names != null) {
                return this.names.length;
            }
            return 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return switch (n2) {
                case 0 -> {
                    if (this.names != null) {
                        yield this.names[n];
                    }
                    yield "N/A";
                }
                case 1 -> {
                    if (this.names != null) {
                        String var3_3 = this.names[n];
                        if (var3_3.equalsIgnoreCase("Sample") || var3_3.equalsIgnoreCase("Original")) {
                            yield "All samples as merged images";
                        }
                        if (var3_3.equalsIgnoreCase("Representative")) {
                            yield "Representative selection from each project";
                        }
                        if (var3_3.equalsIgnoreCase("Average")) {
                            yield "Average selection for each class";
                        }
                        if (var3_3.equalsIgnoreCase("Median")) {
                            yield "Median selection";
                        }
                        if (var3_3.equalsIgnoreCase("Reference Values")) {
                            yield "Reference values together with meta and enviromental data";
                        }
                        if (var3_3.equalsIgnoreCase("White References")) {
                            yield "White reference values";
                        }
                        if (var3_3.equalsIgnoreCase("Dark References")) {
                            yield "Dark reference values";
                        }
                    }
                    yield "N/A";
                }
                default -> "";
            };
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

