/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.mat;

import java.util.ArrayList;
import se.prediktera.map.common.cleanup.CleanUpClass;
import se.prediktera.map.dataimport.mat.MatReaderInterface;

public abstract class AbstractMatReader
extends CleanUpClass
implements MatReaderInterface {
    protected final ArrayList<Integer> extraRows = new ArrayList();
    protected final ArrayList<Integer> extraCols = new ArrayList();
    protected int[] selectedIndices = null;
    protected String path;
    protected int extraRowsCount;
    protected int extraColsCount;
    protected int layerCount;
    protected int currentVarRow = 0;
    protected int currentVarColumn = 0;
    protected int dataVariable = -1;
    protected boolean treatVariablesAsLayers = false;

    @Override
    public void cleanUpChild() {
        if (this.extraRows != null) {
            this.extraRows.clear();
        }
        if (this.extraCols != null) {
            this.extraCols.clear();
        }
        this.selectedIndices = null;
        this.path = null;
    }

    @Override
    public int getColumnCount() {
        if (this.dataVariable < 0 && this.extraRows == null && this.extraCols == null) {
            return 0;
        }
        int n = this.getVariableColumnCount(this.dataVariable);
        if (n == 0 && this.extraRows != null && this.extraRows.size() > 0) {
            n = this.getVariableColumnCount(this.extraRows.get(0));
        }
        for (Integer n2 : this.extraCols) {
            n += this.getVariableColumnCount(n2);
        }
        return n;
    }

    @Override
    public int getExtraColsCount() {
        return this.extraColsCount;
    }

    @Override
    public int getExtraRowsCount() {
        return this.extraRowsCount;
    }

    @Override
    public int getLayerCount() {
        return this.layerCount;
    }

    @Override
    public String getLayerName(int n) {
        return String.valueOf(n + 1);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public int getRowCount() {
        if (this.dataVariable < 0 && this.extraRows == null && this.extraCols == null) {
            return 0;
        }
        int n = this.getVariableRowCount(this.dataVariable);
        if (n == 0 && this.extraCols.size() > 0) {
            n = this.getVariableRowCount(this.extraCols.get(0));
        }
        for (Integer n2 : this.extraRows) {
            n += this.getVariableRowCount(n2);
        }
        return n;
    }

    public int[] getVariableIndexContainingLayer(int n) {
        if (this.selectedIndices == null || this.getLayerCount() < n) {
            return null;
        }
        int[] nArray = new int[2];
        int n2 = 0;
        for (int i = 0; i < this.selectedIndices.length; ++i) {
            int n3 = this.getVariableLayerCount(this.selectedIndices[i]);
            if (n2 + n3 > n) {
                nArray[0] = i;
                nArray[1] = n - n2;
                return nArray;
            }
            n2 += n3;
        }
        return null;
    }

    @Override
    public void selectVariables(boolean bl, int[] nArray) {
        int n;
        int n2;
        this.treatVariablesAsLayers = bl;
        this.dataVariable = -1;
        this.extraRows.clear();
        this.extraRowsCount = 0;
        this.extraCols.clear();
        this.extraColsCount = 0;
        this.selectedIndices = nArray;
        int n3 = 0;
        int n4 = 0;
        for (Object object : nArray) {
            n2 = this.getVariableRowCount((int)object);
            n = this.getVariableColumnCount((int)object);
            if (this.isData((int)object) && (this.dataVariable < 0 || n2 > this.getVariableRowCount(this.dataVariable) || n > this.getVariableColumnCount(this.dataVariable))) {
                this.dataVariable = object;
            }
            if (n2 > n3) {
                n3 = n2;
            }
            if (n <= n4) continue;
            n4 = n;
        }
        if (this.dataVariable < 0 && nArray.length > 0) {
            this.dataVariable = nArray[0];
        }
        if (!this.treatVariablesAsLayers) {
            for (Object object : nArray) {
                if (object == this.dataVariable) continue;
                n2 = this.getVariableRowCount((int)object);
                n = this.getVariableColumnCount((int)object);
                if (n2 == n3) {
                    this.extraCols.add((Integer)object);
                    this.extraColsCount += n;
                    continue;
                }
                if (n == n4 || n2 <= n) {
                    this.extraRows.add((Integer)object);
                    this.extraRowsCount += n2;
                    continue;
                }
                this.extraCols.add((Integer)object);
                this.extraColsCount += n;
            }
        }
        if (this.dataVariable < 0 && this.extraRows == null && this.extraCols == null && this.selectedIndices != null) {
            this.layerCount = 0;
        } else {
            this.layerCount = 0;
            if (this.treatVariablesAsLayers) {
                var5_5 = this.selectedIndices;
                int n5 = ((int[])var5_5).length;
                for (var7_9 = 0; var7_9 < n5; ++var7_9) {
                    Object object;
                    object = var5_5[var7_9];
                    this.layerCount += this.getVariableLayerCount((int)object);
                }
            } else {
                this.layerCount = this.getVariableLayerCount(this.dataVariable);
                var5_5 = this.extraCols.iterator();
                while (var5_5.hasNext()) {
                    Integer n6 = (Integer)var5_5.next();
                    var7_9 = this.getVariableLayerCount(n6);
                    if (var7_9 <= this.layerCount) continue;
                    this.layerCount = var7_9;
                }
                for (Integer n7 : this.extraRows) {
                    var7_9 = this.getVariableLayerCount(n7);
                    if (var7_9 <= this.layerCount) continue;
                    this.layerCount = var7_9;
                }
            }
        }
    }

    public void setDataVariable(int n) {
        this.dataVariable = n;
    }

    protected int getVariableIndexAt(int n, int n2) {
        this.currentVarRow = n;
        this.currentVarColumn = n2;
        if (this.dataVariable >= 0 && this.dataVariable < this.getVariableCount()) {
            int n3;
            if (n < this.extraRowsCount && n2 < this.extraColsCount) {
                return -1;
            }
            for (Integer n4 : this.extraCols) {
                n3 = this.getVariableColumnCount(n4);
                if (this.currentVarColumn < n3) {
                    this.currentVarRow -= this.extraRowsCount;
                    return n4;
                }
                this.currentVarColumn -= n3;
            }
            for (Integer n4 : this.extraRows) {
                n3 = this.getVariableRowCount(n4);
                if (this.currentVarRow < n3) {
                    return n4;
                }
                this.currentVarRow -= n3;
            }
            return this.dataVariable;
        }
        return -1;
    }
}

