/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.mat;

import java.io.IOException;
import java.util.ArrayList;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.dataimport.mat.AbstractVariable;
import se.prediktera.map.datasetcontainer.matrix.DataTypeInterface;

public abstract class AbstractReader
implements DataTypeInterface {
    private boolean swapByteOrder = false;
    protected int maximumformatbytesize = 0;
    private final RandomInputStream inStream;
    private final byte[] cache = new byte[8192];
    private int cachestart = -1;
    private int cacheend = -1;
    private long cachelen = -1L;

    public static int getDataType(int n) {
        return switch (n) {
            case 1 -> 0;
            case 2 -> 1;
            case 4 -> 4;
            case 8 -> 5;
            default -> 4;
        };
    }

    protected AbstractReader(RandomInputStream randomInputStream) {
        this.inStream = randomInputStream;
    }

    public abstract void close();

    public int getDataType() {
        return switch (this.maximumformatbytesize) {
            case 1 -> 0;
            case 2 -> 1;
            case 4 -> 4;
            case 8 -> 5;
            default -> 4;
        };
    }

    public abstract void getVariables(ArrayList<AbstractVariable> var1) throws IOException;

    protected final int correctByteOrderInt(byte[] byArray) {
        return this.correctByteOrderInt(byArray, 0);
    }

    protected final int correctByteOrderInt(byte[] byArray, int n) {
        if (this.swapByteOrder) {
            return byArray[n + 3] << 24 | byArray[n + 2] << 16 & 0xFF0000 | byArray[n + 1] << 8 & 0xFF00 | byArray[n] & 0xFF;
        }
        return byArray[n] << 24 | byArray[n + 1] << 16 & 0xFF0000 | byArray[n + 2] << 8 & 0xFF00 | byArray[n + 3] & 0xFF;
    }

    protected final long correctByteOrderLong(byte[] byArray) {
        return this.correctByteOrderLong(byArray, 0);
    }

    protected final long correctByteOrderLong(byte[] byArray, int n) {
        long l = this.correctByteOrderInt(byArray, n + 4);
        long l2 = this.correctByteOrderInt(byArray, n);
        if (this.swapByteOrder) {
            return l << 32 | l2 & 0xFFFFFFFFL;
        }
        return l2 << 32 | l & 0xFFFFFFFFL;
    }

    protected final short correctByteOrderShort(byte[] byArray) {
        return this.correctByteOrderShort(byArray, 0);
    }

    protected final short correctByteOrderShort(byte[] byArray, int n) {
        if (this.swapByteOrder) {
            return (short)(byArray[n + 1] << 8 & 0xFF00 | byArray[n] & 0xFF);
        }
        return (short)(byArray[n] << 8 & 0xFF00 | byArray[n + 1] & 0xFF);
    }

    protected boolean eof() throws IOException {
        return this.inStream.eof();
    }

    protected long getFilePointer() throws IOException {
        if (this.cacheend >= 0) {
            return this.inStream.getFilePointer() - this.cachelen + (long)this.cacheend;
        }
        return this.inStream.getFilePointer();
    }

    protected int read(byte[] byArray) throws IOException {
        this.revertCache();
        return this.inStream.read(byArray);
    }

    protected int read(byte[] byArray, int n, int n2) throws IOException {
        this.revertCache();
        return this.inStream.read(byArray, n, n2);
    }

    protected byte readByteCorrectOrder() throws IOException {
        this.readCache(1);
        return this.cache[this.cachestart];
    }

    protected double readDoubleCorrectOrder() throws IOException {
        this.readCache(8);
        return Double.longBitsToDouble(this.correctByteOrderLong(this.cache, this.cachestart));
    }

    protected float readFloatCorrectOrder() throws IOException {
        this.readCache(4);
        return Float.intBitsToFloat(this.correctByteOrderInt(this.cache, this.cachestart));
    }

    protected int readInt() throws IOException {
        this.revertCache();
        return this.inStream.readInt();
    }

    protected int readIntCorrectOrder() throws IOException {
        this.readCache(4);
        return this.correctByteOrderInt(this.cache, this.cachestart);
    }

    protected long readLong() throws IOException {
        this.revertCache();
        return this.inStream.readLong();
    }

    protected long readLongCorrectOrder() throws IOException {
        this.readCache(8);
        return this.correctByteOrderLong(this.cache, this.cachestart);
    }

    protected short readShort() throws IOException {
        this.revertCache();
        return this.inStream.readShort();
    }

    protected short readShortCorrectOrder() throws IOException {
        this.readCache(2);
        return this.correctByteOrderShort(this.cache, this.cachestart);
    }

    protected void seek(long l) throws IOException {
        this.inStream.seek(l);
        this.clearCache();
    }

    protected final void setSwapByteOrder(boolean bl) {
        this.swapByteOrder = bl;
    }

    private void clearCache() {
        this.cachestart = -1;
        this.cacheend = -1;
        this.cachelen = -1L;
    }

    private void readCache(int n) throws IOException {
        if (this.cacheend == -1 || this.cacheend + n > this.cache.length) {
            this.cachelen = this.inStream.read(this.cache);
            this.cacheend = n;
        } else {
            this.cacheend += n;
        }
        this.cachestart = this.cacheend - n;
    }

    private void revertCache() throws IOException {
        if (this.cacheend >= 0) {
            this.inStream.seek(this.inStream.getFilePointer() - this.cachelen + (long)this.cacheend);
        }
        this.clearCache();
    }
}

