/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.mat;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.dataimport.mat.AbstractReader;
import se.prediktera.map.dataimport.mat.AbstractVariable;

public class HdfReader
extends AbstractReader {
    private static final Logger logger = LoggerFactory.getLogger(HdfReader.class);
    private Group root = null;
    private FileFormat file = null;

    public HdfReader(RandomInputStream randomInputStream) throws IOException {
        super(randomInputStream);
        try {
            this.file = FileFormat.getInstance((String)randomInputStream.getFile().getPath());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.file == null) {
            logger.error("Cannot open file");
            return;
        }
        try {
            this.file.open();
            this.root = (Group)((DefaultMutableTreeNode)this.file.getRootNode()).getUserObject();
        }
        catch (Exception exception) {
            logger.error("Cannot open file");
        }
    }

    @Override
    public void close() {
        try {
            if (this.file != null) {
                this.file.close();
            }
        }
        catch (Exception exception) {
            logger.error("Cannot close file");
        }
    }

    @Override
    public void getVariables(ArrayList<AbstractVariable> arrayList) throws IOException {
        this.getVariables(this.root, arrayList);
    }

    private void getVariables(Group group, ArrayList<AbstractVariable> arrayList) throws IOException {
        List list = group.getMemberList();
        for (Object e : list) {
            if (e instanceof Dataset) {
                arrayList.add(new HdfVariable(this, (Dataset)e));
                continue;
            }
            if (!(e instanceof Group)) continue;
            this.getVariables((Group)e, arrayList);
        }
    }

    private class HdfVariable
    extends AbstractVariable {
        private Dataset data = null;
        private long[] readPosition;
        private long[] cacheSize;
        private long[] cacheWantedSize;
        private long[] fullSize;
        private Object dataCache;

        public HdfVariable(HdfReader hdfReader, Dataset dataset) {
            this.data = dataset;
            if (dataset != null) {
                dataset.init();
                String string = dataset.getPath().substring(1).replace('/', '.');
                this.name = string + dataset.getName();
                this.fullSize = dataset.getDims();
                if (this.fullSize != null) {
                    if (this.fullSize.length > 2) {
                        this.layerCount = (int)this.fullSize[0];
                        this.columnCount = (int)this.fullSize[1];
                        this.rowCount = (int)this.fullSize[2];
                    } else if (this.fullSize.length > 1) {
                        this.columnCount = (int)this.fullSize[0];
                        this.rowCount = (int)this.fullSize[1];
                    } else if (this.fullSize.length > 0) {
                        this.columnCount = 1;
                        this.rowCount = (int)this.fullSize[0];
                    }
                }
                this.cacheSize = dataset.getSelectedDims();
                this.cacheWantedSize = new long[this.cacheSize.length];
                for (int i = 0; i < this.cacheSize.length; ++i) {
                    this.cacheSize[i] = Math.min(100L, this.fullSize[i]);
                    this.cacheWantedSize[i] = this.cacheSize[i];
                }
                if (this.cacheSize.length > 2) {
                    this.cacheSize[0] = 1L;
                    this.cacheWantedSize[0] = 1L;
                }
                this.readPosition = dataset.getStartDims();
            }
        }

        @Override
        public double getDouble(int n, int n2, int n3) {
            Object object = this.getValue(n, n2, n3);
            if (object instanceof Number) {
                return ((Number)object).doubleValue();
            }
            return 0.0;
        }

        @Override
        public String getString(int n, int n2, int n3) {
            return String.valueOf(this.getValue(n, n2, n3));
        }

        @Override
        public String getTypeName() {
            if (this.data == null) {
                return "N/A";
            }
            return String.valueOf(this.data.getDatatype());
        }

        @Override
        public boolean isData() {
            return this.data != null;
        }

        @Override
        protected void cleanUpChild() {
        }

        private Object getValue(int n, int n2, int n3) {
            if (this.isTransposed()) {
                int n4 = n;
                n = n2;
                n2 = n4;
            }
            try {
                long l = 0L;
                long l2 = 0L;
                long l3 = 0L;
                long l4 = 0L;
                long l5 = 0L;
                if (this.readPosition.length > 2) {
                    l5 = this.readPosition[0];
                    l3 = this.readPosition[1];
                    l4 = l3 + this.cacheSize[1] - 1L;
                    l = this.readPosition[2];
                    l2 = l + this.cacheSize[2] - 1L;
                } else if (this.readPosition.length > 1) {
                    l3 = this.readPosition[0];
                    l4 = l3 + this.cacheSize[0] - 1L;
                    l = this.readPosition[1];
                    l2 = l + this.cacheSize[1] - 1L;
                } else if (this.readPosition.length > 0) {
                    l = this.readPosition[0];
                    l2 = l + this.cacheSize[0] - 1L;
                }
                if (this.dataCache == null || (long)n3 != l5 || (long)n < l || (long)n > l2 || (long)n2 < l3 || (long)n2 > l4) {
                    if (this.readPosition.length > 2) {
                        l3 = (long)n2 - (long)n2 % this.cacheWantedSize[1];
                        l4 = Math.min(l3 + this.cacheWantedSize[1], this.fullSize[1]) - 1L;
                        this.cacheSize[1] = Math.min(this.cacheWantedSize[1], l4 - l3 + 1L);
                        l = (long)n - (long)n % this.cacheWantedSize[2];
                        l2 = Math.min(l + this.cacheWantedSize[2], this.fullSize[2]) - 1L;
                        this.cacheSize[2] = Math.min(this.cacheWantedSize[2], l2 - l + 1L);
                        this.readPosition[0] = n3;
                        this.readPosition[1] = l3;
                        this.readPosition[2] = l;
                    } else if (this.readPosition.length > 1) {
                        l3 = (long)n2 - (long)n2 % this.cacheWantedSize[0];
                        l4 = Math.min(l3 + this.cacheWantedSize[0], this.fullSize[0]) - 1L;
                        this.cacheSize[0] = Math.min(this.cacheWantedSize[0], l4 - l3 + 1L);
                        l = (long)n - (long)n % this.cacheWantedSize[1];
                        l2 = Math.min(l + this.cacheWantedSize[1], this.fullSize[1]) - 1L;
                        this.cacheSize[1] = Math.min(this.cacheWantedSize[1], l2 - l + 1L);
                        this.readPosition[0] = l3;
                        this.readPosition[1] = l;
                    } else if (this.readPosition.length > 0) {
                        l = (long)n - (long)n % this.cacheWantedSize[0];
                        l2 = Math.min(l + this.cacheWantedSize[0], this.fullSize[0]) - 1L;
                        this.cacheSize[0] = Math.min(this.cacheWantedSize[0], l2 - l + 1L);
                        this.readPosition[0] = l;
                    }
                    this.dataCache = this.data.read();
                }
                int n5 = (int)((long)n - l + ((long)n2 - l3) * (l2 - l + 1L));
                if (this.dataCache instanceof double[]) {
                    return ((double[])this.dataCache)[n5];
                }
                if (this.dataCache instanceof float[]) {
                    return Float.valueOf(((float[])this.dataCache)[n5]);
                }
                if (this.dataCache instanceof int[]) {
                    return ((int[])this.dataCache)[n5];
                }
                if (this.dataCache instanceof long[]) {
                    return ((long[])this.dataCache)[n5];
                }
                if (this.dataCache instanceof short[]) {
                    return ((short[])this.dataCache)[n5];
                }
                if (this.dataCache instanceof byte[]) {
                    return ((byte[])this.dataCache)[n5];
                }
                if (this.dataCache instanceof String[]) {
                    return ((String[])this.dataCache)[n5];
                }
            }
            catch (Exception exception) {
                ErrorHandler.logAndReportException(exception);
            }
            return null;
        }
    }
}

