/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.mat;

import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.swing.JOptionPane;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.cleanup.CleanUpClass;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.dataimport.mat.AbstractReader;
import se.prediktera.map.dataimport.mat.AbstractVariable;
import se.prediktera.map.main.Main_GUI;

public class LevelFiveReader
extends AbstractReader {
    private long lastpos = -1L;

    public LevelFiveReader(RandomInputStream randomInputStream) throws IOException {
        super(randomInputStream);
        byte[] byArray = new byte[116];
        this.read(byArray);
        this.readLong();
        this.readShort();
        short s = this.readShort();
        this.setSwapByteOrder(s == 18765);
    }

    @Override
    public void close() {
    }

    @Override
    public void getVariables(ArrayList<AbstractVariable> arrayList) throws IOException {
        this.maximumformatbytesize = 0;
        while (!this.eof()) {
            try {
                LevelFiveVariable levelFiveVariable = new LevelFiveVariable();
                if (this.maximumformatbytesize < levelFiveVariable.getFormatByteSize()) {
                    this.maximumformatbytesize = levelFiveVariable.getFormatByteSize();
                }
                arrayList.add(levelFiveVariable);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(Main_GUI.get(), iOException.getMessage(), "Failed to read variable", 2);
            }
        }
    }

    private class LevelFiveVariable
    extends AbstractVariable {
        private final long dataStart;
        private Decompressor decompressor = null;
        private final double ushortfactor = 65536.0;
        private final double uintfactor = 4.294967296E9;
        private final byte[] bytes = new byte[8];

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LevelFiveVariable() throws IOException {
            int n = LevelFiveReader.this.readIntCorrectOrder();
            long l = LevelFiveReader.this.readIntCorrectOrder();
            if (l < 0L) {
                l = Math.abs(Integer.MIN_VALUE - l) + Integer.MAX_VALUE;
            }
            if (l % 8L != 0L && n == 14) {
                l += 8L - l % 8L;
            }
            long l2 = LevelFiveReader.this.getFilePointer();
            long l3 = l2 + l;
            if (n == 15) {
                this.decompressor = new Decompressor(l2, l3 - 1L);
                this.readIntLevelFive();
                this.readIntLevelFive();
            }
            try {
                byte[] byArray = this.getFlags();
                this.type = byArray[0];
                this.readDimensions();
                this.readName();
                this.format = (byte)this.readIntLevelFive();
                this.readIntLevelFive();
            }
            finally {
                this.dataStart = LevelFiveReader.this.getFilePointer();
                if (this.decompressor != null) {
                    this.decompressor.markDataStart();
                }
                LevelFiveReader.this.seek(l3);
            }
        }

        @Override
        public int getColumnCount() {
            if (this.isTransposed()) {
                return this.rowCount;
            }
            if (this.type == 4) {
                return 1;
            }
            return super.getColumnCount();
        }

        @Override
        public double getDouble(int n, int n2, int n3) {
            int n4;
            if (n3 >= this.layerCount) {
                n3 = this.layerCount - 1;
            }
            if (this.isTransposed()) {
                n4 = n;
                n = n2;
                n2 = n4;
            }
            n4 = this.getFormatByteSize(this.format);
            try {
                long l = this.dataStart + (long)(((n3 * this.columnCount + n2) * this.rowCount + n) * n4);
                if (l == LevelFiveReader.this.lastpos + (long)n4) {
                    LevelFiveReader.this.lastpos = l;
                } else {
                    this.seekLevelFive(l);
                }
                return this.readValue(this.format);
            }
            catch (IOException iOException) {
                ErrorHandler.logAndShowEvinceErrorDialogForException(iOException);
                return 0.0;
            }
        }

        @Override
        public int getFormatByteSize() {
            return this.getFormatByteSize(this.format);
        }

        @Override
        public int getRowCount() {
            if (this.isTransposed() && this.type == 4) {
                return 1;
            }
            return super.getRowCount();
        }

        @Override
        public String getString(int n, int n2, int n3) {
            if (this.type == 4) {
                if (n3 >= this.layerCount) {
                    n3 = this.layerCount - 1;
                }
                if (this.isTransposed()) {
                    int n4 = n;
                    n = n2;
                    n2 = n4;
                }
                try {
                    StringBuilder stringBuilder = new StringBuilder(this.columnCount);
                    int n5 = this.getFormatByteSize(this.format);
                    long l = this.dataStart + (long)(((n3 * this.columnCount + n2) * this.rowCount + n) * n5);
                    for (int i = 0; i < this.columnCount; ++i) {
                        this.seekLevelFive(l);
                        short s = this.readValueShort(this.format);
                        char c = (char)s;
                        if (c == '\u0000') break;
                        stringBuilder.append(c);
                        l += (long)(this.rowCount * n5);
                    }
                    return stringBuilder.toString();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return String.valueOf(this.getDouble(n, n2, n3));
        }

        @Override
        public String getTypeName() {
            return switch (this.getType()) {
                case 1 -> "Cell array";
                case 2 -> "Structure";
                case 3 -> "Object";
                case 4 -> "Character array";
                case 5 -> "Sparse array";
                case 6 -> "Double precision array";
                case 7 -> "Single precision array";
                case 8 -> "8-bit, signed integer";
                case 9 -> "8-bit, unsigned integer";
                case 10 -> "16-bit, signed integer";
                case 11 -> "16-bit, unsigned integer";
                case 12 -> "32-bit, signed integer";
                case 13 -> "32-bit, unsigned integer";
                default -> "Unknown";
            };
        }

        @Override
        public boolean isData() {
            return this.type > 4 && this.type < 14;
        }

        @Override
        protected void cleanUpChild() {
            if (this.decompressor != null) {
                this.decompressor.cleanUp();
                this.decompressor = null;
            }
        }

        private final byte[] getFlags() throws IOException {
            int n = this.readIntLevelFive();
            if (n != 6) {
                throw new IOException("Error reading variable flags!");
            }
            this.readIntLevelFive();
            byte[] byArray = new byte[2];
            int n2 = this.readIntLevelFive();
            byArray[0] = (byte)(n2 & 0xFF);
            byArray[1] = (byte)(n2 >> 8 & 0xFF);
            this.readIntLevelFive();
            return byArray;
        }

        private int getFormatByteSize(byte by) {
            return switch (by) {
                case 1, 2, 16 -> 1;
                case 3, 4, 17 -> 2;
                case 5, 6, 7, 18 -> 4;
                case 9, 12, 13 -> 8;
                default -> 0;
            };
        }

        private byte readByteLevelFive() throws IOException {
            if (this.decompressor == null) {
                return LevelFiveReader.this.readByteCorrectOrder();
            }
            this.decompressor.readDecompressor(this.bytes, 0, 1);
            return this.bytes[0];
        }

        private void readDimensions() throws IOException {
            int n = this.readIntLevelFive();
            if (n != 5) {
                Logg.error("Error reading variable dimensions!", new Object[0]);
            }
            int n2 = this.readIntLevelFive();
            int n3 = n2 / 4;
            for (int i = 0; i < n3; ++i) {
                int n4 = this.readIntLevelFive();
                if (i == 0) {
                    this.rowCount = n4;
                    continue;
                }
                if (i == 1) {
                    this.columnCount = n4;
                    continue;
                }
                if (i != 2) continue;
                this.layerCount = n4;
            }
            this.skipPadding(n2);
        }

        private double readDoubleLevelFive() throws IOException {
            if (this.decompressor == null) {
                return LevelFiveReader.this.readDoubleCorrectOrder();
            }
            this.decompressor.readDecompressor(this.bytes);
            return Double.longBitsToDouble(LevelFiveReader.this.correctByteOrderLong(this.bytes));
        }

        private float readFloatLevelFive() throws IOException {
            if (this.decompressor == null) {
                return LevelFiveReader.this.readFloatCorrectOrder();
            }
            this.decompressor.readDecompressor(this.bytes, 0, 4);
            return Float.intBitsToFloat(LevelFiveReader.this.correctByteOrderInt(this.bytes));
        }

        private int readIntLevelFive() throws IOException {
            if (this.decompressor == null) {
                return LevelFiveReader.this.readIntCorrectOrder();
            }
            this.decompressor.readDecompressor(this.bytes, 0, 4);
            return LevelFiveReader.this.correctByteOrderInt(this.bytes);
        }

        private int readLevelFive(byte[] byArray) throws IOException {
            if (this.decompressor == null) {
                return LevelFiveReader.this.read(byArray);
            }
            return this.decompressor.readDecompressor(byArray);
        }

        private long readLongLevelFive() throws IOException {
            if (this.decompressor == null) {
                return LevelFiveReader.this.readLongCorrectOrder();
            }
            this.decompressor.readDecompressor(this.bytes);
            return LevelFiveReader.this.correctByteOrderLong(this.bytes);
        }

        private final void readName() throws IOException {
            int n;
            boolean bl;
            int n2 = this.readIntLevelFive();
            boolean bl2 = bl = n2 > 65535;
            if (bl) {
                n = n2 >> 16 & 0xFFFF;
                n2 &= 0xFFFF;
            } else {
                n = this.readIntLevelFive();
            }
            if (n2 != 1) {
                Logg.error("Error reading variable name!", new Object[0]);
            }
            byte[] byArray = new byte[n];
            this.readLevelFive(byArray);
            this.name = new String(byArray, 0, n);
            if (bl) {
                this.skipPaddingSmallData(n);
            } else {
                this.skipPadding(n);
            }
        }

        private short readShortLevelFive() throws IOException {
            if (this.decompressor == null) {
                return LevelFiveReader.this.readShortCorrectOrder();
            }
            this.decompressor.readDecompressor(this.bytes, 0, 2);
            return LevelFiveReader.this.correctByteOrderShort(this.bytes);
        }

        private synchronized double readValue(byte by) throws IOException {
            switch (by) {
                case 1: {
                    return this.readByteLevelFive();
                }
                case 2: {
                    byte by2 = this.readByteLevelFive();
                    if (by2 < 0) {
                        return (double)by2 + 256.0;
                    }
                    return by2;
                }
                case 3: {
                    return this.readShortLevelFive();
                }
                case 4: {
                    short s = this.readShortLevelFive();
                    if (s < 0) {
                        return (double)s + 65536.0;
                    }
                    return s;
                }
                case 5: {
                    return this.readIntLevelFive();
                }
                case 6: {
                    int n = this.readIntLevelFive();
                    if (n < 0) {
                        return (double)n + 4.294967296E9;
                    }
                    return n;
                }
                case 7: {
                    return this.readFloatLevelFive();
                }
                case 9: {
                    return this.readDoubleLevelFive();
                }
                case 12: 
                case 13: {
                    return this.readLongLevelFive();
                }
            }
            return 0.0;
        }

        private short readValueShort(byte by) throws IOException {
            return switch (by) {
                case 1, 2, 16 -> this.readByteLevelFive();
                case 3, 4, 17 -> this.readShortLevelFive();
                case 5, 6, 18 -> (short)this.readIntLevelFive();
                case 7 -> (short)this.readFloatLevelFive();
                case 9 -> (short)this.readDoubleLevelFive();
                case 12, 13 -> (short)this.readLongLevelFive();
                default -> 0;
            };
        }

        private void seekLevelFive(long l) throws IOException {
            if (this.decompressor == null) {
                LevelFiveReader.this.seek(l);
            } else {
                this.decompressor.seekDecompressor(l - this.dataStart);
            }
            LevelFiveReader.this.lastpos = l;
        }

        private final void skip(int n) throws IOException {
            for (int i = 0; i < n; ++i) {
                this.readByteLevelFive();
            }
        }

        private final void skipPadding(int n) throws IOException {
            this.skip((8 - n % 8) % 8);
        }

        private final void skipPaddingSmallData(int n) throws IOException {
            this.skip((4 - n % 4) % 4);
        }
    }

    private class Decompressor
    extends CleanUpClass {
        private final Inflater inflater = new Inflater(false);
        private final long variableStart;
        private final long variableEnd;
        private long dataStart;
        private byte[] compressedBuffer;
        private byte[] buffer;
        private int bufferPointer = 0;
        private int currentLength = 0;
        private long currentStart = 0L;
        private long currentCompressedStart;

        public Decompressor(long l, long l2) {
            this.variableStart = l;
            this.currentStart = l;
            this.variableEnd = l2;
            this.compressedBuffer = new byte[Math.min(8000000, (int)(this.variableEnd - l + 1L))];
            this.buffer = new byte[Math.min(8000000, 3 * this.compressedBuffer.length)];
            this.currentCompressedStart = l;
        }

        public void markDataStart() {
            this.dataStart = this.currentStart + (long)this.bufferPointer;
        }

        public int readDecompressor(byte[] byArray) throws IOException {
            return this.readDecompressor(byArray, 0, byArray.length);
        }

        public int readDecompressor(byte[] byArray, int n, int n2) throws IOException {
            for (int i = 0; i < n2; ++i) {
                if (this.bufferPointer >= this.currentLength) {
                    this.inflateData();
                }
                byArray[i + n] = this.buffer[this.bufferPointer++];
            }
            return 0;
        }

        public final void seekDecompressor(long l) throws IOException {
            long l2 = l + this.dataStart;
            if (l2 < this.currentStart) {
                this.currentCompressedStart = this.variableStart;
                this.currentStart = this.variableStart;
                this.currentLength = 0;
                this.inflater.reset();
                while (l2 >= this.currentStart + (long)this.currentLength) {
                    this.inflateData();
                }
            } else if (l2 >= this.currentStart + (long)this.currentLength) {
                while (l2 >= this.currentStart + (long)this.currentLength) {
                    this.inflateData();
                }
            }
            this.bufferPointer = (int)(l2 - this.currentStart);
        }

        @Override
        protected void cleanUpChild() {
            this.inflater.end();
            this.compressedBuffer = null;
            this.buffer = null;
        }

        private void inflateData() throws IOException {
            if (this.inflater.needsInput()) {
                LevelFiveReader.this.seek(this.currentCompressedStart);
                int n = Math.min(this.compressedBuffer.length, (int)(this.variableEnd - this.currentCompressedStart));
                int n2 = LevelFiveReader.this.read(this.compressedBuffer, 0, n);
                if (n2 < 0) {
                    throw new IOException("Unexpected end of file");
                }
                this.currentCompressedStart += (long)n2;
                this.inflater.setInput(this.compressedBuffer, 0, n2);
            }
            this.currentStart += (long)this.currentLength;
            try {
                this.currentLength = this.inflater.inflate(this.buffer);
            }
            catch (DataFormatException dataFormatException) {
                throw new IOException("Data decompression: " + dataFormatException.getMessage());
            }
            this.bufferPointer = 0;
        }
    }
}

