/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.mat;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.dataimport.mat.AbstractReader;
import se.prediktera.map.dataimport.mat.AbstractVariable;

public class LevelFourReader
extends AbstractReader {
    public LevelFourReader(RandomInputStream randomInputStream) {
        super(randomInputStream);
    }

    @Override
    public void close() {
    }

    @Override
    public void getVariables(ArrayList<AbstractVariable> arrayList) throws IOException {
        this.maximumformatbytesize = 0;
        while (!this.eof()) {
            LevelFourVariable levelFourVariable = new LevelFourVariable();
            if (this.maximumformatbytesize < levelFourVariable.getFormatByteSize()) {
                this.maximumformatbytesize = levelFourVariable.getFormatByteSize();
            }
            arrayList.add(levelFourVariable);
        }
    }

    private class LevelFourVariable
    extends AbstractVariable {
        private final boolean hasImaginary;
        private final long dataStart;

        public LevelFourVariable() throws IOException {
            byte by = LevelFourReader.this.readByteCorrectOrder();
            byte by2 = LevelFourReader.this.readByteCorrectOrder();
            LevelFourReader.this.readByteCorrectOrder();
            byte by3 = LevelFourReader.this.readByteCorrectOrder();
            switch (by3) {
                case 0: {
                    System.out.println("IEEE Little Endian (PC, 386, 486, DEC Risc)");
                    LevelFourReader.this.setSwapByteOrder(ByteOrder.nativeOrder() != ByteOrder.LITTLE_ENDIAN);
                    break;
                }
                case 1: {
                    System.out.println("IEEE Big Endian (Macintosh, SPARC, Apollo,SGI, HP 9000/300, other Motorola)");
                    LevelFourReader.this.setSwapByteOrder(ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN);
                    break;
                }
                case 2: {
                    System.out.println("VAX D-float (unsupported)");
                    break;
                }
                case 3: {
                    System.out.println("VAX G-float (unsupported)");
                    break;
                }
                case 4: {
                    System.out.println("Cray (unsupported)");
                }
            }
            LevelFourReader.this.setSwapByteOrder(true);
            switch (by2) {
                case 0: {
                    System.out.println("Double");
                    break;
                }
                case 1: {
                    System.out.println("Float");
                    break;
                }
                case 2: {
                    System.out.println("Signed int");
                    break;
                }
                case 3: {
                    System.out.println("Signed short");
                    break;
                }
                case 4: {
                    System.out.println("Unsigned short");
                    break;
                }
                case 5: {
                    System.out.println("Unsigned byte");
                }
            }
            System.out.println(this.getTypeName(by));
            if (by == 2) {
                throw new IOException("Sorry, can't read sparse matrices");
            }
            if (by > 2) {
                throw new IOException("Unknown matrix type");
            }
            this.rowCount = LevelFourReader.this.readIntCorrectOrder();
            this.columnCount = LevelFourReader.this.readIntCorrectOrder();
            this.hasImaginary = LevelFourReader.this.readIntCorrectOrder() == 1;
            int n = LevelFourReader.this.readIntCorrectOrder();
            if (n > 0) {
                byte[] byArray = new byte[n];
                LevelFourReader.this.read(byArray);
                this.name = new String(byArray, 0, n - 1);
            }
            this.type = by;
            this.format = by2;
            this.dataStart = LevelFourReader.this.getFilePointer();
            long l = (this.hasImaginary ? 2 : 1) * this.rowCount * this.columnCount * this.getFormatByteSize(this.format);
            LevelFourReader.this.seek(this.dataStart + l);
        }

        @Override
        public int getColumnCount() {
            if (this.isTransposed()) {
                return this.rowCount;
            }
            if (this.type == 1) {
                return 1;
            }
            return super.getColumnCount();
        }

        @Override
        public double getDouble(int n, int n2, int n3) {
            int n4;
            if (this.isTransposed()) {
                n4 = n;
                n = n2;
                n2 = n4;
            }
            n4 = this.getFormatByteSize(this.format);
            try {
                LevelFourReader.this.seek(this.dataStart + (long)((n2 * this.rowCount + n) * n4));
                return this.readValue(this.format);
            }
            catch (IOException iOException) {
                return 0.0;
            }
        }

        @Override
        public int getFormatByteSize() {
            return this.getFormatByteSize(this.format);
        }

        @Override
        public int getRowCount() {
            if (this.isTransposed() && this.type == 1) {
                return 1;
            }
            return super.getRowCount();
        }

        @Override
        public String getString(int n, int n2, int n3) {
            if (this.type == 1) {
                if (this.isTransposed()) {
                    int n4 = n;
                    n = n2;
                    n2 = n4;
                }
                try {
                    StringBuilder stringBuilder = new StringBuilder();
                    int n5 = this.getFormatByteSize(this.format);
                    for (int i = 0; i < this.columnCount; ++i) {
                        LevelFourReader.this.seek(this.dataStart + (long)(((n2 + i) * this.rowCount + n) * n5));
                        char c = (char)this.readValue(this.format);
                        if (c == '\u0000') break;
                        stringBuilder.append(c);
                    }
                    return stringBuilder.toString();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return String.valueOf(this.getDouble(n, n2, n3));
        }

        @Override
        public String getTypeName() {
            return this.getTypeName(this.getType());
        }

        @Override
        public boolean isData() {
            return this.type == 0;
        }

        @Override
        protected void cleanUpChild() {
        }

        private int getFormatByteSize(byte by) {
            return switch (by) {
                case 0 -> 8;
                case 1, 2 -> 4;
                case 3, 4 -> 2;
                case 5 -> 1;
                default -> 0;
            };
        }

        private String getTypeName(byte by) {
            return switch (by) {
                case 0 -> "Numeric (full) matrix";
                case 1 -> "Text matrix";
                case 2 -> "Sparse matrix";
                default -> "Unknown";
            };
        }

        private double readValue(byte by) throws IOException {
            return switch (by) {
                case 0 -> LevelFourReader.this.readDoubleCorrectOrder();
                case 1 -> LevelFourReader.this.readFloatCorrectOrder();
                case 2 -> LevelFourReader.this.readIntCorrectOrder();
                case 3, 4 -> LevelFourReader.this.readShortCorrectOrder();
                case 5 -> LevelFourReader.this.readByteCorrectOrder();
                default -> 0.0;
            };
        }
    }
}

