/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.mat;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.dataimport.mat.AbstractMatReader;
import se.prediktera.map.dataimport.mat.AbstractReader;
import se.prediktera.map.dataimport.mat.AbstractVariable;
import se.prediktera.map.dataimport.mat.HdfReader;
import se.prediktera.map.dataimport.mat.LevelFiveReader;
import se.prediktera.map.dataimport.mat.LevelFourReader;

public class MatFileReader
extends AbstractMatReader {
    private final ArrayList<AbstractVariable> variables = new ArrayList();
    private final RandomInputStream inStream;
    private AbstractReader reader;

    public static void main(String[] stringArray) {
        String string = null;
        string = stringArray.length == 0 ? "D:/Data/Breeze/Record/ER000054/E000533/h4.mat" : stringArray[0];
        try {
            MatFileReader matFileReader = new MatFileReader(string);
            int n = matFileReader.getVariableCount();
            matFileReader.setDataVariable(0);
            if (n == 0) {
                System.out.println("No variables found!");
            } else {
                int n2;
                System.out.println("Variables:");
                for (n2 = 0; n2 < n; ++n2) {
                    System.out.println("\t" + matFileReader.getVariableName(n2));
                }
                for (n2 = 0; n2 < matFileReader.getVariableRowCount(0) && n2 < 10; ++n2) {
                    for (int i = 0; i < matFileReader.getVariableColumnCount(0) && i < 10; ++i) {
                        System.out.print(matFileReader.getDouble(n2, i, 0) + " ");
                    }
                    System.out.println();
                }
            }
        }
        catch (IOException iOException) {
            ErrorHandler.logAndReportException(iOException);
        }
    }

    public MatFileReader(String string) throws IOException {
        this.path = string;
        this.inStream = new RandomInputStream(new File(string), null);
        byte by = this.inStream.readByte();
        byte by2 = this.inStream.readByte();
        byte by3 = this.inStream.readByte();
        byte by4 = this.inStream.readByte();
        if (by == 0 || by2 == 0 || by3 == 0 || by4 == 0) {
            this.inStream.seek(0L);
            this.levelFourRead();
        } else if (by == 77 && by2 == 65 && by3 == 84 && by4 == 76) {
            this.inStream.readByte();
            this.inStream.readByte();
            this.inStream.readByte();
            byte by5 = this.inStream.readByte();
            this.inStream.seek(0L);
            if (by5 == 53) {
                this.levelFiveRead();
            } else {
                this.hdfRead();
            }
        } else if (by2 == 72 && by3 == 68 && by4 == 70) {
            this.inStream.seek(0L);
            this.hdfRead();
        }
        this.guessVariableTranspose();
    }

    @Override
    public void cleanUpChild() {
        super.cleanUpChild();
        if (this.variables != null) {
            for (AbstractVariable abstractVariable : this.variables) {
                abstractVariable.cleanUp();
            }
            this.variables.clear();
        }
    }

    @Override
    public void close() {
        this.reader.close();
    }

    @Override
    public int getDataType() {
        return this.reader.getDataType();
    }

    @Override
    public double getDouble(int n, int n2, int n3) {
        AbstractVariable abstractVariable;
        if (this.treatVariablesAsLayers && this.getLayerCount() > 1) {
            int[] nArray = this.getVariableIndexContainingLayer(n3);
            abstractVariable = this.getVariable(this.selectedIndices[nArray[0]]);
            n3 = nArray[1];
            this.currentVarRow = n;
            this.currentVarColumn = n2;
        } else {
            abstractVariable = this.getVariableAt(n, n2);
        }
        if (abstractVariable == null) {
            return 0.0;
        }
        return abstractVariable.getDouble(this.currentVarRow, this.currentVarColumn, n3);
    }

    @Override
    public FastDecimal getDouble(int n, int n2, int n3, FastDecimal fastDecimal) {
        AbstractVariable abstractVariable;
        if (this.treatVariablesAsLayers && this.getLayerCount() > 1) {
            int[] nArray = this.getVariableIndexContainingLayer(n3);
            abstractVariable = this.getVariable(this.selectedIndices[nArray[0]]);
            n3 = nArray[1];
            this.currentVarRow = n;
            this.currentVarColumn = n2;
        } else {
            abstractVariable = this.getVariableAt(n, n2);
        }
        if (abstractVariable == null) {
            fastDecimal.error();
            return fastDecimal;
        }
        return abstractVariable.getDouble(this.currentVarRow, this.currentVarColumn, n3, fastDecimal);
    }

    public String getFileDescription() {
        return "";
    }

    @Override
    public String getString(int n, int n2, int n3) {
        AbstractVariable abstractVariable = this.getVariableAt(n, n2);
        if (abstractVariable == null) {
            return "";
        }
        return abstractVariable.getString(this.currentVarRow, this.currentVarColumn, n3);
    }

    @Override
    public int getVariableColumnCount(int n) {
        AbstractVariable abstractVariable = this.getVariable(n);
        if (abstractVariable == null) {
            return 0;
        }
        return abstractVariable.getColumnCount();
    }

    @Override
    public int getVariableCount() {
        return this.variables.size();
    }

    @Override
    public int getVariableLayerCount(int n) {
        AbstractVariable abstractVariable = this.getVariable(n);
        if (abstractVariable == null) {
            return 0;
        }
        return abstractVariable.getLayerCount();
    }

    @Override
    public String getVariableName(int n) {
        AbstractVariable abstractVariable = this.getVariable(n);
        if (abstractVariable == null) {
            return "N/A";
        }
        return abstractVariable.getName();
    }

    @Override
    public int getVariableRowCount(int n) {
        AbstractVariable abstractVariable = this.getVariable(n);
        if (abstractVariable == null) {
            return 0;
        }
        return abstractVariable.getRowCount();
    }

    @Override
    public String getVariableTypeName(int n) {
        AbstractVariable abstractVariable = this.getVariable(n);
        if (abstractVariable == null) {
            return "N/A";
        }
        return abstractVariable.getTypeName();
    }

    @Override
    public boolean isData(int n) {
        AbstractVariable abstractVariable = this.getVariable(n);
        if (abstractVariable == null) {
            return false;
        }
        return abstractVariable.isData();
    }

    @Override
    public boolean isHdf5() {
        return false;
    }

    @Override
    public boolean isTransposed(int n) {
        AbstractVariable abstractVariable = this.getVariable(n);
        if (abstractVariable == null) {
            return false;
        }
        return abstractVariable.isTransposed();
    }

    @Override
    public boolean readFile() {
        return false;
    }

    @Override
    public void setTransposed(int n, boolean bl) {
        AbstractVariable abstractVariable = this.getVariable(n);
        if (abstractVariable == null) {
            return;
        }
        abstractVariable.setTransposed(bl);
    }

    private AbstractVariable getVariable(int n) {
        if (n < 0 || n >= this.variables.size()) {
            return null;
        }
        return this.variables.get(n);
    }

    private AbstractVariable getVariableAt(int n, int n2) {
        int n3 = this.getVariableIndexAt(n, n2);
        if (n3 == -1) {
            return null;
        }
        return this.getVariable(n3);
    }

    private final void guessVariableTranspose() {
        Iterator<AbstractVariable> iterator = this.variables.iterator();
        AbstractVariable abstractVariable = null;
        while (iterator.hasNext()) {
            AbstractVariable abstractVariable2 = iterator.next();
            if (!abstractVariable2.isData() || abstractVariable != null && abstractVariable2.getRowCount() <= abstractVariable.getRowCount() && abstractVariable2.getColumnCount() <= abstractVariable.getColumnCount()) continue;
            abstractVariable = abstractVariable2;
        }
        if (abstractVariable == null) {
            return;
        }
        int n = abstractVariable.getRowCount();
        int n2 = abstractVariable.getColumnCount();
        for (AbstractVariable abstractVariable3 : this.variables) {
            int n3 = abstractVariable3.getRowCount();
            int n4 = abstractVariable3.getColumnCount();
            if (n3 == n || n4 == n2 || n3 != n2 && n4 != n) continue;
            abstractVariable3.setTransposed(true);
        }
    }

    private final void hdfRead() throws IOException {
        this.reader = new HdfReader(this.inStream);
        this.reader.getVariables(this.variables);
    }

    private final void levelFiveRead() throws IOException {
        this.reader = new LevelFiveReader(this.inStream);
        this.reader.getVariables(this.variables);
    }

    private final void levelFourRead() throws IOException {
        this.reader = new LevelFourReader(this.inStream);
        this.reader.getVariables(this.variables);
    }
}

