/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.mat;

import ch.systemsx.cisd.hdf5.HDF5DataSetInformation;
import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.HDF5LinkInformation;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import ncsa.hdf.hdf5lib.exceptions.HDF5FileNotFoundException;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.dataimport.mat.AbstractMatReader;
import se.prediktera.map.dataimport.mat.AbstractVariable;

public class MatFileReader73
extends AbstractMatReader {
    private final File file;
    private final List<Hdf5DataWrapper> variables = new ArrayList<Hdf5DataWrapper>();
    private IHDF5Reader hdfReader;
    private int maximumformatbytesize;
    private double[] wavelengths;

    public static void main(String[] stringArray) {
        MatFileReader73 matFileReader73 = new MatFileReader73("C:\\TestData\\H5\\NEONDSImagingSpectrometerData.h5");
        matFileReader73.readFile();
        System.out.println(matFileReader73.variables.size());
        for (Hdf5DataWrapper hdf5DataWrapper : matFileReader73.variables) {
            System.out.println(hdf5DataWrapper.rowCount + ", " + hdf5DataWrapper.columnCount + ", " + hdf5DataWrapper.layerCount);
        }
        if (matFileReader73.wavelengths != null) {
            System.out.println("Wavelength:" + matFileReader73.wavelengths[0]);
        }
    }

    public MatFileReader73(String string) {
        this.path = string;
        this.file = new File(string);
    }

    @Override
    public void cleanUpChild() {
        super.cleanUpChild();
        this.hdfReader.close();
        for (Hdf5DataWrapper hdf5DataWrapper : this.variables) {
            hdf5DataWrapper.clearCache();
        }
    }

    @Override
    public void close() {
        if (this.hdfReader != null) {
            this.hdfReader.close();
            this.hdfReader = null;
        }
    }

    @Override
    public int getDataType() {
        return switch (this.maximumformatbytesize) {
            case 1 -> 0;
            case 2 -> 1;
            case 4 -> 4;
            case 8 -> 5;
            default -> 4;
        };
    }

    @Override
    public double getDouble(int n, int n2, int n3) {
        Hdf5DataWrapper hdf5DataWrapper;
        if (this.treatVariablesAsLayers && this.getLayerCount() > 1) {
            int[] nArray = this.getVariableIndexContainingLayer(n3);
            hdf5DataWrapper = this.getVariable(this.selectedIndices[nArray[0]]);
            n3 = nArray[1];
            this.currentVarRow = n;
            this.currentVarColumn = n2;
        } else {
            hdf5DataWrapper = this.getVariableAt(n, n2);
        }
        if (hdf5DataWrapper == null) {
            return 0.0;
        }
        return this.getLocalDouble(hdf5DataWrapper, this.currentVarRow, this.currentVarColumn, n3);
    }

    @Override
    public FastDecimal getDouble(int n, int n2, int n3, FastDecimal fastDecimal) {
        Hdf5DataWrapper hdf5DataWrapper;
        if (this.treatVariablesAsLayers && this.getLayerCount() > 1) {
            int[] nArray = this.getVariableIndexContainingLayer(n3);
            hdf5DataWrapper = this.getVariable(this.selectedIndices[nArray[0]]);
            n3 = nArray[1];
            this.currentVarRow = n;
            this.currentVarColumn = n2;
        } else {
            hdf5DataWrapper = this.getVariableAt(n, n2);
        }
        if (hdf5DataWrapper == null) {
            fastDecimal.error();
            return fastDecimal;
        }
        return hdf5DataWrapper.getDouble(this.currentVarRow, this.currentVarColumn, n3, fastDecimal);
    }

    @Override
    public String getLayerName(int n) {
        if (this.wavelengths != null && n < this.wavelengths.length) {
            return NiceDataFormat.toString(this.wavelengths[n]);
        }
        return super.getLayerName(n);
    }

    public FastDecimal getFastDecimal(double d, FastDecimal fastDecimal) {
        if (!this.isData(0)) {
            fastDecimal.error();
            return fastDecimal;
        }
        fastDecimal.setValue(d);
        return fastDecimal;
    }

    @Override
    public String getString(int n, int n2, int n3) {
        return String.valueOf(this.getDouble(n, n2, n3));
    }

    @Override
    public int getVariableColumnCount(int n) {
        return this.variables.get(n).getColumnCount();
    }

    @Override
    public int getVariableCount() {
        return 1;
    }

    @Override
    public int getVariableLayerCount(int n) {
        return this.variables.get(n).getLayerCount();
    }

    @Override
    public String getVariableName(int n) {
        return this.variables.get(n).getName();
    }

    @Override
    public int getVariableRowCount(int n) {
        return this.variables.get(n).getRowCount();
    }

    @Override
    public String getVariableTypeName(int n) {
        return this.variables.get(n).getLinkInfo().getType().name();
    }

    @Override
    public boolean isData(int n) {
        return this.hdfReader.getDataSetInformation(this.variables.get(n).getLinkInfo().getPath()).getTypeInformation().getDataClass() != null;
    }

    @Override
    public boolean isHdf5() {
        return true;
    }

    @Override
    public boolean isTransposed(int n) {
        return this.variables.get(n).isTransposed();
    }

    @Override
    public boolean readFile() {
        block3: {
            try {
                this.hdfReader = HDF5Factory.openForReading((String)this.file.getAbsolutePath());
                for (HDF5LinkInformation hDF5LinkInformation : this.findDatasetsInGroup("/")) {
                    Hdf5DataWrapper hdf5DataWrapper = new Hdf5DataWrapper(hDF5LinkInformation);
                    this.variables.add(hdf5DataWrapper);
                    hdf5DataWrapper.setCache();
                    double[] dArray = hdf5DataWrapper.findWavelengths();
                    if (dArray == null) continue;
                    this.wavelengths = dArray;
                }
                this.maximumformatbytesize = 5;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (!(exception instanceof HDF5FileNotFoundException)) break block3;
                return false;
            }
        }
        return true;
    }

    private List<HDF5LinkInformation> findDatasetsInGroup(String string) {
        ArrayList<HDF5LinkInformation> arrayList = new ArrayList<HDF5LinkInformation>();
        List list = this.hdfReader.object().getGroupMemberInformation(string, true);
        for (HDF5LinkInformation hDF5LinkInformation : list) {
            String string2 = hDF5LinkInformation.getPath();
            if (this.hdfReader.object().isDataSet(string2)) {
                arrayList.add(hDF5LinkInformation);
                continue;
            }
            if (!this.hdfReader.object().isGroup(string2)) continue;
            arrayList.addAll(this.findDatasetsInGroup(string2));
        }
        return arrayList;
    }

    @Override
    public void setTransposed(int n, boolean bl) {
        this.variables.get(n).setTransposed(bl);
    }

    private double getLocalDouble(Hdf5DataWrapper hdf5DataWrapper, int n, int n2, int n3) {
        return hdf5DataWrapper.getValue(n, n2, n3);
    }

    private Hdf5DataWrapper getVariable(int n) {
        return this.variables.get(n);
    }

    private Hdf5DataWrapper getVariableAt(int n, int n2) {
        int n3 = this.getVariableIndexAt(n, n2);
        if (n3 == -1) {
            return null;
        }
        return this.getVariable(n3);
    }

    private class Hdf5DataWrapper
    extends AbstractVariable {
        private boolean transposed;
        private double[] dataCache;
        private final HDF5LinkInformation linkInfo;

        public Hdf5DataWrapper(HDF5LinkInformation hDF5LinkInformation) {
            this.linkInfo = hDF5LinkInformation;
            HDF5DataSetInformation hDF5DataSetInformation = MatFileReader73.this.hdfReader.getDataSetInformation(hDF5LinkInformation.getPath());
            long[] lArray = hDF5DataSetInformation.getDimensions();
            if (lArray.length == 3) {
                this.rowCount = (int)lArray[2];
                this.columnCount = (int)lArray[1];
                this.layerCount = (int)lArray[0];
            } else if (lArray.length == 2) {
                this.rowCount = (int)lArray[1];
                this.columnCount = (int)lArray[0];
            } else {
                this.rowCount = (int)lArray[0];
                this.columnCount = 1;
            }
            this.name = hDF5LinkInformation.getName();
        }

        public void clearCache() {
            this.dataCache = null;
        }

        @Override
        public String getTypeName() {
            return null;
        }

        @Override
        public boolean isData() {
            return true;
        }

        @Override
        public boolean isTransposed() {
            return this.transposed;
        }

        @Override
        public void setTransposed(boolean bl) {
            this.transposed = bl;
        }

        @Override
        protected void cleanUpChild() {
            this.dataCache = null;
        }

        @Override
        double getDouble(int n, int n2, int n3) {
            return this.dataCache[this.getIndex(n, n2, n3)];
        }

        @Override
        String getString(int n, int n2, int n3) {
            return null;
        }

        private int getIndex(int n, int n2, int n3) {
            return n3 * this.rowCount * this.columnCount + n2 * this.rowCount + n;
        }

        private double getValue(int n, int n2, int n3) {
            return this.dataCache[this.getIndex(n, n2, n3)];
        }

        private double[] setCache() {
            try {
                this.dataCache = MatFileReader73.this.hdfReader.readDoubleArray(this.linkInfo.getPath());
                return this.dataCache;
            }
            catch (Exception exception) {
                this.dataCache = new double[this.layerCount * this.rowCount * this.columnCount];
                return this.dataCache;
            }
        }

        public HDF5LinkInformation getLinkInfo() {
            return this.linkInfo;
        }

        public double[] findWavelengths() {
            List list = MatFileReader73.this.hdfReader.object().getAttributeNames(this.linkInfo.getPath());
            for (String string : list) {
                try {
                    String string2 = MatFileReader73.this.hdfReader.getStringAttribute(this.linkInfo.getPath(), string);
                    if (!"Wavelength".equalsIgnoreCase(string2.trim())) continue;
                    return MatFileReader73.this.hdfReader.getDoubleArrayAttribute(this.linkInfo.getPath(), string.replace(" Name", ""));
                }
                catch (Exception exception) {
                }
            }
            if (this.linkInfo.getName().equalsIgnoreCase("wavelength")) {
                return this.dataCache;
            }
            return null;
        }
    }
}

