/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.mat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataimport.AbstractImportPanel;
import se.prediktera.map.dataimport.ImportInterface;
import se.prediktera.map.dataimport.mat.AbstractMatReader;
import se.prediktera.map.dataimport.mat.MatFileReader;
import se.prediktera.map.dataimport.mat.MatFileReader73;
import se.prediktera.map.dataimport.mat.MatReaderInterface;
import se.prediktera.map.dataimport.mat.MatTableModel;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class MatImportPanel
extends AbstractImportPanel {
    private MatReaderInterface fileReader;
    private final JTable varTable = new JTable();
    private final JCheckBox setAsLayersBox = new JCheckBox("Use variables as layers", false);

    public MatImportPanel(ImportInterface importInterface) {
        super(importInterface.getFiles());
        this.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel("File Name:");
        jLabel.setFont(new Font("SansSerif", 1, 12));
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel2 = new JLabel(this.filenames[0].getName());
        JLabel jLabel3 = new JLabel("Select Variable(s)");
        jLabel3.setFont(new Font("SansSerif", 1, 12));
        this.add((Component)jPanel, "Center");
        this.setAsLayersBox.setEnabled(false);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.setAsLayersBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 100, 0, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 6, 0, 0), 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(12, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JScrollPane(this.varTable), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 13, 1, new Insets(6, 0, 0, 0), 0, 0));
        try {
            this.fileReader = new MatFileReader73(this.filenames[0].getPath());
            if (!this.fileReader.readFile()) {
                this.fileReader = new MatFileReader(this.filenames[0].getPath());
            }
            this.varTable.setSelectionMode(2);
            this.varTable.setModel(new TableModel(this.fileReader));
            if (this.varTable.getRowCount() > 0) {
                this.varTable.setRowSelectionInterval(0, this.varTable.getRowCount() - 1);
            }
            this.varTable.getSelectionModel().addListSelectionListener(listSelectionEvent -> {
                this.ciModel = null;
                this.enableOrDisableCheckBox();
            });
            this.enableOrDisableCheckBox();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(Main_GUI.get(), iOException.getMessage(), "Failed to read file", 2);
        }
    }

    @Override
    public boolean canFinish() {
        return false;
    }

    @Override
    public boolean canNext() {
        return this.varTable.getSelectedRows().length > 0;
    }

    @Override
    public String getType() {
        return "Matlab";
    }

    @Override
    public boolean hasSettings() {
        return true;
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.fileReader != null) {
            ((AbstractMatReader)this.fileReader).cleanUp();
            this.fileReader.close();
            this.fileReader = null;
        }
    }

    @Override
    protected CellIdentifierModel getTableModel(ProgressManager progressManager, boolean bl) {
        if (this.fileReader == null) {
            return null;
        }
        this.fileReader.selectVariables(this.setAsLayersBox.isSelected(), this.varTable.getSelectedRows());
        return new MatTableModel(this.fileReader, this.setAsLayersBox.isSelected());
    }

    private void enableOrDisableCheckBox() {
        if (this.varTable.getSelectedRowCount() > 1) {
            int n = this.varTable.getSelectedRowCount();
            int n2 = 0;
            int n3 = 0;
            boolean bl = true;
            boolean bl2 = true;
            for (int i = 0; i < n; ++i) {
                int n4 = this.varTable.getSelectedRows()[i];
                if (bl) {
                    n2 = (Integer)this.varTable.getValueAt(n4, 2);
                    n3 = (Integer)this.varTable.getValueAt(n4, 3);
                    bl = false;
                    continue;
                }
                if ((Integer)this.varTable.getValueAt(n4, 2) == n2 && (Integer)this.varTable.getValueAt(n4, 3) == n3) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                System.out.println("Enable checkbox.");
                this.setAsLayersBox.setEnabled(true);
            } else {
                System.out.println("Do not enable checkbox.");
                this.setAsLayersBox.setEnabled(false);
                this.setAsLayersBox.setSelected(false);
            }
        }
    }

    private class TableModel
    extends DefaultTableModel {
        private final MatReaderInterface reader;

        public TableModel(MatReaderInterface matReaderInterface) {
            this.reader = matReaderInterface;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 5) {
                return Boolean.class;
            }
            if (n == 2 || n == 3 || n == 4) {
                return Integer.class;
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Type";
                }
                case 2: {
                    return "Rows";
                }
                case 3: {
                    return "Columns";
                }
                case 4: {
                    return "Layers";
                }
                case 5: {
                    return "Transposed";
                }
            }
            return "";
        }

        @Override
        public int getRowCount() {
            if (this.reader == null) {
                return 0;
            }
            return this.reader.getVariableCount();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.reader.getVariableName(n);
                }
                case 1: {
                    return this.reader.getVariableTypeName(n);
                }
                case 2: {
                    return this.reader.getVariableRowCount(n);
                }
                case 3: {
                    return this.reader.getVariableColumnCount(n);
                }
                case 4: {
                    return this.reader.getVariableLayerCount(n);
                }
                case 5: {
                    return this.reader.isTransposed(n);
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 5;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 5 && object instanceof Boolean) {
                this.reader.setTransposed(n, (Boolean)object);
                MatImportPanel.this.varTable.repaint();
                MatImportPanel.this.ciModel = null;
            }
        }
    }
}

