/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.mat;

import java.io.File;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.dataimport.mat.MatReaderInterface;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class MatTableModel
extends CellIdentifierModel {
    final MatReaderInterface fileReader;
    boolean variablesAsLayers;
    int layer = 0;

    public MatTableModel(MatReaderInterface matReaderInterface, boolean bl) {
        super(matReaderInterface.getRowCount(), matReaderInterface.getColumnCount());
        this.variablesAsLayers = bl;
        this.fileReader = matReaderInterface;
        this.dataType = matReaderInterface.getDataType();
    }

    @Override
    public void autoIdentifyData(ProgressManager progressManager, int n) {
        int n2;
        for (n2 = 0; n2 < this.fileReader.getExtraColsCount(); ++n2) {
            this.addInterval(1, n2, (byte)1);
            if (n2 != 0) continue;
            this.setPrimaryCol(0);
        }
        for (n2 = 0; n2 < this.fileReader.getExtraRowsCount(); ++n2) {
            this.addInterval(0, n2, (byte)0);
            if (n2 != 0) continue;
            this.setPrimaryRow(0);
        }
    }

    @Override
    public final int[] getDataOrder() {
        if (this.transpose) {
            return new int[]{1, 0, 2};
        }
        return new int[]{0, 1, 2};
    }

    @Override
    public final FastDecimal getDoubleAt_Transpose(int n, int n2, FastDecimal fastDecimal) {
        return this.fileReader.getDouble(n, n2, this.layer, fastDecimal);
    }

    @Override
    public final int getLayerCount() {
        return this.fileReader.getLayerCount();
    }

    @Override
    public final String getLayerName(int n) {
        return this.fileReader.getLayerName(n);
    }

    @Override
    public File getRootFolder() {
        File file = new File(this.fileReader.getPath());
        if (file.isFile()) {
            return file.getParentFile();
        }
        return file;
    }

    @Override
    public final Object getValueAt_Transpose(int n, int n2) {
        return this.fileReader.getString(n, n2, this.layer);
    }

    @Override
    public final void setCurrentLayer(int n) {
        this.layer = n;
    }
}

