/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.merge;

import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataimport.AbstractDataSource;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;

public class MergeDataSource
extends AbstractDataSource {
    private final AbstractDataMatrix[] matrices;
    private int lindex;
    private int lrow;
    private int lcol;

    public MergeDataSource(AbstractDataMatrix[] abstractDataMatrixArray, byte by) throws IOException {
        super(by);
        this.matrices = abstractDataMatrixArray;
        this.refreshDataSourceLocal(null);
    }

    public MergeDataSource(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.matrices = new AbstractDataMatrix[2];
        this.matrices[0] = (AbstractDataMatrix)mapProperty.resolveNodeFromName(randomInputStream, "m1");
        this.matrices[1] = (AbstractDataMatrix)mapProperty.resolveNodeFromName(randomInputStream, "m2");
    }

    @Override
    public void closeConnections() {
    }

    public final FastDecimal getDoubleAt_Transpose(int n, int n2) {
        if (!this.refreshing && this.isloaded) {
            this.resolveLocalIndex(n, n2);
            this.fastDecimal.setValue(this.matrices[this.lindex].getValue(this.lrow, this.lcol));
        }
        return this.fastDecimal.error();
    }

    @Override
    public String getInformation() {
        StringBuilder stringBuilder = new StringBuilder("");
        return stringBuilder.toString();
    }

    @Override
    public String getName() {
        return "Merge";
    }

    @Override
    public byte getTreeType() {
        return 1;
    }

    @Override
    public final Object getValueAt_Transpose(int n, int n2) {
        if (!this.refreshing && this.isloaded) {
            this.resolveLocalIndex(n, n2);
            return "MV";
        }
        return "1.0";
    }

    @Override
    public boolean isMultiImport() {
        return true;
    }

    @Override
    public void refreshDataSourceLocal(ProgressManager progressManager) throws IOException {
        switch (this.mergeType) {
            case 1: {
                this.rows = this.matrices[0].getN() + this.matrices[1].getN();
                this.columns = this.matrices[0].getK();
                break;
            }
            case 2: {
                this.rows = this.matrices[0].getK() + this.matrices[1].getK();
                this.columns = this.matrices[0].getN();
            }
        }
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyNode("m1", this.matrices[0]);
        randomOutputStream.writePropertyNode("m2", this.matrices[1]);
    }

    private void resolveLocalIndex(int n, int n2) {
        switch (this.mergeType) {
            case 1: {
                this.lcol = n2;
                if (n >= this.matrices[0].getN()) {
                    this.lindex = 1;
                    this.lrow = n - this.matrices[0].getN();
                    break;
                }
                this.lindex = 0;
                break;
            }
            case 2: {
                this.lrow = n;
                if (n2 >= this.matrices[0].getK()) {
                    this.lindex = 1;
                    this.lcol = n2 - this.matrices[0].getK();
                    break;
                }
                this.lindex = 0;
            }
        }
    }
}

