/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.merge;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;

public class MergeDialog
extends JDialog {
    JPanel jPanel1 = new JPanel();
    PanelVisual panelVisual = new PanelVisual();
    BorderLayout borderLayout1 = new BorderLayout();
    JRadioButton radioHorizontal = new JRadioButton();
    JRadioButton radioVertical = new JRadioButton();
    JCheckBox checkReverse = new JCheckBox();
    TitledBorder titledBorder1;
    ButtonGroup buttonGroup = new ButtonGroup();
    JPanel jPanel2 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel3 = new JPanel();
    RadioChanged radioChanged = new RadioChanged();
    TitledBorder titledBorder2;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JTextField textCellAmatrix = new JTextField();
    JTextField textCellBmatrix = new JTextField();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JLabel jLabel4 = new JLabel();
    JLabel jLabel5 = new JLabel();
    Project_GUI p_gui;

    public MergeDialog() {
        super(Main_GUI.get(), "Merge settings", true);
        try {
            this.jbInit();
            this.setLocationRelativeTo(null);
            this.pack();
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    public boolean isReverse() {
        return this.checkReverse.isSelected();
    }

    public boolean mergeRows() {
        return this.radioVertical.isSelected();
    }

    public void showModal(AbstractDataMatrix abstractDataMatrix, AbstractDataMatrix abstractDataMatrix2) {
        if (abstractDataMatrix != null) {
            this.textCellAmatrix.setText(abstractDataMatrix.toString());
        }
        if (abstractDataMatrix2 != null) {
            this.textCellBmatrix.setText(abstractDataMatrix2.toString());
        }
        this.setVisible(true);
    }

    private void jbInit() throws Exception {
        JPanel jPanel = (JPanel)this.getContentPane();
        this.textCellAmatrix.setEnabled(false);
        this.textCellBmatrix.setEnabled(false);
        this.titledBorder1 = new TitledBorder(EvinceBorderFactory.createEvinceBorder(), "Merge Layout");
        this.titledBorder2 = new TitledBorder(EvinceBorderFactory.createEvinceBorder(), "Merge Matrices");
        this.jPanel2.setLayout(this.borderLayout1);
        this.radioHorizontal.setText("Horizontal Merge");
        this.radioHorizontal.addItemListener(this.radioChanged);
        this.radioVertical.setSelected(true);
        this.radioVertical.setText("Vertical Merge");
        this.radioVertical.addItemListener(this.radioChanged);
        this.checkReverse.setText("Reverse");
        this.checkReverse.addItemListener(itemEvent -> this.panelVisual.repaint());
        this.jPanel2.setBorder(this.titledBorder1);
        jPanel.setLayout(this.borderLayout2);
        this.jPanel3.setBorder(this.titledBorder2);
        this.jPanel3.setLayout(this.gridBagLayout1);
        this.jLabel2.setText("matrix");
        this.jLabel3.setFont(new Font("Dialog", 1, 16));
        this.jLabel3.setText("A");
        this.jLabel4.setText("matrix");
        this.jLabel5.setFont(new Font("Dialog", 1, 16));
        this.jLabel5.setToolTipText("");
        this.jLabel5.setText("B");
        this.jPanel2.add((Component)this.jPanel1, "North");
        this.jPanel1.add((Component)this.checkReverse, null);
        this.jPanel1.add((Component)this.radioVertical, null);
        this.jPanel1.add((Component)this.radioHorizontal, null);
        jPanel.add((Component)this.jPanel3, "North");
        this.jPanel3.add((Component)this.textCellBmatrix, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 15, 2, new Insets(0, 0, 10, 10), 0, 0));
        this.jPanel3.add((Component)this.textCellAmatrix, new GridBagConstraints(3, 0, 1, 2, 1.0, 0.0, 15, 2, new Insets(0, 0, 10, 10), 0, 0));
        this.jPanel3.add((Component)this.jLabel1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel3.add((Component)this.jLabel2, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 15, 0, new Insets(0, 0, 10, 0), 0, 0));
        this.jPanel3.add((Component)this.jLabel3, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 15, 0, new Insets(10, 10, 10, 0), 0, 0));
        this.jPanel3.add((Component)this.jLabel4, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 15, 0, new Insets(0, 5, 10, 5), 0, 0));
        this.jPanel3.add((Component)this.jLabel5, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 10, 10, 0), 0, 0));
        jPanel.add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.panelVisual, "Center");
        this.buttonGroup.add(this.radioVertical);
        this.buttonGroup.add(this.radioHorizontal);
    }

    class PanelVisual
    extends JPanel {
        private final BasicStroke stroke = new BasicStroke(1.0f, 1, 0, 10.0f);
        private final BasicStroke stroke2 = new BasicStroke(2.0f, 1, 0, 10.0f);

        PanelVisual() {
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            int n = this.getWidth();
            int n2 = n / 2;
            int n3 = n / 3;
            int n4 = this.getHeight();
            int n5 = n4 / 2;
            int n6 = n4 / 4;
            int n7 = n4 / 3;
            int n8 = n7 / 2;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.setAppearence(graphics2D, MergeDialog.this.radioVertical.isSelected());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            String string = !MergeDialog.this.checkReverse.isSelected() ? "A" : "B";
            String string2 = MergeDialog.this.checkReverse.isSelected() ? "A" : "B";
            graphics2D.drawRect(10, 10, n3 - 20, n5 - 10);
            graphics2D.drawString(string, n3 / 2 - fontMetrics.stringWidth(string) / 2, n6);
            graphics2D.drawRect(10, n5, n3 - 20, n5 - 10);
            graphics2D.drawString(string2, n3 / 2 - fontMetrics.stringWidth(string2) / 2, n5 + n6);
            this.setAppearence(graphics2D, MergeDialog.this.radioHorizontal.isSelected());
            graphics2D.drawRect(n3 + 10, n5 - n8, n3 - 10, n7);
            graphics2D.drawString(string, n3 + n3 / 2 - fontMetrics.stringWidth(string) / 2, n5);
            graphics2D.drawRect(n3 + n3, n5 - n8, n3 - 10, n7);
            graphics2D.drawString(string2, n3 + n2 - fontMetrics.stringWidth(string2) / 2, n5);
        }

        private void setAppearence(Graphics2D graphics2D, boolean bl) {
            if (bl) {
                graphics2D.setFont(new Font("Dialog", 1, 16));
                graphics2D.setStroke(this.stroke2);
                graphics2D.setColor(Color.black);
            } else {
                graphics2D.setFont(new Font("Dialog", 0, 16));
                graphics2D.setStroke(this.stroke);
                graphics2D.setColor(Color.darkGray);
            }
        }
    }

    class RadioChanged
    implements ItemListener {
        RadioChanged() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            MergeDialog.this.panelVisual.repaint();
        }
    }
}

