/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.merge;

import java.awt.Dimension;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.border.EmptyBorder;
import se.prediktera.map.common.cleanup.CleanUpInterface;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.common.wizard.AbstractWizard;
import se.prediktera.map.common.wizard.FileChooserPage;
import se.prediktera.map.common.wizard.WizardDialog;
import se.prediktera.map.common.wizard.WizardPageClass;
import se.prediktera.map.dataimport.AbstractImportInfo;
import se.prediktera.map.dataimport.AbstractImportPanel;
import se.prediktera.map.dataimport.ImportInterface;
import se.prediktera.map.dataimport.MultiImportPanel;
import se.prediktera.map.dataimport.identifier.CellIdentifierPanel;
import se.prediktera.map.dataimport.merge.OriginalDataSource;
import se.prediktera.map.dataimport.multi.MultiCellIdentifierModel;
import se.prediktera.map.dataimport.multi.MultiImageImportPanel;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.main.Evince;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class MergeWizard
extends AbstractWizard
implements ImportInterface {
    private AbstractImportPanel importPanel = null;
    private CellIdentifierPanel cellIdentifierPanel;
    private MultiImageImportPanel multiImageImportPanel;
    private boolean showAutoIdentify;
    private final Project_GUI project_GUI;
    private MultiImportPanel multiImportPanel;
    private File[] openFiles;
    private int lastpage = -1;
    private CellIdentifierModel multiModel;

    public static void main(String[] stringArray) throws Exception {
        Evince.initNoShow();
        MVmatrix mVmatrix = new MVmatrix(10, 10, "Test");
        for (int i = 0; i < mVmatrix.getN(); ++i) {
            for (int j = 0; j < mVmatrix.getK(); ++j) {
                mVmatrix.setValue(i, j, i * j);
            }
        }
        OriginalDataSource originalDataSource = new OriginalDataSource(mVmatrix);
        MergeWizard mergeWizard = new MergeWizard(null, originalDataSource);
        mergeWizard.executeWizard();
    }

    public MergeWizard(Project_GUI project_GUI, OriginalDataSource originalDataSource) {
        this.project_GUI = project_GUI;
        this.multiImageImportPanel = new MultiImageImportPanel(this, originalDataSource);
        this.setBorder(new EmptyBorder(4, 12, 0, 12));
        this.addPage(this.multiImageImportPanel, "Page1");
        this.cellIdentifierPanel = new CellIdentifierPanel(this, false, true, false);
        this.addPage(this.cellIdentifierPanel, "Page2");
    }

    @Override
    public boolean canFinish() {
        return this.currentPage != null && (this.currentPage.canFinish() || !this.showAutoIdentify && this.currentPage.canNext());
    }

    @Override
    public void cleanUpChild() {
        super.cleanUpChild();
        if (this.multiImportPanel != null) {
            this.multiImportPanel.cleanUp();
            this.multiImportPanel = null;
        }
        if (this.importPanel != null) {
            this.importPanel.cleanUp();
            this.importPanel = null;
        }
        if (this.cellIdentifierPanel != null) {
            this.cellIdentifierPanel.cleanUp();
            this.cellIdentifierPanel = null;
        }
        if (this.multiImageImportPanel != null) {
            this.multiImageImportPanel.cleanUp();
            this.multiImageImportPanel = null;
        }
    }

    @Override
    public int executeWizard() {
        return this.executeWizard(null);
    }

    public int executeWizard(File file) {
        this.setPreferredSize(new Dimension(800, 600));
        this.wizardWindow = new WizardDialog("Data Merge Wizard", this, true, true, false);
        if (file != null && file.exists()) {
            return this.wizardWindow.executeWizard(1);
        }
        return this.wizardWindow.executeWizard(0);
    }

    @Override
    public boolean finished() {
        return this.canFinish();
    }

    public void finishIdentify(ProgressManager progressManager) {
        if (this.importPanel != null) {
            this.importPanel.finishIdentify(progressManager);
        }
    }

    public String finishImport(ProgressManager progressManager, CellIdentifierModel cellIdentifierModel, AbstractDataMatrix abstractDataMatrix) {
        if (cellIdentifierModel instanceof MultiCellIdentifierModel) {
            MultiCellIdentifierModel multiCellIdentifierModel = (MultiCellIdentifierModel)cellIdentifierModel;
            return multiCellIdentifierModel.finishImport(progressManager, abstractDataMatrix);
        }
        Object object = null;
        for (int i = 0; i < this.getPageCount(); ++i) {
            String string;
            if (!(this.getPageAt(i) instanceof WizardPageClass) || (string = this.getWizardPageAt(i).finishImport(progressManager, cellIdentifierModel, abstractDataMatrix)) == null) continue;
            object = object == null ? string : (String)object + string;
        }
        return object;
    }

    public CellIdentifierModel getCellIdentifierModel() {
        return this.getCellIdentifierModel(null);
    }

    public CellIdentifierModel getCellIdentifierModel(ProgressManager progressManager) {
        if (this.importPanel != null) {
            return this.importPanel.getCellIdentifierModel(progressManager);
        }
        return this.multiModel;
    }

    @Override
    public String getDescription() {
        return "Merge";
    }

    @Override
    public File[] getFiles() {
        if (this.multiImportPanel != null) {
            return this.multiImportPanel.getFiles();
        }
        return this.openFiles;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public byte getMergeType() {
        if (this.multiImportPanel != null) {
            return this.multiImportPanel.getMergeType();
        }
        return 0;
    }

    @Override
    public Project_GUI getProjectGUI() {
        return this.project_GUI;
    }

    @Override
    public boolean includeFileNames() {
        if (this.multiImportPanel != null) {
            return this.multiImportPanel.includeFileNames();
        }
        return false;
    }

    @Override
    public boolean isLastPage() {
        return super.isLastPage() && this.currentPage != null && !(this.currentPage instanceof FileChooserPage);
    }

    public void setMultiImportPanel(AbstractImportInfo abstractImportInfo, CellIdentifierModel cellIdentifierModel) throws Exception {
        this.multiModel = cellIdentifierModel;
        abstractImportInfo.getImportPanel(this, null);
        this.importPanel = null;
    }

    @Override
    public boolean showStepsOnFirstPage() {
        return false;
    }

    public int showWizard() {
        this.wizardWindow = new WizardDialog("Data Merge Wizard", this, true, true, false);
        return ((WizardDialog)this.wizardWindow).showWizard();
    }

    @Override
    protected String getHelpID() {
        return "evinceMergeproject";
    }

    @Override
    protected void pageChangedLocal(WizardPageClass wizardPageClass, int n) {
        if (wizardPageClass instanceof CellIdentifierPanel && this.lastpage < n) {
            CleanUpInterface cleanUpInterface;
            if (this.importPanel != null && (cleanUpInterface = this.importPanel.getCashedCiModel()) != null) {
                this.cellIdentifierPanel.setLayoutFromLayers(((CellIdentifierModel)cleanUpInterface).isMultiLayer(), ((CellIdentifierModel)cleanUpInterface).isMultiImport());
            }
            cleanUpInterface = new ProgressManagerImpl(){

                @Override
                public Object doWork() {
                    this.setInfoText("Checking file");
                    CellIdentifierModel cellIdentifierModel = MergeWizard.this.multiModel;
                    if (MergeWizard.this.importPanel != null) {
                        cellIdentifierModel = MergeWizard.this.importPanel.getCellIdentifierModel(this, false);
                    }
                    if (cellIdentifierModel != null) {
                        if (MergeWizard.this.importPanel != null) {
                            // empty if block
                        }
                        MergeWizard.this.cellIdentifierPanel.setTableModel(this, cellIdentifierModel, true);
                    }
                    MergeWizard.this.updateTitle();
                    MergeWizard.this.updateButtons(false);
                    return null;
                }
            };
            cleanUpInterface.setDeciSeconds(1);
            cleanUpInterface.invokeLater();
        }
        this.lastpage = n;
    }
}

