/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.merge;

import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataimport.AbstractDataSource;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;

public class OriginalDataSource
extends AbstractDataSource {
    private AbstractDataMatrix originalMatrix;

    public OriginalDataSource(AbstractDataMatrix abstractDataMatrix) {
        super((byte)0);
        this.originalMatrix = abstractDataMatrix;
        this.rows = abstractDataMatrix.getN();
        this.columns = abstractDataMatrix.getK();
        this.dataSetName = abstractDataMatrix.toString();
    }

    public OriginalDataSource(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.originalMatrix = (AbstractDataMatrix)mapProperty.resolveNodeFromName(randomInputStream, "origmatrix");
    }

    @Override
    public void closeConnections() {
    }

    @Override
    public FastDecimal getDoubleAt_Transpose(int n, int n2, FastDecimal fastDecimal) {
        if (this.originalMatrix.isMissing(n, n2)) {
            return fastDecimal.error();
        }
        return fastDecimal.setValue(this.originalMatrix.getValue(n, n2));
    }

    @Override
    public String getInformation() {
        return "Original Matrix";
    }

    @Override
    public String getName() {
        return "Original Matrix";
    }

    @Override
    public byte getTreeType() {
        return 4;
    }

    @Override
    public Object getValueAt_Transpose(int n, int n2) {
        return String.valueOf(this.originalMatrix.getValue(n, n2));
    }

    @Override
    public void refreshDataSourceLocal(ProgressManager progressManager) throws IOException {
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyNode("origmatrix", this.originalMatrix);
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.originalMatrix = null;
    }
}

