/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.multi;

import java.awt.geom.GeneralPath;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataimport.AbstractDataSource;
import se.prediktera.map.dataimport.AbstractImportInfo;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.dataimport.ImportWizard;
import se.prediktera.map.dataimport.multi.MultiRefMatrix;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.transform.category.Category;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class MultiCellIdentifierModel
extends AbstractDataSource {
    private final CellIdentifierModel[][][] modelArray;
    private final int[] maxRows;
    private final int[] maxColumns;
    private final int[] maxLayers;
    private String[][] layerNames;
    private ImportWizard[][][] importWizard;
    private boolean createClass;
    private boolean createAnalogousY;
    private int layers = 0;
    private CellIdentifierModel mergeModel;
    private int mergeLayerIndex;
    private int mergeRow;
    private int mergeCol;
    private int mergeLayer;
    private int[] maxObs;
    private int[] maxVar;
    private int[] maxLayer;
    private File rootFolder = null;

    public MultiCellIdentifierModel(int n, int n2, int n3, CellIdentifierModel[][][] cellIdentifierModelArray, int[] nArray, int[] nArray2, int[] nArray3, String[][] stringArray, ImportWizard[][][] importWizardArray, boolean bl, boolean bl2) {
        super(n, n2);
        this.layers = n3;
        this.modelArray = cellIdentifierModelArray;
        this.maxRows = nArray;
        this.maxColumns = nArray2;
        this.maxLayers = nArray3;
        this.layerNames = stringArray;
        this.importWizard = importWizardArray;
        this.createClass = bl;
        this.createAnalogousY = bl2;
    }

    public MultiCellIdentifierModel(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.layers = mapProperty.getPropertyInt("layers");
        this.maxRows = mapProperty.getPropertyIntArray("maxRows", null);
        this.maxColumns = mapProperty.getPropertyIntArray("maxColumns", null);
        this.maxLayers = mapProperty.getPropertyIntArray("maxLayers", null);
        this.maxObs = mapProperty.getPropertyIntArray("maxObs", null);
        this.maxVar = mapProperty.getPropertyIntArray("maxVar", null);
        this.maxLayer = mapProperty.getPropertyIntArray("maxLayer", null);
        int n = mapProperty.getPropertyInt("m1");
        int n2 = mapProperty.getPropertyInt("m2");
        int n3 = mapProperty.getPropertyInt("m3");
        this.modelArray = new CellIdentifierModel[n][n2][n3];
        for (int i = 0; i < this.modelArray.length; ++i) {
            for (int j = 0; j < this.modelArray[i].length; ++j) {
                for (int k = 0; k < this.modelArray[i][j].length; ++k) {
                    this.modelArray[i][j][k] = (CellIdentifierModel)((Object)mapProperty.resolveNodeFromName(randomInputStream, "mA" + i + j + k));
                }
            }
        }
    }

    @Override
    public void applyModifier(ProgressManager progressManager, AbstractDataMatrix abstractDataMatrix) {
        int n = 0;
        for (int i = 0; i < this.modelArray.length; ++i) {
            int n2 = 0;
            for (int j = 0; j < this.modelArray[i].length; ++j) {
                int n3 = 0;
                for (int k = 0; k < this.modelArray[i][j].length; ++k) {
                    if (this.modelArray[i][j][k] != null) {
                        CellIdentifierModel cellIdentifierModel = this.modelArray[i][j][k];
                        MultiRefMatrix multiRefMatrix = new MultiRefMatrix(abstractDataMatrix, n, n2, n3, cellIdentifierModel.analyzeObs(), cellIdentifierModel.analyzeVar(), cellIdentifierModel.analyzeLayer());
                        cellIdentifierModel.applyModifier(progressManager, multiRefMatrix);
                    }
                    n3 += this.maxLayer[k];
                }
                n2 += this.maxVar[j];
            }
            n += this.maxObs[i];
        }
    }

    @Override
    public void autoIdentifyData(ProgressManager progressManager, int n) {
        if (this.getLayerCount() == 1) {
            super.autoIdentifyData(progressManager, n);
        }
    }

    @Override
    public ArrayList<GeneralPath> createGeneralPath() {
        return super.createGeneralPath();
    }

    @Override
    public void excludeBySelectionPath(String string) {
        this.calculateMax();
        int n = 0;
        for (int i = 0; i < this.modelArray.length; ++i) {
            int n2 = 0;
            for (int j = 0; j < this.modelArray[i].length; ++j) {
                for (int k = 0; k < this.modelArray[i][j].length; ++k) {
                    ArrayList<CellIdentifierModel.SelectionPath> arrayList;
                    CellIdentifierModel cellIdentifierModel = this.modelArray[i][j][k];
                    if (cellIdentifierModel == null || (arrayList = cellIdentifierModel.getPathList()).size() <= 0) continue;
                    for (CellIdentifierModel.SelectionPath selectionPath : arrayList) {
                        CellIdentifierModel.SelectionPath selectionPath2 = new CellIdentifierModel.SelectionPath(selectionPath.path);
                        selectionPath2.sx = n2;
                        selectionPath2.sy = n;
                        this.pathList.add(selectionPath2);
                    }
                }
                n2 += this.maxVar[j];
            }
            n += this.maxObs[i];
        }
        this.includeFromPathList(this.pathList);
    }

    public String finishImport(ProgressManager progressManager, AbstractDataMatrix abstractDataMatrix) {
        return this.finishImport(progressManager, abstractDataMatrix, null);
    }

    /*
     * WARNING - void declaration
     */
    public String finishImport(ProgressManager progressManager, AbstractDataMatrix abstractDataMatrix, Properties properties) {
        abstractDataMatrix.resetMinMax();
        Object object = "";
        this.calculateMax();
        ArrayList<CategoryHolder> arrayList = new ArrayList<CategoryHolder>();
        try {
            boolean bl = this.isMultiLayer();
            if (this.createClass) {
                Case case_ = abstractDataMatrix.getCase();
                DataSet dataSet = (DataSet)case_.getDsContainer().get(0);
                List<String> object2 = this.listReferenceCategories();
                object2.add(0, "Filename");
                for (String string : object2) {
                    if (string == null) continue;
                    CategoryHolder categoryHolder = new CategoryHolder();
                    categoryHolder.obsCategory = (Category)dataSet.createModification(progressManager, "obs", "category");
                    categoryHolder.obsCategory.setLayerName(DataTreeManager.getUniqueName(categoryHolder.obsCategory.getTreeParent(), string));
                    categoryHolder.obsIc = categoryHolder.obsCategory.getInnerColumn();
                    categoryHolder.obsCt = categoryHolder.obsIc.getObject();
                    if (!bl) {
                        categoryHolder.varCategory = (Category)dataSet.createModification(progressManager, "var", "category");
                        categoryHolder.varCategory.setLayerName(DataTreeManager.getUniqueName(categoryHolder.obsCategory.getTreeParent(), string));
                        categoryHolder.varIc = categoryHolder.varCategory.getInnerColumn();
                        categoryHolder.varCt = categoryHolder.varIc.getObject();
                    }
                    arrayList.add(categoryHolder);
                }
            }
            int n = 0;
            for (int i = 0; i < this.modelArray.length; ++i) {
                boolean n2 = false;
                for (int j = 0; j < this.modelArray[i].length; ++j) {
                    int n3 = 0;
                    for (int k = 0; k < this.modelArray[i][j].length; ++k) {
                        if (this.modelArray[i][j][k] != null) {
                            Object object2;
                            Object object3;
                            void var9_15;
                            CellIdentifierModel cellIdentifierModel = this.modelArray[i][j][k];
                            MultiRefMatrix multiRefMatrix = new MultiRefMatrix(abstractDataMatrix, n, (int)var9_15, n3, cellIdentifierModel.analyzeObs(), cellIdentifierModel.analyzeVar(), cellIdentifierModel.analyzeLayer());
                            if (this.createClass && k == 0) {
                                for (int abstractDataSource = 0; abstractDataSource < arrayList.size(); ++abstractDataSource) {
                                    int n4;
                                    short s;
                                    object3 = (CategoryHolder)arrayList.get(abstractDataSource);
                                    object2 = "NA";
                                    if (abstractDataSource < 1) {
                                        if (this.importWizard != null && (object2 = cellIdentifierModel.getReferenceFileName()) == null) {
                                            object2 = this.importWizard[i][j][k].getFiles()[0].getName();
                                        }
                                        if ((s = ((String)object2).lastIndexOf(".")) >= 0) {
                                            object2 = ((String)object2).substring(0, s);
                                        }
                                    } else {
                                        String string = cellIdentifierModel.getReferenceCategoryValue(abstractDataSource - 1);
                                        if (string != null) {
                                            object2 = string;
                                        }
                                    }
                                    if (bl) {
                                        s = ((CategoryHolder)object3).obsCt.addString((String)object2, true);
                                        for (n4 = 0; n4 < ((AbstractDataMatrix)multiRefMatrix).getK(); ++n4) {
                                            for (int i2 = 0; i2 < ((AbstractDataMatrix)multiRefMatrix).getN(); ++i2) {
                                                int n5 = abstractDataMatrix.getFoldN() * (n4 + var9_15) + n + i2;
                                                ((CategoryHolder)object3).obsIc.setValueShort(n5, s);
                                            }
                                        }
                                        continue;
                                    }
                                    if (j == 0) {
                                        s = ((CategoryHolder)object3).obsCt.addString((String)object2, true);
                                        for (n4 = 0; n4 < ((AbstractDataMatrix)multiRefMatrix).getN(); ++n4) {
                                            ((CategoryHolder)object3).obsIc.setValueShort(n + n4, s);
                                        }
                                    }
                                    if (i != 0) continue;
                                    s = ((CategoryHolder)object3).varCt.addString((String)object2, true);
                                    for (n4 = 0; n4 < ((AbstractDataMatrix)multiRefMatrix).getK(); ++n4) {
                                        ((CategoryHolder)object3).varIc.setValueShort((int)(var9_15 + n4), s);
                                    }
                                }
                            }
                            if (this.importWizard != null) {
                                String string = this.importWizard[i][j][k].finishImport(progressManager, cellIdentifierModel, multiRefMatrix);
                                if (string != null) {
                                    if (((String)object).length() > 0) {
                                        object = (String)object + ", ";
                                    }
                                    object = (String)object + string;
                                }
                                this.importWizard[i][j][k].cleanUp();
                            }
                            if (properties != null) {
                                CellIdentifierModel cellIdentifierModel2 = this.modelArray[i][j][k];
                                object3 = cellIdentifierModel2.getImportInfo();
                                object2 = properties;
                                if (object3 != null && properties != null) {
                                    object2 = (Properties)properties.clone();
                                    ((AbstractImportInfo)object3).setCalibrationProperties((Properties)object2, true);
                                    ((AbstractImportInfo)object3).performProperties(progressManager, new Object[]{cellIdentifierModel2, multiRefMatrix}, (Properties)object2);
                                }
                            }
                            if (cellIdentifierModel instanceof AbstractDataSource) {
                                AbstractDataSource abstractDataSource = (AbstractDataSource)cellIdentifierModel;
                                this.addTreeNode(abstractDataSource);
                            }
                        }
                        n3 += this.maxLayer[k];
                    }
                    var9_15 += this.maxVar[j];
                }
                n += this.maxObs[i];
            }
            if (this.createClass) {
                for (CategoryHolder categoryHolder : arrayList) {
                    categoryHolder.obsCategory.updateClasses();
                    categoryHolder.obsCategory.applyTransformation(null, progressManager);
                    if (categoryHolder.varCategory == null) continue;
                    categoryHolder.varCategory.updateClasses();
                    categoryHolder.varCategory.applyTransformation(null, progressManager);
                }
            }
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
        abstractDataMatrix.setLayerMinMax();
        this.importWizard = null;
        return object;
    }

    @Override
    public int[] getDataOrder() {
        CellIdentifierModel cellIdentifierModel = this.getFirstModel();
        if (cellIdentifierModel != null) {
            return cellIdentifierModel.getDataOrder();
        }
        return super.getDataOrder();
    }

    @Override
    public FastDecimal getDoubleAt_Transpose(int n, int n2, FastDecimal fastDecimal) {
        this.setMergeCoord(n, n2);
        if (this.mergeModel != null && this.mergeRow < this.mergeModel.getRowCount() && this.mergeCol < this.mergeModel.getColumnCount()) {
            return this.mergeModel.getDoubleAt_Transpose(this.mergeRow, this.mergeCol, fastDecimal);
        }
        return fastDecimal.error();
    }

    public ImportWizard[][][] getImportWizard() {
        return this.importWizard;
    }

    @Override
    public String getInformation() {
        return "Multi import se.prediktera.map.data Source Description";
    }

    @Override
    public int getLayerCount() {
        return this.layers;
    }

    @Override
    public String getLayerName(int n) {
        this.setMergeLayer(n);
        return this.layerNames[this.mergeLayerIndex][this.mergeLayer];
    }

    public CellIdentifierModel[][][] getModelArray() {
        return this.modelArray;
    }

    @Override
    public String getName() {
        return "Multi Import";
    }

    @Override
    public String getReferenceName(int n) {
        CellIdentifierModel cellIdentifierModel;
        int n2 = 0;
        if (this.createAnalogousY) {
            for (int i = 0; i < this.modelArray.length; ++i) {
                for (int j = 0; j < this.modelArray[i].length; ++j) {
                    if (this.modelArray[i][j][0] == null || n >= ++n2) continue;
                    String string = this.importWizard[i][j][0].getFiles()[0].getName();
                    int n3 = string.lastIndexOf(".");
                    if (n3 >= 0) {
                        string = string.substring(0, n3);
                    }
                    return string;
                }
            }
            n -= n2;
        }
        if ((cellIdentifierModel = this.getFirstModel()) != null) {
            return cellIdentifierModel.getReferenceName(n);
        }
        return super.getReferenceName(n);
    }

    @Override
    public FastDecimal getReferenceValue(int n, int n2, int n3, FastDecimal fastDecimal) {
        this.setMergeCoord(n2, n3);
        int n4 = 0;
        if (this.createAnalogousY) {
            for (CellIdentifierModel[][] cellIdentifierModelArray : this.modelArray) {
                for (int i = 0; i < cellIdentifierModelArray.length; ++i) {
                    if (cellIdentifierModelArray[i][0] == null || n >= ++n4) continue;
                    if (cellIdentifierModelArray[i][0].equals(this.mergeModel)) {
                        return fastDecimal.setValue(1.0);
                    }
                    return fastDecimal.setValue(0.0);
                }
            }
            n -= n4;
        }
        if (this.mergeModel != null && this.mergeRow < this.mergeModel.getRowCount() && this.mergeCol < this.mergeModel.getColumnCount()) {
            return this.mergeModel.getReferenceValue(n, this.mergeRow, this.mergeCol);
        }
        return fastDecimal.error();
    }

    @Override
    public int getReferenceValues() {
        Object object;
        int n = 0;
        if (this.createAnalogousY) {
            object = this.modelArray;
            int n2 = ((CellIdentifierModel[][][])object).length;
            for (int i = 0; i < n2; ++i) {
                Object object2 = object[i];
                for (int j = 0; j < ((Object)object2).length; ++j) {
                    if (object2[j] == null) continue;
                    ++n;
                }
            }
        }
        if ((object = this.getFirstModel()) != null) {
            return n + ((CellIdentifierModel)object).getReferenceValues();
        }
        return n + super.getReferenceValues();
    }

    @Override
    public File getRootFolder() {
        return this.rootFolder;
    }

    @Override
    public byte getTreeType() {
        return 5;
    }

    @Override
    public Object getValueAt_Transpose(int n, int n2) {
        this.setMergeCoord(n, n2);
        if (this.mergeModel != null && this.mergeRow < this.mergeModel.getRowCount() && this.mergeCol < this.mergeModel.getColumnCount()) {
            return this.mergeModel.getValueAt_Transpose(this.mergeRow, this.mergeCol);
        }
        return "MV";
    }

    @Override
    public boolean isMultiImport() {
        return true;
    }

    @Override
    public boolean isReplaceMissingWithMedian() {
        for (CellIdentifierModel[][] cellIdentifierModelArray : this.modelArray) {
            for (int i = 0; i < cellIdentifierModelArray.length; ++i) {
                for (int j = 0; j < cellIdentifierModelArray[i].length; ++j) {
                    if (!this.isReplaceMissingWithMedian(cellIdentifierModelArray[i][j])) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public List<String> listReferenceCategories() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CellIdentifierModel[][] cellIdentifierModelArray : this.modelArray) {
            for (int i = 0; i < cellIdentifierModelArray.length; ++i) {
                for (int j = 0; j < cellIdentifierModelArray[i].length; ++j) {
                    if (cellIdentifierModelArray[i][j] == null) continue;
                    CellIdentifierModel cellIdentifierModel = cellIdentifierModelArray[i][j];
                    for (int k = 0; k < cellIdentifierModel.getReferenceCategorys(); ++k) {
                        String string = cellIdentifierModel.getReferenceCategory(k);
                        if (arrayList.contains(string)) continue;
                        arrayList.add(string);
                    }
                }
            }
        }
        return arrayList;
    }

    @Override
    public void openConnections() throws IOException {
        for (CellIdentifierModel[][] cellIdentifierModelArray : this.modelArray) {
            for (int i = 0; i < cellIdentifierModelArray.length; ++i) {
                for (int j = 0; j < cellIdentifierModelArray[i].length; ++j) {
                    if (cellIdentifierModelArray[i][j] == null) continue;
                    cellIdentifierModelArray[i][j].openConnections();
                }
            }
        }
    }

    @Override
    public void refreshDataSourceLocal(ProgressManager progressManager) throws IOException {
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyInt("layers", this.layers);
        randomOutputStream.writePropertyIntArray("maxRows", this.maxRows);
        randomOutputStream.writePropertyIntArray("maxColumns", this.maxColumns);
        randomOutputStream.writePropertyIntArray("maxLayers", this.maxLayers);
        randomOutputStream.writePropertyIntArray("maxObs", this.maxObs);
        randomOutputStream.writePropertyIntArray("maxVar", this.maxVar);
        randomOutputStream.writePropertyIntArray("maxLayer", this.maxLayer);
        randomOutputStream.writePropertyInt("m1", this.modelArray.length);
        if (this.modelArray.length > 0) {
            randomOutputStream.writePropertyInt("m2", this.modelArray[0].length);
            randomOutputStream.writePropertyInt("m3", this.modelArray[0][0].length);
            for (int i = 0; i < this.modelArray.length; ++i) {
                for (int j = 0; j < this.modelArray[i].length; ++j) {
                    for (int k = 0; k < this.modelArray[i][j].length; ++k) {
                        if (!(this.modelArray[i][j][k] instanceof AbstractDataSource)) continue;
                        randomOutputStream.writePropertyNode("mA" + i + j + k, (AbstractDataSource)this.modelArray[i][j][k]);
                    }
                }
            }
        } else {
            randomOutputStream.writePropertyInt("m2", 0);
            randomOutputStream.writePropertyInt("m3", 0);
        }
    }

    @Override
    public void setCurrentLayer(int n) {
        this.setMergeLayer(n);
        for (CellIdentifierModel[][] cellIdentifierModelArray : this.modelArray) {
            for (int i = 0; i < cellIdentifierModelArray.length; ++i) {
                if (cellIdentifierModelArray[i][this.mergeLayerIndex] == null) continue;
                cellIdentifierModelArray[i][this.mergeLayerIndex].setCurrentLayer(this.mergeLayer);
            }
        }
    }

    public void setRootFolder(File file) {
        this.rootFolder = file;
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
    }

    private void calculateMax() {
        this.maxObs = new int[this.maxRows.length];
        this.maxVar = new int[this.maxColumns.length];
        this.maxLayer = new int[this.maxLayers.length];
        int n = 0;
        for (int i = 0; i < this.modelArray.length; ++i) {
            int n2 = 0;
            for (int j = 0; j < this.modelArray[i].length; ++j) {
                int n3 = 0;
                for (int k = 0; k < this.modelArray[i][j].length; ++k) {
                    if (this.modelArray[i][j][k] != null) {
                        int n4;
                        int n5;
                        int n6;
                        CellIdentifierModel cellIdentifierModel = this.modelArray[i][j][k];
                        for (n6 = 0; n6 < cellIdentifierModel.getColumnCount(); ++n6) {
                            cellIdentifierModel.setColumnType(n6, (byte)this.getColumnType(n6 + n2));
                        }
                        for (n6 = 0; n6 < cellIdentifierModel.getRowCount(); ++n6) {
                            cellIdentifierModel.setRowType(n6, (byte)this.getRowType(n6 + n));
                        }
                        for (n6 = 0; n6 < cellIdentifierModel.getLayerCount(); ++n6) {
                            cellIdentifierModel.setLayerType(n6, (byte)this.getLayerType(n6 + n3));
                        }
                        n6 = cellIdentifierModel.analyzeObs();
                        if (n6 > this.maxObs[i]) {
                            this.maxObs[i] = n6;
                        }
                        if ((n5 = cellIdentifierModel.analyzeVar()) > this.maxVar[j]) {
                            this.maxVar[j] = n5;
                        }
                        if ((n4 = cellIdentifierModel.analyzeLayer()) < this.maxLayer[k]) {
                            this.maxLayer[k] = n4;
                        }
                    }
                    n3 += this.maxLayers[k];
                }
                n2 += this.maxColumns[j];
            }
            n += this.maxRows[i];
        }
    }

    private CellIdentifierModel getFirstModel() {
        if (this.modelArray != null) {
            for (CellIdentifierModel[][] cellIdentifierModelArray : this.modelArray) {
                for (int i = 0; i < cellIdentifierModelArray.length; ++i) {
                    for (int j = 0; j < cellIdentifierModelArray[i].length; ++j) {
                        if (cellIdentifierModelArray[i][j] == null) continue;
                        return cellIdentifierModelArray[i][j];
                    }
                }
            }
        }
        return null;
    }

    private boolean isReplaceMissingWithMedian(CellIdentifierModel cellIdentifierModel) {
        return cellIdentifierModel != null && cellIdentifierModel.isReplaceMissingWithMedian();
    }

    private void setMergeCoord(int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        for (n4 = 0; n4 < this.maxRows.length && n >= n5 + this.maxRows[n4]; ++n4) {
            n5 += this.maxRows[n4];
        }
        int n6 = 0;
        for (n3 = 0; n3 < this.maxColumns.length && n2 >= n6 + this.maxColumns[n3]; ++n3) {
            n6 += this.maxColumns[n3];
        }
        this.mergeModel = this.modelArray[n4][n3][this.mergeLayerIndex];
        this.mergeRow = n - n5;
        this.mergeCol = n2 - n6;
    }

    private void setMergeLayer(int n) {
        int n2 = 0;
        this.mergeLayerIndex = 0;
        while (this.mergeLayerIndex < this.maxLayers.length && n >= n2 + this.maxLayers[this.mergeLayerIndex]) {
            n2 += this.maxLayers[this.mergeLayerIndex];
            ++this.mergeLayerIndex;
        }
        this.mergeLayer = n - n2;
    }

    private static class CategoryHolder {
        public Category obsCategory = null;
        public InnerColumnClass obsIc = null;
        public ClassTypes obsCt = null;
        public Category varCategory = null;
        public InnerColumnClass varIc = null;
        public ClassTypes varCt = null;

        private CategoryHolder() {
        }
    }
}

