/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.multi;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.swing.flat.JFlatButton;
import se.prediktera.map.common.wizard.AbstractWizard;
import se.prediktera.map.common.wizard.WizardPageClass;
import se.prediktera.map.dataimport.ImportHelper;
import se.prediktera.map.dataimport.ImportWizard;
import se.prediktera.map.dataimport.identifier.ImageIdentifierPanel;
import se.prediktera.map.dataimport.merge.MergeWizard;
import se.prediktera.map.dataimport.merge.OriginalDataSource;
import se.prediktera.map.dataimport.multi.MultiImagePanel;
import se.prediktera.map.dataimport.multi.MultiImportInfo;
import se.prediktera.map.main.Evince;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class MultiImageImportPanel
extends WizardPageClass {
    private JButton addColumnFlatButton;
    private JButton addLayerFlatButton;
    private JButton addRowFlatButton;
    private JTextField columnTextField;
    private JPanel columnsPanel;
    private JCheckBox createClassCheckBox;
    private JCheckBox dummyVariableCheckBox;
    private JTextField layerTextField;
    private JPanel layersPanel;
    private MultiImagePanel multiImagePanel1;
    private JPanel optionPanel;
    private JButton removeColumnFlatButton;
    private JButton removeLayerFlatButton;
    private JButton removeRowFlatButton;
    private JFlatButton reshapeFlatButton;
    private JTextField rowTextField;
    private JPanel rowsPanel;

    public static void main(String[] stringArray) throws Exception {
        Evince.initNoShow();
        JFrame jFrame = new JFrame();
        MultiImageImportPanel multiImageImportPanel = new MultiImageImportPanel(null);
        jFrame.getContentPane().add(multiImageImportPanel);
        jFrame.pack();
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    public MultiImageImportPanel(AbstractWizard abstractWizard) {
        this(abstractWizard, null);
    }

    public MultiImageImportPanel(AbstractWizard abstractWizard, OriginalDataSource originalDataSource) {
        this.initComponents();
        this.reshapeFlatButton.setToolTipText("Resize");
        this.reshapeFlatButton.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/reshape.gif")));
        this.reshapeFlatButton.setVisible(false);
        this.multiImagePanel1.setReshapeButton(this.reshapeFlatButton);
        this.addLayerFlatButton.setToolTipText("Add One Layer");
        this.addLayerFlatButton.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/compplus.gif")));
        this.removeLayerFlatButton.setToolTipText("Remove One Layer");
        this.removeLayerFlatButton.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/compminus.gif")));
        this.addColumnFlatButton.setToolTipText("Add One Column");
        this.addColumnFlatButton.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/compplus.gif")));
        this.removeColumnFlatButton.setToolTipText("Remove One Column");
        this.removeColumnFlatButton.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/compminus.gif")));
        this.addRowFlatButton.setToolTipText("Add One Row");
        this.addRowFlatButton.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/compplus.gif")));
        this.removeRowFlatButton.setToolTipText("Remove One Row");
        this.removeRowFlatButton.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/compminus.gif")));
        this.removeLayerFlatButton.setEnabled(false);
        this.removeColumnFlatButton.setEnabled(false);
        this.removeRowFlatButton.setEnabled(false);
        this.multiImagePanel1.setImportWizard(this, abstractWizard, originalDataSource);
    }

    public void addFilesFromChooser(AbstractWizard abstractWizard, File[] fileArray) {
        int n = (int)Math.ceil(Math.sqrt(fileArray.length));
        int n2 = (int)Math.ceil((double)fileArray.length / (double)n);
        this.multiImagePanel1.reshape(n, n2, true);
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                MultiImagePanel.ImageBorderPanel imageBorderPanel = this.multiImagePanel1.getValue(i, j, 0);
                ImageIdentifierPanel imageIdentifierPanel = imageBorderPanel.getImagePanel();
                if (n3 < fileArray.length) {
                    ImportWizard importWizard = imageIdentifierPanel.getImportWizard();
                    if ((importWizard = ImportHelper.importMultiDataFile(importWizard, abstractWizard.getProjectGUI(), Collections.singletonList(fileArray[n3]), false)) != null) {
                        imageIdentifierPanel.setTableModel(importWizard);
                        SwingUtilities.invokeLater(() -> imageIdentifierPanel.setCreated());
                    }
                } else {
                    imageIdentifierPanel.clearImage();
                }
                imageBorderPanel.updateFilename();
                ++n3;
            }
        }
        if (abstractWizard != null) {
            abstractWizard.updateButtons();
        }
        this.updateEnabled();
        this.update(this.multiImagePanel1.isMultiLayer());
    }

    @Override
    public boolean canNext() {
        return this.multiImagePanel1.canNext();
    }

    public CellIdentifierModel createMultiModel() throws Exception {
        return this.multiImagePanel1.createMultiModel(this.createClassCheckBox.isSelected(), this.dummyVariableCheckBox.isEnabled() && this.dummyVariableCheckBox.isSelected());
    }

    @Override
    public boolean nextPressed() {
        try {
            CellIdentifierModel cellIdentifierModel = this.createMultiModel();
            MultiImportInfo multiImportInfo = new MultiImportInfo(cellIdentifierModel);
            ((MergeWizard)this.wizard).setMultiImportPanel(multiImportInfo, cellIdentifierModel);
            return true;
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
            return false;
        }
    }

    public void update(boolean bl) {
        this.dummyVariableCheckBox.setEnabled(bl);
    }

    @Override
    protected void cleanUpChild() {
        this.multiImagePanel1.cleanUp();
    }

    private void addColumnFlatButtonActionPerformed(ActionEvent actionEvent) {
        this.multiImagePanel1.addColumn();
        this.updateEnabled();
    }

    private void addLayerFlatButtonActionPerformed(ActionEvent actionEvent) {
        this.multiImagePanel1.addLayer();
        this.updateEnabled();
    }

    private void addRowFlatButtonActionPerformed(ActionEvent actionEvent) {
        this.multiImagePanel1.addRow();
        this.updateEnabled();
    }

    private int[] getDimensionFromDialog(int n, int n2) {
        String string = JOptionPane.showInputDialog(this.wizard, "Enter dimensions (rows x columns)", n + "x" + n2);
        if (string != null) {
            try {
                String[] stringArray = string.split("x");
                n = Integer.parseInt(stringArray[0].trim());
                n2 = Integer.parseInt(stringArray[1].trim());
                return new int[]{n, n2};
            }
            catch (Exception exception) {
                JOptionPane.showConfirmDialog(this, "Invalid dimension, must be in format (rows x columns)", "Invalid format", -1, 2);
            }
        }
        return null;
    }

    private void initComponents() {
        this.rowsPanel = new JPanel();
        this.addRowFlatButton = new JButton();
        this.removeRowFlatButton = new JButton();
        this.rowTextField = new JTextField();
        this.columnsPanel = new JPanel();
        this.addColumnFlatButton = new JButton();
        this.removeColumnFlatButton = new JButton();
        this.columnTextField = new JTextField();
        this.optionPanel = new JPanel();
        this.createClassCheckBox = new JCheckBox();
        this.dummyVariableCheckBox = new JCheckBox();
        this.layersPanel = new JPanel();
        this.addLayerFlatButton = new JButton();
        this.removeLayerFlatButton = new JButton();
        this.layerTextField = new JTextField();
        this.multiImagePanel1 = new MultiImagePanel();
        this.reshapeFlatButton = new JFlatButton();
        this.setLayout(new GridBagLayout());
        this.rowsPanel.setLayout(new GridBagLayout());
        this.addRowFlatButton.setMaximumSize(new Dimension(20, 20));
        this.addRowFlatButton.setMinimumSize(new Dimension(20, 20));
        this.addRowFlatButton.setPreferredSize(new Dimension(20, 20));
        this.addRowFlatButton.addActionListener(actionEvent -> this.addRowFlatButtonActionPerformed(actionEvent));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        this.rowsPanel.add((Component)this.addRowFlatButton, gridBagConstraints);
        this.removeRowFlatButton.setMaximumSize(new Dimension(20, 20));
        this.removeRowFlatButton.setMinimumSize(new Dimension(20, 20));
        this.removeRowFlatButton.setPreferredSize(new Dimension(20, 20));
        this.removeRowFlatButton.addActionListener(actionEvent -> this.removeRowFlatButtonActionPerformed(actionEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(24, 0, 0, 0);
        this.rowsPanel.add((Component)this.removeRowFlatButton, gridBagConstraints);
        this.rowTextField.setHorizontalAlignment(0);
        this.rowTextField.setText("1");
        this.rowTextField.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.rowTextField.setEnabled(false);
        this.rowTextField.setMaximumSize(new Dimension(20, 20));
        this.rowTextField.setMinimumSize(new Dimension(20, 20));
        this.rowTextField.setPreferredSize(new Dimension(22, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.rowsPanel.add((Component)this.rowTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.add((Component)this.rowsPanel, gridBagConstraints);
        this.columnsPanel.setLayout(new GridBagLayout());
        this.addColumnFlatButton.setMaximumSize(new Dimension(20, 20));
        this.addColumnFlatButton.setMinimumSize(new Dimension(20, 20));
        this.addColumnFlatButton.setPreferredSize(new Dimension(20, 20));
        this.addColumnFlatButton.addActionListener(actionEvent -> this.addColumnFlatButtonActionPerformed(actionEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.columnsPanel.add((Component)this.addColumnFlatButton, gridBagConstraints);
        this.removeColumnFlatButton.setMaximumSize(new Dimension(20, 20));
        this.removeColumnFlatButton.setMinimumSize(new Dimension(20, 20));
        this.removeColumnFlatButton.setPreferredSize(new Dimension(20, 20));
        this.removeColumnFlatButton.addActionListener(actionEvent -> this.removeColumnFlatButtonActionPerformed(actionEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 24, 0, 0);
        this.columnsPanel.add((Component)this.removeColumnFlatButton, gridBagConstraints);
        this.columnTextField.setHorizontalAlignment(0);
        this.columnTextField.setText("1");
        this.columnTextField.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.columnTextField.setEnabled(false);
        this.columnTextField.setMaximumSize(new Dimension(20, 20));
        this.columnTextField.setMinimumSize(new Dimension(20, 20));
        this.columnTextField.setPreferredSize(new Dimension(22, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.columnsPanel.add((Component)this.columnTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.columnsPanel, gridBagConstraints);
        this.optionPanel.setLayout(new GridBagLayout());
        this.createClassCheckBox.setSelected(true);
        this.createClassCheckBox.setText("Create a Category with class for each file");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.optionPanel.add((Component)this.createClassCheckBox, gridBagConstraints);
        this.dummyVariableCheckBox.setText("Create analogous PLS Y-variable for each file");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.optionPanel.add((Component)this.dummyVariableCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.optionPanel, gridBagConstraints);
        this.layersPanel.setLayout(new GridBagLayout());
        this.addLayerFlatButton.setMaximumSize(new Dimension(20, 20));
        this.addLayerFlatButton.setMinimumSize(new Dimension(20, 20));
        this.addLayerFlatButton.setPreferredSize(new Dimension(20, 20));
        this.addLayerFlatButton.addActionListener(actionEvent -> this.addLayerFlatButtonActionPerformed(actionEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.layersPanel.add((Component)this.addLayerFlatButton, gridBagConstraints);
        this.removeLayerFlatButton.setMaximumSize(new Dimension(20, 20));
        this.removeLayerFlatButton.setMinimumSize(new Dimension(20, 20));
        this.removeLayerFlatButton.setPreferredSize(new Dimension(20, 20));
        this.removeLayerFlatButton.addActionListener(actionEvent -> this.removeLayerFlatButtonActionPerformed(actionEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 24);
        this.layersPanel.add((Component)this.removeLayerFlatButton, gridBagConstraints);
        this.layerTextField.setHorizontalAlignment(0);
        this.layerTextField.setText("1");
        this.layerTextField.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.layerTextField.setEnabled(false);
        this.layerTextField.setMaximumSize(new Dimension(20, 20));
        this.layerTextField.setMinimumSize(new Dimension(20, 20));
        this.layerTextField.setPreferredSize(new Dimension(22, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.layersPanel.add((Component)this.layerTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.layersPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.multiImagePanel1, gridBagConstraints);
        this.reshapeFlatButton.setText("jFlatButton3");
        this.reshapeFlatButton.addActionListener(actionEvent -> this.reshapeFlatButtonActionPerformed(actionEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.reshapeFlatButton, gridBagConstraints);
    }

    private void removeColumnFlatButtonActionPerformed(ActionEvent actionEvent) {
        this.multiImagePanel1.removeColumn();
        this.updateEnabled();
    }

    private void removeLayerFlatButtonActionPerformed(ActionEvent actionEvent) {
        this.multiImagePanel1.removeLayer();
        this.updateEnabled();
    }

    private void removeRowFlatButtonActionPerformed(ActionEvent actionEvent) {
        this.multiImagePanel1.removeRow();
        this.updateEnabled();
    }

    private void reshapeFlatButtonActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.getDimensionFromDialog(this.multiImagePanel1.getRows(), this.multiImagePanel1.getColumns());
        if (nArray != null) {
            this.multiImagePanel1.reshape(nArray[0], nArray[1], false);
            this.updateEnabled();
        }
    }

    private void updateEnabled() {
        this.removeLayerFlatButton.setEnabled(this.multiImagePanel1.getLayers() > 1);
        this.layerTextField.setText(String.valueOf(this.multiImagePanel1.getLayers()));
        this.removeRowFlatButton.setEnabled(this.multiImagePanel1.getRows() > 1);
        this.rowTextField.setText(String.valueOf(this.multiImagePanel1.getRows()));
        this.removeColumnFlatButton.setEnabled(this.multiImagePanel1.getColumns() > 1);
        this.columnTextField.setText(String.valueOf(this.multiImagePanel1.getColumns()));
    }
}

