/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.multi;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import se.prediktera.map.common.cleanup.CleanUpTabbedPane;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.common.swing.flat.JFlatButton;
import se.prediktera.map.common.wizard.AbstractWizard;
import se.prediktera.map.dataimport.ImportHelper;
import se.prediktera.map.dataimport.ImportWizard;
import se.prediktera.map.dataimport.identifier.ImageIdentifierPanel;
import se.prediktera.map.dataimport.merge.OriginalDataSource;
import se.prediktera.map.dataimport.multi.MultiCellIdentifierModel;
import se.prediktera.map.dataimport.multi.MultiImageImportPanel;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class MultiImagePanel
extends CleanUpTabbedPane {
    private ArrayList<ArrayList<ArrayList<ImageBorderPanel>>> imageMatrix;
    private MultiImageImportPanel multiImageImportPanel;
    private AbstractWizard multiImportWizard;
    private OriginalDataSource origCiModel;
    private boolean doupdate = true;
    private JFlatButton reshapeFlatButton;

    public MultiImagePanel() {
        this.setTabPlacement(4);
        this.imageMatrix = new ArrayList();
        this.addLayer();
        this.addColumn();
        this.addRow();
    }

    public void addColumn() {
        int n = this.getRows();
        for (int i = 0; i < this.getLayers(); ++i) {
            ArrayList<ImageBorderPanel> arrayList = new ArrayList<ImageBorderPanel>();
            for (int j = 0; j < n; ++j) {
                arrayList.add(this.createImagePanel());
            }
            this.imageMatrix.get(i).add(arrayList);
        }
        this.updateLayout();
    }

    public void addLayer() {
        int n = this.getRows();
        int n2 = this.getColumns();
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < n2; ++i) {
            ArrayList<ImageBorderPanel> arrayList2 = new ArrayList<ImageBorderPanel>();
            for (int j = 0; j < n; ++j) {
                arrayList2.add(this.createImagePanel());
            }
            arrayList.add(arrayList2);
        }
        this.imageMatrix.add(arrayList);
        this.updateLayout();
    }

    public void addRow() {
        for (int i = 0; i < this.getLayers(); ++i) {
            for (int j = 0; j < this.getColumns(); ++j) {
                this.imageMatrix.get(i).get(j).add(this.createImagePanel());
            }
        }
        this.updateLayout();
    }

    public boolean canNext() {
        for (int i = 0; i < this.getLayers(); ++i) {
            for (int j = 0; j < this.getColumns(); ++j) {
                for (int k = 0; k < this.getRows(); ++k) {
                    CellIdentifierModel cellIdentifierModel = this.getValue(k, j, i).getImagePanel().getModel();
                    if (cellIdentifierModel == null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public CellIdentifierModel createMultiModel(boolean bl, boolean bl2) throws Exception {
        int n;
        int n2 = this.getRows();
        int n3 = this.getColumns();
        int n4 = this.getLayers();
        CellIdentifierModel[][][] cellIdentifierModelArray = new CellIdentifierModel[n2][n3][n4];
        ImportWizard[][][] importWizardArray = new ImportWizard[n2][n3][n4];
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n4];
        String[][] stringArray = new String[n4][];
        for (n = 0; n < n4; ++n) {
            int n5 = -1;
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n2; ++j) {
                    ImageIdentifierPanel imageIdentifierPanel = this.getValue(j, i, n).getImagePanel();
                    cellIdentifierModelArray[j][i][n] = imageIdentifierPanel.getModel();
                    importWizardArray[j][i][n] = imageIdentifierPanel.getImportWizard();
                    if (cellIdentifierModelArray[j][i][n] == null) continue;
                    if (nArray[j] < cellIdentifierModelArray[j][i][n].getRowCount()) {
                        nArray[j] = cellIdentifierModelArray[j][i][n].getRowCount();
                    }
                    if (nArray2[i] < cellIdentifierModelArray[j][i][n].getColumnCount()) {
                        nArray2[i] = cellIdentifierModelArray[j][i][n].getColumnCount();
                    }
                    if (nArray3[n] < cellIdentifierModelArray[j][i][n].getLayerCount()) {
                        nArray3[n] = cellIdentifierModelArray[j][i][n].getLayerCount();
                    }
                    if (n5 == -1) {
                        n5 = cellIdentifierModelArray[j][i][n].getLayerCount();
                        stringArray[n] = new String[n5];
                        for (int k = 0; k < n5; ++k) {
                            stringArray[n][k] = cellIdentifierModelArray[j][i][n].getLayerName(k);
                        }
                        continue;
                    }
                    if (cellIdentifierModelArray[j][i][n].getLayerCount() == n5) continue;
                    throw new Exception("The number of layers must be same for all data");
                }
            }
        }
        n = 0;
        for (int n6 : nArray) {
            n += n6;
        }
        int n7 = 0;
        for (int k : nArray2) {
            n7 += k;
        }
        int n8 = 0;
        for (int n9 : nArray3) {
            n8 += n9;
        }
        return new MultiCellIdentifierModel(n, n7, n8, cellIdentifierModelArray, nArray, nArray2, nArray3, stringArray, importWizardArray, bl, bl2);
    }

    public int getColumns() {
        if (this.imageMatrix.size() > 0) {
            return this.imageMatrix.get(0).size();
        }
        return 0;
    }

    public int getLayers() {
        return this.imageMatrix.size();
    }

    public int getRows() {
        if (this.imageMatrix.size() > 0 && this.imageMatrix.get(0).size() > 0) {
            return this.imageMatrix.get(0).get(0).size();
        }
        return 0;
    }

    public ImageBorderPanel getValue(int n, int n2, int n3) {
        ArrayList<ImageBorderPanel> arrayList = this.imageMatrix.get(n3).get(n2);
        return arrayList.get(n);
    }

    public boolean isMultiLayer() {
        for (int i = 0; i < this.getLayers(); ++i) {
            for (int j = 0; j < this.getColumns(); ++j) {
                for (int k = 0; k < this.getRows(); ++k) {
                    ImageIdentifierPanel imageIdentifierPanel = this.getValue(k, j, i).getImagePanel();
                    CellIdentifierModel cellIdentifierModel = imageIdentifierPanel.getModel();
                    if (cellIdentifierModel == null || cellIdentifierModel.isMultiLayer()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void removeColumn() {
        int n = this.getColumns();
        for (int i = 0; i < this.getLayers(); ++i) {
            this.imageMatrix.get(i).remove(n - 1);
        }
        this.updateLayout();
    }

    public void removeLayer() {
        this.imageMatrix.remove(this.getLayers() - 1);
        this.updateLayout();
    }

    public void removeRow() {
        int n = this.getRows();
        for (int i = 0; i < this.getLayers(); ++i) {
            for (int j = 0; j < this.getColumns(); ++j) {
                this.imageMatrix.get(i).get(j).remove(n - 1);
            }
        }
        this.updateLayout();
    }

    public void reshape(int n, int n2, boolean bl) {
        this.doupdate = false;
        for (int i = 0; i < this.getLayers(); ++i) {
            int n3;
            int n4;
            ArrayList<ImageBorderPanel> arrayList = new ArrayList<ImageBorderPanel>();
            int n5 = this.getColumns();
            int n6 = this.getRows();
            for (n4 = 0; n4 < n6; ++n4) {
                for (n3 = 0; n3 < n5; ++n3) {
                    ImageBorderPanel imageBorderPanel = this.getValue(n4, n3, i);
                    if (bl) {
                        imageBorderPanel.getImagePanel().clearImage();
                        continue;
                    }
                    if (imageBorderPanel == null || imageBorderPanel.getFile() == null || arrayList.contains(imageBorderPanel)) continue;
                    arrayList.add(this.getValue(n4, n3, i));
                }
            }
            if (n > n6) {
                for (n4 = n6; n4 < n; ++n4) {
                    this.addRow();
                }
            } else {
                for (n4 = n6; n4 > n; --n4) {
                    this.removeRow();
                }
            }
            if (n2 > n5) {
                for (n4 = n5; n4 < n2; ++n4) {
                    this.addColumn();
                }
            } else {
                for (n4 = n5; n4 > n2; --n4) {
                    this.removeColumn();
                }
            }
            n4 = 0;
            for (n3 = 0; n3 < this.getRows(); ++n3) {
                for (int j = 0; j < this.getColumns(); ++j) {
                    if (n4 < arrayList.size()) {
                        this.setValue(n3, j, i, (ImageBorderPanel)arrayList.get(n4));
                    } else {
                        this.setValue(n3, j, i, this.createImagePanel());
                    }
                    ++n4;
                }
            }
        }
        this.doupdate = true;
        this.updateLayout();
    }

    public void setImportWizard(MultiImageImportPanel multiImageImportPanel, AbstractWizard abstractWizard, OriginalDataSource originalDataSource) {
        this.multiImageImportPanel = multiImageImportPanel;
        this.multiImportWizard = abstractWizard;
        this.origCiModel = originalDataSource;
        if (originalDataSource != null) {
            ImportWizard importWizard = new ImportWizard(null, null, false);
            importWizard.setMultiModel(originalDataSource);
            ImageBorderPanel imageBorderPanel = this.getValue(0, 0, 0);
            ImageIdentifierPanel imageIdentifierPanel = imageBorderPanel.getImagePanel();
            imageIdentifierPanel.setTableModel(importWizard);
            imageIdentifierPanel.setCreated();
        }
    }

    public void setReshapeButton(JFlatButton jFlatButton) {
        this.reshapeFlatButton = jFlatButton;
        this.updateLayout();
    }

    public void setValue(int n, int n2, int n3, ImageBorderPanel imageBorderPanel) {
        ArrayList<ImageBorderPanel> arrayList = this.imageMatrix.get(n3).get(n2);
        arrayList.set(n, imageBorderPanel);
    }

    @Override
    protected void cleanUpChild() {
        this.imageMatrix = null;
        this.multiImageImportPanel = null;
        this.multiImportWizard = null;
        this.origCiModel = null;
    }

    private ImageBorderPanel createImagePanel() {
        final ImageIdentifierPanel imageIdentifierPanel = new ImageIdentifierPanel();
        final ImageBorderPanel imageBorderPanel = new ImageBorderPanel(imageIdentifierPanel);
        imageBorderPanel.button.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ MultiImagePanel this$0;
            {
                this.this$0 = multiImagePanel;
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JMenuItem jMenuItem = new JMenuItem("Clear");
                    jMenuItem.addActionListener(actionEvent -> {
                        imageIdentifierPanel.clearImage();
                        imageBorderPanel.updateFilename();
                        if (this.this$0.multiImportWizard != null) {
                            this.this$0.multiImportWizard.updateButtons();
                        }
                        if (this.this$0.multiImageImportPanel != null) {
                            this.this$0.multiImageImportPanel.update(this.this$0.isMultiLayer());
                        }
                    });
                    jPopupMenu.add(jMenuItem);
                    jPopupMenu.show(imageBorderPanel, mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                imageBorderPanel.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                imageBorderPanel.setCursor(Cursor.getDefaultCursor());
            }
        });
        imageBorderPanel.button.addActionListener(actionEvent -> {
            Project_GUI project_GUI = this.multiImportWizard != null ? this.multiImportWizard.getProjectGUI() : null;
            ImportWizard importWizard = imageIdentifierPanel.getImportWizard();
            if ((importWizard = ImportHelper.importMultiDataFile(importWizard, project_GUI, null)) != null) {
                imageIdentifierPanel.setTableModel(importWizard);
                imageIdentifierPanel.setCreated();
            }
            imageBorderPanel.updateFilename();
            if (this.multiImportWizard != null) {
                this.multiImportWizard.updateButtons();
            }
            if (this.multiImageImportPanel != null) {
                this.multiImageImportPanel.update(this.isMultiLayer());
            }
        });
        imageBorderPanel.setFocusable(false);
        imageBorderPanel.setPreferredSize(new Dimension(100, 100));
        imageBorderPanel.setMinimumSize(new Dimension(100, 100));
        imageBorderPanel.setMaximumSize(new Dimension(100, 100));
        return imageBorderPanel;
    }

    private void updateLayout() {
        if (this.doupdate) {
            this.removeAll();
            for (int i = 0; i < this.getLayers(); ++i) {
                JPanel jPanel = new JPanel(new GridBagLayout());
                jPanel.setBackground(Color.white);
                for (int j = 0; j < this.getColumns(); ++j) {
                    for (int k = 0; k < this.getRows(); ++k) {
                        jPanel.add((Component)this.getValue(k, j, i), new GridBagConstraints(j, k, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
                    }
                }
                JComponent jComponent = new JLabel("");
                if (this.reshapeFlatButton != null) {
                    jComponent = this.reshapeFlatButton.copyButton();
                }
                jPanel.add((Component)jComponent, new GridBagConstraints(this.getColumns(), this.getRows(), 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 6, 6), 0, 0));
                JScrollPane jScrollPane = new JScrollPane();
                jScrollPane.setViewportView(jPanel);
                this.addTab(String.valueOf(i + 1), jScrollPane);
            }
            if (this.multiImportWizard != null) {
                this.multiImportWizard.updateButtons();
            }
        }
    }

    public class ImageBorderPanel
    extends JPanel {
        private final ImageIdentifierPanel imagePanel;
        private final JLabel label = new JLabel();
        private final Icon folderIcon = UIManager.getIcon("FileView.directoryIcon");
        private final JButton button = new JButton(){

            @Override
            public String getToolTipText() {
                File file = ImageBorderPanel.this.getFile();
                if (file != null) {
                    return file.getAbsolutePath();
                }
                if (MultiImagePanel.this.origCiModel != null) {
                    return "Original Matrix";
                }
                return null;
            }
        };

        public ImageBorderPanel(ImageIdentifierPanel imageIdentifierPanel) {
            this.imagePanel = imageIdentifierPanel;
            this.setBackground(Color.white);
            this.setLayout(new BorderLayout());
            this.button.setLayout(new BorderLayout());
            imageIdentifierPanel.setOpaque(true);
            this.button.add((Component)imageIdentifierPanel, "Center");
            this.button.setIcon(this.folderIcon);
            this.add((Component)this.label, "North");
            this.add((Component)this.button, "Center");
            this.updateFilename();
            ToolTipManager.sharedInstance().registerComponent(this.button);
        }

        public void addActionListener(ActionListener actionListener) {
        }

        public File getFile() {
            File[] fileArray;
            if (this.imagePanel != null && this.imagePanel.getImportWizard() != null && (fileArray = this.imagePanel.getImportWizard().getFiles()) != null && fileArray.length > 0) {
                return fileArray[0];
            }
            return null;
        }

        public ImageIdentifierPanel getImagePanel() {
            return this.imagePanel;
        }

        public void updateFilename() {
            File file = this.getFile();
            if (file != null) {
                this.label.setText(jopensaveDialog.getFileName(file));
            } else if (MultiImagePanel.this.origCiModel != null) {
                this.label.setText("Original Matrix");
            } else {
                this.label.setText("N/A");
            }
        }
    }
}

