/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.raw;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.dataimport.raw.TextImportModel;

public class DelimiterPanel
extends CleanUpPanel {
    private final JRadioButton checkTab = new JRadioButton("Tab (tab)");
    private final JRadioButton checkSpace = new JRadioButton("Space (\" \")");
    private final JRadioButton checkComma = new JRadioButton("Comma (\",\")");
    private final JRadioButton checkLine = new JRadioButton("Line (\"-\")");
    private final JRadioButton checkColon = new JRadioButton("Colon (\":\")");
    private final JRadioButton checkSemiColon = new JRadioButton("Semi-Colon (\";\")");
    private final JCheckBox checkTCAD = new JCheckBox("<html>Treat consecutive<br>delimiters as one</html>");
    private JTable previewTable = new JTable();
    private TextImportModel model;
    private boolean noaction = false;
    private byte delimiterIndex = (byte)-1;

    public DelimiterPanel(TextImportModel textImportModel) {
        super("DelimiterPanel", new BorderLayout());
        this.model = textImportModel;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(EvinceBorderFactory.createEvinceBorder("Delimiters"));
        DelCheckListener delCheckListener = new DelCheckListener();
        this.checkTab.addItemListener(delCheckListener);
        this.checkSpace.addItemListener(delCheckListener);
        this.checkComma.addItemListener(delCheckListener);
        this.checkLine.addItemListener(delCheckListener);
        this.checkColon.addItemListener(delCheckListener);
        this.checkSemiColon.addItemListener(delCheckListener);
        this.checkTCAD.addItemListener(itemEvent -> {
            if (!this.noaction) {
                this.analyzeDelimiter(false);
                this.updatePreviewTable();
            }
        });
        this.add((Component)jPanel, "West");
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setOpaque(false);
        this.add((Component)jScrollPane, "Center");
        jScrollPane.setBorder(EvinceBorderFactory.createEvinceBorder("Preview"));
        this.previewTable.setAutoResizeMode(0);
        this.previewTable.setEnabled(false);
        this.previewTable.getTableHeader().setReorderingAllowed(false);
        jScrollPane.setViewportView(this.previewTable);
        jScrollPane.getViewport().setOpaque(false);
        jPanel.add(this.checkTab);
        jPanel.add(this.checkSpace);
        jPanel.add(this.checkComma);
        jPanel.add(this.checkLine);
        jPanel.add(this.checkColon);
        jPanel.add(this.checkSemiColon);
        jPanel.add(new JLabel(" "));
        jPanel.add(this.checkTCAD);
        jPanel.add(Box.createVerticalGlue());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.checkTab);
        buttonGroup.add(this.checkComma);
        buttonGroup.add(this.checkLine);
        buttonGroup.add(this.checkSpace);
        buttonGroup.add(this.checkColon);
        buttonGroup.add(this.checkSemiColon);
    }

    public void analyzeDelimiter(boolean bl) {
        this.noaction = true;
        byte by = this.model.analyzeDelimiter(this.checkTCAD.isSelected());
        if (bl) {
            this.delimiterIndex = by;
            switch (this.delimiterIndex) {
                case 0: {
                    this.checkTab.setSelected(true);
                    break;
                }
                case 1: {
                    this.checkSpace.setSelected(true);
                    break;
                }
                case 2: {
                    this.checkComma.setSelected(true);
                    break;
                }
                case 3: {
                    this.checkLine.setSelected(true);
                    break;
                }
                case 4: {
                    this.checkColon.setSelected(true);
                    break;
                }
                case 5: {
                    this.checkSemiColon.setSelected(true);
                }
            }
        }
        this.noaction = false;
    }

    public byte getDelimiterIndex() {
        return this.delimiterIndex;
    }

    public String getDelimiterRegExp(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.delimiterIndex >= 0 && this.delimiterIndex < TextImportModel.DELIMITERS.length) {
            stringBuilder.append(TextImportModel.DELIMITERS[this.delimiterIndex]);
            if (this.checkTCAD.isSelected()) {
                stringBuilder.append("+");
            }
        }
        if (bl) {
            stringBuilder.append("|\n");
        }
        return stringBuilder.toString();
    }

    public TableModel getTableModel() {
        return this.previewTable.getModel();
    }

    public void setDelimiter(String string) {
        if (string.equalsIgnoreCase("tab") || string.equals("\t")) {
            this.delimiterIndex = 0;
        } else if (string.equalsIgnoreCase("space") || string.equals(" ")) {
            this.delimiterIndex = 1;
        } else if (string.equalsIgnoreCase("comma") || string.equals(",")) {
            this.delimiterIndex = (byte)2;
        } else if (string.equalsIgnoreCase("line") || string.equals("-")) {
            this.delimiterIndex = (byte)3;
        } else if (string.equalsIgnoreCase("colon") || string.equals(":")) {
            this.delimiterIndex = (byte)4;
        } else if (string.equalsIgnoreCase("semicomma") || string.equals(";")) {
            this.delimiterIndex = (byte)5;
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.checkTab.setEnabled(bl);
        this.checkSpace.setEnabled(bl);
        this.checkComma.setEnabled(bl);
        this.checkLine.setEnabled(bl);
        this.checkColon.setEnabled(bl);
        this.checkSemiColon.setEnabled(bl);
        this.checkTCAD.setEnabled(bl);
    }

    public void setTableModel(TableModel tableModel) {
        this.previewTable.setModel(tableModel);
    }

    public boolean treatConsecutiveDelimitersAsOne() {
        return this.checkTCAD.isSelected();
    }

    public void updatePreviewTable() {
        this.previewTable.repaint();
    }

    @Override
    protected void cleanUpChild() {
        this.model = null;
        this.previewTable = null;
    }

    private class DelCheckListener
    implements ItemListener {
        private DelCheckListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1 && !DelimiterPanel.this.noaction) {
                Object object = itemEvent.getSource();
                if (object == DelimiterPanel.this.checkTab) {
                    DelimiterPanel.this.delimiterIndex = 0;
                } else if (object == DelimiterPanel.this.checkSpace) {
                    DelimiterPanel.this.delimiterIndex = 1;
                } else if (object == DelimiterPanel.this.checkComma) {
                    DelimiterPanel.this.delimiterIndex = (byte)2;
                } else if (object == DelimiterPanel.this.checkLine) {
                    DelimiterPanel.this.delimiterIndex = (byte)3;
                } else if (object == DelimiterPanel.this.checkColon) {
                    DelimiterPanel.this.delimiterIndex = (byte)4;
                } else if (object == DelimiterPanel.this.checkSemiColon) {
                    DelimiterPanel.this.delimiterIndex = (byte)5;
                }
                DelimiterPanel.this.updatePreviewTable();
            }
        }
    }
}

