/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.raw;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import javax.swing.JOptionPane;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataimport.AbstractFileDataSource;
import se.prediktera.map.dataimport.raw.TextImportModel;
import se.prediktera.map.main.IniManager;

public class RawDataSource
extends AbstractFileDataSource
implements TextImportModel {
    private int[][] indexMatrix;
    private long[][] rowSizes;
    private short[][] indexLength;
    private int[][] columnsdelimiters;
    private int[] channelrows;
    private int[] channelcolumns;
    private byte delimiterIndex = (byte)-1;
    private byte delimiter;
    private boolean tcad;
    private boolean lnline = false;

    public RawDataSource(File[] fileArray, byte by, boolean bl) throws IOException {
        super(fileArray, by, bl);
        this.initChannelData();
    }

    public RawDataSource(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        if (mapProperty.hasProperty("delindx")) {
            this.delimiterIndex = mapProperty.getLVByte();
        }
        if (mapProperty.hasProperty("del")) {
            this.delimiter = mapProperty.getLVByte();
        }
        if (mapProperty.hasProperty("tcad")) {
            this.tcad = mapProperty.getLVBoolean();
        }
    }

    @Override
    public byte analyzeDelimiter(boolean bl) {
        try {
            return this.analyzeDelimiterInternal(bl, Integer.MAX_VALUE);
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    @Override
    public byte analyzeDelimiter(boolean bl, int n) {
        try {
            return this.analyzeDelimiterInternal(bl, n);
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    @Override
    public int getColumnsForChannel(int n) {
        return this.channelcolumns[n];
    }

    public byte getDelimiterIndex() {
        return this.delimiterIndex;
    }

    @Override
    public String getName() {
        return "Raw";
    }

    @Override
    public int getRowsForChannel(int n) {
        return this.channelrows[n];
    }

    @Override
    public byte getTreeType() {
        return 0;
    }

    public void indexDataSource(ProgressManager progressManager, boolean bl) {
        try {
            Integer.toString(this.columnsdelimiters[0][0]);
        }
        catch (Exception exception) {
            this.analyzeDelimiter(true);
        }
        try {
            boolean bl2 = false;
            this.analyzeDelimiter(true);
            this.curchannel = 0;
            while (this.curchannel < this.channels.length) {
                int n = this.columnsdelimiters[this.curchannel][this.delimiterIndex];
                int n2 = this.channelrows[this.curchannel];
                if (bl) {
                    n2 = n2 > 15 ? 15 : n2;
                    int n3 = n = n > 15 ? 15 : n;
                    if (this.curchannel > 0) {
                        switch (this.mergeType) {
                            case 1: {
                                n2 = n2 + this.rows > 15 ? 15 - this.rows : n2;
                                break;
                            }
                            case 2: {
                                int n4 = n = n + this.columns > 15 ? 15 - this.columns : n;
                            }
                        }
                    }
                }
                if (n2 <= 0 || n <= 0) {
                    if (this.curchannel == 0) {
                        this.rows = 0;
                        this.columns = 0;
                    }
                    break;
                }
                this.channelcolumns[this.curchannel] = n;
                if (this.curchannel == 0) {
                    this.rows = n2;
                    this.columns = n;
                    if (this.includeFileNames) {
                        switch (this.mergeType) {
                            case 1: {
                                ++this.columns;
                                break;
                            }
                            case 2: {
                                ++this.rows;
                            }
                        }
                    }
                } else {
                    switch (this.mergeType) {
                        case 1: {
                            this.rows += n2;
                            break;
                        }
                        case 2: {
                            this.columns += n;
                        }
                    }
                }
                int n5 = n2 * n;
                this.rowSizes[this.curchannel] = new long[n2 + 1];
                this.indexMatrix[this.curchannel] = new int[n5];
                this.indexLength[this.curchannel] = new short[n5];
                byte by = 0;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                RandomAccessFile randomAccessFile = this.channels[this.curchannel];
                randomAccessFile.seek(0L);
                long l = randomAccessFile.length() - 1L;
                long l2 = 0L;
                int n9 = 0;
                int n10 = 0;
                this.lnline = true;
                if (progressManager != null) {
                    progressManager.setMaximumAndReset(n2);
                }
                while (n9 >= 0 && !bl2) {
                    n9 = randomAccessFile.read(this.buf[this.curchannel]);
                    int n11 = 0;
                    while (n11 < n9) {
                        byte by2 = this.buf[this.curchannel][n11];
                        if (!this.lnline || by2 != 10 && by2 != 13) {
                            this.lnline = false;
                            if (!this.tcad || by2 != by || by2 != this.delimiter) {
                                if (l2 == l) {
                                    ++n8;
                                    n10 = -1;
                                    by2 = 10;
                                }
                                if (by2 == 10 || by2 == 13) {
                                    this.lnline = true;
                                }
                                if (by2 == this.delimiter || this.lnline) {
                                    int n12;
                                    if (n7 < n && (n12 = n6 * n + n7) < n5) {
                                        this.indexMatrix[this.curchannel][n12] = (int)l2 - n8 - n10;
                                        int[] nArray = this.indexMatrix[this.curchannel];
                                        int n13 = n12;
                                        nArray[n13] = (int)((long)nArray[n13] - this.rowSizes[this.curchannel][n6]);
                                        this.indexLength[this.curchannel][n12] = (short)n8;
                                    }
                                    n10 = 0;
                                    n8 = 0;
                                    ++n7;
                                    if (this.lnline) {
                                        if (progressManager != null) {
                                            progressManager.incStep();
                                        }
                                        n8 = 0;
                                        if (++n6 > n2) {
                                            bl2 = true;
                                        } else {
                                            this.rowSizes[this.curchannel][n6] = l2;
                                        }
                                        n7 = 0;
                                    }
                                } else {
                                    ++n8;
                                }
                            }
                            by = by2;
                        }
                        ++n11;
                        ++l2;
                    }
                }
                ++this.curchannel;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (progressManager != null) {
                progressManager.Finish();
            }
            this.indexMatrix = null;
            this.indexLength = null;
            JOptionPane.showConfirmDialog(IniManager.getMainFrame(), fileNotFoundException.getMessage(), "File not found", -1, 0, null);
        }
        catch (IOException iOException) {
            if (progressManager != null) {
                progressManager.Finish();
            }
            this.indexMatrix = null;
            this.indexLength = null;
            JOptionPane.showConfirmDialog(IniManager.getMainFrame(), iOException.getMessage(), "Cannot read file", -1, 0, null);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            if (progressManager != null) {
                progressManager.Finish();
            }
            this.indexMatrix = null;
            this.indexLength = null;
            JOptionPane.showConfirmDialog(IniManager.getMainFrame(), outOfMemoryError.getMessage(), "Out of memory", -1, 0, null);
        }
        this.curchannel = 0;
    }

    public void indexDataSource(ProgressManager progressManager, byte by, boolean bl, boolean bl2) {
        this.delimiterIndex = by;
        this.tcad = bl;
        this.delimiter = (byte)DELIMITERS[by];
        this.indexDataSource(progressManager, bl2);
        this.updateFinished();
    }

    @Override
    public void refreshDataSourceLocal(ProgressManager progressManager) throws IOException {
        this.analyzeDelimiter(this.tcad);
        this.indexDataSource(progressManager, false);
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyByte("delindx", this.delimiterIndex);
        randomOutputStream.writePropertyByte("del", this.delimiter);
        randomOutputStream.writePropertyBoolean("tcad", this.tcad);
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.indexMatrix = null;
        this.indexLength = null;
    }

    @Override
    protected void ClearDataLocal() throws IOException {
        super.ClearDataLocal();
        this.indexMatrix = null;
        this.indexLength = null;
        this.columnsdelimiters = null;
        this.channelrows = null;
        this.channelcolumns = null;
    }

    @Override
    protected long getIndex(int n, int n2) {
        return this.rowSizes[this.curchannel][n] + (long)this.indexMatrix[this.curchannel][n * this.channelcolumns[this.curchannel] + n2];
    }

    @Override
    protected int getLength(int n, int n2) {
        int n3;
        if (this.channelcolumns == null || this.indexLength == null || this.curchannel >= this.indexLength.length || this.indexLength[this.curchannel] == null) {
            return 0;
        }
        if (this.curchannel < this.channelcolumns.length && (n3 = n * this.channelcolumns[this.curchannel] + n2) < this.indexLength[this.curchannel].length) {
            return this.indexLength[this.curchannel][n3];
        }
        return 0;
    }

    @Override
    protected void LoadDataLocal(RandomInputStream randomInputStream) throws IOException {
        super.LoadDataLocal(randomInputStream);
        this.initChannelData();
        for (int i = 0; i < this.indexMatrix.length; ++i) {
            int n;
            int n2 = randomInputStream.ReadBlockInt();
            this.indexMatrix[i] = new int[n2];
            this.indexLength[i] = new short[n2];
            for (n = 0; n < n2; ++n) {
                this.indexMatrix[i][n] = randomInputStream.ReadBlockInt();
                this.indexLength[i][n] = randomInputStream.ReadBlockShort();
            }
            n2 = randomInputStream.ReadBlockInt();
            this.columnsdelimiters[i] = new int[n2];
            for (n = 0; n < n2; ++n) {
                this.columnsdelimiters[i][n] = randomInputStream.ReadBlockInt();
            }
            this.channelrows[i] = randomInputStream.ReadBlockInt();
            this.channelcolumns[i] = this.columnsdelimiters[i][this.delimiterIndex];
        }
    }

    @Override
    protected void SaveDataLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveDataLocal(randomOutputStream);
        for (int i = 0; i < this.indexMatrix.length; ++i) {
            int n;
            randomOutputStream.WriteBlockInt(this.indexMatrix[i].length);
            for (n = 0; n < this.indexMatrix[i].length; ++n) {
                randomOutputStream.WriteBlockInt(this.indexMatrix[i][n]);
                randomOutputStream.WriteBlockShort(this.indexLength[i][n]);
            }
            randomOutputStream.WriteBlockInt(this.columnsdelimiters[i].length);
            for (n = 0; n < this.columnsdelimiters[i].length; ++n) {
                randomOutputStream.WriteBlockInt(this.columnsdelimiters[i][n]);
            }
            randomOutputStream.WriteBlockInt(this.channelrows[i]);
        }
    }

    @Override
    protected void setLength(int n, int n2, int n3) {
        int n4 = n * this.channelcolumns[this.curchannel] + n2;
        int n5 = n3 - this.getLength(n, n2);
        this.indexLength[this.curchannel][n4] = (short)n3;
        int n6 = n4 + 1;
        while (n6 < this.indexMatrix[this.curchannel].length) {
            int[] nArray = this.indexMatrix[this.curchannel];
            int n7 = n6++;
            nArray[n7] = nArray[n7] + n5;
        }
    }

    private byte analyzeDelimiterInternal(boolean bl, int n) throws IOException {
        int n2 = 0;
        this.curchannel = 0;
        while (this.curchannel < this.channels.length) {
            int n3;
            int n4 = -1;
            this.columnsdelimiters[this.curchannel] = new int[DELIMITERS.length];
            int[] nArray = new int[DELIMITERS.length];
            int n5 = 0;
            int[] nArray2 = new int[DELIMITERS.length];
            int n6 = 0;
            this.lnline = true;
            int n7 = 0;
            RandomAccessFile randomAccessFile = this.channels[this.curchannel];
            randomAccessFile.seek(0L);
            boolean bl2 = false;
            boolean bl3 = false;
            while (n6 >= 0 && !bl3) {
                n6 = randomAccessFile.read(this.buf[this.curchannel]);
                block11: for (int i = 0; i < n6; ++i) {
                    int n8 = this.buf[this.curchannel][i];
                    if (this.lnline && (n8 == 10 || n8 == 13)) continue;
                    this.lnline = false;
                    if (bl && n8 == n4) continue;
                    switch (n8) {
                        case 9: {
                            nArray[0] = nArray[0] + 1;
                            if (nArray[0] > n5) {
                                n2 = 0;
                                n5 = nArray[0];
                            }
                            nArray2[0] = nArray2[0] + 1;
                            n4 = n8;
                            continue block11;
                        }
                        case 32: {
                            nArray[1] = nArray[1] + 1;
                            if (nArray[1] > n5) {
                                n2 = 1;
                                n5 = nArray[1];
                            }
                            nArray2[1] = nArray2[1] + 1;
                            n4 = n8;
                            continue block11;
                        }
                        case 44: {
                            nArray[2] = nArray[2] + 1;
                            if (nArray[2] > n5) {
                                n2 = 2;
                                n5 = nArray[2];
                            }
                            nArray2[2] = nArray2[2] + 1;
                            n4 = n8;
                            continue block11;
                        }
                        case 45: {
                            nArray[3] = nArray[3] + 1;
                            if (nArray[3] > n5) {
                                n2 = 3;
                                n5 = nArray[3];
                            }
                            nArray2[3] = nArray2[3] + 1;
                            n4 = n8;
                            continue block11;
                        }
                        case 58: {
                            nArray[4] = nArray[4] + 1;
                            if (nArray[4] > n5) {
                                n2 = 4;
                                n5 = nArray[4];
                            }
                            nArray2[4] = nArray2[4] + 1;
                            n4 = n8;
                            continue block11;
                        }
                        case 59: {
                            nArray[5] = nArray[5] + 1;
                            if (nArray[5] > n5) {
                                n2 = 5;
                                n5 = nArray[5];
                            }
                            nArray2[5] = nArray2[5] + 1;
                            n4 = n8;
                            continue block11;
                        }
                        case 10: 
                        case 13: {
                            ++n7;
                            bl2 = false;
                            for (n3 = 0; n3 < 6; ++n3) {
                                int n9 = n3;
                                nArray2[n9] = nArray2[n9] + 1;
                                if (nArray2[n3] > this.columnsdelimiters[this.curchannel][n3]) {
                                    this.columnsdelimiters[this.curchannel][n3] = nArray2[n3];
                                }
                                nArray2[n3] = 0;
                            }
                            n4 = -1;
                            this.lnline = true;
                            bl3 = n7 >= n;
                            continue block11;
                        }
                        default: {
                            bl2 = true;
                            n4 = -1;
                        }
                    }
                }
            }
            if (!this.lnline) {
                for (n3 = 0; n3 < 4; ++n3) {
                    int n10 = n3;
                    nArray2[n10] = nArray2[n10] + 1;
                    if (nArray2[n3] > this.columnsdelimiters[this.curchannel][n3]) {
                        this.columnsdelimiters[this.curchannel][n3] = nArray2[n3];
                    }
                    nArray2[n3] = 0;
                }
            }
            if (bl2) {
                ++n7;
            }
            for (n3 = 0; n3 < DELIMITERS.length; ++n3) {
                if (nArray2[n3] > this.columnsdelimiters[this.curchannel][n3]) {
                    this.columnsdelimiters[this.curchannel][n3] = nArray2[n3];
                }
                nArray2[n3] = 0;
            }
            this.channelrows[this.curchannel] = n7;
            ++this.curchannel;
        }
        if (this.delimiterIndex < 0) {
            this.delimiterIndex = n2;
        }
        return (byte)n2;
    }

    private void countChannelRows() {
        try {
            Arrays.fill(this.channelrows, 0);
            this.curchannel = 0;
            while (this.curchannel < this.channels.length) {
                int n = 0;
                RandomAccessFile randomAccessFile = this.channels[this.curchannel];
                randomAccessFile.seek(0L);
                byte by = -1;
                while (n >= 0) {
                    n = randomAccessFile.read(this.buf[this.curchannel]);
                    for (int i = 0; i < n; ++i) {
                        byte by2 = this.buf[this.curchannel][i];
                        if (this.isLineChar(by2) && !this.isLineChar(by)) {
                            int n2 = this.curchannel;
                            this.channelrows[n2] = this.channelrows[n2] + 1;
                        }
                        by = by2;
                    }
                }
                if (!this.isLineChar(by)) {
                    int n3 = this.curchannel;
                    this.channelrows[n3] = this.channelrows[n3] + 1;
                }
                ++this.curchannel;
            }
        }
        catch (IOException iOException) {
            ErrorHandler.logAndReportException(iOException);
        }
    }

    private void initChannelData() {
        this.indexMatrix = new int[this.channels.length][];
        this.rowSizes = new long[this.channels.length][];
        this.indexLength = new short[this.channels.length][];
        this.columnsdelimiters = new int[this.channels.length][];
        this.channelrows = new int[this.channels.length];
        this.channelcolumns = new int[this.channels.length];
    }

    private boolean isLineChar(byte by) {
        return by == 10 || by == 13;
    }
}

