/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.raw;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.IOException;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.dataimport.AbstractImportPanel;
import se.prediktera.map.dataimport.ImportInterface;
import se.prediktera.map.dataimport.raw.DelimiterPanel;
import se.prediktera.map.dataimport.raw.RawDataSource;
import se.prediktera.map.main.script.ImportClass;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class RawImportPanel
extends AbstractImportPanel {
    private DelimiterPanel delimiterPanel;
    private RawDataSource dsciModel;

    public RawImportPanel(ImportInterface importInterface) {
        super((LayoutManager)new BorderLayout(), importInterface.getFiles());
        try {
            this.dsciModel = new RawDataSource(this.filenames, importInterface.getMergeType(), importInterface.includeFileNames());
            boolean bl = false;
            if (importInterface instanceof ImportClass) {
                ImportClass importClass = (ImportClass)importInterface;
                bl = importClass.isMulti();
            }
            if (!bl) {
                this.delimiterPanel = new DelimiterPanel(this.dsciModel){

                    @Override
                    public void updatePreviewTable() {
                        RawImportPanel.this.updatePreviewTable();
                    }
                };
                this.add((Component)this.delimiterPanel, "Center");
            }
        }
        catch (IOException iOException) {
            ErrorHandler.logAndShowEvinceErrorDialogForException(iOException);
        }
    }

    @Override
    public boolean canFinish() {
        return false;
    }

    @Override
    public CellIdentifierModel getCashedCiModel() {
        TableModel tableModel;
        if (this.delimiterPanel != null && (tableModel = this.delimiterPanel.getTableModel()) instanceof CellIdentifierModel) {
            return (CellIdentifierModel)tableModel;
        }
        return null;
    }

    @Override
    public CellIdentifierModel getTableModel(ProgressManager progressManager, boolean bl) {
        if (this.dsciModel != null) {
            byte by = 2;
            boolean bl2 = false;
            if (this.delimiterPanel != null) {
                bl2 = this.delimiterPanel.treatConsecutiveDelimitersAsOne();
                by = this.delimiterPanel.getDelimiterIndex() >= 0 ? (byte)this.delimiterPanel.getDelimiterIndex() : (this.dsciModel.getDelimiterIndex() >= 0 ? this.dsciModel.getDelimiterIndex() : this.dsciModel.analyzeDelimiter(bl2));
            } else {
                by = this.dsciModel.analyzeDelimiter(bl2);
            }
            this.dsciModel.indexDataSource(progressManager, by, bl2, bl);
        }
        return this.dsciModel;
    }

    @Override
    public String getType() {
        return "Delimiter";
    }

    @Override
    public boolean hasSettings() {
        return true;
    }

    public void setDelimiter(String string) {
        this.delimiterPanel.setDelimiter(string);
    }

    @Override
    public void updateInfo(ImportInterface importInterface) {
        this.delimiterPanel.setTableModel(new DefaultTableModel());
        super.updateInfo(importInterface);
        try {
            this.dsciModel.set(importInterface.getFiles(), importInterface.getMergeType(), importInterface.includeFileNames());
        }
        catch (IOException iOException) {
            ErrorHandler.logAndShowEvinceErrorDialogForException(iOException);
        }
        this.analyseDelimiter(true);
        this.updatePreviewTable();
    }

    public void updatePreviewTable() {
        ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(){

            @Override
            public Object doWork() {
                this.setInfoText("Checking file");
                CellIdentifierModel cellIdentifierModel = RawImportPanel.this.getCellIdentifierModel(this, true);
                if (cellIdentifierModel != null) {
                    RawImportPanel.this.delimiterPanel.setTableModel(cellIdentifierModel);
                }
                return null;
            }
        };
        SwingUtilities.invokeLater(progressManagerImpl);
    }

    protected String bytesToString(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return "";
        }
        return new String(byArray);
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.dsciModel = null;
        if (this.delimiterPanel != null) {
            this.delimiterPanel.cleanUp();
            this.delimiterPanel = null;
        }
    }

    private void analyseDelimiter(boolean bl) {
        if (this.delimiterPanel != null) {
            this.delimiterPanel.analyzeDelimiter(bl);
        }
    }
}

