/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.raw.paste;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.table.AbstractTableModel;
import se.prediktera.map.dataimport.raw.DelimiterPanel;
import se.prediktera.map.dataimport.raw.paste.TextPasteModel;

public class PastePanel
extends JPanel {
    private final DelimiterPanel delimiters;
    private AbstractTableModel model;
    private final TextPasteModel pasteModel = new TextPasteModel();
    private final IndexModel indexModel = new IndexModel();
    private final boolean splitOnNewLine;
    private final JRadioButton pasteBeforeRadioButton = new JRadioButton("Paste before");
    private final JRadioButton pasteAfterRadioButton = new JRadioButton("Paste after");
    private final JCheckBox transposeCheckBox;

    public PastePanel(boolean bl) {
        super(new BorderLayout());
        this.splitOnNewLine = bl;
        this.model = this.pasteModel;
        this.delimiters = new DelimiterPanel(this.pasteModel){

            @Override
            public void updatePreviewTable() {
                this.setTableModel(PastePanel.this.model);
                PastePanel.this.pasteModel.parseData(PastePanel.this.getDelimiters(), 0, PastePanel.this.splitOnNewLine);
                super.updatePreviewTable();
            }
        };
        this.delimiters.analyzeDelimiter(true);
        this.delimiters.updatePreviewTable();
        this.add((Component)this.delimiters, "Center");
        this.transposeCheckBox = new JCheckBox("Transpose");
        this.transposeCheckBox.addItemListener(itemEvent -> this.pasteModel.setTranspose(this.transposeCheckBox.isSelected()));
        this.pasteBeforeRadioButton.setSelected(true);
        if (!bl) {
            JPanel jPanel = new JPanel(new GridLayout(3, 1, 5, 5));
            jPanel.setBorder(BorderFactory.createTitledBorder("Paste options"));
            jPanel.add(this.transposeCheckBox);
            jPanel.add(this.pasteBeforeRadioButton);
            jPanel.add(this.pasteAfterRadioButton);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.pasteBeforeRadioButton);
            buttonGroup.add(this.pasteAfterRadioButton);
            this.add((Component)jPanel, "South");
        }
    }

    public void changeTransposed() {
        this.transposeCheckBox.setSelected(!this.transposeCheckBox.isSelected());
    }

    public int getColumnCount() {
        if (this.pasteModel == null) {
            return 0;
        }
        return this.pasteModel.getColumnCount();
    }

    public String getDelimiters() {
        return this.delimiters.getDelimiterRegExp(this.splitOnNewLine);
    }

    public String[][] getPastedData() {
        return this.pasteModel.getPastedData();
    }

    public int getRowCount() {
        if (this.pasteModel == null) {
            return 0;
        }
        return this.pasteModel.getRowCount();
    }

    public boolean isBefore() {
        return this.pasteBeforeRadioButton.isSelected();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.delimiters.setEnabled(bl);
        this.model = bl ? this.pasteModel : this.indexModel;
        this.delimiters.updatePreviewTable();
    }

    private static class IndexModel
    extends AbstractTableModel {
        private IndexModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return 15;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n < this.getRowCount() - 1) {
                return n + 1;
            }
            return "...";
        }
    }
}

