/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.raw.paste;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import se.prediktera.map.dataimport.raw.TextImportModel;

public class TextPasteModel
extends AbstractTableModel
implements TextImportModel {
    private String rawData;
    private String[][] pastedData;
    private boolean transpose;

    public TextPasteModel() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        try {
            this.rawData = transferable == null || !transferable.isDataFlavorSupported(DataFlavor.stringFlavor) ? "" : (String)transferable.getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException | IOException exception) {
            this.rawData = exception.getMessage();
        }
    }

    @Override
    public byte analyzeDelimiter(boolean bl) {
        return this.analyzeDelimiter(bl, Integer.MAX_VALUE);
    }

    @Override
    public byte analyzeDelimiter(boolean bl, int n) {
        int n2;
        int n3;
        int n4;
        if (this.rawData == null) {
            return 0;
        }
        int[] nArray = new int[DELIMITERS.length];
        int n5 = 0;
        block0: for (n4 = 0; n4 < this.rawData.length(); ++n4) {
            n3 = this.rawData.charAt(n4);
            if (bl && n3 == n5) continue;
            n5 = n3;
            for (n2 = 0; n2 < nArray.length; ++n2) {
                if (n3 != DELIMITERS[n2]) continue;
                int n6 = n2;
                nArray[n6] = nArray[n6] + 1;
                continue block0;
            }
        }
        n4 = 0;
        n3 = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] <= n3) continue;
            n3 = nArray[n2];
            n4 = n2;
        }
        return (byte)n4;
    }

    @Override
    public int getColumnCount() {
        if (this.pastedData == null || this.pastedData.length == 0) {
            return 0;
        }
        if (this.transpose) {
            return this.pastedData[0].length;
        }
        return this.pastedData.length;
    }

    @Override
    public String getColumnName(int n) {
        return Integer.toString(n + 1);
    }

    public String[][] getPastedData() {
        if (this.transpose && this.pastedData.length > 0) {
            String[][] stringArray = new String[this.pastedData[0].length][this.pastedData.length];
            for (int i = 0; i < this.pastedData.length; ++i) {
                for (int j = 0; j < this.pastedData[i].length; ++j) {
                    stringArray[j][i] = this.pastedData[i][j];
                }
            }
            return stringArray;
        }
        return this.pastedData;
    }

    @Override
    public int getRowCount() {
        if (this.pastedData == null || this.pastedData.length == 0) {
            return 0;
        }
        if (this.transpose) {
            return this.pastedData.length;
        }
        return this.pastedData[0].length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.pastedData == null) {
            return "";
        }
        if (this.transpose) {
            return this.pastedData[n][n2];
        }
        return this.pastedData[n2][n];
    }

    public void parseData(String string, int n, boolean bl) {
        if (this.rawData == null) {
            this.pastedData = new String[][]{{""}};
        } else if (bl) {
            this.pastedData = new String[1][];
            this.pastedData[0] = this.rawData.split(string, n);
        } else {
            String[] stringArray = this.rawData.split("\n", n);
            if (stringArray.length > 0) {
                String[] stringArray2 = stringArray[0].split(string, n);
                this.pastedData = new String[stringArray2.length][stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray2 = stringArray[i].split(string, n);
                    if (stringArray2.length > this.pastedData.length) {
                        if (this.pastedData.length > 0 && this.pastedData[0].length > 0) {
                            JOptionPane.showMessageDialog(null, "Error: Data could not be parsed!", "Error parsing data", 0);
                            this.pastedData[0][0] = "Unrecognized data";
                            this.fireTableStructureChanged();
                        }
                        return;
                    }
                    for (int j = 0; j < stringArray2.length; ++j) {
                        this.pastedData[j][i] = stringArray2[j];
                    }
                }
            }
        }
        this.fireTableStructureChanged();
    }

    public void setTranspose(boolean bl) {
        this.transpose = bl;
        this.fireTableStructureChanged();
    }
}

