/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.spc;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class LittleEndianFileReader {
    private final BufferedInputStream bis;

    public static int arr2int(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        byte[] byArray2 = new byte[4];
        for (n2 = n; n2 < n + 4; ++n2) {
            byArray2[n3] = byArray[n2];
            ++n3;
        }
        int n4 = 0;
        n2 = 0;
        for (int i = 0; i < 32; i += 8) {
            n4 = (int)((long)n4 | (long)(byArray2[n2] & 0xFF) << i);
            ++n2;
        }
        return n4;
    }

    private static double arr2double(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        byte[] byArray2 = new byte[8];
        for (n2 = n; n2 < n + 8; ++n2) {
            byArray2[n3] = byArray[n2];
            ++n3;
        }
        long l = 0L;
        n2 = 0;
        for (int i = 0; i < 64; i += 8) {
            l |= (long)(byArray2[n2] & 0xFF) << i;
            ++n2;
        }
        return Double.longBitsToDouble(l);
    }

    private static float arr2float(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        byte[] byArray2 = new byte[4];
        for (n2 = n; n2 < n + 4; ++n2) {
            byArray2[n3] = byArray[n2];
            ++n3;
        }
        int n4 = 0;
        n2 = 0;
        for (int i = 0; i < 32; i += 8) {
            n4 = (int)((long)n4 | (long)(byArray2[n2] & 0xFF) << i);
            ++n2;
        }
        return Float.intBitsToFloat(n4);
    }

    private static short arr2short(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        int n3 = byArray[n + 1] & 0xFF;
        return (short)(n3 << 8 | n2);
    }

    private static byte[] readReversedBytes(BufferedInputStream bufferedInputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        bufferedInputStream.read(byArray);
        return byArray;
    }

    public LittleEndianFileReader(File file) throws FileNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.bis = new BufferedInputStream(fileInputStream);
    }

    public void close() throws IOException {
        this.bis.close();
    }

    public byte readByte() throws IOException {
        return (byte)this.bis.read();
    }

    public byte[] readBytes(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.bis.read(byArray);
        return byArray;
    }

    public char[] readChar(int n) throws IOException {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)this.bis.read();
        }
        return cArray;
    }

    public double readDouble() throws IOException {
        return LittleEndianFileReader.arr2double(LittleEndianFileReader.readReversedBytes(this.bis, 8), 0);
    }

    public float readFloat() throws IOException {
        return LittleEndianFileReader.arr2float(LittleEndianFileReader.readReversedBytes(this.bis, 4), 0);
    }

    public int readInt() throws IOException {
        return LittleEndianFileReader.arr2int(LittleEndianFileReader.readReversedBytes(this.bis, 4), 0);
    }

    public long readLong() throws IOException {
        throw new RuntimeException("Not implemented");
    }

    public short readShort() throws IOException {
        return LittleEndianFileReader.arr2short(LittleEndianFileReader.readReversedBytes(this.bis, 2), 0);
    }

    public long remaining() throws IOException {
        return this.bis.available();
    }
}

