/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.spc;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import se.prediktera.map.dataimport.spc.LittleEndianFileReader;
import se.prediktera.map.dataimport.spc.SpcObservations;
import se.prediktera.map.dataimport.spc.SpcReferenceData;

public class Spc4BReader {
    static int SPC_HEADER_SIZE = 484;
    static int SPC_OLD_FILEFORMAT_ID = 77;
    static int SPC_TSPREC = 1;
    static int SPC_TXVALS_BIT = 7;
    static int SPC_TXYXYS_BIT = 6;
    static int SPC_TMULTI_BIT = 2;
    static int SPC_GEN = 0;
    static int SPC_GC = 1;
    static int SPC_CGM = 2;
    static int SPC_HPLC = 3;
    static int SPC_FTIR = 4;
    static int SPC_NIR = 5;
    static int SPC_UV = 7;
    static int SPC_XRY = 8;
    static int SPC_MS = 9;
    static int SPC_NMR = 10;
    static int SPC_RMN = 11;
    static int SPC_FLR = 12;
    static int SPC_ATM = 13;
    static int SPC_DAD = 14;
    String sgAllExpTitles = "General Chromatogram (could be anything);Gas Chromatogram;General Chromatogram (same as SPCGEN with TCGRAM);HPLC Chromatogram;FT-IR, FT-NIR, FT-Raman Spectrum or Igram (Can also be used for scanning IR.);NIR Spectrum (Usually multi-spectral data sets for calibration.);UV-VIS Spectrum (Can be used for single scanning UV-VIS-NIR.);X-ray Diffraction Spectrum;Mass Spectrum  (Can be single, GC-MS, Continuum, Centroid or TOF.);NMR Spectrum or FID;Spectrum (Usually Diode Array, CCD, etc. use SPCFTIR for FT-Raman.);Fluorescence Spectrum ;Atomic Spectrum;Chromatography Diode Array Spectra";

    public static int BitCount(int n) {
        int n2 = 0;
        for (int i = 0; i < 32; ++i) {
            if (!Spc4BReader.BitChk(n, i)) continue;
            ++n2;
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SpcObservations readSpc(String string, SpcObservations spcObservations, File file) throws IOException {
        SpcReferenceData spcReferenceData = new SpcReferenceData();
        try {
            LittleEndianFileReader littleEndianFileReader = new LittleEndianFileReader(file);
            SpcFileHeader spcFileHeader = new SpcFileHeader();
            spcFileHeader.readFileHeader(littleEndianFileReader);
            spcObservations.setValueCount(spcFileHeader.fnpts);
            spcObservations.setStartValue(spcFileHeader.ffirst);
            spcObservations.setEndValue(spcFileHeader.flast);
            spcObservations.setXZLabel(spcReferenceData.getXZLabel(spcFileHeader.fxtype));
            Spc4BReader.setFileType(spcFileHeader);
            if (Spc4BReader.BitChk(spcFileHeader.ftflgs, SPC_TSPREC)) {
                throw new UnsupportedEncodingException("Files containing 16 bit integer values not currently supported!");
            }
            if (!Spc4BReader.BitChk(spcFileHeader.ftflgs, SPC_TXVALS_BIT)) {
                double d = (spcFileHeader.flast - spcFileHeader.ffirst) / (double)(spcFileHeader.fnpts - 1);
                if (d < 0.0) {
                    // empty if block
                }
                spcObservations.createRows(1);
                for (int i = 0; i < spcFileHeader.fnsub; ++i) {
                    boolean bl;
                    int n = i % 64;
                    SpcSubHeader spcSubHeader = new SpcSubHeader();
                    spcSubHeader.readSubHeader(littleEndianFileReader);
                    SpcObservations.Observation observation = spcObservations.createObservation(0, n, string, spcFileHeader.fnpts);
                    float[] fArray = observation.getVariables();
                    boolean bl2 = (spcFileHeader.ftflgs & 4) != 0;
                    boolean bl3 = bl = (spcFileHeader.ftflgs & 1) != 0;
                    boolean bl4 = bl2 ? spcSubHeader.subexp == 128 : spcFileHeader.fexp == 128;
                    byte by = bl2 ? spcSubHeader.subexp : spcFileHeader.fexp;
                    int n2 = bl ? 16 : 32;
                    for (int j = 0; j < spcFileHeader.fnpts; ++j) {
                        fArray[j] = bl4 ? littleEndianFileReader.readFloat() : Spc4BReader.getSPC4BData(littleEndianFileReader, n2, by);
                    }
                }
                return spcObservations;
            }
            if (Spc4BReader.BitChk(spcFileHeader.ftflgs, SPC_TXYXYS_BIT)) return spcObservations;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return spcObservations;
    }

    private static boolean BitChk(int n, int n2) {
        return (1 & n >> n2) != 0;
    }

    private static float getSPC4BData(LittleEndianFileReader littleEndianFileReader, int n, int n2) throws IOException {
        int n3 = littleEndianFileReader.readInt();
        return (float)(Math.pow(2.0, n2) * (double)n3 / Math.pow(2.0, n));
    }

    private static void setFileType(SpcFileHeader spcFileHeader) {
        spcFileHeader.FileType = Spc4BReader.BitChk(spcFileHeader.ftflgs, SPC_TMULTI_BIT) ? (!Spc4BReader.BitChk(spcFileHeader.ftflgs, SPC_TXYXYS_BIT) ? SPCFileType.Type3dSurface : SPCFileType.Type3dNoLayout) : (Spc4BReader.BitChk(spcFileHeader.ftflgs, SPC_TXYXYS_BIT) ? SPCFileType.Type2dSpike : SPCFileType.Type2dLine);
    }

    private static class SpcFileHeader {
        public SPCFileType FileType;
        public float[] spare;
        public char[] comment;
        public char[] fcatxt;
        public char[] FileMethod;
        public char[] Reserve1;
        public char[] Description;
        public char[] SourceInstrument;
        public byte ftflgs;
        public byte fversn;
        public byte fexper;
        public byte fexp;
        public int fnpts;
        public double ffirst;
        public double flast;
        public int fnsub;
        public byte fxtype;
        public byte fytype;
        public byte fztype;
        public byte fpost;
        public int fdate;
        public short fpeakpt;
        public int flogoff;
        public int fmods;
        public byte fprocs;
        public byte flevel;
        public short fsampin;
        public int ffactor;
        public int ZSubFileIncrement;
        public int fwplanes;
        public int WPlaneIncrement;
        public byte fwtype;

        private SpcFileHeader() {
        }

        public void readFileHeader(LittleEndianFileReader littleEndianFileReader) throws IOException {
            this.spare = new float[8];
            this.ftflgs = littleEndianFileReader.readByte();
            this.fversn = littleEndianFileReader.readByte();
            this.fexper = littleEndianFileReader.readByte();
            this.fexp = littleEndianFileReader.readByte();
            this.fnpts = littleEndianFileReader.readInt();
            this.ffirst = littleEndianFileReader.readDouble();
            this.flast = littleEndianFileReader.readDouble();
            this.fnsub = littleEndianFileReader.readInt();
            this.fxtype = littleEndianFileReader.readByte();
            this.fytype = littleEndianFileReader.readByte();
            this.fztype = littleEndianFileReader.readByte();
            this.fpost = littleEndianFileReader.readByte();
            this.fdate = littleEndianFileReader.readInt();
            this.Description = littleEndianFileReader.readChar(9);
            this.SourceInstrument = littleEndianFileReader.readChar(9);
            this.fpeakpt = littleEndianFileReader.readShort();
            for (int i = 0; i < 8; ++i) {
                this.spare[i] = littleEndianFileReader.readFloat();
            }
            this.comment = littleEndianFileReader.readChar(130);
            this.fcatxt = littleEndianFileReader.readChar(30);
            this.flogoff = littleEndianFileReader.readInt();
            this.fmods = littleEndianFileReader.readInt();
            this.fprocs = littleEndianFileReader.readByte();
            this.flevel = littleEndianFileReader.readByte();
            this.fsampin = littleEndianFileReader.readShort();
            this.ffactor = littleEndianFileReader.readInt();
            this.FileMethod = littleEndianFileReader.readChar(48);
            this.ZSubFileIncrement = littleEndianFileReader.readInt();
            this.fwplanes = littleEndianFileReader.readInt();
            this.WPlaneIncrement = littleEndianFileReader.readInt();
            this.fwtype = littleEndianFileReader.readByte();
            this.Reserve1 = littleEndianFileReader.readChar(187);
        }
    }

    private static class SpcSubHeader {
        byte subflgs;
        byte subexp;
        int subindx;
        float subtime;
        float subnext;
        float subnois;
        int subnpts;
        int subscan;
        float subwlevel;
        byte[] Reserved1;

        private SpcSubHeader() {
        }

        public void readSubHeader(LittleEndianFileReader littleEndianFileReader) throws IOException {
            this.subflgs = littleEndianFileReader.readByte();
            this.subexp = littleEndianFileReader.readByte();
            this.subindx = littleEndianFileReader.readShort();
            this.subtime = littleEndianFileReader.readFloat();
            this.subnext = littleEndianFileReader.readFloat();
            this.subnois = littleEndianFileReader.readFloat();
            this.subnpts = littleEndianFileReader.readInt();
            this.subscan = littleEndianFileReader.readInt();
            this.subwlevel = littleEndianFileReader.readFloat();
            this.Reserved1 = littleEndianFileReader.readBytes(4);
        }
    }

    static enum SPCFileType {
        Type3dSurface,
        Type3dNoLayout,
        Type2dLine,
        Type2dSpike;

    }
}

