/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.spc;

import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import se.prediktera.map.dataimport.spc.LittleEndianFileReader;
import se.prediktera.map.dataimport.spc.SpcObservations;
import se.prediktera.map.dataimport.spc.SpcReferenceData;

public class Spc4DReader {
    public static float getSPC4DData(LittleEndianFileReader littleEndianFileReader, int n, int n2) throws IOException {
        byte[] byArray = littleEndianFileReader.readBytes(2);
        byte[] byArray2 = littleEndianFileReader.readBytes(2);
        byte[] byArray3 = new byte[]{byArray2[0], byArray2[1], byArray[0], byArray[1]};
        int n3 = LittleEndianFileReader.arr2int(byArray3, 0);
        return (float)((double)n3 / Math.pow(2.0, n) * Math.pow(2.0, n2));
    }

    public static SpcObservations readSpc(String string, SpcObservations spcObservations, File file) throws IOException {
        SpcReferenceData spcReferenceData = new SpcReferenceData();
        boolean bl = false;
        try {
            LittleEndianFileReader littleEndianFileReader = new LittleEndianFileReader(file);
            SPC4DHeader sPC4DHeader = new SPC4DHeader(littleEndianFileReader);
            bl = (sPC4DHeader.oftflgs & 4) != 0;
            spcObservations.setValueCount((int)sPC4DHeader.onpts);
            spcObservations.setStartValue(sPC4DHeader.ofirst);
            spcObservations.setEndValue(sPC4DHeader.olast);
            spcObservations.setXZLabel(spcReferenceData.getXZLabel(sPC4DHeader.oxtype));
            spcObservations.createRows(1);
            spcObservations.createObservation(0, 0, string, (int)sPC4DHeader.onpts);
            SpcObservations.Observation observation = spcObservations.getLastObservation();
            float[] fArray = observation.getVariables();
            int n = (int)sPC4DHeader.onpts;
            if (sPC4DHeader.oexp == 128) {
                for (int i = 0; i < n; ++i) {
                    fArray[i] = littleEndianFileReader.readFloat();
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    fArray[i] = Spc4DReader.getSPC4DData(littleEndianFileReader, 32, sPC4DHeader.oexp);
                }
            }
            if (bl) {
                JOptionPane.showMessageDialog(null, "This version is not currently supporting multiple observations per file.\nOnly the first observation will be shown.", "Warning", 2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return spcObservations;
    }

    private static class SPC4DHeader {
        private final byte oftflgs;
        private final byte oversn;
        private final short oexp;
        private final float onpts;
        private final float ofirst;
        private final float olast;
        private final byte oxtype;
        private final byte oytype;
        private final short oyear;
        private final byte omonth;
        private final byte oday;
        private final byte ohour;
        private final byte ominute;
        private final char[] ores;
        private final short peakpt;
        private final short onscans;
        private final char[] ocmnt;
        private final char[] ocatxt;
        private final char[] osubh1;

        public SPC4DHeader(LittleEndianFileReader littleEndianFileReader) throws IOException {
            this.oftflgs = littleEndianFileReader.readByte();
            this.oversn = littleEndianFileReader.readByte();
            this.oexp = littleEndianFileReader.readShort();
            this.onpts = littleEndianFileReader.readFloat();
            this.ofirst = littleEndianFileReader.readFloat();
            this.olast = littleEndianFileReader.readFloat();
            this.oxtype = littleEndianFileReader.readByte();
            this.oytype = littleEndianFileReader.readByte();
            this.oyear = littleEndianFileReader.readShort();
            this.omonth = littleEndianFileReader.readByte();
            this.oday = littleEndianFileReader.readByte();
            this.ohour = littleEndianFileReader.readByte();
            this.ominute = littleEndianFileReader.readByte();
            this.ores = littleEndianFileReader.readChar(8);
            this.peakpt = littleEndianFileReader.readShort();
            this.onscans = littleEndianFileReader.readShort();
            littleEndianFileReader.readBytes(28);
            this.ocmnt = littleEndianFileReader.readChar(130);
            this.ocatxt = littleEndianFileReader.readChar(30);
            this.osubh1 = littleEndianFileReader.readChar(32);
        }
    }
}

