/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.spc;

import java.io.IOException;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.dataimport.spc.SpcObservations;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class SpcDataSource
extends CellIdentifierModel {
    private final SpcObservations values;
    private final boolean includeFileNames;

    public SpcDataSource(SpcObservations spcObservations, boolean bl) throws IOException, IndexOutOfBoundsException {
        super(spcObservations.getObservationCount() + 1, spcObservations.getLastObservation().getVariableCount() + (bl ? 1 : 0));
        this.values = spcObservations;
        this.includeFileNames = bl;
    }

    @Override
    public void autoIdentifyData(ProgressManager progressManager, int n) {
        this.setPrimaryRow(0);
        this.addInterval(0, 0, (byte)0);
        if (this.includeFileNames) {
            this.addInterval(1, 0, (byte)1);
        }
    }

    @Override
    public final FastDecimal getDoubleAt_Transpose(int n, int n2, FastDecimal fastDecimal) {
        if (n == 0) {
            return fastDecimal.error();
        }
        SpcObservations.Observation observation = this.values.getObservationAt(n - 1);
        if (this.includeFileNames) {
            if (n2 == 0) {
                return fastDecimal.error();
            }
            --n2;
        }
        return fastDecimal.setValue(observation.getVariables()[n2]);
    }

    @Override
    public Object getValueAt_Transpose(int n, int n2) {
        if (n == 0) {
            if (this.includeFileNames) {
                if (n2 == 0) {
                    return "";
                }
                --n2;
            }
            return this.values.getWavelength(n2);
        }
        SpcObservations.Observation observation = this.values.getObservationAt(n - 1);
        if (this.includeFileNames) {
            if (n2 == 0) {
                return observation.getFilename();
            }
            --n2;
        }
        return String.valueOf(observation.getVariables()[n2]);
    }
}

