/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.spc;

import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataimport.AbstractImportPanel;
import se.prediktera.map.dataimport.ImportInterface;
import se.prediktera.map.dataimport.spc.LittleEndianFileReader;
import se.prediktera.map.dataimport.spc.Spc4BReader;
import se.prediktera.map.dataimport.spc.Spc4DReader;
import se.prediktera.map.dataimport.spc.SpcDataSource;
import se.prediktera.map.dataimport.spc.SpcObservations;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class SpcImportPanel
extends AbstractImportPanel {
    private SpcDataSource spcModel;

    public SpcImportPanel(ImportInterface importInterface) {
        super(importInterface.getFiles());
        try {
            this.spcModel = new SpcDataSource(this.readCorrectSPCFormat(importInterface.getFiles()), importInterface.includeFileNames());
        }
        catch (Exception exception) {
            if (exception.getMessage().length() > 0) {
                JOptionPane.showMessageDialog(null, "Error while trying to open file, file corrupt?\n\nError returned was: " + exception.getMessage(), "Error opening file", 2);
            } else {
                JOptionPane.showMessageDialog(null, "Error while trying to open file, file corrupt?", "Error opening file", 2);
            }
            return;
        }
    }

    @Override
    public CellIdentifierModel getTableModel(ProgressManager progressManager, boolean bl) {
        return this.spcModel;
    }

    @Override
    public String getType() {
        return "JCAMP Data File";
    }

    @Override
    public boolean hasSettings() {
        return false;
    }

    @Override
    protected void cleanUpChild() {
        this.spcModel = null;
    }

    protected boolean isMultiLayer() {
        return false;
    }

    protected boolean preLoadData() {
        return false;
    }

    private SpcObservations readCorrectSPCFormat(File[] fileArray) throws IOException {
        SpcObservations spcObservations = new SpcObservations();
        block4: for (File file : fileArray) {
            String string = file.getName();
            int n = string.lastIndexOf(".");
            if (n >= 0) {
                string = string.substring(0, n);
            }
            LittleEndianFileReader littleEndianFileReader = new LittleEndianFileReader(file);
            byte[] byArray = littleEndianFileReader.readBytes(2);
            switch (byArray[1]) {
                case 77: {
                    littleEndianFileReader.close();
                    Spc4DReader.readSpc(string, spcObservations, file);
                    continue block4;
                }
                case 75: {
                    littleEndianFileReader.close();
                    Spc4BReader.readSpc(string, spcObservations, file);
                    continue block4;
                }
                default: {
                    littleEndianFileReader.close();
                    throw new IOException("Incorrect SPC file format.");
                }
            }
        }
        return spcObservations;
    }
}

