/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.spc;

import java.text.NumberFormat;
import java.util.ArrayList;

public class SpcObservations {
    private final ArrayList<ArrayList<Observation>> observations = new ArrayList();
    private double startValue;
    private double endValue;
    private int valueCount;
    private String XZLabel;
    private final NumberFormat nf = NumberFormat.getNumberInstance();

    public SpcObservations() {
        this.nf.setGroupingUsed(false);
        this.nf.setMaximumFractionDigits(2);
        this.nf.setMinimumFractionDigits(2);
    }

    public Observation createObservation(int n, int n2, String string, int n3) {
        Observation observation = new Observation(string, n3);
        this.observations.get(n).add(observation);
        return observation;
    }

    public void createRows(int n) {
        for (int i = 0; i < n; ++i) {
            this.observations.add(new ArrayList());
        }
    }

    public Observation getLastObservation() {
        int n = this.observations.size();
        int n2 = this.observations.get(0).size();
        return this.observations.get(n - 1).get(n2 - 1);
    }

    public Observation getObservationAt(int n) {
        if (n < 0 || n >= this.observations.get(0).size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.observations.get(0).get(n);
    }

    public int getObservationCount() {
        return this.observations.get(0).size();
    }

    public String getWavelength(int n) {
        double d = (this.endValue - this.startValue) / (double)this.valueCount;
        double d2 = this.startValue + (double)n * d;
        return this.nf.format(d2) + " " + this.XZLabel;
    }

    public void setEndValue(double d) {
        this.endValue = d;
    }

    public void setStartValue(double d) {
        this.startValue = d;
    }

    public void setValueCount(int n) {
        this.valueCount = n;
    }

    public void setXZLabel(String string) {
        this.XZLabel = string;
    }

    static class Observation {
        private final String filename;
        private final float[] variables;

        public Observation(String string, int n) {
            this.filename = string;
            this.variables = new float[n];
        }

        public String getFilename() {
            return this.filename;
        }

        public int getVariableCount() {
            return this.variables.length;
        }

        public float[] getVariables() {
            return this.variables;
        }
    }
}

