/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.xls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataimport.AbstractImportPanel;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.dataimport.ImportInterface;
import se.prediktera.map.simpletableeditor.CellIdentifier;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class XlsImportPanel
extends AbstractImportPanel {
    private final JTable sheetTable = new JTable();
    private Workbook[] workbooks = null;
    private final HashMap<Integer, Sheet> bufMap = new HashMap();

    public XlsImportPanel(ImportInterface importInterface) throws Exception {
        super((LayoutManager)new BorderLayout(), importInterface.getFiles());
        this.jbInit();
        this.openWorkbooks(this.filenames);
        this.sheetTable.setModel(new SheetModel(this.workbooks));
        if (this.sheetTable.getRowCount() > 0) {
            this.sheetTable.setRowSelectionInterval(0, 0);
        }
    }

    @Override
    public boolean canFinish() {
        return false;
    }

    public void closeWorkBooks() {
        for (Workbook workbook : this.workbooks) {
            this.closeWorkBook(workbook);
        }
        this.workbooks = null;
    }

    public CellIdentifier getCellIdentifier() {
        return null;
    }

    @Override
    public CellIdentifierModel getTableModel(ProgressManager progressManager, boolean bl) {
        Sheet sheet = ((SheetModel)this.sheetTable.getModel()).getSelectedSheet();
        final FormulaEvaluator formulaEvaluator = sheet.getWorkbook().getCreationHelper().createFormulaEvaluator();
        return new CellIdentifierModel(this, this.getNumberOfRows(sheet), this.getNumberOfColumns(sheet)){
            private Sheet currentSheet;
            final /* synthetic */ XlsImportPanel this$0;
            {
                this.this$0 = xlsImportPanel;
                super(n, n2);
                this.currentSheet = ((SheetModel)this.this$0.sheetTable.getModel()).getSelectedSheet();
            }

            @Override
            public final FastDecimal getDoubleAt_Transpose(int n, int n2, FastDecimal fastDecimal) {
                Cell cell;
                Row row = this.currentSheet.getRow(n);
                if (row != null && (cell = row.getCell(n2)) != null) {
                    int n3 = cell.getCellType();
                    if (n3 == 0) {
                        return fastDecimal.setValue(cell.getNumericCellValue());
                    }
                    String string = this.getCellValue(cell);
                    return fastDecimal.parseString(string);
                }
                return fastDecimal.error();
            }

            @Override
            public int getLayerCount() {
                return ((SheetModel)this.this$0.sheetTable.getModel()).getSelectedSheets().length;
            }

            @Override
            public String getLayerName(int n) {
                return ((SheetModel)this.this$0.sheetTable.getModel()).getSelectedSheets()[n].getSheetName();
            }

            @Override
            public File getRootFolder() {
                if (this.this$0.filenames != null && this.this$0.filenames.length > 0) {
                    return this.this$0.filenames[0].getParentFile();
                }
                return null;
            }

            @Override
            public final Object getValueAt_Transpose(int n, int n2) {
                Cell cell;
                Row row = this.currentSheet.getRow(n);
                if (row != null && (cell = row.getCell(n2)) != null) {
                    return this.getCellValue(cell);
                }
                return "";
            }

            @Override
            public void setCurrentLayer(int n) {
                this.currentSheet = ((SheetModel)this.this$0.sheetTable.getModel()).getSelectedSheets()[n];
            }

            private String getCellValue(Cell cell) {
                int n = cell.getCellType();
                if (n == 0) {
                    return this.formatNumber(cell);
                }
                if (n == 2) {
                    try {
                        CellValue cellValue = formulaEvaluator.evaluate(cell);
                        switch (cellValue.getCellType()) {
                            case 4: {
                                return String.valueOf(cellValue.getBooleanValue());
                            }
                            case 0: {
                                return String.valueOf(cellValue.getNumberValue());
                            }
                            case 1: {
                                return cellValue.getStringValue();
                            }
                            case 5: {
                                return "Error: " + cellValue.getErrorValue();
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return cell.getCellFormula();
                }
                try {
                    return cell.getStringCellValue();
                }
                catch (Exception exception) {
                    return "Error Cell";
                }
            }

            private String formatNumber(Cell cell) {
                String string = String.valueOf(cell.getNumericCellValue());
                if (string.endsWith(".0")) {
                    return string.substring(0, string.length() - 2);
                }
                return string;
            }
        };
    }

    @Override
    public String getType() {
        return "Excel";
    }

    @Override
    public boolean hasSettings() {
        return true;
    }

    @Override
    protected void cleanUpChild() {
        this.bufMap.clear();
        this.closeWorkBooks();
        this.sheetTable.setModel(new SheetModel(null));
    }

    protected boolean preLoadData() {
        return false;
    }

    private void closeWorkBook(Workbook workbook) {
        if (workbook != null) {
            // empty if block
        }
    }

    private int getNumberOfColumns(Sheet sheet) {
        int n = this.getNumberOfRows(sheet);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = this.getNumberOfColumns(sheet, i);
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    private int getNumberOfColumns(Sheet sheet, int n) {
        Row row = sheet.getRow(n);
        if (row != null) {
            return row.getLastCellNum();
        }
        return 0;
    }

    private int getNumberOfRows(Sheet sheet) {
        int n = sheet.getLastRowNum() + 1;
        if (n > 1 || this.getNumberOfColumns(sheet, 0) > 0) {
            return n;
        }
        return 0;
    }

    private void jbInit() {
        this.sheetTable.getSelectionModel().addListSelectionListener(listSelectionEvent -> {
            this.ciModel = null;
        });
        JLabel jLabel = new JLabel(this.filenames.length > 1 ? "File Names:" : "File Name:");
        jLabel.setFont(new Font("SansSerif", 1, 12));
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel2 = new JLabel("Select Sheet");
        jLabel2.setFont(new Font("SansSerif", 1, 12));
        jPanel.setBorder(null);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 12, 0, 0), 0, 0));
        StringBuilder stringBuilder = new StringBuilder(this.filenames[0].getName());
        for (int i = 1; i < this.filenames.length; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(this.filenames[i].getName());
        }
        jPanel.add((Component)new JLabel(stringBuilder.toString()), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 18, 0, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        jPanel.add((Component)new JScrollPane(this.sheetTable), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 13, 1, new Insets(6, 18, 12, 12), 0, 0));
    }

    private void openWorkbook(int n, File file) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.workbooks[n] = WorkbookFactory.create((InputStream)fileInputStream);
    }

    private void openWorkbooks(File[] fileArray) throws Exception {
        this.workbooks = new Workbook[this.filenames.length];
        for (int i = 0; i < this.workbooks.length; ++i) {
            this.openWorkbook(i, fileArray[i]);
        }
    }

    private class SheetModel
    extends DefaultTableModel {
        private final Workbook[] workbookRef;

        public SheetModel(Workbook[] workbookArray) {
            this.workbookRef = workbookArray;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int n) {
            return switch (n) {
                case 0 -> "Name";
                case 1 -> "Rows";
                case 2 -> "Columns";
                default -> "";
            };
        }

        @Override
        public int getRowCount() {
            if (this.workbookRef == null) {
                return 0;
            }
            int n = 0;
            for (Workbook workbook : this.workbookRef) {
                if (workbook == null) continue;
                n += workbook.getNumberOfSheets();
            }
            return n;
        }

        public Sheet getSelectedSheet() {
            return this.getSheetAt(XlsImportPanel.this.sheetTable.getSelectedRow());
        }

        public Sheet[] getSelectedSheets() {
            int[] nArray = XlsImportPanel.this.sheetTable.getSelectedRows();
            Sheet[] sheetArray = new Sheet[nArray.length];
            for (int i = 0; i < sheetArray.length; ++i) {
                sheetArray[i] = this.getSheetAt(nArray[i]);
            }
            return sheetArray;
        }

        public Sheet getSheetAt(int n) {
            Sheet sheet = this.getBufferedSheet(n);
            if (sheet != null) {
                return sheet;
            }
            int n2 = 0;
            for (Workbook workbook : this.workbookRef) {
                if (workbook == null) continue;
                int n3 = workbook.getNumberOfSheets();
                if (n - n2 < n3) {
                    sheet = workbook.getSheetAt(n - n2);
                    this.putBufferedSheet(n, sheet);
                    return sheet;
                }
                n2 += n3;
            }
            return null;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Sheet sheet = this.getSheetAt(n);
            return switch (n2) {
                case 0 -> {
                    if (this.workbookRef.length == 1) {
                        yield sheet.getSheetName();
                    }
                    yield XlsImportPanel.this.filenames[this.getWorkbookIndex(n)].getName() + ": " + sheet.getSheetName();
                }
                case 1 -> String.valueOf(XlsImportPanel.this.getNumberOfRows(sheet));
                case 2 -> String.valueOf(XlsImportPanel.this.getNumberOfColumns(sheet));
                default -> "";
            };
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        private Sheet getBufferedSheet(int n) {
            if (!XlsImportPanel.this.bufMap.containsKey(n)) {
                return null;
            }
            return XlsImportPanel.this.bufMap.get(n);
        }

        private int getWorkbookIndex(int n) {
            int n2 = 0;
            for (int i = 0; i < this.workbookRef.length; ++i) {
                if (this.workbookRef[i] == null) continue;
                int n3 = this.workbookRef[i].getNumberOfSheets();
                if (n - n2 < n3) {
                    return i;
                }
                n2 += n3;
            }
            return 0;
        }

        private void putBufferedSheet(int n, Sheet sheet) {
            XlsImportPanel.this.bufMap.put(n, sheet);
        }
    }
}

