/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.geom.GeneralPath;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import no.uib.cipr.matrix.Matrix;
import se.prediktera.map.common.CMenu;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.Threader;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.common.propagation.PropagationDataNode;
import se.prediktera.map.components.paint.AbstractPaint;
import se.prediktera.map.data.datasettable.NewDataSetTableInfo;
import se.prediktera.map.dataimport.AbstractDataSource;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.dataimport.ImportHelper;
import se.prediktera.map.dataimport.ImportWizard;
import se.prediktera.map.dataimport.merge.MergeWizard;
import se.prediktera.map.dataimport.merge.OriginalDataSource;
import se.prediktera.map.datasetcontainer.BasicTreeInterface;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.datainfo.DataGroupValues;
import se.prediktera.map.datasetcontainer.datainfo.DataInfoEvent;
import se.prediktera.map.datasetcontainer.datainfo.IncExclude;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnImageResource;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnShort;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnString;
import se.prediktera.map.datasetcontainer.datainfo.VariablesInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.AbstractMVmatrix;
import se.prediktera.map.datasetcontainer.matrix.DataSourceMatrix;
import se.prediktera.map.datasetcontainer.matrix.LayerMatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.datasetcontainer.transform.category.Category;
import se.prediktera.map.main.Data_GUI;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.StatusBar;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.model.ModelWrapper;
import se.prediktera.map.register.RegisterKeyManager;
import se.prediktera.map.simpletableeditor.CellIdentifier;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class Case
extends PropagationDataNode
implements Cloneable,
CellIdentifier {
    public static final byte IMPORT_CASE = 0;
    public static final byte EXTERNAL_CASE = 1;
    public static final byte MODEL_CASE = 2;
    public static final int OBSERVATIONS = 0;
    public static final int VARIABLES = 1;
    public static final int LAYERS = 2;
    public static final byte NONE = 0;
    public static final byte ABSORBANCE = 1;
    public static final byte REFLECTANCE = 2;
    public static final byte SOURCE_IN_PROJECT = 0;
    public static final byte SOURCE_ON_DISK = 1;
    private static ImageIcon icon = AbstractPaint.createIcon(0);
    private static ImageIcon iconExternal = AbstractPaint.createIcon(16);
    private static ImageIcon iconModel = AbstractPaint.createIcon(18);
    private DataSet originalDataSet = null;
    private AbstractDataMatrix originalMatrix = null;
    private DataContainer dsContainer;
    public DataContainer subModels;
    private AbstractDataSource model;
    private DataContainer addedData = null;
    private byte case_type = 0;
    private byte calibrationType = 0;
    private boolean calibrationCap = false;
    private double cellWidth = 1.0;
    private double cellHeight = 1.0;
    private double cellArea = 1.0;
    private String cellUnit = "px";
    private int reduce = 1;
    private boolean[] includedArray = null;
    private Properties envProperties;
    private Properties metaProperties;
    private Properties refProperties;
    private byte sourcePosition = 0;
    private AbstractDataSource linkedDataSource;
    private String convertTo;

    public static int[] createIndex(int[] nArray, int n) {
        return Case.createIndex(nArray, n, 0);
    }

    public static int[] createIndex(int[] nArray, int n, int n2) {
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = new int[n + 1];
        int n3 = n2;
        for (int i = 0; i < n; ++i) {
            if (n3 < nArray.length && i == nArray[n3]) {
                nArray2[i] = -1;
                ++n3;
                continue;
            }
            nArray2[i] = n3 - n2;
        }
        nArray2[nArray2.length - 1] = n3 - n2;
        return nArray2;
    }

    private static boolean addLayerMatrix(AbstractDataMatrix abstractDataMatrix, AbstractDataMatrix abstractDataMatrix2, String string) {
        if (abstractDataMatrix instanceof LayerMatrix) {
            LayerMatrix layerMatrix = (LayerMatrix)abstractDataMatrix;
            layerMatrix.addMatrix(abstractDataMatrix2);
            abstractDataMatrix2.setFoldN(layerMatrix.getFoldN());
            abstractDataMatrix2.setName(string);
            return true;
        }
        return false;
    }

    public Case(int n, int n2) {
        super("N/A", true);
        this.createObsVar(n, n2);
    }

    public Case(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        try {
            AbstractDataInfo abstractDataInfo;
            this.subModels = (DataContainer)mapProperty.resolveNodeFromName(randomInputStream, "models");
            this.originalDataSet = (DataSet)mapProperty.resolveNodeFromName(randomInputStream, "oDataSet");
            this.originalMatrix = (AbstractDataMatrix)mapProperty.resolveNodeFromName(randomInputStream, "oMatrix");
            if (this.originalMatrix instanceof LayerMatrix && (abstractDataInfo = this.originalDataSet.getDataInfo(0)).getRowCount() != this.originalMatrix.getN()) {
                abstractDataInfo.setRowCount(this.originalMatrix.getN());
            }
            this.dsContainer = (DataContainer)mapProperty.resolveNodeFromName(randomInputStream, "dsC");
            this.model = (AbstractDataSource)mapProperty.resolveNodeFromName(randomInputStream, "model");
            this.addedData = (DataContainer)mapProperty.resolveNodeFromName(randomInputStream, "addedData");
            this.case_type = mapProperty.getPropertyByte("case_type");
            if (mapProperty.hasProperty("ext") & mapProperty.getPropertyBoolean("ext", false)) {
                this.case_type = 1;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            JOptionPane.showConfirmDialog(IniManager.getMainFrame(), outOfMemoryError.toString(), "Memory Error", -1, 0, null);
        }
        this.calibrationType = mapProperty.getPropertyByte("calibrationType", (byte)0);
        this.calibrationCap = mapProperty.getPropertyBoolean("calibrationCap", true);
        this.cellWidth = mapProperty.getPropertyDouble("cellwidth", 1.0);
        this.cellHeight = mapProperty.getPropertyDouble("cellheight", 1.0);
        this.cellArea = mapProperty.getPropertyDouble("cellarea", 1.0);
        this.cellUnit = mapProperty.getPropertyStringUTF("cellunit", "px");
        this.includedArray = mapProperty.getPropertyBooleanArray("incArray");
        this.envProperties = mapProperty.getProperty("envProp");
        this.metaProperties = mapProperty.getProperty("metaProp");
        this.refProperties = mapProperty.getProperty("refProp");
        this.sourcePosition = mapProperty.getPropertyByte("sourceP");
    }

    public void addData(DataTreeInterface dataTreeInterface) {
        if (this.addedData == null) {
            this.createAddedData();
        }
        this.addedData.addTreeNode(dataTreeInterface);
    }

    public void addDataSet(DataSet dataSet) {
        this.dsContainer.addTreeNode(dataSet);
    }

    public void addSubModel(ModelWrapper modelWrapper) {
        if (this.subModels == null) {
            this.subModels = new DataContainer("Submodels", -1);
            this.addTreeNode(this.subModels);
        }
        this.subModels.addTreeNode(modelWrapper);
    }

    @Override
    public boolean addToPopup(final Project_GUI project_GUI, DataTreeInterface dataTreeInterface, Point point, JPopupMenu jPopupMenu, boolean bl) {
        if (this.case_type == 0) {
            jPopupMenu.add(new CMenuItem(this, "Import New Data", true){
                final /* synthetic */ Case this$0;
                {
                    this.this$0 = case_;
                    super(string, bl);
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ImportHelper.importData(project_GUI, this.this$0, null);
                }
            });
            jPopupMenu.add(new CMenuItem(this, "Purge Case", true){
                final /* synthetic */ Case this$0;
                {
                    this.this$0 = case_;
                    super(string, bl);
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = JOptionPane.showConfirmDialog(Main_GUI.get(), "This will purge all data from this case.\nDo you want to continue?", "Really purge case?", 2);
                    if (n == 0) {
                        this.this$0.purge();
                        if (project_GUI != null) {
                            project_GUI.purgeSignal();
                        }
                    }
                }
            });
            if (RegisterKeyManager.isPredikteraDevelopmentLicense()) {
                jPopupMenu.add(new CMenuItem(this, "Merge With External Data", true){
                    final /* synthetic */ Case this$0;
                    {
                        this.this$0 = case_;
                        super(string, bl);
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        OriginalDataSource originalDataSource = new OriginalDataSource(this.this$0.originalMatrix);
                        MergeWizard mergeWizard = new MergeWizard(project_GUI, originalDataSource);
                        if (mergeWizard.executeWizard() == 1) {
                            ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(this){

                                @Override
                                public Object doWork() {
                                    return null;
                                }
                            };
                            progressManagerImpl.invokeNow();
                        }
                    }
                });
            }
            CMenu cMenu = new CMenu("Add new data from file", true);
            jPopupMenu.add(cMenu);
            cMenu.add(new CMenuItem(this, "Observations", true){
                final /* synthetic */ Case this$0;
                {
                    this.this$0 = case_;
                    super(string, bl);
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.addDataFromFile(project_GUI, false);
                }
            });
            cMenu.add(new CMenuItem(this, "Variables", true){
                final /* synthetic */ Case this$0;
                {
                    this.this$0 = case_;
                    super(string, bl);
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.addDataFromFile(project_GUI, true);
                }
            });
            if (RegisterKeyManager.isPredikteraDevelopmentLicense()) {
                jPopupMenu.add(new CMenuItem("Remove data", true){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Case.this.deleteData(new int[]{5, 10, 15}, new int[]{2, 3, 4});
                    }
                });
            }
            jPopupMenu.add(new CMenuItem(this, "New DataSet", AbstractPaint.createIcon(1)){
                final /* synthetic */ Case this$0;
                {
                    this.this$0 = case_;
                    super(string, imageIcon);
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NewDataSetTableInfo newDataSetTableInfo = new NewDataSetTableInfo();
                    Data_GUI data_GUI = project_GUI.getData_GUI();
                    data_GUI.createWindowFromWizard(this.this$0.getOriginalMatrix(), newDataSetTableInfo);
                }
            });
        } else {
            jPopupMenu.add(new CMenuItem(this, "Delete", new ImageIcon(Main_GUI.class.getResource("gif/delete.png"))){
                final /* synthetic */ Case this$0;
                {
                    this.this$0 = case_;
                    super(string, imageIcon);
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = JOptionPane.showConfirmDialog(IniManager.getMainFrame(), "Really delete \"" + String.valueOf(this.this$0) + "\"?", "Really delete?", 2);
                    if (n == 0) {
                        this.this$0.cleanUp();
                        if (project_GUI != null) {
                            project_GUI.purgeSignal();
                        }
                    }
                }
            });
        }
        return true;
    }

    public void changeState(ProgressManager progressManager, String string, Properties properties) {
        if (string.equalsIgnoreCase("keepdataondisk")) {
            this.originalMatrix.addMemoryState((byte)2);
        } else if (string.equalsIgnoreCase("keepdatainmemory")) {
            this.loadFromDataSource(progressManager);
        } else {
            throw new RuntimeException("State is not supported: " + string);
        }
        Project_GUI project_GUI = this.getProject_GUI();
        if (project_GUI != null) {
            project_GUI.setProjectChanged();
        }
    }

    public AbstractDataMatrix createData(CellIdentifierModel cellIdentifierModel, ProgressManager progressManager) {
        int n;
        int n2;
        Object object;
        AbstractDataMatrix abstractDataMatrix = null;
        if (cellIdentifierModel.isMultiLayer()) {
            object = cellIdentifierModel.getDefaultBand();
            if (object == null) {
                object = new int[Math.min(cellIdentifierModel.getLayerCount(), 3)];
                for (n2 = 0; n2 < ((int[])object).length; ++n2) {
                    if (cellIdentifierModel.getLayerCount() > 10) {
                        n = cellIdentifierModel.getLayerCount() / 4;
                        object[n2] = n * n2 + n;
                        continue;
                    }
                    object[n2] = n2;
                }
            }
            abstractDataMatrix = new LayerMatrix((int[])object);
        }
        if (cellIdentifierModel.isDataSourceMatrix()) {
            for (int i = 0; i < cellIdentifierModel.getLayerCount(); ++i) {
                DataSourceMatrix dataSourceMatrix;
                if (!cellIdentifierModel.isLayerTypeData(i) || Case.addLayerMatrix(abstractDataMatrix, dataSourceMatrix = new DataSourceMatrix(cellIdentifierModel, i), cellIdentifierModel.getLayerName(i))) continue;
                abstractDataMatrix = dataSourceMatrix;
            }
        } else {
            object = cellIdentifierModel.getMatrixInfo();
            n2 = cellIdentifierModel.getLayerCount();
            for (n = 0; n < n2; ++n) {
                AbstractDataMatrix abstractDataMatrix2;
                if (!cellIdentifierModel.isLayerTypeData(n) || Case.addLayerMatrix(abstractDataMatrix, abstractDataMatrix2 = cellIdentifierModel.createSuitableMatrix((int)object[0][0], (int)object[1][0]), cellIdentifierModel.getLayerName(n))) continue;
                abstractDataMatrix = abstractDataMatrix2;
            }
            this.loadDataFromModel(progressManager, cellIdentifierModel, abstractDataMatrix);
        }
        if (abstractDataMatrix instanceof LayerMatrix) {
            ((AbstractDataMatrix)abstractDataMatrix).setLayerMinMax();
        }
        abstractDataMatrix.setName(cellIdentifierModel.dataSetName);
        return abstractDataMatrix;
    }

    public DataSet createDataSet() {
        DataSet dataSet = this.createDataSet(null, false);
        dataSet.setCreated(null, false);
        return dataSet;
    }

    public DataSet createDataSet(boolean bl) {
        return this.createDataSet(null, bl);
    }

    public DataSet createDataSet(ProgressManager progressManager, boolean bl) {
        return this.createDataSet(progressManager, IniManager.getMainFrame(), bl);
    }

    public DataSet createDataSet(ProgressManager progressManager, Component component, boolean bl) {
        return this.originalDataSet.cloneDataSet(progressManager, component, bl);
    }

    public void createObsVar(int n, int n2) {
        this.purge();
        try {
            DataSet dataSet = new DataSet(this, n, n2);
            dataSet.setName("Original DataSet");
            dataSet.setVisibleInTree(false);
            this.replaceNode(this.originalDataSet, dataSet, false);
            this.originalDataSet = dataSet;
            DataContainer dataContainer = new DataContainer("DataSets", 0);
            this.replaceNode(this.dsContainer, dataContainer, true);
            this.dsContainer = dataContainer;
            this.createAddedData();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            JOptionPane.showConfirmDialog(IniManager.getMainFrame(), outOfMemoryError.toString(), "Memory Error", -1, 0, null);
        }
    }

    public AbstractDataMatrix createOriginalMatrix(double[][] dArray, int n, int n2) {
        MVmatrix mVmatrix = dArray == null ? new MVmatrix(n, n2) : new MVmatrix(dArray, n, n2);
        mVmatrix.setName("OriginalMatrix");
        mVmatrix.setProtected(false);
        this.setOriginalMatrix(mVmatrix);
        return this.originalMatrix;
    }

    public AbstractDataMatrix createOriginalMatrix(int n, int n2) {
        return this.createOriginalMatrix(null, n, n2);
    }

    public void deleteData(int[] nArray, int[] nArray2) {
        AbstractDataMatrix abstractDataMatrix = this.getOriginalMatrix();
        int[] nArray3 = Case.createIndex(nArray, abstractDataMatrix.getN());
        int[] nArray4 = Case.createIndex(nArray2, abstractDataMatrix.getK());
        try {
            this.getOriginalMatrix().deleteData(nArray3, nArray4);
            this.originalDataSet.removeIndex(nArray3, nArray4, true);
            for (int i = 0; i < this.dsContainer.getTreeNodeCount(); ++i) {
                DataSet dataSet = (DataSet)this.dsContainer.getTreeNodeAt(i);
                dataSet.removeIndex(nArray3, nArray4, false);
            }
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    public DataContainer getAddedData() {
        return this.addedData;
    }

    public String getArea(double d) {
        return this.getSIunit(d, this.cellArea, this.cellUnit, true);
    }

    public String getArea(double d, double d2, String string) {
        return this.getSIunit(d, d2, string, true);
    }

    public boolean getCalibrationCap() {
        return this.calibrationCap;
    }

    public byte getCalibrationType() {
        return this.calibrationType;
    }

    public double getCellArea() {
        return this.cellArea;
    }

    public String getCellUnit() {
        return this.cellUnit;
    }

    public int getReduce() {
        return this.reduce;
    }

    public DataGroupValues getDataGroup(int n, int n2) {
        AbstractDataInfo[] abstractDataInfoArray = this.getDataInfo();
        if (abstractDataInfoArray != null && abstractDataInfoArray[n] != null) {
            return abstractDataInfoArray[n].getGroupColumnByType(n2);
        }
        return null;
    }

    public AbstractDataInfo[] getDataInfo() {
        if (this.originalDataSet != null) {
            return this.originalDataSet.getDataInfo();
        }
        return null;
    }

    public AbstractDataInfo getDataInfo(int n) {
        AbstractDataInfo[] abstractDataInfoArray = this.getDataInfo();
        if (abstractDataInfoArray != null) {
            return abstractDataInfoArray[n];
        }
        return null;
    }

    public AbstractDataSource getDataSource() {
        return this.model;
    }

    public String getDistanceX(double d) {
        return this.getSIunit(d, this.cellWidth, this.cellUnit, false);
    }

    public String getDistanceX(double d, double d2, String string) {
        return this.getSIunit(d, d2, string, false);
    }

    public String getDistanceY(double d) {
        return this.getSIunit(d, this.cellHeight, this.cellUnit, false);
    }

    public String getDistanceY(double d, double d2, String string) {
        return this.getSIunit(d, d2, string, false);
    }

    public DataContainer getDsContainer() {
        return this.dsContainer;
    }

    public Properties getEnvProperties() {
        return this.envProperties;
    }

    @Override
    public ImageIcon getIcon(byte by) {
        return switch (this.case_type) {
            case 0 -> icon;
            case 1 -> iconExternal;
            case 2 -> iconModel;
            default -> icon;
        };
    }

    public boolean[] getIncludedArray() {
        return this.includedArray;
    }

    @Override
    public String getInformation() {
        StringBuilder stringBuilder = new StringBuilder("<HTML><BODY>");
        stringBuilder.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
        stringBuilder.append("<TR><TD>Type:</TD><TD>");
        switch (this.case_type) {
            case 0: {
                stringBuilder.append("Normal");
                break;
            }
            case 1: {
                stringBuilder.append("Prediction");
                break;
            }
            case 2: {
                stringBuilder.append("Model");
            }
        }
        stringBuilder.append("</TD></TR>");
        stringBuilder.append("<TR><TD>Original Data:</TD><TD>");
        stringBuilder.append(this.originalMatrix == null ? "N/A" : this.originalMatrix.toString());
        stringBuilder.append("</TD></TR>");
        stringBuilder.append("<TR><TD>DataSets:</TD><TD>");
        stringBuilder.append(this.dsContainer == null ? 0 : this.dsContainer.size());
        stringBuilder.append("</TD></TR>");
        if (this.isDataSource()) {
            stringBuilder.append("<TR><TD>Comment:</TD><TD>Has DataSource</TD></TR>");
        }
        stringBuilder.append("</TABLE></BODY></HTML>");
        return stringBuilder.toString();
    }

    public Properties getMetaProperties() {
        return this.metaProperties;
    }

    public int getNrOfSubModels() {
        if (this.subModels == null) {
            return 0;
        }
        return this.subModels.getTreeNodeCount();
    }

    public DataSet getOriginalDataSet() {
        return this.originalDataSet;
    }

    public AbstractDataMatrix getOriginalMatrix() {
        return this.originalMatrix;
    }

    public String getOriginalName() {
        if (this.originalMatrix != null) {
            return this.originalMatrix.toString();
        }
        if (this.name.length() > 0) {
            return this.name;
        }
        return null;
    }

    public Properties getRefProperties() {
        return this.refProperties;
    }

    @Override
    public String getScript() {
        return null;
    }

    @Override
    public String getScriptName() {
        return "";
    }

    public String getSIunit(double d, double d2, String string, boolean bl) {
        if (d2 > 0.0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(NiceDataFormat.toString(d * d2));
            if (string != null) {
                stringBuilder.append(" ");
                stringBuilder.append(string);
                if (bl) {
                    stringBuilder.append("^2");
                }
            }
            return stringBuilder.toString();
        }
        return NiceDataFormat.toString(d);
    }

    public ModelWrapper getSubModelAt(int n) {
        return (ModelWrapper)this.subModels.getTreeNodeAt(n);
    }

    @Override
    public byte getTreeType() {
        return 0;
    }

    @Override
    public byte getType() {
        return -2;
    }

    public String getUniqueAddedDataName(String string) {
        if (this.addedData != null) {
            return this.addedData.getUniqueName(string);
        }
        return string;
    }

    public boolean hasData() {
        return this.originalMatrix != null;
    }

    public DataSet importCaseFromMatrix(AbstractDataMatrix abstractDataMatrix, Project_GUI project_GUI, ProgressManager progressManager, int n) {
        BasicTreeInterface basicTreeInterface;
        this.reduce = n;
        this.createObsVar(abstractDataMatrix.getN(), abstractDataMatrix.getK());
        AbstractDataInfo abstractDataInfo = this.getDataInfo(0);
        DataGroupValues dataGroupValues = this.getDataGroup(0, 0);
        DataGroupValues dataGroupValues2 = this.getDataGroup(1, 0);
        if (dataGroupValues.getColumnCount() == 0) {
            dataGroupValues.addColumn("ObsID 1");
        }
        if (dataGroupValues2.getColumnCount() == 0) {
            basicTreeInterface = (InnerColumnString)dataGroupValues2.addColumn("VarID 1");
            if (abstractDataMatrix instanceof LayerMatrix) {
                LayerMatrix layerMatrix = (LayerMatrix)abstractDataMatrix;
                for (int i = 0; i < layerMatrix.getMatrixCount(); ++i) {
                    ((AbstractInnerColumn)basicTreeInterface).setValue(i, layerMatrix.getMatrixAt(i).getName());
                }
            }
        }
        this.setOriginalMatrix(abstractDataMatrix);
        basicTreeInterface = this.createDataSet(progressManager, false);
        ((DataSet)basicTreeInterface).setCreated(project_GUI, false);
        abstractDataInfo.setRowCount(((DataSet)basicTreeInterface).getDataInfo(0).getRowCount());
        return basicTreeInterface;
    }

    public boolean importCaseFromModel(CellIdentifierModel cellIdentifierModel, Project_GUI project_GUI, ProgressManager progressManager, Properties properties) {
        int n;
        if (this.hasData()) {
            progressManager.Finish();
            n = JOptionPane.showConfirmDialog(IniManager.getMainFrame(), "This Case has already loaded an original matrix\nDo you want to purge the current case and continue?", "Purge current case?", 0, 3, null);
            if (n != 0) {
                return false;
            }
            this.purge();
        }
        cellIdentifierModel.init(progressManager);
        cellIdentifierModel.setExclusionByResolution();
        n = cellIdentifierModel.analyzeObs();
        int n2 = cellIdentifierModel.analyzeVar();
        int n3 = cellIdentifierModel.analyzeLayer() + cellIdentifierModel.getReferenceValues();
        if (n == 0 && n2 == 0 && ScriptHelper.getPropertyBool(properties, "checkemptydata", true)) {
            progressManager.Finish();
            Main_GUI.setStatusMessage(StatusBar.MessageType.ERROR, "File did not contain any data. Please import again and redo the data identification or select another file", 20);
            return false;
        }
        progressManager.setMaximumAndReset(n + n2 + n * n2 * n3);
        progressManager.setInfoText("Copying data from file into project");
        try {
            BasicTreeInterface basicTreeInterface;
            Object object;
            if (cellIdentifierModel.isMultiLayer()) {
                this.createObsVar(n * n2, n3);
            } else {
                this.createObsVar(n, n2);
            }
            if (cellIdentifierModel instanceof AbstractDataSource) {
                this.model = (AbstractDataSource)cellIdentifierModel;
                this.addTreeNode(this.model);
                this.model.reCalcRef();
                this.model.setCase(this);
            }
            this.includedArray = cellIdentifierModel.createIncludedArray();
            AbstractDataMatrix abstractDataMatrix = this.createData(cellIdentifierModel, progressManager);
            this.setOriginalMatrix(abstractDataMatrix);
            this.originalDataSet.setName("DataSet (" + cellIdentifierModel.dataSetName + ")");
            DataGroupValues dataGroupValues = this.getDataGroup(0, 0);
            DataGroupValues dataGroupValues2 = this.getDataGroup(1, 0);
            int n4 = cellIdentifierModel.getPrimaryCol();
            int n5 = cellIdentifierModel.getPrimaryRow();
            AbstractDataInfo abstractDataInfo = this.getDataInfo(0);
            AbstractDataInfo abstractDataInfo2 = this.getDataInfo(1);
            abstractDataInfo.createDataFromModel(cellIdentifierModel, progressManager, n5, n4);
            abstractDataInfo2.createDataFromModel(cellIdentifierModel, progressManager, n5, n4);
            if (dataGroupValues.getColumnCount() == 0) {
                dataGroupValues.addColumn("ObsID 1");
            }
            if (dataGroupValues2.getColumnCount() == 0) {
                dataGroupValues2.addColumn("VarID 1");
                if (cellIdentifierModel.isMultiLayer()) {
                    int n6;
                    abstractDataInfo2.setRowCount(cellIdentifierModel.getLayerCount() + cellIdentifierModel.getReferenceValues());
                    int n7 = 0;
                    for (n6 = 0; n6 < cellIdentifierModel.getLayerCount(); ++n6) {
                        if (!cellIdentifierModel.isLayerTypeData(n6)) continue;
                        object = cellIdentifierModel.getLayerName(n6);
                        dataGroupValues2.setValue(n7, 0, (String)object);
                        ++n7;
                    }
                    for (n6 = 0; n6 < cellIdentifierModel.getReferenceValues(); ++n6) {
                        object = cellIdentifierModel.getReferenceName(n6);
                        if (object == null) continue;
                        dataGroupValues2.setValue(n7, 0, (String)object);
                        ++n7;
                    }
                }
            }
            DataSet dataSet = this.createDataSet(progressManager, false);
            dataSet.setCreated(project_GUI, false);
            abstractDataInfo.setRowCount(dataSet.getDataInfo(0).getRowCount());
            this.envProperties = cellIdentifierModel.getEnvProperties();
            this.metaProperties = cellIdentifierModel.getMetaProperties();
            this.refProperties = cellIdentifierModel.getRefProperties();
            if (this.metaProperties != null) {
                project_GUI.getProperties().addProperties(this.metaProperties);
            }
            if (cellIdentifierModel.isMultiLayer() && cellIdentifierModel.getLayerCount() > 1 && IniManager.showWindow((byte)3, true)) {
                ArrayList arrayList = new ArrayList();
                object = dataSet.getObsDataInfo();
                basicTreeInterface = (IncExclude)((AbstractDataInfo)object).getGroupColumnByType(1);
                InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)((DataGroupValues)basicTreeInterface).getPrimaryColumn();
                int n8 = cellIdentifierModel.getMaskLayer();
                if (ScriptHelper.hasKey(properties, "masklayer")) {
                    n8 = ScriptHelper.getPropertyInt(properties, "masklayer");
                }
                int n9 = cellIdentifierModel.getMaskSampleId();
                if (ScriptHelper.hasKey(properties, "masksampleid")) {
                    n9 = ScriptHelper.getPropertyInt(properties, "masksampleid");
                }
                this.originalMatrix.beginCalculations();
                int n10 = this.originalMatrix.getK() - cellIdentifierModel.getReferenceValues();
                for (int i = 0; i < this.originalMatrix.getN(); ++i) {
                    int n11;
                    boolean bl = false;
                    if (arrayList.size() > 0) {
                        n11 = i / this.originalMatrix.getFoldN();
                        int n12 = i % this.originalMatrix.getFoldN();
                        boolean bl2 = false;
                        for (GeneralPath generalPath : arrayList) {
                            if (!generalPath.contains(n11, n12)) continue;
                            bl2 = true;
                            break;
                        }
                        if (!bl2) {
                            for (int j = 0; j < n10; ++j) {
                                this.originalMatrix.setValue(i, j, 0.0);
                            }
                            bl = true;
                        }
                    }
                    if (!bl) {
                        bl = true;
                        if (n8 >= 0) {
                            bl = this.originalMatrix.getValue(i, n8) != (double)n9;
                        } else {
                            for (n11 = 0; n11 < n10; ++n11) {
                                double d = this.originalMatrix.getValue(i, n11);
                                if (d == 0.0) continue;
                                bl = false;
                                break;
                            }
                        }
                    }
                    if (!bl) continue;
                    innerColumnBoolean.setValueBool(i, false);
                }
                if (n8 >= 0) {
                    VariablesInfo variablesInfo = dataSet.getVarDataInfo();
                    InnerColumnBoolean innerColumnBoolean2 = (InnerColumnBoolean)variablesInfo.getPrimaryColumnByType(1);
                    innerColumnBoolean2.setValueBool(n8, false);
                }
                this.originalMatrix.endCalculations();
                dataSet.updateReferences();
                this.originalDataSet.updateReferences();
            }
            VariablesInfo variablesInfo = dataSet.getVarDataInfo();
            object = (InnerColumnString)variablesInfo.getPrimaryColumnByType(0);
            basicTreeInterface = (InnerColumnBoolean)variablesInfo.getPrimaryColumnByType(1);
            for (int i = 0; i < ((AbstractInnerColumn)object).getSize(); ++i) {
                String string = ((InnerColumnString)object).getValueLocal(i);
                if (string == null || !string.equals("0")) continue;
                ((InnerColumnBoolean)basicTreeInterface).setValueBool(i, false);
            }
            dataSet.updateReferences();
            this.originalDataSet.updateReferences();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            JOptionPane.showConfirmDialog(progressManager.getWindow(), outOfMemoryError.getMessage(), "Input Memory Exception", -1, 0, null);
            return false;
        }
        catch (Exception exception) {
            ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
            return false;
        }
        return true;
    }

    public boolean isDataSource() {
        return this.model != null && this.model.isDataSource();
    }

    public boolean isExternal() {
        return this.case_type == 1;
    }

    public boolean isMultiLayer() {
        return this.originalMatrix instanceof LayerMatrix;
    }

    public Object[] listDataSet() {
        Object[] objectArray = new DataSet[this.dsContainer.getTreeNodeCount()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = (DataSet)this.dsContainer.getTreeNodeAt(i);
        }
        return objectArray;
    }

    public void loadFromDataSource(ProgressManager progressManager) {
        try {
            this.model.openConnections();
            progressManager.setInfoText("Loading data from file");
            this.loadDataFromModel(progressManager, this.model, this.originalMatrix);
            this.model.applyModifier(progressManager, this.originalMatrix);
            ImportHelper.replaceMissingWithMedian(progressManager, this.model, this.originalMatrix);
            this.originalMatrix.removeMemoryState((byte)2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public void purge() {
        super.purge();
        this.cleanUpChildLocal();
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyNode("models", this.subModels);
        randomOutputStream.writePropertyNode("oDataSet", this.originalDataSet);
        randomOutputStream.writePropertyNode("oMatrix", this.originalMatrix);
        randomOutputStream.writePropertyNode("dsC", this.dsContainer);
        randomOutputStream.writePropertyNode("model", this.model);
        randomOutputStream.writePropertyNode("addedData", this.addedData);
        randomOutputStream.writePropertyByte("case_type", this.case_type);
        randomOutputStream.writePropertyByte("calibrationType", this.calibrationType);
        randomOutputStream.writePropertyBoolean("calibrationCap", this.calibrationCap);
        randomOutputStream.writePropertyDouble("cellwidth", this.cellWidth);
        randomOutputStream.writePropertyDouble("cellheight", this.cellHeight);
        randomOutputStream.writePropertyDouble("cellarea", this.cellArea);
        randomOutputStream.writePropertyStringUTF("cellunit", this.cellUnit);
        randomOutputStream.writePropertyBooleanArray("incArray", this.includedArray);
        randomOutputStream.writeProperty("envProp", this.envProperties);
        randomOutputStream.writeProperty("metaProp", this.metaProperties);
        randomOutputStream.writeProperty("refProp", this.refProperties);
        randomOutputStream.writePropertyByte("sourceP", this.sourcePosition);
    }

    public void setCalibrationCap(boolean bl) {
        this.calibrationCap = bl;
    }

    public void setCalibrationType(byte by) {
        this.calibrationType = by;
    }

    public void setCellArea(double d) {
        this.cellArea = d;
    }

    public void setCellUnit(String string) {
        this.cellUnit = string;
    }

    public void setDsContainer(DataContainer dataContainer) {
        this.dsContainer = dataContainer;
    }

    public void setExternal() {
        this.case_type = 1;
        if (this.originalMatrix != null && this.dsContainer != null && !this.dsContainer.isEmpty()) {
            this.originalMatrix.setVisibleInTree(false);
            DataSet dataSet = (DataSet)this.dsContainer.getTreeNodeAt(0);
            dataSet.setVisibleInTree(false);
            AbstractDataMatrix abstractDataMatrix = dataSet.getMatrix(0);
            abstractDataMatrix.setName("Prediction data");
            this.addShortcut(abstractDataMatrix);
        }
    }

    public void setModel() {
        this.case_type = (byte)2;
    }

    public void setOriginalMatrix(AbstractDataMatrix abstractDataMatrix) {
        if (this.originalMatrix != abstractDataMatrix && this.originalDataSet != null) {
            this.replaceNode(this.originalMatrix, abstractDataMatrix);
            this.originalMatrix = abstractDataMatrix;
            this.originalMatrix.setMatrixDataSetContainer(this);
            this.originalDataSet.updateReferences();
        }
    }

    @Override
    public String toString() {
        String string = this.getOriginalName();
        if (string != null) {
            return "Case (" + string + ")";
        }
        return "Case";
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.cleanUpChildLocal();
    }

    @Override
    protected void doUpdateLocal(ProgressManager progressManager) {
    }

    @Override
    protected void setProtectedLocal(ProgressManager progressManager, boolean bl) {
    }

    private void addDataFromFile(Project_GUI project_GUI, final boolean bl) {
        CellIdentifierModel cellIdentifierModel;
        ImportWizard importWizard;
        int n;
        int n2;
        if (bl) {
            n2 = 0;
            n = 1;
        } else {
            n2 = 1;
            n = 0;
        }
        DataGroupValues dataGroupValues = this.getDataGroup(n2, 0);
        Object[] objectArray = new Object[dataGroupValues.getColumnCount()];
        for (int i = 0; i < dataGroupValues.getColumnCount(); ++i) {
            objectArray[i] = dataGroupValues.getColumn(i);
        }
        String string = bl ? "observation" : "variable";
        final InnerColumnString innerColumnString = (InnerColumnString)JOptionPane.showInputDialog(project_GUI, "Select " + string + " to map data from", "Select " + string, 3, null, objectArray, dataGroupValues.getPrimaryColumn());
        if (innerColumnString != null && (importWizard = new ImportWizard(project_GUI, null, true, false)).executeWizard(null) == 1 && (cellIdentifierModel = importWizard.getCellIdentifierModel()) != null) {
            ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(this){
                final /* synthetic */ Case this$0;
                {
                    this.this$0 = case_;
                }

                @Override
                public Object doWork() {
                    int n14;
                    Object object;
                    Object object2;
                    int n22;
                    int n3;
                    int n4;
                    int n5;
                    int n6;
                    int n7;
                    this.setInfoText("Adding new " + (bl ? "variables" : "observations"));
                    int n8 = cellIdentifierModel.getPrimaryCol();
                    int n9 = cellIdentifierModel.getPrimaryRow();
                    this.this$0.originalMatrix.beginUpdate();
                    if (bl) {
                        n7 = cellIdentifierModel.getRowCount();
                        n6 = cellIdentifierModel.getColumnCount();
                        n5 = this.this$0.originalMatrix.getN();
                        n4 = this.this$0.originalMatrix.getK();
                        n3 = cellIdentifierModel.analyzeVar();
                        this.this$0.originalMatrix.addData(0, n3);
                    } else {
                        n7 = cellIdentifierModel.getColumnCount();
                        n6 = cellIdentifierModel.getRowCount();
                        n5 = this.this$0.originalMatrix.getK();
                        n4 = this.this$0.originalMatrix.getN();
                        n3 = cellIdentifierModel.analyzeObs();
                        this.this$0.originalMatrix.addData(n3, 0);
                    }
                    for (n22 = 0; n22 < n5; ++n22) {
                        int n10;
                        object2 = innerColumnString.getValueLocal(n22);
                        boolean bl2 = false;
                        for (n10 = 0; n10 < n7; ++n10) {
                            if (!cellIdentifierModel.isTypeData(n2, n10)) continue;
                            object = bl ? String.valueOf(cellIdentifierModel.getValueAt(n10, n8)) : String.valueOf(cellIdentifierModel.getValueAt(n9, n10));
                            if (!((String)object2).equalsIgnoreCase((String)(object = NiceDataFormat.tryGetNiceString((String)object)))) continue;
                            bl2 = true;
                            n14 = n4;
                            for (int i = 0; i < n6; ++i) {
                                FastDecimal fastDecimal;
                                if (!cellIdentifierModel.isTypeData(n, i)) continue;
                                if (bl) {
                                    fastDecimal = cellIdentifierModel.getDoubleAt(n10, i);
                                    this.this$0.originalMatrix.setValue(n22, n14++, fastDecimal);
                                    continue;
                                }
                                fastDecimal = cellIdentifierModel.getDoubleAt(i, n10);
                                this.this$0.originalMatrix.setValue(n14++, n22, fastDecimal);
                            }
                        }
                        if (bl2) continue;
                        for (n10 = 0; n10 < n3; ++n10) {
                            if (bl) {
                                this.this$0.originalMatrix.setValue(n22, n4 + n10, 0.0, true);
                                continue;
                            }
                            this.this$0.originalMatrix.setValue(n4 + n10, n22, 0.0, true);
                        }
                    }
                    this.this$0.originalMatrix.endUpdate();
                    for (n22 = -1; n22 < this.this$0.dsContainer.getTreeNodeCount(); ++n22) {
                        object2 = n22 < 0 ? this.this$0.originalDataSet : this.this$0.dsContainer.getTreeNodeAt(n22);
                        if (!(object2 instanceof DataSet)) continue;
                        DataSet dataSet = (DataSet)object2;
                        AbstractDataInfo abstractDataInfo = bl ? dataSet.getVarDataInfo() : dataSet.getObsDataInfo();
                        object = cellIdentifierModel.getRootFolder();
                        for (n14 = 0; n14 < abstractDataInfo.getGroupSize(); ++n14) {
                            DataGroupValues dataGroupValues = abstractDataInfo.getGroupColumnByIndex(n14);
                            for (int i = 0; i < dataGroupValues.getColumnCount(); ++i) {
                                Object icType = dataGroupValues.getColumn(i);
                                if (icType == null) continue;
                                String string = ((AbstractInnerColumn)icType).toString();
                                int n11 = 2;
                                for (int j = 0; j < n7; ++j) {
                                    if (cellIdentifierModel.isTypeData(n2, j)) continue;
                                    Object object3 = bl ? (j == n9 ? "VarID 1" : "VarID " + n11++) : cellIdentifierModel.getValueAt(n9, j);
                                    if (!string.equalsIgnoreCase(object3.toString())) continue;
                                    int n12 = n4;
                                    ((AbstractInnerColumn)icType).insert(n4, n3);
                                    for (int k = 0; k < n6; ++k) {
                                        if (!cellIdentifierModel.isTypeData(n, k)) continue;
                                        Object object4 = bl ? cellIdentifierModel.getValueAt(j, k) : cellIdentifierModel.getValueAt(k, j);
                                        if (icType instanceof InnerColumnImageResource) {
                                            InnerColumnImageResource innerColumnImageResource = (InnerColumnImageResource)icType;
                                            innerColumnImageResource.setValueFromPath((File)object, n12++, object4.toString());
                                            continue;
                                        }
                                        ((AbstractInnerColumn)icType).setValue(n12++, (Object)object4);
                                    }
                                }
                            }
                        }
                        dataSet.updateReferences();
                        dataSet.triggetDataInfoEvent(new DataInfoEvent(dataSet.getVarDataInfo(), bl ? (byte)10 : 9));
                    }
                    try {
                        Category category = (Category)this.this$0.originalDataSet.createModification(this, bl ? "var" : "obs", "category");
                        category.setLayerName(DataTreeManager.getUniqueName(category.getTreeParent(), "Filename"));
                        object2 = category.getInnerColumn();
                        ClassTypes classTypes = ((InnerColumnClass)object2).getObject();
                        classTypes.addString("Original");
                        String string = importWizard.getFiles()[0].getName();
                        int n13 = string.lastIndexOf(".");
                        if (n13 >= 0) {
                            string = string.substring(0, n13);
                        }
                        classTypes.addString(string);
                        for (n14 = 0; n14 < ((AbstractInnerColumn)object2).getSize(); ++n14) {
                            if (n14 < n4) {
                                ((InnerColumnShort)object2).setValueShort(n14, (short)1);
                                continue;
                            }
                            ((InnerColumnShort)object2).setValueShort(n14, (short)2);
                        }
                        category.updateClasses();
                        category.applyTransformation(null, this);
                    }
                    catch (Exception exception) {
                        ErrorHandler.logAndReportException(exception);
                    }
                    return null;
                }
            };
            progressManagerImpl.invokeLater();
        }
    }

    private void cleanUpChildLocal() {
        this.originalMatrix = null;
        this.originalDataSet = null;
        this.dsContainer = null;
        this.subModels = null;
        this.model = null;
        this.addedData = null;
        this.linkedDataSource = null;
    }

    private void createAddedData() {
        this.addedData = new DataContainer("Calculated data", 16){

            @Override
            public boolean isVisibleInTree() {
                return this.hasChildren();
            }
        };
        this.replaceNode(this.addedData, this.addedData, true);
    }

    private void loadDataFromModel(final ProgressManager progressManager, final CellIdentifierModel cellIdentifierModel, AbstractDataMatrix abstractDataMatrix) {
        int n;
        int n2;
        int[][] nArray = cellIdentifierModel.getMatrixInfo();
        LayerMatrix layerMatrix = null;
        if (abstractDataMatrix instanceof LayerMatrix) {
            layerMatrix = (LayerMatrix)abstractDataMatrix;
        }
        abstractDataMatrix.beginCalculations();
        AbstractDataMatrix[] abstractDataMatrixArray = null;
        Matrix[] matrixArray = null;
        if (layerMatrix != null) {
            abstractDataMatrixArray = layerMatrix.getMatrixArray();
            matrixArray = new Matrix[abstractDataMatrixArray.length];
            for (int i = 0; i < abstractDataMatrixArray.length; ++i) {
                matrixArray[i] = ((AbstractMVmatrix)abstractDataMatrixArray[i]).getInternalMatrixPublic();
                if (matrixArray[i] != null) continue;
                matrixArray[i] = ((AbstractMVmatrix)abstractDataMatrixArray[i]).createInternamMatrix();
            }
        } else {
            abstractDataMatrixArray = new AbstractDataMatrix[]{abstractDataMatrix};
        }
        int[] nArray2 = cellIdentifierModel.getDataOrder();
        int[] nArray3 = new int[3];
        int[] nArray4 = new int[3];
        final int n3 = nArray2[0];
        final int n4 = nArray2[1];
        final int n5 = nArray2[2];
        final int[] nArray5 = cellIdentifierModel.getDataIndex(n3);
        final int[] nArray6 = cellIdentifierModel.getDataIndex(n4);
        final int[] nArray7 = cellIdentifierModel.getDataIndex(n5);
        boolean bl = cellIdentifierModel.isMultiLayer();
        if (bl) {
            if (cellIdentifierModel.hasMissing()) {
                FastDecimal fastDecimal = new FastDecimal();
                for (var19_24 = 0; var19_24 < nArray7.length; ++var19_24) {
                    nArray4[n5] = nArray7[var19_24];
                    nArray3[n5] = var19_24;
                    for (n2 = 0; n2 < nArray6.length; ++n2) {
                        nArray4[n4] = nArray6[n2];
                        nArray3[n4] = n2;
                        n = 0;
                        while (n < nArray5.length) {
                            nArray4[n3] = nArray5[n];
                            nArray3[n3] = n++;
                            cellIdentifierModel.setCurrentLayer(nArray4[2]);
                            abstractDataMatrixArray[nArray3[2]].setValue(nArray3[0], nArray3[1], cellIdentifierModel.getDirectDoubleAtNoSync(nArray4[0], nArray4[1], fastDecimal));
                        }
                        progressManager.incStep(nArray5.length);
                    }
                }
            } else if (cellIdentifierModel.supportMultiThread()) {
                final Matrix[] matrixArray2 = matrixArray;
                new Threader(this){

                    @Override
                    protected void doOp(boolean bl, int n, int n2) {
                        int[] nArray = new int[3];
                        int[] nArray2 = new int[3];
                        for (int i = n; i < n2; ++i) {
                            nArray2[n5] = nArray7[i];
                            nArray[n5] = i;
                            for (int j = 0; j < nArray6.length; ++j) {
                                nArray2[n4] = nArray6[j];
                                nArray[n4] = j;
                                int n32 = 0;
                                while (n32 < nArray5.length) {
                                    nArray2[n3] = nArray5[n32];
                                    nArray[n3] = n32++;
                                    matrixArray2[nArray[2]].set(nArray[0], nArray[1], cellIdentifierModel.getDirectDoubleAtNoMissing(nArray2[0], nArray2[1], nArray2[2]));
                                }
                            }
                            progressManager.incStep(nArray6.length * nArray5.length);
                        }
                    }
                }.execute(nArray7.length);
            } else {
                for (int i = 0; i < nArray7.length; ++i) {
                    nArray4[n5] = nArray7[i];
                    nArray3[n5] = i;
                    for (var19_24 = 0; var19_24 < nArray6.length; ++var19_24) {
                        nArray4[n4] = nArray6[var19_24];
                        nArray3[n4] = var19_24;
                        n2 = 0;
                        while (n2 < nArray5.length) {
                            nArray4[n3] = nArray5[n2];
                            nArray3[n3] = n2++;
                            matrixArray[nArray3[2]].set(nArray3[0], nArray3[1], cellIdentifierModel.getDirectDoubleAtNoMissing(nArray4[0], nArray4[1], nArray4[2]));
                        }
                        progressManager.incStep(nArray5.length);
                    }
                }
            }
        } else {
            for (int i = 0; i < nArray7.length; ++i) {
                nArray4[n5] = nArray7[i];
                nArray3[n5] = i;
                for (var19_24 = 0; var19_24 < nArray6.length; ++var19_24) {
                    nArray4[n4] = nArray6[var19_24];
                    nArray3[n4] = var19_24;
                    n2 = 0;
                    while (n2 < nArray5.length) {
                        nArray4[n3] = nArray5[n2];
                        nArray3[n3] = n2++;
                        abstractDataMatrixArray[nArray3[2]].setValue(nArray3[0], nArray3[1], cellIdentifierModel.getDoubleAt(nArray4[0], nArray4[1]));
                    }
                    progressManager.incStep(nArray5.length);
                }
            }
        }
        DataGroupValues dataGroupValues = this.getDataGroup(1, 3);
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)dataGroupValues.getPrimaryColumn();
        n2 = cellIdentifierModel.getColumnCount();
        n = cellIdentifierModel.getRowCount();
        for (int i = 0; i < cellIdentifierModel.getReferenceValues(); ++i) {
            String string = cellIdentifierModel.getReferenceName(i);
            if (string == null) continue;
            AbstractDataMatrix abstractDataMatrix2 = cellIdentifierModel.createSuitableMatrix(nArray[0][0], nArray[1][0]);
            int n6 = 0;
            for (int j = 0; j < n2; ++j) {
                int n7 = 0;
                if (!cellIdentifierModel.isColumnTypeData(j)) continue;
                for (int k = 0; k < n; ++k) {
                    if (!cellIdentifierModel.isRowTypeData(k)) continue;
                    abstractDataMatrix2.setValue(n7, n6, cellIdentifierModel.getReferenceValue(i, k, j));
                    ++n7;
                }
                ++n6;
            }
            innerColumnBoolean.setValueBool(abstractDataMatrix.getMatrixCount(), false);
            Case.addLayerMatrix(abstractDataMatrix, abstractDataMatrix2, string);
        }
        abstractDataMatrix.endCalculations();
    }

    public void setLinkedDataSource(AbstractDataSource abstractDataSource) {
        this.linkedDataSource = abstractDataSource;
    }

    public AbstractDataSource getLinkedDataSource() {
        return this.linkedDataSource;
    }

    public void setConvertTo(String string) {
        this.convertTo = string;
    }

    public String getConvertTo() {
        return this.convertTo;
    }
}

