/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer;

import java.io.IOException;
import javax.swing.ImageIcon;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.datasetcontainer.AbstractDataNode;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;

public class DataContainer
extends AbstractDataNode {
    private static final byte[] painttype = new byte[]{1, 3, 2, -1, 9, 6, -1, -1, -1, -1, -1, -1, -1, 15, 15};
    private final byte type;

    public DataContainer(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        if ("Matrixs".equals(this.name)) {
            this.name = "Matrices";
        }
        this.type = mapProperty.getPropertyByte("ctype", (byte)0);
    }

    public DataContainer(String string, byte by) {
        super(string);
        this.type = by;
    }

    public DataContainer(String string, byte by, boolean bl) {
        this(string, by);
        if (!bl) {
            this.excludeChildrenFromCalculation();
        }
    }

    @Override
    public void addShortcut(DataTreeInterface dataTreeInterface) {
        if (dataTreeInterface != null) {
            super.addShortcut(dataTreeInterface);
            this.triggerPropertyEvent(dataTreeInterface, (byte)1);
        }
    }

    @Override
    public void addTreeNode(DataTreeInterface dataTreeInterface) {
        super.addTreeNode(dataTreeInterface);
        this.triggerPropertyEvent(dataTreeInterface, (byte)1);
    }

    @Override
    public void addTreeNode(DataTreeInterface dataTreeInterface, DataTreeInterface dataTreeInterface2) {
        super.addTreeNode(dataTreeInterface, dataTreeInterface2);
        this.triggerPropertyEvent(dataTreeInterface, (byte)1);
    }

    @Override
    public ImageIcon getIcon(byte by) {
        return new ImageIcon(Main_GUI.class.getResource("gif/datacontainer.png"));
    }

    @Override
    public String getInformation() {
        return "";
    }

    public int getPainttype() {
        if (this.type >= 0 && this.type < painttype.length) {
            return painttype[this.type];
        }
        return -1;
    }

    @Override
    public byte getTreeType() {
        return 2;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    @Override
    public void insertTreeNode(DataTreeInterface dataTreeInterface) {
        super.insertTreeNode(dataTreeInterface);
        this.triggerPropertyEvent(dataTreeInterface, (byte)3);
    }

    @Override
    public boolean isVisibleInTree() {
        return switch (this.type) {
            case 1 -> false;
            case 13, 14, 15, 16 -> {
                if (super.isVisibleInTree() && this.hasNotCleanedChildren()) {
                    yield true;
                }
                yield false;
            }
            default -> super.isVisibleInTree();
        };
    }

    @Override
    public boolean removeTreeNode(DataTreeInterface dataTreeInterface) {
        if (super.removeTreeNode(dataTreeInterface)) {
            this.triggerPropertyEvent(dataTreeInterface, (byte)2);
            return true;
        }
        return false;
    }

    @Override
    public void removeTreeNodeAt(int n) {
        super.removeTreeNodeAt(n);
        this.triggerPropertyEvent(this, (byte)2);
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyByte("ctype", this.type);
    }

    private boolean hasNotCleanedChildren() {
        for (int i = this.getTreeNodeCount() - 1; i >= 0; --i) {
            if (!this.getTreeNodeAt(i).isCleaned()) {
                return true;
            }
            this.removeTreeNodeAt(i);
        }
        return false;
    }

    private void triggerPropertyEvent(DataTreeInterface dataTreeInterface, byte by) {
        if (this.type != -1 && Project_GUI.getMode() == 0) {
            this.triggerPropertyEvent(new DataTreeEvent((Object)this, dataTreeInterface, by));
        }
    }
}

