/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer;

import java.awt.Point;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.cleanup.CleanUpVector;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.DataTreeMemoryClass;
import se.prediktera.map.datasetcontainer.ShortcutInterface;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.datasetcontainer.event.DataTreeListener;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractPrediction;

public abstract class DataTreeClass
extends CleanUpVector<DataTreeInterface>
implements DataTreeInterface,
ShortcutInterface,
Cloneable {
    protected DataTreeManager dataTreeManager = null;
    protected Integer nodeID;
    protected ArrayList<DataTreeListener> listenerList;
    protected String name = "";
    protected int saveIndex = -1;
    private DataTreeInterface nodeParent;
    private boolean visible = true;
    protected DataTreeInterface realParent = null;
    private boolean childrenInCalculation = true;
    private Case belongsToCase = null;

    public DataTreeClass(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(mapProperty.getPropertyStringUTF("name", "Loaded"));
        this.dataTreeManager = randomInputStream.getDataTreeManager();
        if (this.dataTreeManager != null) {
            this.nodeID = this.dataTreeManager.addUniqueID(randomInputStream.getCT().id, this);
        }
        if (mapProperty.hasProperty("name")) {
            this.name = mapProperty.getLVStringUTF();
        }
        if (mapProperty.hasProperty("vis")) {
            this.visible = mapProperty.getLVBoolean();
        }
        this.childrenInCalculation = mapProperty.getPropertyBoolean("cic", true);
        this.nodeParent = mapProperty.resolveNodeFromName(randomInputStream, "tp");
        this.realParent = mapProperty.resolveNodeFromName(randomInputStream, "rp");
    }

    public DataTreeClass(String string) {
        super(string);
        this.setName(string);
    }

    @Override
    public void addDataTreeChangeListener(DataTreeListener dataTreeListener) {
        if (!(dataTreeListener == null || this.listenerList != null && this.listenerList.contains(dataTreeListener))) {
            if (this.listenerList == null) {
                this.listenerList = new ArrayList();
            }
            this.listenerList.add(dataTreeListener);
        }
    }

    @Override
    public void addShortcut(DataTreeInterface dataTreeInterface) {
        if (dataTreeInterface != null) {
            this.add(dataTreeInterface);
        }
    }

    @Override
    public boolean addToPopup(Project_GUI project_GUI, DataTreeInterface dataTreeInterface, Point point, JPopupMenu jPopupMenu, boolean bl) {
        return false;
    }

    @Override
    public void addTreeNode(DataTreeInterface dataTreeInterface) {
        if (dataTreeInterface != null && !dataTreeInterface.isCleaned()) {
            this.add(dataTreeInterface);
            dataTreeInterface.setTreeParent(this);
        }
    }

    @Override
    public void addTreeNode(DataTreeInterface dataTreeInterface, DataTreeInterface dataTreeInterface2) {
        if (dataTreeInterface != null && !dataTreeInterface.isCleaned()) {
            this.add(dataTreeInterface);
            if (dataTreeInterface.getTreeParent() == null) {
                dataTreeInterface.setTreeParent(this);
            }
            this.realParent = dataTreeInterface2;
        }
    }

    public void addTreeNodeSortedByType(DataTreeInterface dataTreeInterface) {
        if (dataTreeInterface != null && !dataTreeInterface.isCleaned()) {
            boolean bl = false;
            boolean bl2 = false;
            int n = this.getTreeNodeCount();
            for (int i = 0; i < n; ++i) {
                boolean bl3;
                boolean bl4 = bl3 = this.getTreeNodeAt(i).getTreeType() == dataTreeInterface.getTreeType();
                if (bl && !bl3) {
                    this.add(i, dataTreeInterface);
                    bl2 = true;
                    break;
                }
                bl = bl3;
            }
            if (!bl2) {
                this.add(dataTreeInterface);
            }
            dataTreeInterface.setTreeParent(this);
        }
    }

    public void beginCalculations() {
        if (this.childrenInCalculation) {
            int n = this.getTreeNodeCount();
            for (int i = 0; i < n; ++i) {
                DataTreeInterface dataTreeInterface = this.getTreeNodeAt(i);
                if (dataTreeInterface instanceof DataTreeClass) {
                    ((DataTreeClass)dataTreeInterface).beginCalculations();
                    continue;
                }
                if (!(dataTreeInterface instanceof DataTreeMemoryClass)) continue;
                ((DataTreeMemoryClass)dataTreeInterface).beginCalculations();
            }
        }
    }

    public void beginUpdate() {
    }

    public void beginUpdate(DataTreeInterface dataTreeInterface) {
    }

    public void beginUpdateRecursive() {
        this.beginUpdate();
        for (int i = 0; i < this.size(); ++i) {
            if (!(this.get(i) instanceof DataTreeClass)) continue;
            ((DataTreeClass)this.get(i)).beginUpdateRecursive();
        }
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public boolean containsTreeNode(DataTreeInterface dataTreeInterface) {
        return this.contains(dataTreeInterface);
    }

    public void copyDataTreeChangeListeners(DataTreeInterface dataTreeInterface) {
        if (this.listenerList != null) {
            for (DataTreeListener dataTreeListener : this.listenerList) {
                dataTreeInterface.addDataTreeChangeListener(dataTreeListener);
            }
        }
    }

    public void cutPaste(DataTreeInterface dataTreeInterface) {
        DataTreeInterface dataTreeInterface2 = dataTreeInterface.getTreeParent();
        if (dataTreeInterface2 != null) {
            dataTreeInterface2.removeTreeNode(dataTreeInterface);
        }
        this.addTreeNode(dataTreeInterface);
    }

    public void endCalculations() {
        if (this.childrenInCalculation) {
            int n = this.getTreeNodeCount();
            for (int i = 0; i < n; ++i) {
                DataTreeInterface dataTreeInterface = this.getTreeNodeAt(i);
                if (dataTreeInterface instanceof DataTreeClass) {
                    ((DataTreeClass)dataTreeInterface).endCalculations();
                    continue;
                }
                if (!(dataTreeInterface instanceof DataTreeMemoryClass)) continue;
                ((DataTreeMemoryClass)dataTreeInterface).endCalculations();
            }
        }
    }

    public void endUpdate() {
    }

    public void endUpdateRecursive() {
        this.endUpdate();
        for (int i = 0; i < this.size(); ++i) {
            if (!(this.get(i) instanceof DataTreeClass)) continue;
            ((DataTreeClass)this.get(i)).endUpdateRecursive();
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof DataTreeInterface) {
            DataTreeInterface dataTreeInterface = (DataTreeInterface)object;
            if (this.nodeID != null) {
                return this.nodeID.equals(dataTreeInterface.getID());
            }
            if (dataTreeInterface.getID() != null) {
                return dataTreeInterface.getID().equals(this.nodeID);
            }
            if (dataTreeInterface.isLeaf() != this.isLeaf()) {
                return false;
            }
            if (this.getNodeType() == dataTreeInterface.getNodeType() && this.getTreeType() == dataTreeInterface.getTreeType()) {
                if (!this.toString().equalsIgnoreCase(dataTreeInterface.toString())) {
                    return false;
                }
                return super.equals(object);
            }
        }
        return false;
    }

    public void excludeChildrenFromCalculation() {
        this.childrenInCalculation = false;
    }

    public String getAbsolutePath() {
        return DataTreeManager.getAbsolutePath(this);
    }

    public DataTreeInterface getAncestor() {
        return DataTreeManager.getAncestor(this);
    }

    public Case getCase() {
        DataTreeInterface dataTreeInterface;
        if (this.belongsToCase == null && (dataTreeInterface = this.getAncestor()) instanceof Case) {
            this.belongsToCase = (Case)dataTreeInterface;
        }
        return this.belongsToCase;
    }

    @Override
    public DataTreeManager getDataTreeManager() {
        if (this.dataTreeManager == null && this.nodeParent != null) {
            this.setDataTreeManager(this.nodeParent.getDataTreeManager(), false);
        }
        return this.dataTreeManager;
    }

    public List<AbstractModel> getEnabledModels(String string) {
        ArrayList<AbstractModel> arrayList = new ArrayList<AbstractModel>();
        int n = this.getTreeNodeCount();
        for (int i = 0; i < n; ++i) {
            DataTreeInterface dataTreeInterface = this.getTreeNodeAt(i);
            if (!(dataTreeInterface instanceof AbstractModel) || !((AbstractModel)dataTreeInterface).isEnabled()) continue;
            arrayList.add((AbstractModel)dataTreeInterface);
        }
        return arrayList;
    }

    @Override
    public ImageIcon getIcon(byte by) {
        return null;
    }

    @Override
    public Integer getID() {
        if (this.nodeID == null && this.getDataTreeManager() != null) {
            this.nodeID = this.dataTreeManager.addUniqueID(null, this);
        }
        return this.nodeID;
    }

    @Override
    public String getInformation() {
        return "<HTML><BODY><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" ><TR><TD>Number:</TD><TD></TD></TR></TABLE></BODY></HTML>";
    }

    public ArrayList<DataTreeListener> getListenerList() {
        return this.listenerList;
    }

    public String getName() {
        return this.name;
    }

    public DataTreeInterface getNodeByName(String string) {
        int n = this.getTreeNodeCount();
        for (int i = 0; i < n; ++i) {
            DataTreeInterface dataTreeInterface = this.getTreeNodeAt(i);
            if (dataTreeInterface == null || dataTreeInterface.isCleaned() || !EvinceScriptCommands.removeSpace(dataTreeInterface.toString().toLowerCase()).equalsIgnoreCase(EvinceScriptCommands.removeSpace(string))) continue;
            return dataTreeInterface;
        }
        return null;
    }

    public DataTreeInterface getNodeByClass(Class clazz) {
        int n = this.getTreeNodeCount();
        for (int i = 0; i < n; ++i) {
            DataTreeInterface dataTreeInterface = this.getTreeNodeAt(i);
            if (!clazz.isAssignableFrom(dataTreeInterface.getClass())) continue;
            return dataTreeInterface;
        }
        return null;
    }

    public Project_GUI getProject_GUI() {
        Case case_ = this.getCase();
        if (case_ != null && case_.getDataTreeManager() != null) {
            return case_.getDataTreeManager().getProject();
        }
        return null;
    }

    public DataTreeInterface getRoot() {
        return DataTreeManager.getRoot(this);
    }

    @Override
    public int getSaveIndex() {
        return this.saveIndex;
    }

    @Override
    public String getToolTipText() {
        return this.toString();
    }

    @Override
    public DataTreeInterface getTreeNodeAt(int n) {
        if (0 <= n && n < this.size()) {
            return (DataTreeInterface)this.get(n);
        }
        return null;
    }

    @Override
    public int getTreeNodeCount() {
        return this.size();
    }

    @Override
    public DataTreeInterface getTreeParent() {
        return this.nodeParent;
    }

    public DataTreeClass getTreeRoot() {
        DataTreeInterface dataTreeInterface = this;
        while (dataTreeInterface.getTreeParent() != null) {
            dataTreeInterface = dataTreeInterface.getTreeParent();
        }
        return dataTreeInterface;
    }

    public int getUniqueIndex() {
        DataTreeInterface dataTreeInterface;
        DataTreeInterface dataTreeInterface2 = dataTreeInterface = this.realParent != null ? this.realParent : this.getTreeParent();
        if (dataTreeInterface instanceof DataTreeClass) {
            DataTreeClass dataTreeClass = (DataTreeClass)dataTreeInterface;
            return dataTreeClass.indexOf(this);
        }
        return -1;
    }

    public String getUniqueName() {
        return "node" + this.getUniqueIndex();
    }

    public String getUniqueName(String string) {
        return DataTreeManager.getUniqueName(this, string);
    }

    public boolean hasChild(DataTreeInterface dataTreeInterface) {
        return this.indexOfTreeNode(dataTreeInterface) >= 0;
    }

    public boolean hasChildren() {
        return !this.isEmpty();
    }

    public boolean hasChildWithName(String string) {
        return this.getNodeByName(string) != null;
    }

    public int indexOfTreeNode(DataTreeInterface dataTreeInterface) {
        return this.indexOf(dataTreeInterface);
    }

    @Override
    public void insertTreeNode(DataTreeInterface dataTreeInterface) {
        this.insertTreeNode(0, dataTreeInterface);
    }

    public void insertTreeNode(int n, DataTreeInterface dataTreeInterface) {
        if (dataTreeInterface != null && !dataTreeInterface.isCleaned()) {
            this.add(n, dataTreeInterface);
            dataTreeInterface.setTreeParent(this);
        }
    }

    public boolean isEmptyTreeNode() {
        return this.isEmpty();
    }

    @Override
    public boolean isLeaf() {
        return this.isEmpty();
    }

    @Override
    public boolean isNode() {
        return !this.isLeaf();
    }

    public boolean isRelatedTo(DataTreeInterface dataTreeInterface) {
        if (dataTreeInterface instanceof DataTreeClass) {
            DataTreeInterface dataTreeInterface2 = this.getAncestor();
            DataTreeInterface dataTreeInterface3 = ((DataTreeClass)dataTreeInterface).getAncestor();
            return dataTreeInterface2.equals(dataTreeInterface3);
        }
        return false;
    }

    public boolean isRoot() {
        return this.getTreeParent() == null;
    }

    @Override
    public boolean isShortcut() {
        return this.realParent != null && !this.realParent.equals(this) && !this.realParent.equals(this.getTreeParent());
    }

    public boolean isUpdating() {
        return false;
    }

    @Override
    public boolean isVisibleInTree() {
        return this.visible;
    }

    public void moveDataTreeChangeListeners(DataTreeClass dataTreeClass) {
        if (this.listenerList != null) {
            this.copyDataTreeChangeListeners(dataTreeClass);
            this.listenerList.clear();
            this.listenerList = null;
        }
    }

    public boolean nameExists(String string) {
        int n = this.getTreeNodeCount();
        for (int i = 0; i < n; ++i) {
            if (!this.getTreeNodeAt(i).toString().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public void purge() {
        this.cleanUpRecursive();
    }

    public void purgeSignal() {
        Project_GUI project_GUI = this.getProject_GUI();
        if (project_GUI != null) {
            project_GUI.purgeSignal();
        }
    }

    public void removeAllDataTreeChangeListener() {
        if (this.listenerList != null) {
            this.listenerList.clear();
            this.listenerList = null;
        }
    }

    @Override
    public void removeDataTreeChangeListener(DataTreeListener dataTreeListener) {
        if (this.listenerList != null) {
            this.listenerList.remove(dataTreeListener);
            if (this.listenerList.isEmpty()) {
                this.listenerList = null;
            }
        }
    }

    @Override
    public boolean removeTreeNode(DataTreeInterface dataTreeInterface) {
        if (!this.isEmpty()) {
            try {
                return this.remove(dataTreeInterface);
            }
            catch (Exception exception) {
                System.out.println("Cannot delete child: " + exception.getMessage());
            }
        }
        return false;
    }

    public void removeTreeNodeAt(int n) {
        this.remove(n);
    }

    public DataTreeInterface replaceNode(DataTreeInterface dataTreeInterface, DataTreeInterface dataTreeInterface2) {
        return this.replaceNode(dataTreeInterface, dataTreeInterface2, true);
    }

    public DataTreeInterface replaceNode(DataTreeInterface dataTreeInterface, DataTreeInterface dataTreeInterface2, boolean bl) {
        int n = this.indexOf(dataTreeInterface);
        if (n >= 0) {
            if (dataTreeInterface2 != null) {
                if (dataTreeInterface instanceof DataTreeClass) {
                    DataTreeClass dataTreeClass = (DataTreeClass)dataTreeInterface;
                    if (dataTreeInterface2 instanceof DataTreeClass) {
                        DataTreeClass dataTreeClass2 = (DataTreeClass)dataTreeInterface2;
                        dataTreeClass.moveDataTreeChangeListeners(dataTreeClass2);
                        if (dataTreeClass.isUpdating()) {
                            dataTreeClass2.beginUpdate(dataTreeClass);
                        }
                        dataTreeClass2.triggerReplaceEvent(new DataTreeEvent((Object)this, dataTreeInterface, dataTreeInterface2));
                    } else {
                        dataTreeClass.triggerReplaceEvent(new DataTreeEvent((Object)this, dataTreeInterface, dataTreeInterface2));
                    }
                }
                this.set(n, dataTreeInterface2);
                dataTreeInterface2.setTreeParent(this);
            }
            if (dataTreeInterface != null && bl) {
                dataTreeInterface.cleanUp();
            }
        } else {
            this.addTreeNode(dataTreeInterface2);
        }
        return dataTreeInterface2;
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream, int n) throws IOException {
        this.saveIndex = n;
        randomOutputStream.writePropertyStringUTF("name", this.name);
        randomOutputStream.writePropertyBoolean("vis", this.visible);
        randomOutputStream.writePropertyNode("rp", this.realParent);
        randomOutputStream.writePropertyNode("tp", this.nodeParent);
        randomOutputStream.writePropertyBoolean("cic", this.childrenInCalculation);
        this.SavePropertyLocal(randomOutputStream);
    }

    @Override
    public void setDataTreeManager(DataTreeManager dataTreeManager, boolean bl) {
        if (bl || this.dataTreeManager != null && this.dataTreeManager != dataTreeManager) {
            this.nodeID = null;
        }
        this.dataTreeManager = dataTreeManager;
        if (this.nodeID == null && this.dataTreeManager != null) {
            this.nodeID = this.dataTreeManager.addUniqueID(null, this);
        }
        for (int i = 0; i < this.getTreeNodeCount(); ++i) {
            DataTreeInterface dataTreeInterface = this.getTreeNodeAt(i);
            if (dataTreeInterface == null) continue;
            dataTreeInterface.setDataTreeManager(dataTreeManager, bl);
        }
    }

    public void setID(Integer n) {
        this.nodeID = n;
    }

    public void setListenerList(ArrayList<DataTreeListener> arrayList) {
        this.listenerList = arrayList;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setProjectChanged() {
        Project_GUI project_GUI = this.getProject_GUI();
        if (project_GUI != null) {
            project_GUI.setProjectChanged();
        }
    }

    public void setRootNode(DataTreeManager dataTreeManager) {
        if (this.nodeID == null) {
            this.nodeID = dataTreeManager.setUniqueRoot(this);
        }
        this.setDataTreeManager(dataTreeManager, false);
    }

    public void setTreeNode(int n, DataTreeInterface dataTreeInterface) {
        this.set(n, dataTreeInterface);
    }

    @Override
    public void setTreeParent(DataTreeInterface dataTreeInterface) {
        if (dataTreeInterface != null && dataTreeInterface != this.nodeParent) {
            this.nodeParent = dataTreeInterface;
            this.dataTreeManager = dataTreeInterface.getDataTreeManager();
            for (int i = 0; i < this.getTreeNodeCount(); ++i) {
                DataTreeInterface dataTreeInterface2 = this.getTreeNodeAt(i);
                if (dataTreeInterface2 == null) continue;
                dataTreeInterface2.setTreeParent(this);
            }
        }
        if (this.nodeID == null && this.dataTreeManager != null) {
            this.setDataTreeManager(this.dataTreeManager, false);
        }
    }

    public void setVisibleInTree(boolean bl) {
        this.visible = bl;
    }

    public void statisticSignal() {
        Project_GUI project_GUI = this.getProject_GUI();
        if (project_GUI != null) {
            project_GUI.statisticSignal();
        }
    }

    @Override
    public void swapNodes(int n, int n2) {
        DataTreeInterface dataTreeInterface = (DataTreeInterface)this.get(n);
        this.set(n, (DataTreeInterface)this.get(n2));
        this.set(n2, dataTreeInterface);
    }

    @Override
    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return super.toString();
    }

    public String toStringShortcut() {
        return this.toString();
    }

    public void triggerReplaceEvent(DataTreeEvent dataTreeEvent) {
        if (this.listenerList != null) {
            ArrayList arrayList = (ArrayList)this.listenerList.clone();
            for (Object e : arrayList) {
                ((DataTreeListener)e).nodeReplaced(dataTreeEvent);
            }
        }
        dataTreeEvent.cleanUp();
    }

    @Override
    protected void cleanUpChild() {
        if (this.dataTreeManager != null && this.nodeID != null) {
            this.dataTreeManager.removeUniqueID(this.nodeID);
        }
        this.cleanUpRecursive();
        if (this.nodeParent != null) {
            this.nodeParent.removeTreeNode(this);
        }
        this.nodeID = null;
        this.dataTreeManager = null;
        this.realParent = null;
        this.nodeParent = null;
        this.belongsToCase = null;
    }

    protected abstract void SavePropertyLocal(RandomOutputStream var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerPropertyEvent(DataTreeEvent dataTreeEvent) {
        Serializable serializable;
        if (this.listenerList != null) {
            serializable = this.listenerList;
            synchronized (serializable) {
                int n = this.listenerList.size();
                for (int i = 0; i < n; ++i) {
                    if (this.listenerList == null || this.listenerList.get(i) == null) continue;
                    this.listenerList.get(i).propertyChanged(dataTreeEvent);
                }
            }
        }
        if (dataTreeEvent.getProperty() == 0 && (serializable = this.getProject_GUI()) != null) {
            ((Project_GUI)serializable).renameSignal();
        }
        dataTreeEvent.cleanUp();
    }

    private void cleanUpRecursive() {
        while (!this.isEmpty()) {
            DataTreeInterface dataTreeInterface = this.getTreeNodeAt(0);
            if (!(this.dataTreeManager != null && !this.dataTreeManager.hasDataMask(dataTreeInterface) || dataTreeInterface.getTreeParent() != this && !(dataTreeInterface instanceof AbstractPrediction)) && !dataTreeInterface.cleanUp() || this.remove(dataTreeInterface)) continue;
            this.remove(0);
        }
    }
}

