/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.TreeHeader;
import se.prediktera.map.common.cleanup.CleanUpClass;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.common.propagation.PropagationInterface;
import se.prediktera.map.common.resource.ImageResource;
import se.prediktera.map.common.resource.ResourceNode;
import se.prediktera.map.data.DataGroupLayer;
import se.prediktera.map.data.DescriptionLayer;
import se.prediktera.map.data.datasettable.DataSetTable;
import se.prediktera.map.data.intervall.IntervallTable;
import se.prediktera.map.data.modeltable.ModelTable;
import se.prediktera.map.data.quicktable.QuickTable;
import se.prediktera.map.data.sparsetable.SparseTable;
import se.prediktera.map.dataimport.database.DatabaseTableModel;
import se.prediktera.map.dataimport.merge.MergeDataSource;
import se.prediktera.map.dataimport.merge.OriginalDataSource;
import se.prediktera.map.dataimport.multi.MultiCellIdentifierModel;
import se.prediktera.map.dataimport.raw.RawDataSource;
import se.prediktera.map.datasetcontainer.AbstractDataNode;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.MemoryInterface;
import se.prediktera.map.datasetcontainer.OriginalData;
import se.prediktera.map.datasetcontainer.classes.Classes;
import se.prediktera.map.datasetcontainer.classes.prediction.PredictionClasses;
import se.prediktera.map.datasetcontainer.database.DataBaseControl;
import se.prediktera.map.datasetcontainer.datainfo.DNAclass;
import se.prediktera.map.datasetcontainer.datainfo.DataImage;
import se.prediktera.map.datasetcontainer.datainfo.Description;
import se.prediktera.map.datasetcontainer.datainfo.IncExclude;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.datainfo.Smiles;
import se.prediktera.map.datasetcontainer.datainfo.VariablesInfo;
import se.prediktera.map.datasetcontainer.datainfo.obsinfo.ProjectLink;
import se.prediktera.map.datasetcontainer.datainfo.obsinfo.Test;
import se.prediktera.map.datasetcontainer.datainfo.obsinfo.Train;
import se.prediktera.map.datasetcontainer.datainfo.varinfo.Datatype;
import se.prediktera.map.datasetcontainer.datainfo.varinfo.XYclass;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.dataset.DataSetHistoryNode;
import se.prediktera.map.datasetcontainer.dataset.DataSetMatrix;
import se.prediktera.map.datasetcontainer.dataset.type.DataSetGroup;
import se.prediktera.map.datasetcontainer.dataset.type.DataSetHierarchy;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.DataSourceMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrixInterface;
import se.prediktera.map.datasetcontainer.matrix.FrameMatrix;
import se.prediktera.map.datasetcontainer.matrix.GroupMatrix;
import se.prediktera.map.datasetcontainer.matrix.LayerMatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrixByte;
import se.prediktera.map.datasetcontainer.matrix.MVmatrixFloat;
import se.prediktera.map.datasetcontainer.matrix.MVmatrixShort;
import se.prediktera.map.datasetcontainer.matrix.MatrixContainer;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.datasetcontainer.matrix.NormalizedModelMatrix;
import se.prediktera.map.datasetcontainer.matrix.ReferenceMatrix;
import se.prediktera.map.datasetcontainer.matrix.SparseMatrix;
import se.prediktera.map.datasetcontainer.matrix.TransformedReferenceMatrix;
import se.prediktera.map.datasetcontainer.nodecase.ProjectDataSource;
import se.prediktera.map.datasetcontainer.transform.TransformMatrix;
import se.prediktera.map.datasetcontainer.transform.Transformations;
import se.prediktera.map.datasetcontainer.transform.baseline.BaseLineCorrection;
import se.prediktera.map.datasetcontainer.transform.category.Category;
import se.prediktera.map.datasetcontainer.transform.center.TCenter;
import se.prediktera.map.datasetcontainer.transform.cr.ContinuumRemovalTransform;
import se.prediktera.map.datasetcontainer.transform.derivative.Derivative;
import se.prediktera.map.datasetcontainer.transform.function.Function;
import se.prediktera.map.datasetcontainer.transform.interactionterm.InteractionTerm;
import se.prediktera.map.datasetcontainer.transform.logarithm.Logarithm;
import se.prediktera.map.datasetcontainer.transform.msc.MscTransform;
import se.prediktera.map.datasetcontainer.transform.quadterm.QuadTerm;
import se.prediktera.map.datasetcontainer.transform.reduce.ReduceToAverage;
import se.prediktera.map.datasetcontainer.transform.savitzky.Savitzky;
import se.prediktera.map.datasetcontainer.transform.snv.SnvTransform;
import se.prediktera.map.datasetcontainer.transform.uvscale.TUVScale;
import se.prediktera.map.datasetcontainer.transform.value.AddedValue;
import se.prediktera.map.graphcollection.GraphManager;
import se.prediktera.map.history.HistoryManager;
import se.prediktera.map.history.HistoryScrollPane;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.extclass.DataTreeExtLibInterface;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.main.extclass.ExtLibException;
import se.prediktera.map.main.layer.LayerContainer;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.main.script.ScriptManager;
import se.prediktera.map.model.AbstractPrediction;
import se.prediktera.map.model.ModelWrapper;
import se.prediktera.map.model.output.OutputClass;
import se.prediktera.map.plot.PlotContainer;
import se.prediktera.map.plot.axisplot.plot2D.contour2D.Contour2D;
import se.prediktera.map.plot.axisplot.plot2D.contour2D.Contour2DLayer;
import se.prediktera.map.plot.axisplot.plot2D.contour2D.ContourAccessorPanel;
import se.prediktera.map.plot.axisplot.plot2D.contour2D.FloatWindowContour2D;
import se.prediktera.map.plot.axisplot.plot2D.pie.FloatWindowPie;
import se.prediktera.map.plot.axisplot.plot2D.pie.Pie2D;
import se.prediktera.map.plot.axisplot.plot2D.pie.PieLayer;
import se.prediktera.map.plot.axisplot.plot2D.quickspectral.FloatWindowQuickSpectral;
import se.prediktera.map.plot.axisplot.plot2D.quickspectral.QuickSpectral;
import se.prediktera.map.plot.axisplot.plot2D.quickspectral.QuickSpectralLayer;
import se.prediktera.map.plot.axisplot.plot2D.radar.FloatWindowRadar;
import se.prediktera.map.plot.axisplot.plot2D.radar.Radar2D;
import se.prediktera.map.plot.axisplot.plot2D.radar.RadarLayer;
import se.prediktera.map.plot.axisplot.plot2D.radar.design.Design2D;
import se.prediktera.map.plot.axisplot.plot2D.radar.design.DesignLayer;
import se.prediktera.map.plot.axisplot.plot2D.radar.design.FloatWindowDesign;
import se.prediktera.map.plot.axisplot.plot2D.scatter.FloatWindowScatter;
import se.prediktera.map.plot.axisplot.plot2D.scatter.Scatter2D;
import se.prediktera.map.plot.axisplot.plot2D.scatter.ScatterLayer;
import se.prediktera.map.plot.axisplot.plot2D.scatter.biplot.FloatWindowScatterBiPlot;
import se.prediktera.map.plot.axisplot.plot2D.scatter.biplot.Scatter2DBiPlot;
import se.prediktera.map.plot.axisplot.plot2D.serie.contribution.Contribution;
import se.prediktera.map.plot.axisplot.plot2D.serie.contribution.ContributionLayer;
import se.prediktera.map.plot.axisplot.plot2D.serie.contribution.FloatWindowContribution;
import se.prediktera.map.plot.axisplot.plot2D.serie.dendogram.Dendogram;
import se.prediktera.map.plot.axisplot.plot2D.serie.dendogram.DendogramLayer;
import se.prediktera.map.plot.axisplot.plot2D.serie.dendogram.FloatWindowDendogram;
import se.prediktera.map.plot.axisplot.plot2D.serie.histogram.FloatWindowHistogram;
import se.prediktera.map.plot.axisplot.plot2D.serie.histogram.Histogram2D;
import se.prediktera.map.plot.axisplot.plot2D.serie.histogram.HistogramLayer;
import se.prediktera.map.plot.axisplot.plot2D.serie.serie2D.FloatWindowSerie;
import se.prediktera.map.plot.axisplot.plot2D.serie.serie2D.Serie2D;
import se.prediktera.map.plot.axisplot.plot2D.serie.serie2D.SerieLayer;
import se.prediktera.map.plot.axisplot.plot2D.serie.serie2D.box.Box2D;
import se.prediktera.map.plot.axisplot.plot2D.serie.serie2D.box.BoxLayer;
import se.prediktera.map.plot.axisplot.plot2D.serie.serie2D.box.FloatWindowBox;
import se.prediktera.map.plot.axisplot.plot2D.spectral.FloatWindowSpectral;
import se.prediktera.map.plot.axisplot.plot2D.spectral.FloatWindowSpectralSingle;
import se.prediktera.map.plot.axisplot.plot2D.spectral.Spectral2D;
import se.prediktera.map.plot.axisplot.plot2D.spectral.SpectralLayer;
import se.prediktera.map.plot.axisplot.plot3D.contour3D.Contour3D;
import se.prediktera.map.plot.axisplot.plot3D.contour3D.Contour3DLayer;
import se.prediktera.map.plot.axisplot.plot3D.contour3D.FloatWindowContour3D;
import se.prediktera.map.plot.axisplot.plot3D.cube3D.Cube3D;
import se.prediktera.map.plot.axisplot.plot3D.cube3D.Cube3DLayer;
import se.prediktera.map.plot.axisplot.plot3D.cube3D.FloatWindowCube3D;
import se.prediktera.map.plot.axisplot.plot3D.scatter3D.FloatWindowScatter3D;
import se.prediktera.map.plot.axisplot.plot3D.scatter3D.Scatter3D;
import se.prediktera.map.plot.axisplot.plot3D.scatter3D.Scatter3DLayer;
import se.prediktera.map.plot.axisplot.windows.FloatImageWindow;
import se.prediktera.map.plot.axisplot.windows.FloatTextWindow;
import se.prediktera.map.plot.axisplot.windows.LegendWindow;
import se.prediktera.map.plot.layout.DescriptionTextBox;
import se.prediktera.map.plot.layout.SwitchTextBox;

public class DataTreeManager
extends CleanUpClass {
    public static final byte JDATASETCONTAINER = 0;
    public static final byte DATASET = 1;
    public static final byte DATACONTAINER = 2;
    public static final byte MODELWRAPPER = 3;
    public static final byte RESOURCENODE = 4;
    public static final byte IMAGERESOURCE = 5;
    public static final byte DATASETGROUP = 6;
    public static final byte DATASETHIERARCHY = 7;
    public static final byte OUTPUTCLASS = 8;
    public static final byte MVMATRIX = 0;
    public static final byte MODELMATRIX = 1;
    public static final byte MATRIXCONTAINER = 2;
    public static final byte SPARSEMATRIX = 3;
    public static final byte REFERENCEMATRIX = 4;
    public static final byte DATASETMATRIX = 5;
    public static final byte TRANSFORMMATRIX = 6;
    public static final byte DATASOURCEMATRIX = 7;
    public static final byte LAYERMATRIX = 8;
    public static final byte FOLDMATRIX = 9;
    public static final byte TRANSFORMEDREFERENCEMATRIX = 10;
    public static final byte ORIGINALDATA = 11;
    public static final byte MVMATRIX_SHORT = 12;
    public static final byte MVMATRIX_FLOAT = 13;
    public static final byte MVMATRIX_BYTE = 14;
    public static final byte NORMALIZEDMATRIX = 15;
    public static final byte GROUPMATRIX = 16;
    public static final byte FRAMEMATRIX = 17;
    public static final byte SCATTERPLOT = 0;
    public static final byte SERIEPLOT = 1;
    public static final byte SCATTERPLOT3D = 2;
    public static final byte LINEPLOT = 3;
    public static final byte CONTOURPLOT3D = 4;
    public static final byte HISTOGRAM = 5;
    public static final byte PLOTCONTAINER = 6;
    public static final byte DENDOGRAM = 7;
    public static final byte PIEPLOT = 8;
    public static final byte CONTOURPLOT2D = 9;
    public static final byte CONTRIBUTION = 10;
    public static final byte QUICKSPECTRALPLOT = 11;
    public static final byte SCATTERBIPLOT = 12;
    public static final byte RADARPLOT = 13;
    public static final byte DESIGNPLOT = 14;
    public static final byte CUBE3DPLOT = 15;
    public static final byte BOXPLOT = 16;
    public static final byte TEXTWINDOW = 0;
    public static final byte LEGENDWINDOW = 1;
    public static final byte SCATTERPLOTWINDOW = 2;
    public static final byte SERIEPLOTWINDOW = 3;
    public static final byte SCATTER3DPLOTWINDOW = 4;
    public static final byte LINEPLOTWINDOW = 5;
    public static final byte EMPTYPLOTWINDOW = 6;
    public static final byte CONTOUR3DPLOTWINDOW = 7;
    public static final byte HISTOGRAMPLOTWINDOW = 8;
    public static final byte DENDOGRAMPLOTWINDOW = 9;
    public static final byte PIEPLOTWINDOW = 10;
    public static final byte CONTOUR2DPLOTWINDOW = 11;
    public static final byte CONTRIBUTIONPLOTWINDOW = 12;
    public static final byte DESCRIPTIONTEXTWINDOW = 13;
    public static final byte QUICKSPECTRALPLOTWINDOW = 14;
    public static final byte IMAGEWINDOW = 15;
    public static final byte SWITCHWINDOW = 16;
    public static final byte SCATTERBIPLOTWINDOW = 17;
    public static final byte RADARPLOTWINDOW = 18;
    public static final byte DESIGNPLOTWINDOW = 19;
    public static final byte CUBE3DPLOTWINDOW = 20;
    public static final byte LINESINGLEPLOTWINDOW = 21;
    public static final byte BOXPLOTWINDOW = 22;
    public static final byte SCATTERPLOTLAYER = 0;
    public static final byte SERIEPLOTLAYER = 1;
    public static final byte SCATTER3DPLOTLAYER = 2;
    public static final byte LINEPLOTLAYER = 3;
    public static final byte EMPTYPLOTLAYER = 4;
    public static final byte CONTOUR3DPLOTLAYER = 5;
    public static final byte HISTOGRAMPLOTLAYER = 6;
    public static final byte DENDOGRAMPLOTLAYER = 7;
    public static final byte PIEPLOTLAYER = 8;
    public static final byte CONTOUR2DPLOTLAYER = 9;
    public static final byte CONTRIBUTIONPLOTLAYER = 10;
    public static final byte CONTOURACCESSORPANEL = 11;
    public static final byte QUICKSPECTRALPLOTLAYER = 12;
    public static final byte RADARPLOTLAYER = 13;
    public static final byte DESIGNPLOTLAYER = 14;
    public static final byte CUBE3DPLOTLAYER = 15;
    public static final byte BOXPLOTLAYER = 16;
    public static final byte QUICKTABLE = 0;
    public static final byte SPARSETABLE = 1;
    public static final byte DATASETTABLE = 2;
    public static final byte FILTERTABLE = 3;
    public static final byte MODELTABLE = 4;
    public static final byte DATAGROUPLAYER = 0;
    public static final byte DESCRIPTIONLAYER = 1;
    public static final byte DATACELLLAYER = 2;
    public static final byte CENTER = 0;
    public static final byte UVSCALE = 1;
    public static final byte INTERACTION = 2;
    public static final byte QUAD = 3;
    public static final byte CATEGORY = 4;
    public static final byte LAYERCONTAINER = 5;
    public static final byte FUNCTION = 6;
    public static final byte LOGARITHM = 7;
    public static final byte MSC = 8;
    public static final byte DERIVATIVE = 9;
    public static final byte SAVITZKY = 10;
    public static final byte SNV = 11;
    public static final byte REDUCE = 12;
    public static final byte ADDEDDATA = 13;
    public static final byte BASELINECORR = 14;
    public static final byte CONTINUUMREMOVAL = 15;
    public static final byte OBSERVATIONS = 0;
    public static final byte VARIABLES = 1;
    public static final byte DESCRIPTION = 0;
    public static final byte INCEXL = 1;
    public static final byte CLASSES = 2;
    public static final byte XY = 3;
    public static final byte TRAIN = 4;
    public static final byte TEST = 5;
    public static final byte DATATYPE = 6;
    public static final byte DATA = 7;
    public static final byte DATASMILES = 8;
    public static final byte DATADNA = 9;
    public static final byte TRANSFORMATIONS = 10;
    public static final byte PREDICTION_CLASSES = 11;
    public static final byte DATAIMAGE = 12;
    public static final byte PROJECTLINK = 13;
    public static final byte RAWDATASOURCE = 0;
    public static final byte MERGEDATASOURCE = 1;
    public static final byte DATABASEDATASOURCE = 2;
    public static final byte PROJECTDATASOURCE = 3;
    public static final byte ORIGINALDATASOURCE = 4;
    public static final byte MULTIIMPORTDATASOURCE = 5;
    public static final byte HISTORYMANAGER = 0;
    public static final byte DATASETHISTORY = 1;
    private static int globalsaveindex = 0;
    public static final int DATABASEMASK = -16777216;
    private static final String ErrorMessage = "There is a critial error in the saved file, can't be restored";
    private static final int IDMASK = 0xFFFFFF;
    public static final int DATABASEBEGIN = 0x1000000;
    private final ArrayList<IDItems> randomList = new ArrayList(500);
    private final LinkedList<Integer> removeList = new LinkedList();
    private final SortedIDComparator sortedIDComparator = new SortedIDComparator();
    private final IDItems dummy = new IDItems();
    protected int databaseID = 0;
    protected int maxnumber = 0;
    private boolean islocal = true;
    private File swapfile;
    private HistoryScrollPane history;
    private GraphManager graphManager;
    private Project_GUI project = null;
    private final Timer historyTimer = new Timer(500, actionEvent -> {
        if (this.history != null && this.history.isVisibleGUI()) {
            this.history.updateHistory();
        }
        if (this.graphManager != null && this.graphManager.isVisibleGUI()) {
            this.updateGraph();
        }
    });

    public static final String getAbsolutePath(DataTreeInterface dataTreeInterface) {
        Object object = dataTreeInterface.toString();
        DataTreeInterface dataTreeInterface2 = dataTreeInterface;
        DataTreeInterface dataTreeInterface3 = dataTreeInterface2.getTreeParent();
        while (dataTreeInterface3 != null && !dataTreeInterface3.toString().equals("Project Root")) {
            dataTreeInterface2 = dataTreeInterface3;
            object = String.valueOf(dataTreeInterface3) + "/" + (String)object;
            dataTreeInterface3 = dataTreeInterface2.getTreeParent();
        }
        return object;
    }

    public static DataTreeInterface getAncestor(DataTreeInterface dataTreeInterface) {
        return DataTreeManager.getAncestor(dataTreeInterface, null);
    }

    public static DataTreeInterface getAncestor(DataTreeInterface dataTreeInterface, Class clazz) {
        if (dataTreeInterface == null) {
            return null;
        }
        DataTreeInterface dataTreeInterface2;
        while ((dataTreeInterface2 = DataTreeManager.getParent(dataTreeInterface)) != null) {
            if (clazz != null) {
                if (clazz.isAssignableFrom(dataTreeInterface.getClass())) {
                    return dataTreeInterface;
                }
                if (clazz.isAssignableFrom(dataTreeInterface2.getClass())) {
                    return dataTreeInterface2;
                }
            }
            if (DataTreeManager.getParent(dataTreeInterface2) == null) {
                return dataTreeInterface;
            }
            dataTreeInterface = dataTreeInterface2;
        }
        return dataTreeInterface;
    }

    public static DataTreeInterface getAncestorNull(DataTreeInterface dataTreeInterface, Class clazz) {
        DataTreeInterface dataTreeInterface2 = DataTreeManager.getAncestor(dataTreeInterface, clazz);
        if (dataTreeInterface2 != null && clazz.isAssignableFrom(dataTreeInterface2.getClass())) {
            return dataTreeInterface2;
        }
        return null;
    }

    public static DataTreeInterface getChildByName(DataTreeInterface dataTreeInterface, String string) {
        if (EvinceScriptCommands.removeSpace(dataTreeInterface.toString().toLowerCase()).equalsIgnoreCase(EvinceScriptCommands.removeSpace(string))) {
            return dataTreeInterface;
        }
        int n = dataTreeInterface.getTreeNodeCount();
        for (int i = 0; i < n; ++i) {
            DataTreeInterface dataTreeInterface2 = dataTreeInterface.getTreeNodeAt(i);
            DataTreeInterface dataTreeInterface3 = DataTreeManager.getChildByName(dataTreeInterface2, string);
            if (dataTreeInterface3 == null) continue;
            return dataTreeInterface3;
        }
        return null;
    }

    public static DataTreeInterface getRoot(DataTreeInterface dataTreeInterface) {
        DataTreeInterface dataTreeInterface2;
        while ((dataTreeInterface2 = DataTreeManager.getParent(dataTreeInterface)) != null) {
            dataTreeInterface = dataTreeInterface2;
        }
        return dataTreeInterface;
    }

    public static AbstractDataNode getScriptParent(DataTreeInterface dataTreeInterface) {
        DataTreeInterface dataTreeInterface2 = dataTreeInterface.getTreeParent();
        if (dataTreeInterface2 instanceof AbstractDataNode) {
            AbstractDataNode abstractDataNode = (AbstractDataNode)dataTreeInterface2;
            if (abstractDataNode.getType() != -1) {
                return abstractDataNode;
            }
            return DataTreeManager.getScriptParent(abstractDataNode);
        }
        return null;
    }

    public static int getStartIndex(DataTreeInterface dataTreeInterface, Class clazz, Class clazz2) {
        DataTreeInterface dataTreeInterface2 = dataTreeInterface.getTreeParent();
        int n = 0;
        for (int i = 0; i < dataTreeInterface2.getTreeNodeCount(); ++i) {
            if (!clazz.equals(dataTreeInterface2.getTreeNodeAt(i).getClass())) continue;
            if (dataTreeInterface.equals(dataTreeInterface2.getTreeNodeAt(i))) {
                return n;
            }
            n += DataTreeManager.getTreeNodeCount(dataTreeInterface2.getTreeNodeAt(i), clazz2);
        }
        return -1;
    }

    public static int getTreeNodeCount(DataTreeInterface dataTreeInterface, Class clazz) {
        int n = 0;
        for (int i = 0; i < dataTreeInterface.getTreeNodeCount(); ++i) {
            if (!clazz.equals(dataTreeInterface.getTreeNodeAt(i).getClass())) continue;
            ++n;
        }
        return n;
    }

    public static String getUniqueName(DataTreeInterface dataTreeInterface, String string) {
        int n = dataTreeInterface.getTreeNodeCount();
        if (n == 0) {
            return string;
        }
        int n2 = string.length();
        boolean bl = false;
        int n3 = 1;
        for (int i = 0; i < n; ++i) {
            Case case_;
            String string2 = dataTreeInterface.getTreeNodeAt(i).toString();
            DataTreeInterface dataTreeInterface2 = dataTreeInterface.getTreeNodeAt(i);
            if (dataTreeInterface2 instanceof Case && (case_ = (Case)dataTreeInterface2).getOriginalMatrix() != null) {
                string2 = case_.getOriginalMatrix().toString();
            }
            if (!string2.startsWith(string)) continue;
            bl = true;
            int n4 = string2.indexOf(40, n2) + 1;
            int n5 = string2.indexOf(41, n2);
            if (n4 <= 0 || n5 <= n4) continue;
            try {
                int n6 = Integer.parseInt(string2.substring(n4, n5));
                if (n6 < n3) continue;
                n3 = n6 + 1;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (bl) {
            return string + " (" + n3 + ")";
        }
        return string;
    }

    public static final int incSaveIndex() {
        return globalsaveindex++;
    }

    public static int indexOfTreeNode(DataTreeInterface dataTreeInterface, DataTreeInterface dataTreeInterface2, Class clazz) {
        int n = 0;
        for (int i = 0; i < dataTreeInterface.getTreeNodeCount(); ++i) {
            if (!clazz.equals(dataTreeInterface.getTreeNodeAt(i).getClass())) continue;
            if (dataTreeInterface2.equals(dataTreeInterface.getTreeNodeAt(i))) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static boolean isOrigMatrixLayer(DataTreeInterface dataTreeInterface) {
        AbstractDataMatrix abstractDataMatrix;
        Case case_ = (Case)DataTreeManager.getAncestorNull(dataTreeInterface, Case.class);
        if (case_ != null && (abstractDataMatrix = case_.getOriginalMatrix()) != null) {
            return abstractDataMatrix instanceof LayerMatrix || abstractDataMatrix instanceof FrameMatrix;
        }
        return false;
    }

    public static boolean isParentTo(DataTreeInterface dataTreeInterface, DataTreeInterface dataTreeInterface2) {
        if (dataTreeInterface2 == null) {
            return false;
        }
        if (dataTreeInterface2.equals(dataTreeInterface)) {
            return true;
        }
        if (dataTreeInterface2 instanceof AbstractPrediction) {
            return DataTreeManager.isParentTo(dataTreeInterface, ((AbstractPrediction)dataTreeInterface2).getDataSet());
        }
        if (dataTreeInterface2 instanceof FoldMatrix) {
            return DataTreeManager.isParentTo(dataTreeInterface, ((FoldMatrix)dataTreeInterface2).getReferencedMatrix().getTreeParent());
        }
        return DataTreeManager.isParentTo(dataTreeInterface, dataTreeInterface2.getTreeParent());
    }

    public static DataTreeInterface Load(Object object, RandomInputStream randomInputStream) throws IOException, ExtLibException {
        TreeHeader treeHeader = randomInputStream.getCT();
        MapProperty mapProperty = randomInputStream.readNodeProperties();
        DataTreeInterface dataTreeInterface = DataTreeManager.createFromStream(treeHeader.node, treeHeader.type, treeHeader.extlibserial, randomInputStream, mapProperty);
        if (dataTreeInterface != null && mapProperty.hasProperty("childs")) {
            int n = mapProperty.getLVInt();
            for (int i = 0; i < n; ++i) {
                DataTreeInterface dataTreeInterface2 = mapProperty.resolveNodeFromName(object, randomInputStream, "childs" + i);
                if (dataTreeInterface2 == null) continue;
                if (dataTreeInterface2.getTreeParent() == null || dataTreeInterface2.getTreeParent() == dataTreeInterface) {
                    dataTreeInterface.addTreeNode(dataTreeInterface2);
                    continue;
                }
                dataTreeInterface.addShortcut(dataTreeInterface2);
            }
        }
        return dataTreeInterface;
    }

    public static DataTreeInterface LoadFromStream(RandomInputStream randomInputStream) throws IOException, ExtLibException {
        boolean bl;
        DataTreeInterface dataTreeInterface = null;
        do {
            bl = randomInputStream.readBoolean();
            byte by = randomInputStream.readByte();
            byte by2 = randomInputStream.readByte();
            int n = 0;
            if (by == 5) {
                n = randomInputStream.readInt();
            }
            randomInputStream.readByte();
            randomInputStream.setStreamID(randomInputStream.readInt());
            MapProperty mapProperty = randomInputStream.readNodeProperties();
            dataTreeInterface = DataTreeManager.createFromStream(by, by2, n, randomInputStream, mapProperty);
            if (dataTreeInterface != null && mapProperty.hasProperty("childs")) {
                int n2 = mapProperty.getLVInt();
                for (int i = 0; i < n2; ++i) {
                    DataTreeInterface dataTreeInterface2 = mapProperty.resolveNodeFromName(null, randomInputStream, "childs" + i);
                    if (dataTreeInterface2 == null) continue;
                    dataTreeInterface.addTreeNode(dataTreeInterface2);
                }
            }
            if (!(dataTreeInterface instanceof MemoryInterface)) continue;
            ((MemoryInterface)((Object)dataTreeInterface)).LoadIntoMemory(randomInputStream);
        } while (!bl);
        return dataTreeInterface;
    }

    public static void LoadIntoMemory(Project_GUI project_GUI, DataTreeInterface dataTreeInterface, boolean bl) {
        ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(new Object[]{project_GUI, dataTreeInterface, bl}){

            @Override
            public Object doWork() {
                DataTreeManager.LoadIntoMemory((Project_GUI)this.arguments[0], this, (DataTreeInterface)this.arguments[1], (Boolean)this.arguments[2]);
                return null;
            }
        };
        progressManagerImpl.setInfoText("Loading data into memory");
        SwingUtilities.invokeLater(progressManagerImpl);
    }

    public static void LoadIntoMemory(Project_GUI project_GUI, ProgressManager progressManager, DataTreeInterface dataTreeInterface, boolean bl) {
        RandomInputStream randomInputStream;
        if (dataTreeInterface == null) {
            return;
        }
        int n = (int)DataTreeManager.CountDataSizeRecursive(dataTreeInterface, false);
        if (progressManager != null) {
            progressManager.setMaximumAndReset(n + 1);
        }
        if ((randomInputStream = DataTreeManager.LoadIntoMemoryRecursive(project_GUI, progressManager, dataTreeInterface, bl, null)) != null) {
            try {
                randomInputStream.close();
            }
            catch (IOException iOException) {
                ErrorHandler.logAndReportException(iOException);
            }
        }
        if (progressManager != null) {
            progressManager.incStep();
        }
    }

    public static final void printTree(DataTreeInterface dataTreeInterface) {
        System.out.println(dataTreeInterface.getID() + " - " + DataTreeManager.getAbsolutePath(dataTreeInterface));
        for (int i = 0; i < dataTreeInterface.getTreeNodeCount(); ++i) {
            DataTreeManager.printTree(dataTreeInterface.getTreeNodeAt(i));
        }
    }

    public static void SaveMemoryInterface(MemoryInterface memoryInterface, RandomOutputStream randomOutputStream, int n) throws IOException {
        byte by = memoryInterface.getMemoryState();
        if ((by & 1) == 0) {
            memoryInterface.SaveData(randomOutputStream, n);
        } else {
            try {
                File file = memoryInterface.getSaveFile();
                RandomInputStream randomInputStream = randomOutputStream.getSwapFile();
                if (randomInputStream != null && !randomInputStream.getFile().equals(file)) {
                    randomInputStream.close();
                    randomInputStream = null;
                }
                if (randomInputStream == null) {
                    randomInputStream = new RandomInputStream(file, null);
                    randomOutputStream.setSwapFile(randomInputStream);
                }
                long l = randomOutputStream.getFilePointer();
                randomInputStream.copyDataBlock(memoryInterface, randomOutputStream);
                if (randomOutputStream.isStorePosition()) {
                    memoryInterface.setBlockBeginning(l);
                }
            }
            catch (EOFException eOFException) {
                Object object = eOFException.getMessage();
                object = object == null ? memoryInterface.toString() : (String)object + " " + String.valueOf(memoryInterface);
                EOFException eOFException2 = new EOFException((String)object);
                eOFException2.setStackTrace(eOFException.getStackTrace());
                throw eOFException2;
            }
        }
    }

    public static void SaveToStream(DataTreeInterface dataTreeInterface, RandomOutputStream randomOutputStream, int n, boolean bl) throws IOException {
        int n2;
        if (dataTreeInterface.isNode()) {
            for (n2 = 0; n2 < dataTreeInterface.getTreeNodeCount(); ++n2) {
                DataTreeManager.SaveToStream(dataTreeInterface.getTreeNodeAt(n2), randomOutputStream, n, false);
            }
        }
        if (dataTreeInterface.getSaveIndex() < n) {
            randomOutputStream.writeBoolean(bl);
            randomOutputStream.writeByte(dataTreeInterface.getNodeType());
            randomOutputStream.writeByte(dataTreeInterface.getTreeType());
            if (dataTreeInterface.getNodeType() == 5) {
                DataTreeExtLibInterface dataTreeExtLibInterface = (DataTreeExtLibInterface)dataTreeInterface;
                randomOutputStream.writeInt(dataTreeExtLibInterface.getLibrary().getSerial());
            }
            randomOutputStream.writeByte(0);
            if (dataTreeInterface.getID() != null) {
                randomOutputStream.writeInt(dataTreeInterface.getID());
            } else {
                randomOutputStream.writeInt(0);
            }
            randomOutputStream.beginNodeProperty();
            randomOutputStream.writePropertyInt("childs", dataTreeInterface.getTreeNodeCount());
            for (n2 = 0; n2 < dataTreeInterface.getTreeNodeCount(); ++n2) {
                randomOutputStream.writePropertyNode("childs" + n2, dataTreeInterface.getTreeNodeAt(n2));
            }
            dataTreeInterface.SaveProperty(randomOutputStream, n);
            randomOutputStream.endProperty();
            if (dataTreeInterface instanceof MemoryInterface) {
                DataTreeManager.SaveMemoryInterface((MemoryInterface)((Object)dataTreeInterface), randomOutputStream, n);
            }
        }
    }

    private static long CountDataSizeRecursive(DataTreeInterface dataTreeInterface, boolean bl) {
        MemoryInterface memoryInterface;
        if (dataTreeInterface instanceof MemoryInterface && !(memoryInterface = (MemoryInterface)((Object)dataTreeInterface)).isSupportClearMemory() && memoryInterface.isLoaded() == bl) {
            return memoryInterface.getDataSize();
        }
        long l = 0L;
        if (!dataTreeInterface.isCleaned() && dataTreeInterface.isNode()) {
            for (int i = dataTreeInterface.getTreeNodeCount() - 1; i >= 0; --i) {
                l += DataTreeManager.CountDataSizeRecursive(dataTreeInterface.getTreeNodeAt(i), bl);
            }
        }
        return l;
    }

    private static DataTreeInterface createDataGroupValuesFromStream(byte by, RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        return switch (by) {
            case 0 -> new Description(randomInputStream, mapProperty);
            case 1 -> new IncExclude(randomInputStream, mapProperty);
            case 2 -> new Classes(randomInputStream, mapProperty);
            case 11 -> new PredictionClasses(randomInputStream, mapProperty);
            case 10 -> new Transformations(randomInputStream, mapProperty);
            case 3 -> new XYclass(randomInputStream, mapProperty);
            case 4 -> new Train(randomInputStream, mapProperty);
            case 5 -> new Test(randomInputStream, mapProperty);
            case 6 -> new Datatype(randomInputStream, mapProperty);
            case 8 -> new Smiles(randomInputStream, mapProperty);
            case 9 -> new DNAclass(randomInputStream, mapProperty);
            case 12 -> new DataImage(randomInputStream, mapProperty);
            case 13 -> new ProjectLink(randomInputStream, mapProperty);
            default -> throw new IOException(ErrorMessage);
        };
    }

    private static DataTreeInterface createDataInfoFromStream(byte by, RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        return switch (by) {
            case 0 -> new ObservationInfo(randomInputStream, mapProperty);
            case 1 -> new VariablesInfo(randomInputStream, mapProperty);
            default -> throw new IOException(ErrorMessage);
        };
    }

    private static DataTreeInterface createDataSourceFromStream(byte by, RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        return switch (by) {
            case 0 -> new RawDataSource(randomInputStream, mapProperty);
            case 1 -> new MergeDataSource(randomInputStream, mapProperty);
            case 2 -> new DatabaseTableModel(randomInputStream, mapProperty);
            case 3 -> new ProjectDataSource(randomInputStream, mapProperty);
            case 4 -> new OriginalDataSource(randomInputStream, mapProperty);
            case 5 -> new MultiCellIdentifierModel(randomInputStream, mapProperty);
            default -> throw new IOException(ErrorMessage);
        };
    }

    private static DataTreeInterface createFromStream(byte by, byte by2, int n, RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException, ExtLibException {
        return switch (by) {
            case 0 -> DataTreeManager.createNodeFromStream(by2, randomInputStream, mapProperty);
            case 1 -> DataTreeManager.createLeafFromStream(by2, randomInputStream, mapProperty);
            case 2 -> DataTreeManager.createPlotFromStream(by2, randomInputStream, mapProperty);
            case 3 -> DataTreeManager.createPlotWindowFromStream(by2, randomInputStream, mapProperty);
            case 4 -> DataTreeManager.createPlotLayerFromStream(by2, randomInputStream, mapProperty);
            case 5 -> ExtClassLoader.createExtLibNodeFromStream(n, by2, randomInputStream, mapProperty);
            case 6 -> DataTreeManager.createTablesFromStream(by2, randomInputStream, mapProperty);
            case 7 -> DataTreeManager.createTransformFromStream(by2, randomInputStream, mapProperty);
            case 8 -> DataTreeManager.createDataInfoFromStream(by2, randomInputStream, mapProperty);
            case 9 -> DataTreeManager.createDataGroupValuesFromStream(by2, randomInputStream, mapProperty);
            case 10 -> DataTreeManager.createDataSourceFromStream(by2, randomInputStream, mapProperty);
            case 11 -> DataTreeManager.createTableLayerFromStream(by2, randomInputStream, mapProperty);
            case 12 -> DataTreeManager.createHistoryFromStream(by2, randomInputStream, mapProperty);
            default -> throw new IOException(ErrorMessage);
        };
    }

    private static DataTreeInterface createHistoryFromStream(byte by, RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        switch (by) {
            case 0: {
                return new HistoryManager(randomInputStream, mapProperty);
            }
            case 1: {
                return new DataSetHistoryNode(randomInputStream, mapProperty);
            }
        }
        throw new IOException(ErrorMessage);
    }

    private static DataTreeInterface createLeafFromStream(byte by, RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        return switch (by) {
            case 1 -> new ModelMatrix(randomInputStream, mapProperty);
            case 0 -> new MVmatrix(randomInputStream, mapProperty);
            case 2 -> new MatrixContainer(randomInputStream, mapProperty);
            case 3 -> new SparseMatrix(randomInputStream, mapProperty);
            case 4 -> new ReferenceMatrix(randomInputStream, mapProperty);
            case 5 -> new DataSetMatrix(randomInputStream, mapProperty);
            case 6 -> new TransformMatrix(randomInputStream, mapProperty);
            case 7 -> new DataSourceMatrix(randomInputStream, mapProperty);
            case 8 -> new LayerMatrix(randomInputStream, mapProperty);
            case 9 -> new FoldMatrix(randomInputStream, mapProperty);
            case 10 -> new TransformedReferenceMatrix(randomInputStream, mapProperty);
            case 11 -> new OriginalData(randomInputStream, mapProperty);
            case 12 -> new MVmatrixShort(randomInputStream, mapProperty);
            case 13 -> new MVmatrixFloat(randomInputStream, mapProperty);
            case 14 -> new MVmatrixByte(randomInputStream, mapProperty);
            case 15 -> new NormalizedModelMatrix(randomInputStream, mapProperty);
            case 16 -> new GroupMatrix(randomInputStream, mapProperty);
            case 17 -> new FrameMatrix(randomInputStream, mapProperty);
            default -> throw new IOException(ErrorMessage);
        };
    }

    private static DataTreeInterface createNodeFromStream(byte by, RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        return switch (by) {
            case 0 -> new Case(randomInputStream, mapProperty);
            case 1 -> new DataSet(randomInputStream, mapProperty);
            case 2 -> new DataContainer(randomInputStream, mapProperty);
            case 3 -> new ModelWrapper(randomInputStream, mapProperty);
            case 4 -> new ResourceNode(randomInputStream, mapProperty);
            case 5 -> new ImageResource(randomInputStream, mapProperty);
            case 6 -> new DataSetGroup(randomInputStream, mapProperty);
            case 7 -> new DataSetHierarchy(randomInputStream, mapProperty);
            case 8 -> new OutputClass(randomInputStream, mapProperty);
            default -> throw new IOException(ErrorMessage);
        };
    }

    private static DataTreeInterface createPlotFromStream(byte by, RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        return switch (by) {
            case 0 -> new Scatter2D(randomInputStream, mapProperty);
            case 1 -> new Serie2D(randomInputStream, mapProperty);
            case 2 -> new Scatter3D(randomInputStream, mapProperty);
            case 3 -> new Spectral2D(randomInputStream, mapProperty);
            case 4 -> new Contour3D(randomInputStream, mapProperty);
            case 5 -> new Histogram2D(randomInputStream, mapProperty);
            case 6 -> new PlotContainer(randomInputStream, mapProperty);
            case 7 -> new Dendogram(randomInputStream, mapProperty);
            case 8 -> new Pie2D(randomInputStream, mapProperty);
            case 9 -> new Contour2D(randomInputStream, mapProperty);
            case 10 -> new Contribution(randomInputStream, mapProperty);
            case 11 -> new QuickSpectral(randomInputStream, mapProperty);
            case 12 -> new Scatter2DBiPlot(randomInputStream, mapProperty);
            case 13 -> new Radar2D(randomInputStream, mapProperty);
            case 14 -> new Design2D(randomInputStream, mapProperty);
            case 15 -> new Cube3D(randomInputStream, mapProperty);
            case 16 -> new Box2D(randomInputStream, mapProperty);
            default -> throw new IOException(ErrorMessage);
        };
    }

    private static DataTreeInterface createPlotLayerFromStream(byte by, RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        return switch (by) {
            case 0 -> new ScatterLayer(randomInputStream, mapProperty);
            case 1 -> new SerieLayer(randomInputStream, mapProperty);
            case 2 -> new Scatter3DLayer(randomInputStream, mapProperty);
            case 3 -> new SpectralLayer(randomInputStream, mapProperty);
            case 5 -> new Contour3DLayer(randomInputStream, mapProperty);
            case 6 -> new HistogramLayer(randomInputStream, mapProperty);
            case 7 -> new DendogramLayer(randomInputStream, mapProperty);
            case 8 -> new PieLayer(randomInputStream, mapProperty);
            case 9 -> new Contour2DLayer(randomInputStream, mapProperty);
            case 10 -> new ContributionLayer(randomInputStream, mapProperty);
            case 11 -> new ContourAccessorPanel(randomInputStream, mapProperty);
            case 12 -> new QuickSpectralLayer(randomInputStream, mapProperty);
            case 13 -> new RadarLayer(randomInputStream, mapProperty);
            case 14 -> new DesignLayer(randomInputStream, mapProperty);
            case 15 -> new Cube3DLayer(randomInputStream, mapProperty);
            case 16 -> new BoxLayer(randomInputStream, mapProperty);
            default -> throw new IOException(ErrorMessage);
        };
    }

    private static DataTreeInterface createPlotWindowFromStream(byte by, RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        return switch (by) {
            case 0 -> new FloatTextWindow(randomInputStream, mapProperty);
            case 1 -> new LegendWindow(randomInputStream, mapProperty);
            case 2 -> new FloatWindowScatter(randomInputStream, mapProperty);
            case 3 -> new FloatWindowSerie(randomInputStream, mapProperty);
            case 4 -> new FloatWindowScatter3D(randomInputStream, mapProperty);
            case 5 -> new FloatWindowSpectral(randomInputStream, mapProperty);
            case 21 -> new FloatWindowSpectralSingle(randomInputStream, mapProperty);
            case 7 -> new FloatWindowContour3D(randomInputStream, mapProperty);
            case 8 -> new FloatWindowHistogram(randomInputStream, mapProperty);
            case 9 -> new FloatWindowDendogram(randomInputStream, mapProperty);
            case 10 -> new FloatWindowPie(randomInputStream, mapProperty);
            case 11 -> new FloatWindowContour2D(randomInputStream, mapProperty);
            case 12 -> new FloatWindowContribution(randomInputStream, mapProperty);
            case 13 -> new DescriptionTextBox(randomInputStream, mapProperty);
            case 14 -> new FloatWindowQuickSpectral(randomInputStream, mapProperty);
            case 15 -> new FloatImageWindow(randomInputStream, mapProperty);
            case 16 -> new SwitchTextBox(randomInputStream, mapProperty);
            case 17 -> new FloatWindowScatterBiPlot(randomInputStream, mapProperty);
            case 18 -> new FloatWindowRadar(randomInputStream, mapProperty);
            case 19 -> new FloatWindowDesign(randomInputStream, mapProperty);
            case 20 -> new FloatWindowCube3D(randomInputStream, mapProperty);
            case 22 -> new FloatWindowBox(randomInputStream, mapProperty);
            default -> throw new IOException(ErrorMessage);
        };
    }

    private static DataTreeInterface createTableLayerFromStream(byte by, RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        return switch (by) {
            case 0 -> new DataGroupLayer(randomInputStream, mapProperty);
            case 1 -> new DescriptionLayer(randomInputStream, mapProperty);
            default -> throw new IOException(ErrorMessage);
        };
    }

    private static DataTreeInterface createTablesFromStream(byte by, RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        return switch (by) {
            case 0 -> new QuickTable(randomInputStream, mapProperty);
            case 1 -> new SparseTable(randomInputStream, mapProperty);
            case 2 -> new DataSetTable(randomInputStream, mapProperty);
            case 3 -> new IntervallTable(randomInputStream, mapProperty);
            case 4 -> new ModelTable(randomInputStream, mapProperty);
            default -> throw new IOException(ErrorMessage);
        };
    }

    private static DataTreeInterface createTransformFromStream(byte by, RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        return switch (by) {
            case 0 -> new TCenter(randomInputStream, mapProperty);
            case 1 -> new TUVScale(randomInputStream, mapProperty);
            case 4 -> new Category(randomInputStream, mapProperty);
            case 13 -> new AddedValue(randomInputStream, mapProperty);
            case 2 -> new InteractionTerm(randomInputStream, mapProperty);
            case 3 -> new QuadTerm(randomInputStream, mapProperty);
            case 5 -> new LayerContainer(randomInputStream, mapProperty);
            case 6 -> new Function(randomInputStream, mapProperty);
            case 7 -> new Logarithm(randomInputStream, mapProperty);
            case 8 -> new MscTransform(randomInputStream, mapProperty);
            case 10 -> new Savitzky(randomInputStream, mapProperty);
            case 9 -> new Derivative(randomInputStream, mapProperty);
            case 11 -> new SnvTransform(randomInputStream, mapProperty);
            case 12 -> new ReduceToAverage(randomInputStream, mapProperty);
            case 14 -> new BaseLineCorrection(randomInputStream, mapProperty);
            case 15 -> new ContinuumRemovalTransform(randomInputStream, mapProperty);
            default -> throw new IOException(ErrorMessage);
        };
    }

    private static DataTreeInterface getParent(DataTreeInterface dataTreeInterface) {
        if (dataTreeInterface instanceof AbstractPrediction && ((AbstractPrediction)dataTreeInterface).isExternal()) {
            return ((AbstractPrediction)dataTreeInterface).getDataSet();
        }
        if (dataTreeInterface instanceof FoldMatrixInterface) {
            return ((FoldMatrixInterface)((Object)dataTreeInterface)).getReferencedMatrix();
        }
        return dataTreeInterface.getTreeParent();
    }

    private static synchronized RandomInputStream LoadIntoMemoryRecursive(Project_GUI project_GUI, ProgressManager progressManager, DataTreeInterface dataTreeInterface, boolean bl, RandomInputStream randomInputStream) {
        block7: {
            MemoryInterface memoryInterface;
            byte by;
            if (dataTreeInterface instanceof MemoryInterface && ((by = (memoryInterface = (MemoryInterface)((Object)dataTreeInterface)).getMemoryState()) & 1) == 1 && (bl || !memoryInterface.isSupportClearMemory())) {
                try {
                    if (randomInputStream != null && !randomInputStream.getFile().equals(memoryInterface.getSaveFile())) {
                        randomInputStream.close();
                        randomInputStream = null;
                    }
                    if (randomInputStream == null) {
                        randomInputStream = new RandomInputStream(project_GUI, memoryInterface.getSaveFile(), progressManager);
                    }
                    memoryInterface.LoadIntoMemory(randomInputStream);
                }
                catch (IOException iOException) {
                    ErrorHandler.logAndReportException("Cannot load data into memory (" + String.valueOf(dataTreeInterface) + "), data will be cleaned", iOException);
                    dataTreeInterface.cleanUp();
                    if (dataTreeInterface.getTreeParent() == null) break block7;
                    dataTreeInterface.getTreeParent().removeTreeNode(dataTreeInterface);
                }
            }
        }
        if (!dataTreeInterface.isCleaned() && dataTreeInterface.isNode()) {
            for (int i = dataTreeInterface.getTreeNodeCount() - 1; i >= 0; --i) {
                randomInputStream = DataTreeManager.LoadIntoMemoryRecursive(project_GUI, progressManager, dataTreeInterface.getTreeNodeAt(i), bl, randomInputStream);
            }
        }
        return randomInputStream;
    }

    public void updateGraph() {
        if (this.graphManager != null) {
            this.graphManager.updateGraph();
        }
    }

    public DataTreeManager(boolean bl) {
        this(bl, 0);
    }

    public DataTreeManager(boolean bl, int n) {
        super("DataTreeManager");
        this.islocal = bl;
        this.maxnumber = n;
        this.historyTimer.setRepeats(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Integer addUniqueID(Integer n, DataTreeInterface dataTreeInterface) {
        ArrayList<IDItems> arrayList = this.randomList;
        synchronized (arrayList) {
            int n2;
            if (n == null) {
                n = this.removeList.isEmpty() ? Integer.valueOf(this.maxnumber++) : this.removeList.removeFirst();
            }
            IDItems iDItems = new IDItems(n, dataTreeInterface);
            if (iDItems.ID >= this.maxnumber) {
                this.maxnumber = iDItems.ID + 1;
            }
            if ((n2 = Collections.binarySearch(this.randomList, iDItems, this.sortedIDComparator)) >= 0) {
                iDItems.setID(this.maxnumber++);
                this.randomList.add(iDItems);
            } else {
                this.randomList.add(-n2 - 1, iDItems);
            }
            return iDItems.ID;
        }
    }

    public synchronized void ClearDataFromMemory(DataTreeInterface dataTreeInterface) {
        ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(new Object[]{dataTreeInterface}){

            @Override
            public Object doWork() {
                DataTreeManager.this.ClearDataFromMemory((DataTreeInterface)this.arguments[0], 0, Long.MAX_VALUE, this);
                System.gc();
                return null;
            }
        };
        progressManagerImpl.setInfoText("Clearing data from memory");
        SwingUtilities.invokeLater(progressManagerImpl);
    }

    public synchronized void ClearDataFromMemory(DataTreeInterface dataTreeInterface, int n, long l, ProgressManager progressManager) {
        try {
            Serializable serializable;
            if (this.swapfile == null) {
                serializable = IniManager.getTempDir();
                this.swapfile = File.createTempFile("swap", ".map", (File)serializable);
                this.swapfile.deleteOnExit();
            }
            if (progressManager != null) {
                progressManager.setMaximumAndReset(0);
            }
            serializable = new RandomOutputStream(this.swapfile, true, progressManager);
            this.ClearDataFromMemory(dataTreeInterface, (RandomOutputStream)serializable, DataTreeManager.incSaveIndex(), n, l);
            ((RandomOutputStream)serializable).close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public synchronized void ClearDataFromMemory(DataTreeInterface dataTreeInterface, ProgressManager progressManager) throws IOException {
        this.ClearDataFromMemory(dataTreeInterface, 0, Long.MAX_VALUE, progressManager);
    }

    public synchronized boolean ClearDataFromMemoryIfExceedPercent(DataTreeInterface dataTreeInterface, ProgressManager progressManager, long l, double d) {
        Runtime runtime = Runtime.getRuntime();
        long l2 = runtime.maxMemory();
        long l3 = runtime.totalMemory();
        long l4 = l3 - runtime.freeMemory();
        double d2 = (double)(l4 + l) / (double)l2;
        if (d2 > d) {
            progressManager.setInfoText("Unloading " + ScriptManager.getType(dataTreeInterface).toLowerCase() + " from memory");
            this.ClearDataFromMemory(dataTreeInterface, 0, Long.MAX_VALUE, progressManager);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DataTreeInterface getDataTreeInterface(int n) {
        this.dummy.ID = n;
        ArrayList<IDItems> arrayList = this.randomList;
        synchronized (arrayList) {
            int n2 = Collections.binarySearch(this.randomList, this.dummy, this.sortedIDComparator);
            if (n2 >= 0) {
                return this.randomList.get((int)n2).node;
            }
        }
        if (this.databaseID == 0 && (n < 0 || n >= 0x1000000)) {
            return DataBaseControl.getDataTreeInterface(n);
        }
        return null;
    }

    public File getFirstSaveFile(DataTreeInterface dataTreeInterface) {
        File file;
        if (dataTreeInterface instanceof MemoryInterface && (file = ((MemoryInterface)((Object)dataTreeInterface)).getSaveFile()) != null) {
            return file;
        }
        if (dataTreeInterface.isNode()) {
            for (int i = 0; i < dataTreeInterface.getTreeNodeCount(); ++i) {
                File file2 = this.getFirstSaveFile(dataTreeInterface.getTreeNodeAt(i));
                if (file2 == null) continue;
                return file2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Integer getId(DataTreeInterface dataTreeInterface) {
        ArrayList<IDItems> arrayList = this.randomList;
        synchronized (arrayList) {
            for (IDItems iDItems : this.randomList) {
                if (iDItems.node != dataTreeInterface) continue;
                return iDItems.ID;
            }
        }
        return null;
    }

    public Project_GUI getProject() {
        return this.project;
    }

    public boolean hasDataMask(DataTreeInterface dataTreeInterface) {
        if (dataTreeInterface == null) {
            return false;
        }
        Integer n = dataTreeInterface.getID();
        return n != null && (n & 0xFF000000) == this.databaseID;
    }

    public void printIdList() {
        for (IDItems iDItems : this.randomList) {
            if (!(iDItems.node instanceof DataContainer)) continue;
            System.out.print("\t");
            System.out.println(iDItems);
        }
    }

    public void printRemovedIdList() {
        Iterator iterator = this.removeList.iterator();
        while (iterator.hasNext()) {
            System.out.print("\t");
            System.out.println(iterator.next());
        }
    }

    public void PropagateAllChanges(DataTreeInterface dataTreeInterface, ProgressManager progressManager) {
        if (dataTreeInterface instanceof PropagationInterface) {
            PropagationInterface propagationInterface = (PropagationInterface)dataTreeInterface;
            propagationInterface.doUpdate(progressManager);
        }
        for (int i = 0; i < dataTreeInterface.getTreeNodeCount(); ++i) {
            this.PropagateAllChanges(dataTreeInterface.getTreeNodeAt(i), progressManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeUniqueID(Integer n) {
        if (n == null) {
            return;
        }
        this.dummy.ID = n;
        ArrayList<IDItems> arrayList = this.randomList;
        synchronized (arrayList) {
            int n2 = Collections.binarySearch(this.randomList, this.dummy, this.sortedIDComparator);
            if (n2 >= 0) {
                this.randomList.remove(n2);
                this.removeList.add(n2);
            }
        }
    }

    public void SaveRoot(DataTreeInterface dataTreeInterface, RandomOutputStream randomOutputStream, int n) throws IOException {
        if (dataTreeInterface.getID() == null) {
            dataTreeInterface.setDataTreeManager(this, false);
        }
        randomOutputStream.setRootID(dataTreeInterface.getID());
        this.Save(dataTreeInterface, randomOutputStream, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DataTreeInterface searchNode(String string) {
        ArrayList<IDItems> arrayList = this.randomList;
        synchronized (arrayList) {
            for (IDItems iDItems : this.randomList) {
                if (!iDItems.node.toString().equals(string)) continue;
                return iDItems.node;
            }
        }
        return null;
    }

    public final void setGraphManager(GraphManager graphManager) {
        this.graphManager = graphManager;
    }

    public final void setHistory(HistoryScrollPane historyScrollPane) {
        this.history = historyScrollPane;
    }

    public void setProject(Project_GUI project_GUI) {
        this.project = project_GUI;
    }

    public void setProjectChanged() {
        if (this.project != null) {
            this.project.setProjectChanged();
        }
    }

    public void setSaveFile(DataTreeInterface dataTreeInterface, File file) {
        if (dataTreeInterface instanceof MemoryInterface) {
            ((MemoryInterface)((Object)dataTreeInterface)).setSaveFile(file);
        }
        if (dataTreeInterface.isNode()) {
            for (int i = 0; i < dataTreeInterface.getTreeNodeCount(); ++i) {
                this.setSaveFile(dataTreeInterface.getTreeNodeAt(i), file);
            }
        }
    }

    public final Integer setUniqueRoot(DataTreeInterface dataTreeInterface) {
        return this.addUniqueID(null, dataTreeInterface);
    }

    public void touchSwapFile() {
        if (this.swapfile != null) {
            this.swapfile.setLastModified(System.currentTimeMillis());
        }
    }

    public final void updateHistory() {
        this.historyTimer.restart();
    }

    @Override
    protected void cleanUpChild() {
        while (!this.randomList.isEmpty()) {
            IDItems iDItems = this.randomList.get(0);
            if (iDItems.node == null) {
                this.randomList.remove(0);
                continue;
            }
            if (iDItems.node.cleanUp()) {
                this.randomList.remove(0);
            }
            iDItems.node = null;
        }
        this.removeList.clear();
        this.maxnumber = 0;
    }

    private void ClearDataFromMemory(DataTreeInterface dataTreeInterface, RandomOutputStream randomOutputStream, int n, int n2, long l) throws IOException {
        if (this.hasDataMask(dataTreeInterface)) {
            MemoryInterface memoryInterface;
            if (dataTreeInterface.getSaveIndex() < n && dataTreeInterface instanceof MemoryInterface && (memoryInterface = (MemoryInterface)((Object)dataTreeInterface)).isLoaded() && memoryInterface.isSupportClearMemory() && !memoryInterface.isCalculating() && memoryInterface.getDataSize() >= n2 && memoryInterface.getLastUsed() <= l) {
                memoryInterface.SaveData(randomOutputStream, n);
                memoryInterface.ClearFromMemory();
            }
            if (dataTreeInterface.isNode()) {
                for (int i = 0; i < dataTreeInterface.getTreeNodeCount(); ++i) {
                    this.ClearDataFromMemory(dataTreeInterface.getTreeNodeAt(i), randomOutputStream, n, n2, l);
                }
            }
        }
    }

    private void Save(DataTreeInterface dataTreeInterface, RandomOutputStream randomOutputStream, int n) throws IOException {
        if (this.hasDataMask(dataTreeInterface)) {
            if (dataTreeInterface.isCleaned()) {
                System.out.println("Trying to save cleaned child: " + String.valueOf(dataTreeInterface));
                return;
            }
            if (dataTreeInterface.getSaveIndex() < n) {
                TreeHeader treeHeader = new TreeHeader(dataTreeInterface);
                treeHeader.save(randomOutputStream);
                randomOutputStream.beginNodeProperty();
                if (!(dataTreeInterface instanceof LayerContainer) || !((LayerContainer)dataTreeInterface).isShortcut()) {
                    randomOutputStream.writePropertyInt("childs", dataTreeInterface.getTreeNodeCount());
                    for (int i = 0; i < dataTreeInterface.getTreeNodeCount(); ++i) {
                        randomOutputStream.writePropertyNode("childs" + i, dataTreeInterface.getTreeNodeAt(i));
                    }
                }
                dataTreeInterface.SaveProperty(randomOutputStream, n);
                randomOutputStream.endProperty();
                if (dataTreeInterface instanceof MemoryInterface) {
                    DataTreeManager.SaveMemoryInterface((MemoryInterface)((Object)dataTreeInterface), randomOutputStream, n);
                }
                treeHeader.writeCRC(randomOutputStream);
            }
            if (dataTreeInterface.isNode()) {
                for (int i = 0; i < dataTreeInterface.getTreeNodeCount(); ++i) {
                    this.Save(dataTreeInterface.getTreeNodeAt(i), randomOutputStream, n);
                }
            }
        }
    }

    static class SortedIDComparator
    implements Comparator<IDItems> {
        SortedIDComparator() {
        }

        @Override
        public int compare(IDItems iDItems, IDItems iDItems2) {
            return Double.compare(iDItems.ID, iDItems2.ID);
        }
    }

    class IDItems {
        private int ID;
        private DataTreeInterface node;

        public IDItems() {
        }

        public IDItems(int n, DataTreeInterface dataTreeInterface) {
            if (DataTreeManager.this.islocal) {
                this.setID(n);
            } else {
                this.ID = n;
            }
            this.node = dataTreeInterface;
        }

        public String toString() {
            return this.ID + " " + this.node.toString();
        }

        private void setID(int n) {
            this.ID = n & 0xFFFFFF | DataTreeManager.this.databaseID;
        }
    }
}

