/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JPopupMenu;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.DataTreeClass;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.MemoryInterface;
import se.prediktera.map.main.Project_GUI;

public abstract class DataTreeMemoryClass
extends DataTreeClass
implements MemoryInterface {
    protected int iscalculating = 0;
    private long blockBegin;
    private byte memorystate = 1;
    private File saveFile;
    private long lastused;

    public DataTreeMemoryClass(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.saveFile = randomInputStream.getFile();
        this.blockBegin = randomInputStream.getFilePointer();
        this.memorystate = mapProperty.getPropertyByte("memstate");
        this.addMemoryState((byte)1);
    }

    public DataTreeMemoryClass(String string) {
        super(string);
        this.memorystate = 0;
    }

    public void addMemoryState(byte by) {
        if (!this.isMemoryState(by)) {
            this.memorystate = (byte)(this.memorystate + by);
        }
    }

    @Override
    public boolean addToPopup(Project_GUI project_GUI, DataTreeInterface dataTreeInterface, Point point, JPopupMenu jPopupMenu, boolean bl) {
        if (!bl && this.isSupportClearMemory() && !this.isCalculating()) {
            if (this.isMemoryState((byte)1)) {
                jPopupMenu.add(new CMenuItem("Load into Memory", true){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DataTreeManager.LoadIntoMemory(null, DataTreeMemoryClass.this, true);
                    }
                });
            } else {
                jPopupMenu.add(new CMenuItem("Free from Memory", true){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DataTreeMemoryClass.this.dataTreeManager.ClearDataFromMemory(DataTreeMemoryClass.this);
                    }
                });
            }
        }
        return true;
    }

    @Override
    public void beginCalculations() {
        super.beginCalculations();
        if (this.isMemoryState((byte)1)) {
            DataTreeManager.LoadIntoMemory(null, null, this, true);
        }
        ++this.iscalculating;
    }

    public void changeState(ProgressManager progressManager, String string, Properties properties) {
        if (string.equalsIgnoreCase("unload")) {
            DataTreeManager dataTreeManager = this.getDataTreeManager();
            dataTreeManager.ClearDataFromMemory(this);
        } else if (string.equalsIgnoreCase("load")) {
            DataTreeManager.LoadIntoMemory(null, this, true);
        } else {
            throw new RuntimeException("State is not supported: " + string);
        }
    }

    @Override
    public void ClearFromMemory() throws IOException {
        this.ClearDataLocal();
        this.addMemoryState((byte)1);
    }

    @Override
    public void endCalculations() {
        super.endCalculations();
        --this.iscalculating;
        if (this.iscalculating <= 0) {
            this.lastused = System.currentTimeMillis();
            this.iscalculating = 0;
        }
    }

    @Override
    public long getBlockBegin() {
        return this.blockBegin;
    }

    @Override
    public int getDataByteSize() {
        return 800;
    }

    @Override
    public int getDataSize() {
        return 100;
    }

    @Override
    public long getLastUsed() {
        return this.lastused;
    }

    @Override
    public byte getMemoryState() {
        return this.memorystate;
    }

    public String getMemoryStateDescr() {
        return STATE_DESCR[this.memorystate];
    }

    @Override
    public File getSaveFile() {
        return this.saveFile;
    }

    @Override
    public boolean isCalculating() {
        return this.iscalculating > 0;
    }

    @Override
    public boolean isLoaded() {
        return this.memorystate == 0;
    }

    @Override
    public boolean isMemoryState(byte by) {
        return (this.memorystate & by) == by;
    }

    @Override
    public boolean isSupportClearMemory() {
        return false;
    }

    @Override
    public void LoadIntoMemory(RandomInputStream randomInputStream) throws IOException {
        randomInputStream.seek(this.blockBegin);
        if (randomInputStream.beginDataBlock("Loading " + String.valueOf(this) + " into memory", false)) {
            this.removeMemoryState((byte)1);
            this.LoadDataLocal(randomInputStream);
            randomInputStream.endDataBlock();
        }
    }

    public void removeMemoryState(byte by) {
        if (this.isMemoryState(by)) {
            this.memorystate = (byte)(this.memorystate - by);
        }
    }

    public void resetMemoryState() {
        this.memorystate = 0;
    }

    @Override
    public void SaveData(RandomOutputStream randomOutputStream, int n) throws IOException {
        this.saveIndex = n;
        if (randomOutputStream.isStorePosition()) {
            this.blockBegin = randomOutputStream.getFilePointer();
            this.saveFile = randomOutputStream.getFile();
        }
        randomOutputStream.beginDataBlock();
        this.SaveDataLocal(randomOutputStream);
        randomOutputStream.endDataBlock();
    }

    @Override
    public void setBlockBeginning(long l) {
        this.blockBegin = l;
    }

    @Override
    public void setSaveFile(File file) {
        this.saveFile = file;
    }

    protected final void checkAndLoadIntoMemory() {
        if (this.iscalculating <= 0) {
            this.lastused = System.currentTimeMillis();
            if (this.isMemoryState((byte)1)) {
                DataTreeManager.LoadIntoMemory(null, null, this, true);
            }
        }
    }

    protected abstract void ClearDataLocal() throws IOException;

    protected abstract void LoadDataLocal(RandomInputStream var1) throws IOException;

    protected abstract void SaveDataLocal(RandomOutputStream var1) throws IOException;

    @Override
    protected void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.writePropertyByte("memstate", this.memorystate);
    }
}

