/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;

public class MVPanel
extends CleanUpPanel {
    private final JSlider jSlider1 = new JSlider();
    private final JScrollPane scrollPane = new JScrollPane();
    private final JLabel mvToleranceLabel = new JLabel();
    private JTable mvTable = null;
    private String title;
    private final JLabel dynInfo = new JLabel();
    private Vector<AbstractDataMatrix.RCinfo> resVector = null;
    private AbstractDataMatrix matrix;
    private String[] descriptions;
    private int checktype = 0;

    public MVPanel() {
        super(new BorderLayout());
        this.jbinit();
    }

    public ArrayList<Integer> generateRemove() {
        int n = this.descriptions.length;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = 0;
        for (int i = 0; i < n && n2 < this.resVector.size(); ++i) {
            AbstractDataMatrix.RCinfo rCinfo = this.resVector.elementAt(n2++);
            if (!rCinfo.excluded) continue;
            arrayList.add(rCinfo.index);
        }
        return arrayList;
    }

    public void setMV(AbstractDataMatrix abstractDataMatrix, String string, int n, String[] stringArray, int n2) {
        this.title = string;
        this.matrix = abstractDataMatrix;
        this.checktype = n;
        this.descriptions = stringArray;
        double d = (double)abstractDataMatrix.getNrMV() / (double)abstractDataMatrix.getMatrixSize() * 100.0;
        this.dynInfo.setText("Total " + (int)d + "% MV (" + abstractDataMatrix.getNrMV() + " elements)");
        this.mvTable = new JTable();
        this.mvTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!mouseEvent.isConsumed()) {
                    JTable jTable = (JTable)mouseEvent.getSource();
                    int n = jTable.columnAtPoint(mouseEvent.getPoint());
                    if (n == 2) {
                        int n2 = jTable.rowAtPoint(mouseEvent.getPoint());
                        AbstractDataMatrix.RCinfo rCinfo = MVPanel.this.resVector.elementAt(n2);
                        rCinfo.excluded = !rCinfo.excluded;
                        MVPanel.this.mvTable.repaint();
                    }
                    mouseEvent.consume();
                }
            }
        });
        this.mvTable.setModel(new TableModel());
        this.mvTable.setRowHeight(22);
        this.mvTable.setDefaultRenderer(JProgressBar.class, new ProgressBarRenderer());
        this.mvTable.setDefaultRenderer(JComboBox.class, new ComboBoxRenderer());
        this.scrollPane.getViewport().setView(this.mvTable);
        this.setTolerance(n2);
    }

    @Override
    protected void cleanUpChild() {
        this.matrix = null;
        this.descriptions = null;
    }

    private void jbinit() {
        this.jSlider1.setMajorTickSpacing(25);
        this.jSlider1.setMinorTickSpacing(5);
        this.jSlider1.setPaintLabels(true);
        this.jSlider1.setPaintTicks(true);
        this.jSlider1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                MVPanel.this.setTolerance(MVPanel.this.jSlider1.getValue());
            }
        });
        this.jSlider1.addChangeListener(new SliderListener());
        JButton jButton = new JButton("Select All");
        JButton jButton2 = new JButton("Clear All");
        jButton.addActionListener(actionEvent -> this.setExclude(true));
        jButton2.addActionListener(actionEvent -> this.setExclude(false));
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1, 5, 5));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel(new BorderLayout());
        JPanel jPanel5 = new JPanel();
        jPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        jPanel3.setBorder(BorderFactory.createEtchedBorder());
        jPanel4.setBorder(EvinceBorderFactory.createEvinceBorder("Missing Value Cutoff"));
        this.mvToleranceLabel.setMinimumSize(new Dimension(50, 17));
        this.mvToleranceLabel.setPreferredSize(new Dimension(70, 17));
        this.mvToleranceLabel.setHorizontalAlignment(0);
        this.mvToleranceLabel.setHorizontalTextPosition(0);
        this.setMaximumSize(new Dimension(300, 320));
        this.setMinimumSize(new Dimension(300, 320));
        this.setPreferredSize(new Dimension(300, 320));
        this.add((Component)jPanel, "Center");
        jPanel.add((Component)jPanel2, "North");
        jPanel2.add((Component)new JLabel("Information"), null);
        jPanel2.add((Component)this.dynInfo, null);
        jPanel.add((Component)jPanel3, "Center");
        jPanel3.add((Component)this.scrollPane, "Center");
        jPanel3.add((Component)jPanel5, "South");
        jPanel5.add((Component)jButton2, null);
        jPanel5.add((Component)jButton, null);
        jPanel.add((Component)jPanel4, "South");
        jPanel4.add((Component)this.jSlider1, "Center");
        jPanel4.add((Component)this.mvToleranceLabel, "East");
    }

    private void setExclude(boolean bl) {
        for (int i = 0; i < this.resVector.size(); ++i) {
            this.resVector.elementAt((int)i).excluded = bl;
        }
        this.mvTable.repaint();
    }

    private void setTolerance(int n) {
        this.mvToleranceLabel.setText(n + "%");
        this.jSlider1.setValue(n);
        this.resVector = this.matrix.missingValueCheck(n, this.checktype == 1);
        this.mvTable.revalidate();
    }

    class TableModel
    extends AbstractTableModel {
        TableModel() {
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return switch (n) {
                case 1 -> JProgressBar.class;
                case 2 -> JComboBox.class;
                default -> String.class;
            };
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int n) {
            return switch (n) {
                case 1 -> "% missing";
                case 2 -> "Exclude";
                default -> MVPanel.this.title;
            };
        }

        @Override
        public int getRowCount() {
            return MVPanel.this.resVector.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            AbstractDataMatrix.RCinfo rCinfo = MVPanel.this.resVector.elementAt(n);
            return switch (n2) {
                case 1 -> (int)rCinfo.MV;
                case 2 -> rCinfo.excluded;
                default -> MVPanel.this.descriptions == null ? String.valueOf(rCinfo.index) : MVPanel.this.descriptions[rCinfo.index];
            };
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    private class ProgressBarRenderer
    extends JProgressBar
    implements TableCellRenderer {
        public ProgressBarRenderer() {
            super(0, 100);
            this.setBorder(null);
            this.setForeground(Color.red);
            this.setBackground(Color.white);
            this.setStringPainted(true);
            this.setBorderPainted(false);
            this.setPreferredSize(new Dimension(0, 18));
            this.setFont(new Font("Serif", 1, 10));
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setValue((Integer)object);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(Color.white);
            }
            return this;
        }
    }

    private class ComboBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public ComboBoxRenderer() {
            this.setBackground(Color.white);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setSelected((Boolean)object);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(Color.white);
            }
            return this;
        }
    }

    class SliderListener
    implements ChangeListener {
        SliderListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (object instanceof JSlider) {
                JSlider jSlider = (JSlider)object;
                MVPanel.this.mvToleranceLabel.setText(jSlider.getValue() + "%");
            }
        }
    }
}

