/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.classes;

import java.awt.Color;
import java.io.IOException;
import java.util.Arrays;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.cleanup.CleanUpVector;
import se.prediktera.map.datasetcontainer.classes.ClassSettings;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.plot.axisplot.settings.Color.PerfectSpread;

public class ClassTypes
extends CleanUpVector<ClassSettings> {
    private InnerColumnClass ic;

    private static int compareStringOrNumber(String string, String string2) {
        if (string != null && string2 != null) {
            try {
                double d = Double.parseDouble(string);
                Double d2 = Double.valueOf(string2);
                return Double.compare(d, d2);
            }
            catch (NumberFormatException numberFormatException) {
                return string.compareTo(string2);
            }
        }
        return 0;
    }

    public ClassTypes() {
    }

    public ClassTypes(InnerColumnClass innerColumnClass) {
        this.ic = innerColumnClass;
        this.add(new ClassSettings("-", this.size()));
    }

    public final void addSorted(String string) {
        if (this.getTypeDescriptionIndex(string) < 0) {
            boolean bl = false;
            for (int i = 0; i < this.size() && !bl; ++i) {
                if (ClassTypes.compareStringOrNumber(((ClassSettings)this.get(i)).getName(), string) <= 0) continue;
                this.add(i, new ClassSettings(string, this.size()));
                bl = true;
            }
            if (!bl) {
                this.add(new ClassSettings(string, this.size()));
            }
        }
    }

    public final short addString(String string) {
        this.add(new ClassSettings(string, this.size()));
        this.ic.endUpdate((byte)3);
        return (short)(this.size() - 1);
    }

    public final short addString(String string, boolean bl) {
        short s = -1;
        if (bl) {
            s = this.getTypeDescriptionIndex(string);
        }
        if (s < 0) {
            s = this.addString(string);
        }
        return s;
    }

    public final short addStringNoEvent(String string) {
        return this.addStringNoEvent(string, null);
    }

    public final short addStringNoEvent(String string, Color color) {
        this.add(new ClassSettings(string, this.size(), color));
        return (short)(this.size() - 1);
    }

    public final short addType() {
        this.add(new ClassSettings(String.valueOf(this.size()), this.size()));
        this.ic.endUpdate((byte)3);
        return (short)(this.size() - 1);
    }

    public final Object clone(InnerColumnClass innerColumnClass) {
        ClassTypes classTypes = (ClassTypes)this.clone();
        classTypes.ic = innerColumnClass;
        return classTypes;
    }

    @Override
    public final boolean equals(Object object) {
        if (object instanceof ClassTypes) {
            ClassTypes classTypes = (ClassTypes)object;
            if (this.ic != null) {
                return this.ic.equals(classTypes.ic);
            }
        }
        return super.equals(object);
    }

    public final ClassSettings getClassSettings(int n) {
        if (n >= 0 && n < this.size()) {
            return (ClassSettings)this.get(n);
        }
        return null;
    }

    public final ClassSettings getClassSettingsByName(String string) {
        for (int i = 0; i < this.size(); ++i) {
            ClassSettings classSettings = (ClassSettings)this.get(i);
            if (!classSettings.getName().equalsIgnoreCase(string)) continue;
            return classSettings;
        }
        return null;
    }

    public final ClassSettings getClassSettingsByRefIndex(int n) {
        for (int i = 0; i < this.size(); ++i) {
            ClassSettings classSettings = (ClassSettings)this.get(i);
            if (classSettings.getRefindex() != n) continue;
            return classSettings;
        }
        return null;
    }

    public final Color getColor(int n) {
        ClassSettings classSettings = this.getClassSettings(n);
        if (classSettings != null) {
            return classSettings.getColor();
        }
        return null;
    }

    public final int getSize(boolean bl) {
        int n = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (!bl && this.getTypeDescription(i).equals("-")) continue;
            ++n;
        }
        return n;
    }

    public final String getTypeDescription(int n) {
        String string = this.getTypeDescriptionNull(n);
        if (string == null) {
            return "No class";
        }
        return string;
    }

    public final short getTypeDescriptionIndex(String string) {
        for (short s = 0; s < this.size(); s = (short)(s + 1)) {
            if (!this.getTypeDescription(s).equalsIgnoreCase(string)) continue;
            return s;
        }
        return -1;
    }

    public final String getTypeDescriptionNull(int n) {
        if (n >= 0 && n < this.size()) {
            return ((ClassSettings)this.get(n)).getName();
        }
        return null;
    }

    public final boolean hasTypeDescription(String string) {
        return this.getTypeDescriptionIndex(string) >= 0;
    }

    @Override
    public final int indexOf(Object object) {
        return super.indexOf(object);
    }

    public final void LoadData(RandomInputStream randomInputStream, int n) throws IOException {
        this.clear();
        int n2 = randomInputStream.ReadBlockInt();
        for (int i = 0; i < n2; ++i) {
            String string = randomInputStream.ReadBlockUTF();
            int n3 = i;
            Color color = PerfectSpread.generateColor(i);
            if (n >= 3) {
                n3 = randomInputStream.ReadBlockInt();
                int n4 = randomInputStream.ReadBlockInt();
                color = new Color(n4);
            }
            ClassSettings classSettings = new ClassSettings(string, n3, color);
            this.add(classSettings);
        }
    }

    public final void SaveData(RandomOutputStream randomOutputStream, int n) throws IOException {
        randomOutputStream.WriteBlockInt(this.size());
        for (int i = 0; i < this.size(); ++i) {
            ClassSettings classSettings = (ClassSettings)this.get(i);
            randomOutputStream.WriteBlockUTF(classSettings.getName());
            randomOutputStream.WriteBlockInt(classSettings.getRefindex());
            Color color = classSettings.getColor();
            randomOutputStream.WriteBlockInt(color != null ? color.getRGB() : Color.white.getRGB());
        }
    }

    public final void setTypeDescription(int n, String string) {
        ClassSettings classSettings = (ClassSettings)this.get(n);
        classSettings.setName(string);
        this.ic.endUpdate((byte)3);
    }

    public final void sortStringListToClassOrder(String[] stringArray) {
        Arrays.sort(stringArray, (string, string2) -> {
            ClassSettings classSettings = this.getClassSettingsByName((String)string);
            ClassSettings classSettings2 = this.getClassSettingsByName((String)string2);
            if (classSettings != null && classSettings2 != null) {
                return Float.compare(classSettings.getRefindex(), classSettings2.getRefindex());
            }
            return 0;
        });
    }

    @Override
    public final String toString() {
        if (this.ic == null) {
            return "N/A";
        }
        return this.ic.toString();
    }

    @Override
    protected final void cleanUpChild() {
        this.ic = null;
    }

    public Color[] createColorArray() {
        Color[] colorArray = new Color[this.size()];
        for (int i = 0; i < colorArray.length; ++i) {
            ClassSettings classSettings = this.getClassSettings(i);
            colorArray[i] = classSettings.getColor();
        }
        return colorArray;
    }
}

