/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.classes;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Properties;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataimport.AbstractDataSource;
import se.prediktera.map.datasetcontainer.classes.ClassSettings;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.datainfo.DataGroupValues;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnShort;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.transform.category.Category;
import se.prediktera.map.datasetcontainer.transform.category.DataInfoClassEvent;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.main.script.StringDataClass;
import se.prediktera.map.plot.axisplot.settings.Color.PerfectSpread;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class InnerColumnClass
extends InnerColumnShort {
    private Category category = null;
    private ClassTypes holdObject = null;

    public InnerColumnClass(Category category, String string, DataGroupValues dataGroupValues, CellIdentifierModel cellIdentifierModel, int n) {
        super(string, dataGroupValues, cellIdentifierModel, n);
        this.category = category;
    }

    public ClassSettings addClass(String string, String string2) {
        short s = this.holdObject.addString(string);
        ClassSettings classSettings = this.holdObject.getClassSettings(s);
        classSettings.setColor(PerfectSpread.getColorFromString(string2));
        this.getDataInfo().triggerGlobalEvent(new DataInfoClassEvent(this.getDataInfo(), 0, this.category, this.holdObject, 0));
        this.category.updateClasses();
        return classSettings;
    }

    @Override
    public AbstractInnerColumn<Integer> clone(DataGroupValues dataGroupValues) {
        InnerColumnClass innerColumnClass = (InnerColumnClass)super.clone(dataGroupValues);
        ClassTypes classTypes = this.getObject();
        innerColumnClass.holdObject((ClassTypes)classTypes.clone());
        return innerColumnClass;
    }

    public int[] countClasses() {
        int n = this.getSize();
        ClassTypes classTypes = this.getObject();
        int[] nArray = new int[classTypes.size()];
        for (int i = 0; i < n; ++i) {
            short s;
            short s2 = s = this.getValueShort(i);
            nArray[s2] = nArray[s2] + 1;
        }
        return nArray;
    }

    public Object createCategory(ProgressManager progressManager, DataSet dataSet) throws Exception {
        return null;
    }

    public void fillColumn(short s) {
        int n = this.getSize();
        for (int i = 0; i < n; ++i) {
            this.setValueShort(i, s);
        }
    }

    @Override
    public Object get(String string) throws Exception {
        if (string.equalsIgnoreCase("category")) {
            return this.category;
        }
        return super.get(string);
    }

    public Category getCategory() {
        return this.category;
    }

    public StringDataClass getClass(Double d) {
        int n = d.intValue();
        return new StringDataClass(this.holdObject.getTypeDescription(n));
    }

    public Double getClassCount(String string) {
        short s = this.holdObject.getTypeDescriptionIndex(string);
        return this.countValue(s);
    }

    public Object getClassFromIndex(Double d) throws Exception {
        return this.getClassFromIndex(d, null);
    }

    public Object getClassFromIndex(Double d, Properties properties) throws Exception {
        int n = d.intValue() - 1;
        short s = this.getValueShort(n);
        boolean bl = false;
        if (properties != null && ScriptHelper.hasKey(properties, "clone")) {
            bl = ScriptHelper.getPropertyBool(properties, "clone");
        }
        if (bl) {
            return this.holdObject.getClassSettings(s).clone();
        }
        return this.holdObject.getClassSettings(s);
    }

    public Double[] getClassIndex(String string) {
        int[] nArray = this.getClassIndexInt(string);
        Double[] doubleArray = new Double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            doubleArray[i] = (double)nArray[i] + 1.0;
        }
        return doubleArray;
    }

    public int[] getClassIndexInt(String string) {
        int n;
        short s = this.holdObject.getTypeDescriptionIndex(string);
        int n2 = this.getSize();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            if (this.getValueShort(n) != s) continue;
            ++n3;
        }
        n = 0;
        int[] nArray = new int[n3];
        for (int i = 0; i < n2; ++i) {
            if (this.getValueShort(i) != s) continue;
            nArray[n++] = i;
        }
        return nArray;
    }

    public Object getClassSettings(String string) {
        return this.holdObject.getClassSettingsByName(string);
    }

    public Double getClassSize() throws Exception {
        return this.getClassSize(null);
    }

    public Double getClassSize(Properties properties) throws Exception {
        boolean bl = true;
        if (properties != null && ScriptHelper.hasKey(properties, "includenoclass")) {
            bl = ScriptHelper.getPropertyBool(properties, "includenoclass");
        }
        return this.holdObject.getSize(bl);
    }

    public ClassTypes getHoldObject() {
        return this.holdObject;
    }

    public Double getIndex() {
        if (this.parent != null) {
            return (double)this.parent.getIndexOf(this) + 1.0;
        }
        throw new RuntimeException("Cannot get parent index");
    }

    public ClassTypes getObject() {
        return this.holdObject;
    }

    public void holdObject(ClassTypes classTypes) {
        this.holdObject = classTypes;
    }

    public String[] list() throws Exception {
        return this.list(null);
    }

    public String[] list(Properties properties) throws Exception {
        Object object;
        String[] stringArray = new String[]{};
        if (properties != null && ScriptHelper.hasKey(properties, "exclude")) {
            object = ScriptHelper.getProperty(properties, "exclude");
            stringArray = ((String)object).split(";");
        }
        object = new LinkedList();
        for (int i = 0; i < this.holdObject.size(); ++i) {
            String string = this.holdObject.getTypeDescription(i);
            if (this.checkExclude(string, stringArray)) continue;
            object.add(string);
        }
        String[] stringArray2 = new String[object.size()];
        for (int i = 0; i < object.size(); ++i) {
            stringArray2[i] = (String)object.get(i);
        }
        return stringArray2;
    }

    @Override
    public void LoadLocal(RandomInputStream randomInputStream, int n) throws IOException {
        super.LoadLocal(randomInputStream, n);
        if (!(n <= 0 || this.parent != null && this.parent.isReference())) {
            ClassTypes classTypes = new ClassTypes(this);
            classTypes.LoadData(randomInputStream, n);
            this.holdObject(classTypes);
        }
    }

    public void removeClass(String string) {
        short s = this.holdObject.getTypeDescriptionIndex(string);
        if (s >= 0) {
            this.removeClassByIndex(s);
            this.holdObject.remove(s);
            this.getDataInfo().triggerGlobalEvent(new DataInfoClassEvent(this.getDataInfo(), 0, this.category, this.holdObject, 1));
            this.category.updateClasses();
        }
    }

    public void removeClassByIndex(int n) {
        int n2 = this.getSize();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.getValueLocal(i);
            if (n3 < n) continue;
            if (n3 == n) {
                this.setValueShort(i, (short)0);
                continue;
            }
            this.setValueShort(i, (short)(n3 - 1));
        }
    }

    @Override
    public void SaveLocal(RandomOutputStream randomOutputStream, int n) throws IOException {
        super.SaveLocal(randomOutputStream, n);
        if (!this.parent.isReference()) {
            this.getObject().SaveData(randomOutputStream, n);
        }
    }

    public void setClass(Double[] doubleArray, ClassSettings classSettings) {
        String string = classSettings.getName();
        short s = this.holdObject.getTypeDescriptionIndex(string);
        if (s < 0) {
            this.holdObject.add(new ClassSettings(string, classSettings.getRefindex(), classSettings.getColor()));
            s = (short)(this.holdObject.size() - 1);
            this.category.updateClasses();
        }
        if (doubleArray != null) {
            for (Double d : doubleArray) {
                this.setValueShort(d.intValue() - 1, s);
            }
        } else {
            int n = this.getRowsLocal();
            for (int i = 0; i < n; ++i) {
                this.setValueShort(i, s);
            }
        }
    }

    public void setClass(Double[] doubleArray, String string, boolean bl) {
        short s = this.holdObject.getTypeDescriptionIndex(string);
        if (s < 0) {
            s = this.holdObject.addString(string);
            this.category.updateClasses();
        }
        for (Double d : doubleArray) {
            this.setValueShort(d.intValue() - 1, s);
        }
        if (bl) {
            this.getDataInfo().triggerGlobalEvent(new DataInfoClassEvent(this.getDataInfo(), 0, this.category, this.holdObject, 2));
        }
    }

    public void setClass(int n, String string) {
        short s = this.holdObject.getTypeDescriptionIndex(string);
        if (s < 0) {
            s = this.holdObject.addString(string);
            this.category.updateClasses();
        }
        this.setValueShort(n, s);
    }

    public void setClass(InteractionArray interactionArray, String string) {
        short s = this.holdObject.getTypeDescriptionIndex(string);
        if (s < 0) {
            s = this.holdObject.addString(string);
            this.category.updateClasses();
        }
        for (int i = interactionArray.getFirstSet(); i <= interactionArray.getLastSet(); ++i) {
            if (!interactionArray.get(i)) continue;
            this.setValueShort(i, s);
        }
        this.getDataInfo().triggerGlobalEvent(new DataInfoClassEvent(this.getDataInfo(), 0, this.category, this.holdObject, 2));
    }

    public void setClass(String string) {
        short s = this.holdObject.getTypeDescriptionIndex(string);
        if (s < 0) {
            s = this.holdObject.addString(string);
        }
        int n = this.getSize();
        for (int i = 0; i < n; ++i) {
            this.setValueShort(i, s);
        }
    }

    public void setClassSettings(Double d, String string) {
        this.setClassSettings(d, string, null);
    }

    public void setClassSettings(Double d, String string, String string2) {
        ClassSettings classSettings = this.holdObject.getClassSettings(d.intValue() - 1);
        classSettings.setName(string);
        if (string2 != null) {
            classSettings.setColor(PerfectSpread.getColorFromString(string2));
        }
        this.getDataInfo().triggerGlobalEvent(new DataInfoClassEvent(this.getDataInfo(), 0, this.category, this.holdObject, 2));
    }

    public void setClassSettings(String string, String string2) {
        ClassSettings classSettings = this.holdObject.getClassSettingsByName(string);
        if (classSettings != null) {
            classSettings.setColor(PerfectSpread.getColorFromString(string2));
        }
        this.getDataInfo().triggerGlobalEvent(new DataInfoClassEvent(this.getDataInfo(), 0, this.category, this.holdObject, 2));
    }

    public void swapValues(short s, short s2) {
        int n = this.getSize();
        for (int i = 0; i < n; ++i) {
            short s3 = this.getValueShort(i);
            if (s3 == s) {
                this.setValueShort(i, s2);
                continue;
            }
            if (s3 != s2) continue;
            this.setValueShort(i, s);
        }
        String string = this.holdObject.getTypeDescription(s);
        String string2 = this.holdObject.getTypeDescription(s2);
        this.holdObject.setTypeDescription(s, string2);
        this.holdObject.setTypeDescription(s2, string);
    }

    public void triggerGlobalEvent() {
        this.getDataInfo().triggerGlobalEvent(new DataInfoClassEvent(this.getDataInfo(), 0, this.category, this.holdObject, 2));
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.holdObject = null;
    }

    @Override
    protected AbstractInnerColumn<Integer> createNew(String string, DataGroupValues dataGroupValues, AbstractDataSource abstractDataSource, int n) {
        return new InnerColumnClass(this.category, string, dataGroupValues, abstractDataSource, n);
    }

    private boolean checkExclude(String string, String[] stringArray) {
        for (String string2 : stringArray) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }
}

