/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.classes.prediction;

import java.io.IOException;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataimport.AbstractDataSource;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.classes.ClassSettings;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.classes.prediction.PredictionClasses;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.datainfo.DataGroupValues;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.transform.category.Category;
import se.prediktera.map.datasetcontainer.transform.category.DataInfoClassEvent;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class InnerColumnPredClass
extends InnerColumnClass {
    private DataTreeInterface model;
    private int modelId = -1;

    public InnerColumnPredClass(String string, DataGroupValues dataGroupValues, CellIdentifierModel cellIdentifierModel, int n) {
        super(null, string, dataGroupValues, cellIdentifierModel, n);
    }

    @Override
    public AbstractInnerColumn<Integer> clone(DataGroupValues dataGroupValues) {
        InnerColumnPredClass innerColumnPredClass = (InnerColumnPredClass)super.clone(dataGroupValues);
        if (this.getArray() != null) {
            innerColumnPredClass.setArray((short[])this.getArray().clone());
        }
        ClassTypes classTypes = this.getObject();
        innerColumnPredClass.holdObject((ClassTypes)classTypes.clone());
        innerColumnPredClass.model = this.model;
        innerColumnPredClass.modelId = this.modelId;
        return innerColumnPredClass;
    }

    @Override
    public Object createCategory(ProgressManager progressManager, DataSet dataSet) throws Exception {
        int n;
        Category category = (Category)dataSet.createModification(progressManager, "obs", "category");
        InnerColumnClass innerColumnClass = category.getInnerColumn();
        ClassTypes classTypes = this.getObject();
        ClassTypes classTypes2 = innerColumnClass.getObject();
        classTypes2.clear();
        for (n = 0; n < classTypes.size(); ++n) {
            ClassSettings classSettings = classTypes.getClassSettings(n);
            classTypes2.add(new ClassSettings(classSettings.getName(), classSettings.getRefindex(), classSettings.getColor()));
        }
        n = this.getSize();
        int n2 = innerColumnClass.getSize();
        for (int i = 0; i < n; ++i) {
            if (i >= n2) continue;
            innerColumnClass.setValueShort(i, this.getValueShort(i));
        }
        return innerColumnClass;
    }

    public DataSet getDataSet() {
        PredictionClasses predictionClasses = (PredictionClasses)this.getParent();
        if (predictionClasses != null && predictionClasses.getDataSet() != null) {
            return predictionClasses.getDataSet();
        }
        if (this.model instanceof AbstractModel) {
            return ((AbstractModel)this.model).getDataSet();
        }
        return null;
    }

    public DataTreeInterface getModel() {
        return this.model;
    }

    @Override
    public void LoadLocal(RandomInputStream randomInputStream, int n) throws IOException {
        super.LoadLocal(randomInputStream, n);
        if (!(n < 2 || this.parent != null && this.parent.isReference())) {
            this.modelId = randomInputStream.ReadBlockInt();
        }
    }

    public void replaceClassWithPrediction(String string, InnerColumnPredClass innerColumnPredClass) {
        int n;
        ClassTypes classTypes = innerColumnPredClass.getObject();
        ClassTypes classTypes2 = this.getObject();
        int n2 = classTypes2.size();
        boolean bl = false;
        for (n = 0; n < classTypes.size(); ++n) {
            String string2 = classTypes.getTypeDescription(n);
            if (string2.equals("-")) {
                bl = true;
                continue;
            }
            classTypes2.addStringNoEvent(string2, classTypes.getColor(n));
        }
        this.beginUpdate();
        n = classTypes2.getTypeDescriptionIndex(string);
        int n3 = this.getSize();
        for (int i = 0; i < n3; ++i) {
            short s = this.getValueShort(i);
            if (s != n) continue;
            int n4 = innerColumnPredClass.getValueShort(i) + n2;
            if (bl) {
                n4 = n4 == n2 ? 0 : --n4;
            }
            this.setValueShort(i, (short)n4);
        }
        this.removeClassByIndex(n);
        classTypes2.remove(n);
        this.endUpdate();
        AbstractDataInfo abstractDataInfo = this.getDataInfo();
        abstractDataInfo.triggerGlobalEvent(new DataInfoClassEvent(abstractDataInfo, 7, null, classTypes2, 0));
    }

    @Override
    public void SaveLocal(RandomOutputStream randomOutputStream, int n) throws IOException {
        super.SaveLocal(randomOutputStream, n);
        if (!this.parent.isReference()) {
            if (this.model != null && this.model.getID() != null) {
                this.modelId = this.model.getID();
            }
            randomOutputStream.WriteBlockInt(this.modelId);
        }
    }

    public void setModel(DataTreeInterface dataTreeInterface) {
        this.model = dataTreeInterface;
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
    }

    @Override
    protected AbstractInnerColumn<Integer> createNew(String string, DataGroupValues dataGroupValues, AbstractDataSource abstractDataSource, int n) {
        return new InnerColumnPredClass(string, dataGroupValues, abstractDataSource, n);
    }
}

