/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.database;

import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JOptionPane;
import se.prediktera.map.common.AbstractRandomStream;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.database.DataBaseManager;
import se.prediktera.map.datasetcontainer.database.DataBaseNode;
import se.prediktera.map.datasetcontainer.database.SelectDatabaseDialog;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Main_GUI;

public class DataBaseControl {
    private static Vector<DataBaseManager> databaseVector = new Vector();

    public static boolean CreateDataBase(DataBaseNode dataBaseNode) {
        if (DataBaseControl.hasDataBase(dataBaseNode.toString())) {
            return false;
        }
        DataBaseManager dataBaseManager = new DataBaseManager(DataBaseControl.getUniqueDatabaseID(), dataBaseNode, dataBaseNode.toString());
        databaseVector.addElement(dataBaseManager);
        if (Main_GUI.get() != null) {
            Main_GUI.get().UpdateProjectTrees();
        }
        return true;
    }

    public static boolean ExportDataBase() {
        int n = SelectDatabaseDialog.showDialog(databaseVector);
        if (n >= 0) {
            try {
                File file = IniManager.getEdbDir();
                DataBaseManager dataBaseManager = databaseVector.elementAt(n);
                File file2 = new File(IniManager.Slash(file.getAbsolutePath()) + dataBaseManager.toString() + ".edb");
                jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Export database to ..", IniManager.getMainFrame());
                jopensaveDialog2.setSelectedFile(new File(String.valueOf(dataBaseManager) + ".edb"));
                if (jopensaveDialog2.saveshow()) {
                    AbstractRandomStream.CopyFile(file2, jopensaveDialog2.getSelectedFile());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return true;
    }

    public static DataBaseManager getDataBaseManagerByName(String string) {
        for (int i = 0; i < databaseVector.size(); ++i) {
            DataBaseManager dataBaseManager = databaseVector.elementAt(i);
            if (!dataBaseManager.toString().equals(string)) continue;
            return dataBaseManager;
        }
        return null;
    }

    public static Vector<DataBaseManager> getDataBaseVector() {
        return databaseVector;
    }

    public static DataTreeInterface getDataTreeInterface(int n) {
        int n2 = n & 0xFF000000;
        for (int i = 0; i < databaseVector.size(); ++i) {
            DataBaseManager dataBaseManager = databaseVector.elementAt(i);
            if (dataBaseManager.getDatabaseID() != n2) continue;
            return dataBaseManager.getDataTreeInterface(n);
        }
        return null;
    }

    public static boolean hasDataBase(String string) {
        for (int i = 0; i < databaseVector.size(); ++i) {
            if (!databaseVector.elementAt(i).toString().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean ImportDataBase() {
        jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Select Datafile to import", IniManager.getMainFrame());
        jopensaveDialog2.addExtension(new String[]{"edb"}, "Evince Database File (*.edb)");
        if (jopensaveDialog2.openshow()) {
            try {
                File file = IniManager.getEdbDir();
                File file2 = jopensaveDialog2.getSelectedFile();
                String string = DataBaseControl.getDatabaseName(file2);
                if (DataBaseControl.hasDataBase(string)) {
                    JOptionPane.showConfirmDialog(IniManager.getMainFrame(), "This database already exists, import aborted", "Already exists", -1, 0, null);
                } else {
                    File file3 = new File(IniManager.Slash(file.getAbsolutePath()) + string + ".edb");
                    AbstractRandomStream.CopyFile(file2, file3);
                    DataBaseManager dataBaseManager = DataBaseControl.LoadDataBase(file3, DataBaseControl.getUniqueDatabaseID());
                    if (dataBaseManager != null) {
                        IniManager.reloadAllDataTrees(dataBaseManager.getRootNode());
                    }
                }
            }
            catch (HeadlessException | IOException exception) {
                // empty catch block
            }
        }
        return true;
    }

    public static void LoadDataBases() {
        try {
            File[] fileArray;
            File[] fileArray2;
            File file = IniManager.getEdbDir();
            if (file != null && file.isDirectory()) {
                fileArray = fileArray2 = file.listFiles();
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    File file2 = fileArray[i];
                    if (!file2.getName().endsWith(".edb")) continue;
                    try {
                        DataBaseControl.LoadDataBase(file2, -1);
                        continue;
                    }
                    catch (Exception exception) {
                        System.out.println("Couldn't load database: " + file2.getName());
                    }
                }
            }
            if ((fileArray2 = new File(IniManager.getStartDir())).isDirectory()) {
                for (File file3 : fileArray = fileArray2.listFiles()) {
                    if (!file3.getName().endsWith(".edb")) continue;
                    try {
                        String string = DataBaseControl.getDatabaseName(file3);
                        if (DataBaseControl.hasDataBase(string)) continue;
                        File file4 = new File(IniManager.Slash(file.getAbsolutePath()) + string + ".edb");
                        AbstractRandomStream.CopyFile(file3, file4);
                        DataBaseControl.LoadDataBase(file4, DataBaseControl.getUniqueDatabaseID());
                    }
                    catch (Exception exception) {
                        System.out.println("Couldn't load database: " + file3.getName());
                    }
                }
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    public static void SaveDataBases() {
        try {
            File file = IniManager.getEdbDir();
            for (int i = 0; i < databaseVector.size(); ++i) {
                try {
                    DataBaseManager dataBaseManager = databaseVector.elementAt(i);
                    File file2 = new File(IniManager.Slash(file.getAbsolutePath()) + dataBaseManager.toString() + ".edb");
                    File file3 = File.createTempFile("temp", "save", file2.getParentFile());
                    RandomOutputStream randomOutputStream = new RandomOutputStream(file3, false, null);
                    randomOutputStream.setDatabaseID(dataBaseManager.getDatabaseID());
                    randomOutputStream.writeHeader(8);
                    randomOutputStream.writeIndexTable();
                    randomOutputStream.setStartIndex((byte)1, randomOutputStream.getFilePointer());
                    dataBaseManager.SaveRoot(randomOutputStream, 0);
                    randomOutputStream.setEndIndex((byte)1, randomOutputStream.getFilePointer());
                    randomOutputStream.writeIndexTable();
                    randomOutputStream.close();
                    file2.delete();
                    file3.renameTo(file2);
                    continue;
                }
                catch (IOException iOException) {
                    System.out.println("Couldn't save EvinceDataBase");
                }
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    public static DataBaseNode searchDataBaseNode(String string) {
        for (int i = 0; i < databaseVector.size(); ++i) {
            DataBaseManager dataBaseManager = databaseVector.elementAt(i);
            DataBaseNode dataBaseNode = dataBaseManager.searchDataBaseNode(string);
            if (dataBaseNode == null) continue;
            return dataBaseNode;
        }
        return null;
    }

    private static String getDatabaseName(File file) {
        String string = file.getName();
        int n = string.indexOf(".");
        if (n > 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    private static int getUniqueDatabaseID() {
        boolean bl = false;
        for (int i = 1; i < 255; ++i) {
            int n = i << 24;
            bl = true;
            for (int j = 0; j < databaseVector.size(); ++j) {
                DataBaseManager dataBaseManager = databaseVector.elementAt(j);
                if (dataBaseManager.getDatabaseID() != n) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return n;
        }
        return 0;
    }

    private static DataBaseManager LoadDataBase(File file, int n) throws IOException {
        RandomInputStream randomInputStream = new RandomInputStream(null, file, null);
        randomInputStream.readFileFramework(true);
        DataBaseManager dataBaseManager = null;
        if (randomInputStream.getMAPversion() == 8) {
            dataBaseManager = new DataBaseManager(DataBaseControl.getDatabaseName(file));
            if (n < 0) {
                dataBaseManager.setDatabaseID(randomInputStream.getDatabaseID());
            } else {
                dataBaseManager.setDatabaseID(n);
            }
            randomInputStream.setDataTreeManager(dataBaseManager);
            DataBaseNode dataBaseNode = (DataBaseNode)randomInputStream.resolveRoot();
            if (dataBaseNode != null) {
                dataBaseManager.setRootNode(dataBaseNode);
                databaseVector.addElement(dataBaseManager);
                for (int i = 0; i < dataBaseNode.getTreeNodeCount(); ++i) {
                    DataTreeManager.LoadIntoMemory(null, null, dataBaseNode.getTreeNodeAt(i), false);
                }
            }
        }
        randomInputStream.close();
        return dataBaseManager;
    }

    private DataBaseControl() {
    }
}

