/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.database;

import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.data.DataInit;
import se.prediktera.map.data.quicktable.QuickTable;
import se.prediktera.map.datasetcontainer.AbstractDataNode;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.database.DataBaseManager;
import se.prediktera.map.datasetcontainer.database.EditableTreeInterface;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;

public abstract class DataBaseNode
extends AbstractDataNode
implements EditableTreeInterface {
    private Project_GUI project_GUI;
    private DataBaseManager dataBaseManager;

    public DataBaseNode(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
    }

    public DataBaseNode(String string) {
        super(string);
    }

    @Override
    public void addToPopupMenu(Project_GUI project_GUI, JPopupMenu jPopupMenu) {
        this.project_GUI = project_GUI;
        this.dataBaseManager = (DataBaseManager)this.dataTreeManager;
        JMenuItem jMenuItem = new JMenuItem("Cut");
        if (!this.dataBaseManager.getRootNode().equals(this)) {
            jMenuItem.addActionListener(actionEvent -> this.dataBaseManager.setCutNode(this));
        } else {
            jMenuItem.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Paste");
        if (this.dataBaseManager.getCutNode() != null) {
            jMenuItem2.addActionListener(actionEvent -> {
                this.cutPaste(this.dataBaseManager.getCutNode());
                this.project_GUI.updateDataTree(this.dataBaseManager.getCutNode());
                this.dataBaseManager.setCutNode(null);
            });
        } else {
            jMenuItem2.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.addSeparator();
        jPopupMenu.add(new AbstractAction("New Folder"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog(Main_GUI.get(), "Choose name for the new folder", DataBaseNode.this.getUniqueName("New Folder"));
                if (string != null) {
                    DataBaseNode dataBaseNode = DataBaseNode.this.createNode(string);
                    DataBaseNode.this.addTreeNode(dataBaseNode);
                    DataBaseNode.this.project_GUI.updateDataTree(dataBaseNode);
                }
            }
        });
        jPopupMenu.add(new AbstractAction("New Item"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog(Main_GUI.get(), "Choose name for the new item", DataBaseNode.this.getUniqueName("New Item"));
                if (string != null) {
                    DataInit dataInit = new DataInit(DataBaseNode.this.createItem(string));
                    DataBaseNode.this.addTreeNode(dataInit.getDataTreeInterface());
                    DataBaseNode.this.project_GUI.getData_GUI().addWindow(new QuickTable(dataInit), false);
                    DataBaseNode.this.project_GUI.updateDataTree(dataInit.getDataTreeInterface());
                }
            }
        });
        jPopupMenu.addSeparator();
        jPopupMenu.add(new AbstractAction("Rename \"" + String.valueOf(this) + "\""){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog(IniManager.getMainFrame(), "Enter the new name:", DataBaseNode.this.toString());
                if (string != null) {
                    DataBaseNode.this.setName(string);
                    DataTreeEvent dataTreeEvent = new DataTreeEvent((Object)this, (DataTreeInterface)DataBaseNode.this, string);
                    DataBaseNode.this.triggerPropertyEvent(dataTreeEvent);
                    dataTreeEvent.cleanUp();
                }
            }
        });
        jPopupMenu.add(new AbstractAction("Erase \"" + String.valueOf(this) + "\""){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataBaseNode.this.project_GUI.purgeSignal();
                DataBaseNode.this.cleanUp();
            }
        });
    }

    public abstract DataTreeInterface createItem(String var1);

    public abstract DataBaseNode createNode(String var1);

    @Override
    public byte getType() {
        return 7;
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.project_GUI = null;
        this.dataBaseManager = null;
    }
}

