/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.datainfo;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import se.prediktera.map.common.BooleanArray;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.data.datasettable.DataSetTable;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.datasetcontainer.DataTreeClass;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.Classes;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.classes.prediction.PredictionClasses;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.datainfo.DataGroupValues;
import se.prediktera.map.datasetcontainer.datainfo.DataInfoEvent;
import se.prediktera.map.datasetcontainer.datainfo.DataInfoListener;
import se.prediktera.map.datasetcontainer.datainfo.Description;
import se.prediktera.map.datasetcontainer.datainfo.IncExclude;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnString;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.transform.AbstractDataTransform;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.datasetcontainer.transform.TransformMatrix;
import se.prediktera.map.datasetcontainer.transform.Transformations;
import se.prediktera.map.datasetcontainer.transform.category.Category;
import se.prediktera.map.main.Data_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.layer.LayerContainer;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public abstract class AbstractDataInfo
extends DataTreeClass
implements DataInfoListener {
    private int rows;
    private List<DataInfoListener> listeners = Collections.synchronizedList(new ArrayList());
    private ArrayList<Classes> oldClasses = null;
    private int groupID = 0;

    public AbstractDataInfo(int n, boolean bl, int n2) {
        super("AbstractDataInfo");
        this.rows = n;
        this.groupID = n2;
        if (bl) {
            this.createGroupValues(n);
            this.addColumn("Inc/Exc", 1);
        }
    }

    public AbstractDataInfo(RandomInputStream randomInputStream, AbstractDataInfo abstractDataInfo) throws IOException {
        super("AbstractDataInfo");
        this.rows = randomInputStream.ReadBlockInt();
        randomInputStream.ReadBlockInt();
        this.createGroupValues(this.rows);
        for (int i = 0; i < this.getGroupSize(); ++i) {
            DataGroupValues dataGroupValues = null;
            if (abstractDataInfo != null) {
                dataGroupValues = abstractDataInfo.getGroupColumnByIndex(i);
            }
            this.getGroupColumnByIndex(i).load(randomInputStream, dataGroupValues);
        }
    }

    public AbstractDataInfo(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.rows = mapProperty.getPropertyInt("rows");
        this.groupID = mapProperty.getPropertyInt("groupID");
    }

    public AbstractInnerColumn addColumn(String string, int n) {
        DataGroupValues dataGroupValues = this.getGroupColumnByType(n);
        if (dataGroupValues == null) {
            return null;
        }
        return dataGroupValues.addColumn(string);
    }

    public void addDescription(String[] stringArray, boolean bl) {
        int n = this.getGroupSize();
        for (int i = 0; i < n; ++i) {
            this.getGroupColumnByIndex(i).addDescription(stringArray, bl);
        }
        this.rows += stringArray.length;
    }

    public void addListener(DataInfoListener dataInfoListener) {
        if (dataInfoListener != this && this.listeners != null && !this.listeners.contains(dataInfoListener)) {
            this.listeners.add(dataInfoListener);
        }
    }

    @Override
    public void addTreeNode(DataTreeInterface dataTreeInterface) {
        if (dataTreeInterface.getClass().equals(Classes.class)) {
            if (this.oldClasses == null) {
                this.oldClasses = new ArrayList();
            }
            this.oldClasses.add((Classes)dataTreeInterface);
        } else {
            super.addTreeNode(dataTreeInterface);
        }
    }

    public void clearAddedDescriptions(int n) {
        int n2 = this.getGroupSize();
        for (int i = 0; i < n2; ++i) {
            this.getGroupColumnByIndex(i).clearAddedDescriptions(n);
        }
        this.rows = n;
    }

    public boolean containsListener(DataInfoListener dataInfoListener) {
        if (this.listeners != null) {
            return this.listeners.contains(dataInfoListener);
        }
        return false;
    }

    public abstract void createDataFromModel(CellIdentifierModel var1, ProgressManager var2, int var3, int var4);

    @Override
    public boolean dataInfoEvent(DataInfoEvent dataInfoEvent) {
        if (this.isCleaned()) {
            return false;
        }
        this.triggerEvent(dataInfoEvent);
        return true;
    }

    public boolean fillColumn(int n, boolean bl) {
        AbstractInnerColumn abstractInnerColumn = this.getAllInnerColumn(n);
        if (abstractInnerColumn instanceof InnerColumnBoolean) {
            InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)abstractInnerColumn;
            DataGroupValues dataGroupValues = abstractInnerColumn.getParent();
            if (dataGroupValues instanceof Transformations) {
                ((Transformations)dataGroupValues).fillColumn(innerColumnBoolean, bl);
            } else {
                innerColumnBoolean.fillColumn(bl);
                return true;
            }
        }
        return false;
    }

    public int getActiveTrueSize(int n) {
        DataGroupValues dataGroupValues = this.getGroupColumnByType(n);
        if (dataGroupValues instanceof IncExclude) {
            return ((IncExclude)dataGroupValues).getActiveTrueSize();
        }
        return 0;
    }

    public int getAllColumnCount() {
        int n = 0;
        int n2 = this.getGroupSize();
        for (int i = 0; i < n2; ++i) {
            n += this.getGroupColumnByIndex(i).getColumnCount();
        }
        return n;
    }

    public AbstractInnerColumn getAllInnerColumn(int n) {
        for (int i = 0; i < this.getGroupSize(); ++i) {
            DataGroupValues dataGroupValues = this.getGroupColumnByIndex(i);
            if (!dataGroupValues.isTableble()) continue;
            int n2 = dataGroupValues.getColumnCount();
            if (n < n2) {
                return dataGroupValues.getInnerColumn(n);
            }
            n -= n2;
        }
        return null;
    }

    public InnerColumnClass getClassByNameOrIndex(String string, int n) {
        Transformations transformations = (Transformations)this.getGroupColumnByType(10);
        if (transformations != null) {
            int n2 = transformations.getColumnCount();
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                if (transformations.getColumnType(i) != 4) continue;
                if (string != null && transformations.getInnerColumn(i).toString().equals(string) || n3 == n) {
                    return (InnerColumnClass)transformations.getInnerColumn(i);
                }
                ++n3;
            }
        }
        return null;
    }

    public String getColumnName(int n) {
        return this.getAllInnerColumn(n).toString();
    }

    public DataSet getDataSet() {
        DataTreeInterface dataTreeInterface = this.getTreeParent();
        if (dataTreeInterface instanceof DataSet) {
            return (DataSet)dataTreeInterface;
        }
        return null;
    }

    public abstract int getDataType();

    public FastDecimal getDoubleAt(int n, int n2, FastDecimal fastDecimal) {
        AbstractInnerColumn abstractInnerColumn = this.getAllInnerColumn(n2);
        if (abstractInnerColumn == null) {
            return null;
        }
        return abstractInnerColumn.getDoubleAt(n, fastDecimal);
    }

    public DataGroupValues getGroupColumnByIndex(int n) {
        DataTreeInterface dataTreeInterface = this.getTreeNodeAt(n);
        if (dataTreeInterface instanceof DataGroupValues) {
            return (DataGroupValues)dataTreeInterface;
        }
        return null;
    }

    public DataGroupValues getGroupColumnByType(int n) {
        int n2 = this.getGroupIndex(n);
        if (n2 == -1) {
            return null;
        }
        return this.getGroupColumnByIndex(n2);
    }

    public int getGroupID() {
        return this.groupID;
    }

    public int getGroupSize() {
        return this.getTreeNodeCount();
    }

    @Override
    public byte getNodeType() {
        return 8;
    }

    public int getOriginalSize() {
        if (this.getTreeParent() == null) {
            return 0;
        }
        return ((DataSet)this.getTreeParent()).getOriginalSize(this.getDataType());
    }

    public AbstractDataInfo getOtherDataInfo() {
        int n = this.getDataType();
        DataTreeInterface dataTreeInterface = this.getTreeParent();
        if (dataTreeInterface instanceof DataTreeClass) {
            DataTreeClass dataTreeClass = (DataTreeClass)dataTreeInterface;
            if (n == 0) {
                return (AbstractDataInfo)dataTreeClass.getNodeByName("Variables");
            }
            return (AbstractDataInfo)dataTreeClass.getNodeByName("Observations");
        }
        return null;
    }

    public AbstractInnerColumn getPrimaryColumnByType(int n) {
        DataGroupValues dataGroupValues = this.getGroupColumnByType(n);
        if (dataGroupValues != null) {
            return dataGroupValues.getPrimaryColumn();
        }
        return null;
    }

    public abstract int[] getRef(boolean var1);

    public int getRowCount() {
        return this.rows;
    }

    public String getScript(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = this.getDataType() == 0 ? "obs" : "var";
        for (int i = this.getGroupSize() - 1; i >= 0; --i) {
            stringBuilder.append(this.getGroupColumnByIndex(i).getScript(string, string2));
        }
        return stringBuilder.toString();
    }

    public int getTableColumnCount() {
        int n = 0;
        int n2 = this.getGroupSize();
        for (int i = 0; i < n2; ++i) {
            DataGroupValues dataGroupValues = this.getGroupColumnByIndex(i);
            if (dataGroupValues == null || !dataGroupValues.isTableble()) continue;
            n += dataGroupValues.getColumnCount();
        }
        return n;
    }

    public AbstractTransform getTransformation(AbstractInnerColumn abstractInnerColumn) {
        Transformations transformations = (Transformations)this.getGroupColumnByType(10);
        if (transformations == null) {
            return null;
        }
        int n = transformations.getColumnCount();
        for (int i = 0; i < n; ++i) {
            AbstractTransform abstractTransform = transformations.getTransform(i);
            if (!abstractTransform.getInnerColumn().equals(abstractInnerColumn)) continue;
            return abstractTransform;
        }
        return null;
    }

    public Transformations getTransformationNode() {
        Transformations transformations = (Transformations)this.getNodeByName("Modifications");
        if (transformations == null) {
            transformations = new Transformations(this.rows);
            this.addTreeNode(transformations);
        }
        return transformations;
    }

    public DataTreeInterface getTransformationNode(AbstractTransform.Type type) {
        if (this.isGroup() && type == AbstractTransform.Type.globalAdd) {
            type = AbstractTransform.Type.localAdd;
        }
        Transformations transformations = this.getTransformationNode();
        LayerContainer layerContainer = null;
        int n = transformations.getTreeNodeCount();
        for (int i = 0; i < n; ++i) {
            DataTreeInterface dataTreeInterface = transformations.getTreeNodeAt(i);
            if (!(dataTreeInterface instanceof LayerContainer) || ((LayerContainer)dataTreeInterface).getTransformationType() != type) continue;
            layerContainer = (LayerContainer)dataTreeInterface;
        }
        if (layerContainer == null) {
            AbstractDataInfo abstractDataInfo;
            if (type == AbstractTransform.Type.globalAdd && (abstractDataInfo = this.getOriginalDataInfo()) != null && abstractDataInfo != this) {
                layerContainer = (LayerContainer)abstractDataInfo.getTransformationNode(type);
                layerContainer = new LayerContainer(layerContainer);
                transformations.addTreeNode(layerContainer);
                return layerContainer;
            }
            layerContainer = new LayerContainer(type);
            transformations.addTreeNode(layerContainer);
        }
        return layerContainer;
    }

    public TransformMatrix getTransformMatrix() {
        DataSet dataSet = this.getDataSet();
        if (dataSet != null) {
            return dataSet.getResultMatrix();
        }
        return null;
    }

    public Object getValueAt(int n, int n2) {
        AbstractInnerColumn abstractInnerColumn = this.getAllInnerColumn(n2);
        if (abstractInnerColumn == null) {
            return null;
        }
        return abstractInnerColumn.getValue(n);
    }

    public void insertData(int n, int n2, boolean bl) {
        int n3 = this.getGroupSize();
        for (int i = 0; i < n3; ++i) {
            DataGroupValues dataGroupValues = this.getGroupColumnByIndex(i);
            if (dataGroupValues.isReference()) continue;
            int n4 = dataGroupValues.getColumnCount();
            for (int j = 0; j < n4; ++j) {
                if (!bl && dataGroupValues.getColumnType(j) == 4) continue;
                Object icType = dataGroupValues.getInnerColumn(j);
                ((AbstractInnerColumn)icType).beginUpdate();
                if (icType != null) {
                    ((AbstractInnerColumn)icType).insert(n, n2);
                }
                ((AbstractInnerColumn)icType).endUpdate();
            }
        }
    }

    public boolean isGroup() {
        return this.groupID != 0;
    }

    public boolean isIncluded(int n) {
        IncExclude incExclude = (IncExclude)this.getGroupColumnByType(1);
        return incExclude.isIncluded(n);
    }

    public boolean isIncluded(int n, int n2) {
        AbstractInnerColumn abstractInnerColumn = this.getAllInnerColumn(n2);
        if (abstractInnerColumn instanceof InnerColumnBoolean && abstractInnerColumn.getParent() != null) {
            return ((InnerColumnBoolean)abstractInnerColumn).getValueBool(n);
        }
        return false;
    }

    @Override
    public boolean isVisibleInTree() {
        return false;
    }

    public int removeDataColumn(AbstractInnerColumn abstractInnerColumn) {
        int n = this.getAllColumnCount();
        for (int i = 0; i < n; ++i) {
            DataGroupValues dataGroupValues;
            AbstractInnerColumn abstractInnerColumn2 = this.getAllInnerColumn(i);
            if (!abstractInnerColumn2.equals(abstractInnerColumn) || (dataGroupValues = abstractInnerColumn2.getParent()) == null) continue;
            dataGroupValues.removeColumn(abstractInnerColumn);
            return i;
        }
        return -1;
    }

    public void removeIndex(int[] nArray, boolean bl) {
        int n = this.getGroupSize();
        for (int i = 0; i < n; ++i) {
            DataGroupValues dataGroupValues = this.getGroupColumnByIndex(i);
            if (dataGroupValues.isReference()) continue;
            int n2 = dataGroupValues.getColumnCount();
            for (int j = 0; j < n2; ++j) {
                if (!bl && dataGroupValues.getColumnType(j) == 4) continue;
                Object icType = dataGroupValues.getInnerColumn(j);
                ((AbstractInnerColumn)icType).beginUpdate();
                if (icType != null) {
                    ((AbstractInnerColumn)icType).removeIndex(nArray);
                }
                ((AbstractInnerColumn)icType).endUpdate();
            }
        }
    }

    public void removeListener(DataInfoListener dataInfoListener) {
        if (this.listeners != null) {
            this.listeners.remove(dataInfoListener);
        }
    }

    public void setByClass(byte by, AbstractModel abstractModel, String string, String string2, int n, boolean bl) {
        AbstractTransform abstractTransform = this.getTransformation(4, string);
        InnerColumnClass innerColumnClass = null;
        if (abstractTransform != null) {
            innerColumnClass = (InnerColumnClass)abstractTransform.getInnerColumn();
        } else {
            PredictionClasses predictionClasses = (PredictionClasses)this.getGroupColumnByType(11);
            if (predictionClasses != null) {
                innerColumnClass = predictionClasses.getPredictionClass(abstractModel, string);
            }
        }
        if (innerColumnClass != null) {
            this.setByClass(by, innerColumnClass, string2, n, bl);
        }
    }

    public void setByClass(byte by, InnerColumnClass innerColumnClass, String string, int n, boolean bl) {
        IncExclude incExclude = (IncExclude)this.getGroupColumnByType(1);
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)incExclude.getPrimaryColumn();
        IncExclude incExclude2 = (IncExclude)this.getGroupColumnByType(by);
        InnerColumnBoolean innerColumnBoolean2 = (InnerColumnBoolean)incExclude2.getPrimaryColumn();
        if (string != null) {
            ClassTypes classTypes = innerColumnClass.getObject();
            n = classTypes.getTypeDescriptionIndex(string);
        }
        for (int i = 0; i < innerColumnClass.getSize(); ++i) {
            if (innerColumnClass.getValueShort(i) != n) continue;
            if (bl || by == 3) {
                innerColumnBoolean.setValueBool(i, true);
            }
            innerColumnBoolean2.setValueBool(i, bl);
        }
    }

    public void setCreated(Project_GUI project_GUI) {
        AbstractDataInfo abstractDataInfo = this.getOriginalDataInfo();
        if (abstractDataInfo != null && abstractDataInfo != this) {
            abstractDataInfo.addListener(this);
        }
        if (this.oldClasses != null) {
            if (abstractDataInfo == this) {
                for (Classes classes : this.oldClasses) {
                    classes.makeTransformations(this);
                    classes.cleanUp();
                }
            }
            this.oldClasses.clear();
            this.oldClasses = null;
        }
        int n = this.getTreeNodeCount();
        for (int i = 0; i < n; ++i) {
            DataTreeInterface dataTreeInterface = this.getTreeNodeAt(i);
            if (!(dataTreeInterface instanceof Transformations)) continue;
            for (int j = 0; j < dataTreeInterface.getTreeNodeCount(); ++j) {
                DataTreeInterface dataTreeInterface2 = dataTreeInterface.getTreeNodeAt(j);
                for (int k = dataTreeInterface2.getTreeNodeCount() - 1; k >= 0; --k) {
                    DataTreeInterface dataTreeInterface3 = dataTreeInterface2.getTreeNodeAt(k);
                    if (!(dataTreeInterface3 instanceof AbstractTransform) || ((AbstractTransform)dataTreeInterface3).setCreated(project_GUI, this)) continue;
                    dataTreeInterface2.removeTreeNode(dataTreeInterface3);
                }
            }
        }
    }

    public void setIncluded(BooleanArray booleanArray, boolean bl, boolean bl2) {
        DataSetTable dataSetTable;
        DataSet dataSet = this.getDataSet();
        IncExclude incExclude = (IncExclude)this.getGroupColumnByType(1);
        IncExclude incExclude2 = (IncExclude)this.getGroupColumnByType(4);
        IncExclude incExclude3 = (IncExclude)this.getGroupColumnByType(5);
        for (int i = 0; i < booleanArray.size(); ++i) {
            if (incExclude2 != null && !incExclude2.isIncluded(i) && (incExclude3 == null || !incExclude3.isIncluded(i))) continue;
            if (booleanArray.get(i)) {
                incExclude.setIncluded(i, bl);
                continue;
            }
            if (!bl2) continue;
            incExclude.setIncluded(i, !bl);
        }
        Data_GUI data_GUI = this.dataTreeManager.getProject().getData_GUI();
        DataSetTable dataSetTable2 = dataSetTable = data_GUI == null ? null : data_GUI.getTableForDataSet(dataSet);
        if (dataSetTable == null) {
            dataSet.updateReferences();
        } else {
            dataSetTable.updateInformation();
            dataSetTable.getCurrentTable().repaint();
        }
        this.triggerObsVarIncExc();
    }

    public void setIncluded(int n, int n2, boolean bl, boolean bl2) {
        AbstractInnerColumn abstractInnerColumn = this.getAllInnerColumn(n2);
        if (abstractInnerColumn instanceof InnerColumnBoolean && abstractInnerColumn.getParent() != null) {
            Transformations transformations;
            Serializable serializable;
            ((InnerColumnBoolean)abstractInnerColumn).setValueBool(n, bl);
            if (bl2 && (serializable = abstractInnerColumn.getParent()) instanceof Transformations && (serializable = (transformations = (Transformations)serializable).getTransform(n2 - 3)) instanceof AbstractDataTransform) {
                ((AbstractDataTransform)serializable).triggerEvent();
            }
        }
    }

    public void setIncluded(int[] nArray, boolean bl) {
        IncExclude incExclude = (IncExclude)this.getGroupColumnByType(1);
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)incExclude.getPrimaryColumn();
        int n = 0;
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == Integer.MAX_VALUE) {
                    for (i = n; i < incExclude.getRows(); ++i) {
                        innerColumnBoolean.setValueBool(i, bl);
                    }
                    break;
                }
                n = nArray[i];
                innerColumnBoolean.setValueBool(n, bl);
            }
        } else {
            innerColumnBoolean.fillColumn(bl);
        }
    }

    public void setRowCount(int n) {
        int n2 = this.getGroupSize();
        for (int i = 0; i < n2; ++i) {
            DataGroupValues dataGroupValues = this.getGroupColumnByIndex(i);
            if (dataGroupValues == null) continue;
            dataGroupValues.setRows(n);
        }
        this.rows = n;
    }

    public void setValueAt(int n, int n2, Object object) {
        this.getAllInnerColumn(n2).setValue(n, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerEvent(DataInfoEvent dataInfoEvent) {
        if (this.listeners != null) {
            List<DataInfoListener> list = this.listeners;
            synchronized (list) {
                ArrayList<DataInfoListener> arrayList = null;
                for (DataInfoListener dataInfoListener : this.listeners) {
                    if (dataInfoListener == null || dataInfoListener.dataInfoEvent(dataInfoEvent)) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList<DataInfoListener>();
                    }
                    arrayList.add(dataInfoListener);
                }
                if (arrayList != null) {
                    this.listeners.removeAll(arrayList);
                }
            }
        }
    }

    public void triggerGlobalEvent(DataInfoEvent dataInfoEvent) {
        if (this.getTreeParent() instanceof DataSet) {
            ((DataSet)this.getTreeParent()).triggetDataInfoEvent(dataInfoEvent);
        } else {
            this.triggerEvent(dataInfoEvent);
        }
    }

    public void triggerObsVarIncExc() {
        this.triggerGlobalEvent(new DataInfoEvent(this, this.getDataType() == 0 ? (byte)11 : 12));
    }

    public void updateReferences() {
        IncExclude incExclude = (IncExclude)this.getGroupColumnByType(1);
        if (incExclude != null) {
            InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)incExclude.getPrimaryColumn();
            int n = this.getGroupSize();
            for (int i = 0; i < n; ++i) {
                DataGroupValues dataGroupValues = this.getGroupColumnByIndex(i);
                if (!(dataGroupValues instanceof IncExclude)) continue;
                ((IncExclude)dataGroupValues).updateReferences(innerColumnBoolean);
            }
        }
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.listeners = null;
    }

    protected final DataGroupValues[] cloneDataGroupValues() {
        DataGroupValues[] dataGroupValuesArray = new DataGroupValues[this.getGroupSize()];
        int n = this.getGroupSize();
        for (int i = 0; i < n; ++i) {
            dataGroupValuesArray[i] = this.getGroupColumnByIndex(i).cloneThis(null);
        }
        return dataGroupValuesArray;
    }

    protected void createGroupValues(int n) {
        this.addTreeNode(new Description(n));
        this.addTreeNode(new IncExclude(n));
    }

    protected AbstractInnerColumn createInnerColumn(int n, boolean bl, String string, CellIdentifierModel cellIdentifierModel, int n2, boolean bl2) {
        Description description = (Description)this.getGroupColumnByType(0);
        if (string != null && string.length() == 0) {
            string = null;
        }
        switch (n) {
            case 5: {
                return this.getGroupColumnByType(8).addColumn(string, cellIdentifierModel, n2, bl2);
            }
            case 14: {
                return this.getGroupColumnByType(12).addColumn(string, cellIdentifierModel, n2, bl2);
            }
            case 15: {
                return this.getGroupColumnByType(13).addColumn(string, cellIdentifierModel, n2, bl2);
            }
            case 6: {
                return this.getGroupColumnByType(9).addColumn(string, cellIdentifierModel, n2, bl2);
            }
            case 3: {
                if (string == null) {
                    string = "Classes";
                }
                Category category = new Category(this, string, this instanceof ObservationInfo);
                category.setLayerVisible(true);
                this.getTransformationNode(AbstractTransform.Type.globalAdd).addTreeNode(category);
                return category.getInnerColumn(this.getTransformationNode());
            }
            case 0: 
            case 1: {
                InnerColumnString innerColumnString = (InnerColumnString)description.addColumn(string, cellIdentifierModel, n2, bl2);
                if (bl) {
                    description.setPrimaryColumn(innerColumnString);
                }
                return innerColumnString;
            }
        }
        return null;
    }

    @Override
    protected void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.writePropertyInt("rows", this.rows);
        randomOutputStream.writePropertyInt("groupID", this.groupID);
    }

    private int getGroupIndex(int n) {
        int n2 = this.getGroupSize();
        for (int i = 0; i < n2; ++i) {
            if (this.getGroupColumnByIndex(i).getTreeType() != n) continue;
            return i;
        }
        return -1;
    }

    private AbstractDataInfo getOriginalDataInfo() {
        if (this.getTreeParent() == null) {
            return null;
        }
        return ((DataSet)this.getTreeParent()).getCase().getDataInfo(this.getDataType());
    }

    private AbstractTransform getTransformation(int n, String string) {
        Transformations transformations = (Transformations)this.getGroupColumnByType(10);
        if (transformations == null) {
            return null;
        }
        int n2 = transformations.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            AbstractTransform abstractTransform = transformations.getTransform(i);
            if (abstractTransform.getTreeType() != n || !abstractTransform.toString().equalsIgnoreCase(string)) continue;
            return abstractTransform;
        }
        return null;
    }
}

