/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.datainfo;

import java.io.IOException;
import java.io.Serializable;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.cleanup.CleanUpClass;
import se.prediktera.map.dataimport.AbstractDataSource;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.datasetcontainer.BasicTreeInterface;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.DataGroupValues;
import se.prediktera.map.datasetcontainer.transform.TransformMatrix;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public abstract class AbstractInnerColumn<type>
extends CleanUpClass
implements BasicTreeInterface,
Cloneable,
Serializable {
    protected DataGroupValues parent = null;
    protected AbstractDataSource ciModel = null;
    private String descr;
    private boolean primary = false;
    private boolean isupdating = false;
    private int dsIndex = -1;
    private TransformMatrix cacheMatrix;
    private boolean isobs;
    private Class ctypecache = null;

    public AbstractInnerColumn(String string, DataGroupValues dataGroupValues, CellIdentifierModel cellIdentifierModel, int n) {
        super("ic");
        this.descr = string;
        this.parent = dataGroupValues;
        if (cellIdentifierModel != null && cellIdentifierModel.isDataSource()) {
            this.ciModel = (AbstractDataSource)cellIdentifierModel;
        }
        this.dsIndex = n;
    }

    public void beginUpdate() {
        this.isupdating = true;
    }

    public AbstractInnerColumn<type> clone(DataGroupValues dataGroupValues) {
        AbstractInnerColumn<type> abstractInnerColumn = null;
        if (dataGroupValues != null) {
            abstractInnerColumn = this.createNew(this.descr, dataGroupValues, this.ciModel, this.dsIndex);
            if (this.ciModel != null) {
                dataGroupValues.setDataSource(this.ciModel);
            }
        } else {
            abstractInnerColumn = this.createNew(this.descr, this.parent, this.ciModel, this.dsIndex);
        }
        abstractInnerColumn.setPrimary(this.isPrimary());
        return abstractInnerColumn;
    }

    public void endUpdate() {
        this.endUpdate((byte)2);
    }

    public void endUpdate(byte by) {
        this.isupdating = false;
        this.parent.triggerEvent(this, by);
    }

    public Object get(String string) throws Exception {
        if (string.equalsIgnoreCase("name")) {
            return this.toString();
        }
        throw new Exception("No such type: " + string);
    }

    public AbstractDataInfo getDataInfo() {
        if (this.parent != null && this.parent.getTreeParent() instanceof AbstractDataInfo) {
            return (AbstractDataInfo)this.parent.getTreeParent();
        }
        return null;
    }

    public int getDataSourceIndex() {
        return this.dsIndex;
    }

    public FastDecimal getDoubleAt(int n, FastDecimal fastDecimal) {
        if (this.ciModel != null) {
            if (this.parent.isObs()) {
                if (n < this.ciModel.getDataRowCount()) {
                    return fastDecimal.parseString(this.ciModel.getRowValueAt(n, this.dsIndex).toString());
                }
                n -= this.ciModel.getDataRowCount();
            }
            if (n < this.ciModel.getDataColumnCount()) {
                return fastDecimal.parseString(this.ciModel.getColumnValueAt(this.dsIndex, n).toString());
            }
            n -= this.ciModel.getDataColumnCount();
        }
        if (n < this.getSize()) {
            return this.getDoubleLocal(n, fastDecimal);
        }
        fastDecimal.setValue(n);
        return fastDecimal;
    }

    public abstract Class getGenericSuperClass();

    public String getName() {
        return this.descr;
    }

    public DataGroupValues getParent() {
        return this.parent;
    }

    public int getParentIndexOf() {
        if (this.parent == null) {
            return -1;
        }
        return this.parent.getIndexOf(this);
    }

    public int getSize() {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.getRows();
    }

    public TransformMatrix getTransformMatrix() {
        if (this.parent != null) {
            return this.parent.getTransformMatrix();
        }
        return null;
    }

    public Object getValue(int n) {
        if (this.ciModel != null) {
            if (this.parent.isObs()) {
                if (n < this.ciModel.getDataRowCount()) {
                    return this.ciModel.getRowValueAt(n, this.dsIndex);
                }
                n -= this.ciModel.getDataRowCount();
            }
            if (n < this.ciModel.getDataColumnCount()) {
                return this.ciModel.getColumnValueAt(this.dsIndex, n);
            }
            return String.valueOf(n -= this.ciModel.getDataColumnCount());
        }
        if (n < this.getSizeLocal()) {
            return this.getValueLocal(n);
        }
        return String.valueOf(n);
    }

    public boolean hasSiblings() {
        if (this.parent != null) {
            return this.parent.getColumnCount() > 1;
        }
        return false;
    }

    public void insert(int n, int n2) {
        if (this.ciModel != null) {
            n2 = this.parent.isObs() ? (n2 -= this.ciModel.getDataRowCount()) : (n2 -= this.ciModel.getDataColumnCount());
        }
        this.insertLocal(n, n2);
    }

    public boolean isDataSource() {
        return this.ciModel != null;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public boolean isUpdating() {
        return this.isupdating;
    }

    public boolean isY(int n) {
        if (this.parent != null) {
            return this.parent.isY(n);
        }
        return false;
    }

    public void Load(RandomInputStream randomInputStream, int n) throws IOException {
        if (n >= 1 && randomInputStream.ReadBlockBoolean()) {
            this.dsIndex = randomInputStream.ReadBlockInt();
        } else {
            this.ciModel = null;
        }
        this.descr = randomInputStream.ReadBlockUTF();
        this.primary = randomInputStream.ReadBlockBoolean();
        this.LoadLocal(randomInputStream, n);
    }

    public abstract void removeIndex(int[] var1);

    public void Save(RandomOutputStream randomOutputStream, int n) throws IOException {
        boolean bl = this.isDataSource();
        randomOutputStream.WriteBlockBoolean(bl);
        if (bl) {
            randomOutputStream.WriteBlockInt(this.dsIndex);
        }
        randomOutputStream.WriteBlockUTF(this.descr);
        randomOutputStream.WriteBlockBoolean(this.primary);
        this.SaveLocal(randomOutputStream, n);
    }

    public void setName(String string) {
        this.descr = string;
    }

    public void setParent(DataGroupValues<AbstractInnerColumn> dataGroupValues) {
        this.parent = dataGroupValues;
    }

    public void setParentPrimary() {
        if (this.parent != null) {
            this.parent.setPrimaryColumn(this);
        }
    }

    public void setPrimary(boolean bl) {
        this.primary = bl;
    }

    public void setSize(int n) {
        if (this.ciModel != null) {
            n = this.parent.isObs() ? (n -= this.ciModel.getDataRowCount()) : (n -= this.ciModel.getDataColumnCount());
        }
        this.setSizeLocal(n);
    }

    public void setValue(int n, type type) {
        if (this.ciModel != null) {
            if (this.parent.isObs()) {
                if (n < this.ciModel.getDataRowCount()) {
                    this.ciModel.setRowValueAt(n, this.dsIndex, type);
                } else {
                    this.setValueLocal(n - this.ciModel.getDataRowCount(), type);
                }
            } else if (n < this.ciModel.getDataColumnCount()) {
                this.ciModel.setColumnValueAt(this.dsIndex, n, type);
            } else {
                this.setValueLocal(n - this.ciModel.getDataColumnCount(), type);
            }
        } else {
            if (this.ctypecache == null) {
                this.ctypecache = this.getGenericSuperClass();
            }
            if (type != null) {
                Class<?> clazz = type.getClass();
                if (this.ctypecache != null && clazz != null) {
                    if (this.ctypecache.equals(FastDecimal.class) && clazz.equals(String.class)) {
                        FastDecimal fastDecimal = new FastDecimal();
                        fastDecimal.parseString(type.toString());
                        this.setValueLocal(n, fastDecimal);
                    } else if (this.ctypecache.equals(clazz)) {
                        this.setValueLocal(n, type);
                    }
                } else {
                    this.setValueLocal(n, type);
                }
            }
        }
    }

    public abstract void setValueLocal(int var1, type var2);

    public String toString() {
        return this.descr;
    }

    @Override
    protected void cleanUpChild() {
        this.parent = null;
        this.ciModel = null;
        this.cacheMatrix = null;
    }

    protected abstract AbstractInnerColumn<type> createNew(String var1, DataGroupValues var2, AbstractDataSource var3, int var4);

    protected FastDecimal getDoubleLocal(int n, FastDecimal fastDecimal) {
        return fastDecimal.parseString(this.getValueLocal(n).toString());
    }

    protected final int getOriginatingRow(int n) {
        if (this.cacheMatrix == null) {
            this.cacheMatrix = this.getTransformMatrix();
            this.isobs = this.parent.isObs();
        }
        if (this.cacheMatrix != null) {
            if (this.isobs) {
                return this.cacheMatrix.getOriginatingRow(n);
            }
            return this.cacheMatrix.getOriginatingColumn(n);
        }
        return n;
    }

    protected int getRowsLocal() {
        int n = 0;
        if (this.parent != null) {
            n = this.parent.getRows();
        }
        if (this.ciModel != null) {
            n = this.parent == null || this.parent.isObs() ? (n -= this.ciModel.getDataRowCount()) : (n -= this.ciModel.getDataColumnCount());
        }
        return n;
    }

    protected abstract int getSizeLocal();

    public final int getType(int n) {
        if (this.cacheMatrix == null) {
            this.cacheMatrix = this.getTransformMatrix();
            this.isobs = this.parent.isObs();
        }
        if (this.cacheMatrix != null) {
            if (this.isobs) {
                return this.cacheMatrix.getRowType(n);
            }
            return this.cacheMatrix.getColumnType(n);
        }
        return 4;
    }

    protected abstract type getValueLocal(int var1);

    protected abstract void insertLocal(int var1, int var2);

    protected abstract void LoadLocal(RandomInputStream var1, int var2) throws IOException;

    protected abstract void SaveLocal(RandomOutputStream var1, int var2) throws IOException;

    protected abstract void setSizeLocal(int var1);
}

