/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.datainfo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.cleanup.CleanUpInterface;
import se.prediktera.map.dataimport.AbstractDataSource;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeMemoryClass;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnString;
import se.prediktera.map.datasetcontainer.datainfo.VariablesInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.event.DataGroupListener;
import se.prediktera.map.datasetcontainer.transform.TransformMatrix;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public abstract class DataGroupValues<icType extends AbstractInnerColumn>
extends DataTreeMemoryClass {
    public static final byte ADDEVENT = 0;
    public static final byte REMOVEEVENT = 1;
    public static final byte UPDATEEVENT = 2;
    public static final byte HOLDOBJECTEVENT = 3;
    public static final int SAVE_VERSION = 3;
    protected int rows;
    protected int columns = -1;
    protected int version = 0;
    private List<icType> vector_cs = null;
    private icType primaryColumn = null;
    protected boolean tableable;
    private DataGroupValues<icType> reference = null;
    private List<DataGroupListener> listeners = new ArrayList<DataGroupListener>();
    private CellIdentifierModel ciModel = null;
    private boolean isObs;

    public DataGroupValues(int n, boolean bl) {
        super("DataGroupValues");
        this.rows = n;
        this.tableable = bl;
        this.vector_cs = new Vector<icType>();
    }

    public DataGroupValues(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.reference = (DataGroupValues)mapProperty.resolveNodeFromName(randomInputStream, "ref");
        this.ciModel = (CellIdentifierModel)((Object)mapProperty.resolveNodeFromName(randomInputStream, "model"));
        this.vector_cs = this.reference == null ? new Vector<icType>() : this.reference.getVector();
        this.rows = mapProperty.getPropertyInt("rows");
        this.tableable = mapProperty.getPropertyBoolean("ta");
        this.columns = mapProperty.getPropertyInt("cols", -1);
        this.isObs = mapProperty.getPropertyBoolean("isobs");
        this.version = mapProperty.getPropertyInt("ver");
    }

    public icType addColumn() {
        return this.addColumn((String)null);
    }

    public icType addColumn(icType icType) {
        if (this.primaryColumn == null) {
            this.setPrimaryColumn(icType);
        }
        ((AbstractInnerColumn)icType).setParent(this);
        this.getVector().add(icType);
        this.triggerEvent((AbstractInnerColumn)icType, (byte)0);
        return icType;
    }

    public icType addColumn(String string) {
        if (string == null) {
            string = String.valueOf(this.getVector().size() + 1);
        }
        return this.addColumn(this.createInnerColumn(string, null, -1));
    }

    public icType addColumn(String string, CellIdentifierModel cellIdentifierModel, int n, boolean bl) {
        if (string == null) {
            string = String.valueOf(this.getVector().size() + 1);
        }
        if (cellIdentifierModel != null && cellIdentifierModel.isDataSource()) {
            this.setDataSource(cellIdentifierModel);
            this.isObs = bl;
        }
        return this.addColumn(this.createInnerColumn(string, cellIdentifierModel, n));
    }

    public void addDescription(String[] stringArray, boolean bl) {
        int n = this.getRows();
        this.rows += stringArray.length;
        int n2 = this.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            icType icType = this.getInnerColumn(i);
            ((AbstractInnerColumn)icType).setSize(((AbstractInnerColumn)icType).getSize() + stringArray.length);
            for (int j = 0; j < stringArray.length; ++j) {
                this.addValue(icType, n + j, stringArray[j], bl);
            }
        }
    }

    public void addListener(DataGroupListener dataGroupListener) {
        if (this.reference == null) {
            if (this.listeners != null && !this.listeners.contains(dataGroupListener)) {
                this.listeners.add(dataGroupListener);
            }
        } else {
            this.reference.addListener(dataGroupListener);
        }
    }

    public abstract void addValue(icType var1, int var2, String var3, boolean var4);

    @Override
    public void beginUpdate() {
    }

    public void clearAddedDescriptions(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            ((AbstractInnerColumn)this.getInnerColumn(i)).setSize(n);
        }
        this.rows = n;
    }

    public DataGroupValues<icType> cloneThis(DataGroupValues<icType> dataGroupValues) {
        DataGroupValues<icType> dataGroupValues2 = this.cloneThis();
        dataGroupValues2.setObs(this.isObs());
        if (this.isReference() && dataGroupValues != null) {
            dataGroupValues2.makeReference(dataGroupValues);
        } else {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                icType icType = this.getInnerColumn(i);
                AbstractInnerColumn abstractInnerColumn = dataGroupValues2.addColumn(((AbstractInnerColumn)icType).clone(dataGroupValues2));
                if (!((AbstractInnerColumn)icType).isPrimary()) continue;
                abstractInnerColumn.setParentPrimary();
            }
        }
        return dataGroupValues2;
    }

    public abstract icType createInnerColumn(String var1, CellIdentifierModel var2, int var3);

    public void endUpdate(icType icType) {
        if (icType != null) {
            this.triggerEvent((AbstractInnerColumn)icType, (byte)2);
        }
    }

    public icType getColumn(int n) {
        List<icType> list = this.getVector();
        if (list != null && n < list.size()) {
            return (icType)((AbstractInnerColumn)list.get(n));
        }
        return null;
    }

    public int getColumnCount() {
        if (this.vector_cs == null && this.columns != -1) {
            return this.columns;
        }
        this.checkAndLoadIntoMemory();
        if (this.vector_cs == null) {
            return 0;
        }
        return this.vector_cs.size();
    }

    public String getColumnName(int n) {
        List<icType> list = this.getVector();
        if (list != null && n < list.size()) {
            return String.valueOf(list.get(n));
        }
        return "N/A";
    }

    public int getColumnType(int n) {
        return -1;
    }

    public DataSet getDataSet() {
        DataTreeInterface dataTreeInterface = this.getTreeParent();
        if (dataTreeInterface instanceof DataSet) {
            return (DataSet)dataTreeInterface;
        }
        return null;
    }

    public int getIndexOf(AbstractInnerColumn abstractInnerColumn) {
        int n = 0;
        int n2 = this.getColumnCount();
        for (n = 0; n < n2; ++n) {
            icType icType = this.getInnerColumn(n);
            if (!icType.equals(abstractInnerColumn)) continue;
            return n;
        }
        return this.getVector().indexOf(abstractInnerColumn) + n;
    }

    @Override
    public String getInformation() {
        StringBuilder stringBuilder = new StringBuilder("<HTML><BODY>");
        stringBuilder.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
        stringBuilder.append("<TR><TD>Columns:</TD><TD>" + this.getColumnCount() + "</TD></TR>");
        stringBuilder.append("<TR><TD>Rows:</TD><TD>").append(this.getRows()).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Data:</TD><TD>");
        stringBuilder.append(this.isLoaded() ? "In memory" : "On disk").append("</TD></TR>");
        stringBuilder.append("</TABLE></BODY></HTML>");
        return stringBuilder.toString();
    }

    public icType getInnerColumn(int n) {
        int n2 = this.getColumnCount();
        if (n2 < 0 || n >= n2 || n < 0) {
            return null;
        }
        this.getVector();
        if (this.vector_cs != null) {
            return (icType)((AbstractInnerColumn)this.vector_cs.get(n));
        }
        return null;
    }

    public icType getInnerColumnByName(String string) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            icType icType = this.getInnerColumn(i);
            if (icType == null || !EvinceScriptCommands.removeSpace(((AbstractInnerColumn)icType).toString()).equalsIgnoreCase(EvinceScriptCommands.removeSpace(string))) continue;
            return icType;
        }
        return null;
    }

    @Override
    public byte getNodeType() {
        return 9;
    }

    public int getOriginalRows() {
        if (this.getTreeParent() == null) {
            return this.rows;
        }
        return ((AbstractDataInfo)this.getTreeParent()).getOriginalSize();
    }

    public icType getPrimaryColumn() {
        this.checkAndLoadIntoMemory();
        return this.primaryColumn;
    }

    public DataGroupValues getReference() {
        return this.reference;
    }

    public int getRows() {
        return this.rows;
    }

    public int getSaveVersion() {
        return this.version;
    }

    public String getScript(String string, String string2) {
        return "";
    }

    public TransformMatrix getTransformMatrix() {
        DataTreeInterface dataTreeInterface = this.getTreeParent();
        if (dataTreeInterface instanceof AbstractDataInfo) {
            return ((AbstractDataInfo)dataTreeInterface).getTransformMatrix();
        }
        return null;
    }

    public Object getValue(int n, int n2) {
        icType icType = this.getInnerColumn(n2);
        if (icType == null || n >= ((AbstractInnerColumn)icType).getSize() || n < 0) {
            return String.valueOf(n);
        }
        return ((AbstractInnerColumn)icType).getValue(n);
    }

    public boolean hasColumnName(String string) {
        for (AbstractInnerColumn abstractInnerColumn : this.getVector()) {
            if (!abstractInnerColumn.toString().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public int indexOfColumn(icType icType) {
        return this.getVector().indexOf(icType);
    }

    public boolean isObs() {
        DataTreeInterface dataTreeInterface = this.getTreeParent();
        if (dataTreeInterface != null && dataTreeInterface.getTreeType() == 0) {
            return true;
        }
        return this.isObs;
    }

    public boolean isPrimaryColumn(int n) {
        return ((AbstractInnerColumn)this.getInnerColumn(n)).isPrimary();
    }

    public boolean isReference() {
        return this.reference != null;
    }

    @Override
    public boolean isSupportClearMemory() {
        return true;
    }

    public boolean isTableble() {
        return this.tableable;
    }

    @Override
    public boolean isVisibleInTree() {
        return false;
    }

    public boolean isY(int n) {
        DataTreeInterface dataTreeInterface = this.getTreeParent();
        if (dataTreeInterface instanceof VariablesInfo) {
            return ((VariablesInfo)dataTreeInterface).isY(n);
        }
        return false;
    }

    public void load(RandomInputStream randomInputStream, DataGroupValues<icType> dataGroupValues) throws IOException {
        if (randomInputStream.ReadBlockBoolean()) {
            this.reference = dataGroupValues;
            if (dataGroupValues != null) {
                this.vector_cs = dataGroupValues.getVector();
            }
        } else {
            this.LoadDataLocal(randomInputStream);
        }
    }

    public void makeReference(DataGroupValues<icType> dataGroupValues) {
        this.reference = dataGroupValues;
        this.vector_cs = dataGroupValues.getVector();
    }

    public void removeAllColumns() {
        this.checkAndLoadIntoMemory();
        if (this.vector_cs != null) {
            for (AbstractInnerColumn abstractInnerColumn : this.vector_cs) {
                abstractInnerColumn.cleanUp();
            }
            this.vector_cs.clear();
        }
    }

    public void removeColumn(AbstractInnerColumn abstractInnerColumn) {
        this.getVector().remove(abstractInnerColumn);
        this.triggerEvent(abstractInnerColumn, (byte)1);
    }

    public void removeListener(DataGroupListener dataGroupListener) {
        if (this.reference == null && this.listeners != null) {
            this.listeners.remove(dataGroupListener);
        } else if (this.reference != null) {
            this.reference.removeListener(dataGroupListener);
        }
    }

    public void save(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.WriteBlockBoolean(this.isReference());
        this.SaveDataLocal(randomOutputStream);
    }

    public void setColumnName(int n, String string) {
        ((AbstractInnerColumn)this.getVector().get(n)).setName(string);
    }

    public void setDataSource(CellIdentifierModel cellIdentifierModel) {
        this.ciModel = cellIdentifierModel;
    }

    public void setObs(boolean bl) {
        this.isObs = bl;
    }

    public void setPrimaryColumn(icType icType) {
        if (!icType.equals(this.primaryColumn)) {
            if (this.primaryColumn != null) {
                ((AbstractInnerColumn)this.primaryColumn).setPrimary(false);
                List<icType> list = this.getVector();
                list.remove(icType);
                list.add(0, icType);
            }
            ((AbstractInnerColumn)icType).setPrimary(true);
            this.primaryColumn = icType;
        }
    }

    public void setPrimaryColumn(int n) {
        icType icType = this.getInnerColumn(n);
        if (icType != null) {
            this.setPrimaryColumn(icType);
        }
    }

    public void setRows(int n) {
        this.rows = n;
        int n2 = this.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            icType icType = this.getInnerColumn(i);
            if (icType == null) continue;
            ((AbstractInnerColumn)icType).setSize(this.rows);
        }
    }

    public void setValue(int n, int n2, String string) {
        icType icType = this.getInnerColumn(n2);
        if (icType instanceof InnerColumnString) {
            ((InnerColumnString)icType).setValue(n, string);
        }
    }

    public void triggerEvent(AbstractInnerColumn abstractInnerColumn, byte by) {
        if (this.reference == null) {
            if (!abstractInnerColumn.isUpdating()) {
                for (DataGroupListener dataGroupListener : this.listeners) {
                    dataGroupListener.dataGroupChanged(abstractInnerColumn, by);
                }
            }
        } else {
            this.reference.triggerEvent(abstractInnerColumn, by);
        }
    }

    @Override
    protected void cleanUpChild() {
        this.cleanUpVector();
        this.primaryColumn = null;
        this.reference = null;
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
        this.ciModel = null;
    }

    @Override
    protected void ClearDataLocal() throws IOException {
        if (!this.isReference()) {
            this.columns = this.vector_cs.size();
            this.cleanUpVector();
            this.primaryColumn = null;
        }
    }

    protected abstract DataGroupValues<icType> cloneThis();

    @Override
    protected void LoadDataLocal(RandomInputStream randomInputStream) throws IOException {
        if (!this.isReference()) {
            this.vector_cs = new Vector<icType>();
            int n = randomInputStream.ReadBlockInt();
            AbstractInnerColumn abstractInnerColumn = null;
            for (int i = 0; i < n; ++i) {
                abstractInnerColumn = (AbstractInnerColumn)this.createInnerColumn(null, this.ciModel, 0);
                if (abstractInnerColumn == null) continue;
                abstractInnerColumn.Load(randomInputStream, this.version);
                if (abstractInnerColumn.isPrimary()) {
                    this.primaryColumn = abstractInnerColumn;
                }
                this.vector_cs.add(abstractInnerColumn);
            }
            if (abstractInnerColumn != null && this.primaryColumn == null) {
                this.setPrimaryColumn(abstractInnerColumn);
            }
        }
    }

    @Override
    protected void SaveDataLocal(RandomOutputStream randomOutputStream) throws IOException {
        if (!this.isReference()) {
            this.version = 3;
            int n = this.getColumnCount();
            randomOutputStream.WriteBlockInt(n);
            for (int i = 0; i < n; ++i) {
                ((AbstractInnerColumn)this.getInnerColumn(i)).Save(randomOutputStream, this.version);
            }
        }
    }

    @Override
    protected void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.writePropertyNode("ref", this.reference);
        randomOutputStream.writePropertyNode("model", (AbstractDataSource)this.ciModel);
        randomOutputStream.writePropertyInt("rows", this.rows);
        randomOutputStream.writePropertyBoolean("ta", this.tableable);
        randomOutputStream.writePropertyInt("cols", this.getColumnCount());
        randomOutputStream.writePropertyBoolean("isobs", this.isObs);
        randomOutputStream.writePropertyInt("ver", 3);
    }

    private void cleanUpVector() {
        if (this.vector_cs != null) {
            for (AbstractInnerColumn abstractInnerColumn : this.vector_cs) {
                abstractInnerColumn.cleanUp();
            }
            this.vector_cs.clear();
        }
        this.vector_cs = null;
        int n = this.size();
        for (int i = n - 1; i >= 0; --i) {
            DataTreeInterface dataTreeInterface = (DataTreeInterface)this.get(i);
            if (!(dataTreeInterface instanceof CleanUpInterface)) continue;
            dataTreeInterface.cleanUp();
        }
        this.clear();
    }

    private List<icType> getVector() {
        this.checkAndLoadIntoMemory();
        return this.vector_cs;
    }
}

