/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.datainfo;

import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.datasetcontainer.datainfo.DataGroupValues;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBooleanIncExc;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class IncExclude
extends DataGroupValues<InnerColumnBoolean> {
    private int activeTrueSize;

    public IncExclude(int n) {
        super(n, true);
    }

    public IncExclude(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.activeTrueSize = mapProperty.getPropertyInt("ats");
    }

    @Override
    public void addValue(InnerColumnBoolean innerColumnBoolean, int n, String string, boolean bl) {
    }

    @Override
    public InnerColumnBoolean createInnerColumn(String string, CellIdentifierModel cellIdentifierModel, int n) {
        return new InnerColumnBooleanIncExc(string, this, cellIdentifierModel, n);
    }

    public int getActiveTrueSize() {
        return this.activeTrueSize;
    }

    @Override
    public String getScript(String object, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = -1;
        int n2 = this.getRows();
        boolean bl = ((InnerColumnBoolean)this.getPrimaryColumn()).defaultValue;
        object = (String)object + "." + this.getScriptPrefix();
        if (this.getClass() == IncExclude.class) {
            object = (String)object + "\"" + string + "\", ";
        }
        for (int i = 0; i < n2; ++i) {
            if (this.isIncluded(i) == bl || i == n2 - 1) {
                if (n == -1) continue;
                int n3 = i;
                if (i == n2 - 1) {
                    ++n3;
                }
                stringBuilder.append((String)object);
                stringBuilder.append("[");
                stringBuilder.append(n + 1);
                stringBuilder.append(", ");
                stringBuilder.append(n3);
                stringBuilder.append("]);");
                n = -1;
                continue;
            }
            if (n != -1) continue;
            n = i;
        }
        return stringBuilder.toString();
    }

    @Override
    public byte getTreeType() {
        return 1;
    }

    public boolean isIncluded(int n) {
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)this.getPrimaryColumn();
        if (innerColumnBoolean != null) {
            return innerColumnBoolean.getValueBool(n);
        }
        return false;
    }

    public void setIncluded(int n, boolean bl) {
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)this.getPrimaryColumn();
        if (n < innerColumnBoolean.getSize()) {
            innerColumnBoolean.setValueBool(n, bl);
        }
    }

    @Override
    public String toString() {
        return "Inc/Exc";
    }

    public void updateReferences(InnerColumnBoolean innerColumnBoolean) {
        this.activeTrueSize = 0;
        InnerColumnBoolean innerColumnBoolean2 = (InnerColumnBoolean)this.getPrimaryColumn();
        if (innerColumnBoolean2 == null || innerColumnBoolean == null) {
            return;
        }
        if (innerColumnBoolean2 instanceof InnerColumnBooleanIncExc) {
            ((InnerColumnBooleanIncExc)innerColumnBoolean2).setOrignalRows(this.getOriginalRows());
        }
        for (int i = 0; i < this.rows; ++i) {
            if (!innerColumnBoolean2.getValueBool(i) || !innerColumnBoolean.getValueBool(i)) continue;
            ++this.activeTrueSize;
        }
    }

    @Override
    protected DataGroupValues<InnerColumnBoolean> cloneThis() {
        return new IncExclude(this.getRows());
    }

    protected String getScriptPrefix() {
        return "exclude(";
    }

    @Override
    protected void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyInt("ats", this.activeTrueSize);
    }
}

