/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.datasetcontainer.datainfo;

import java.io.IOException;
import java.util.BitSet;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.dataimport.AbstractDataSource;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.datainfo.DataGroupValues;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class InnerColumnBoolean
extends AbstractInnerColumn<Boolean> {
    protected boolean[] array;
    protected boolean defaultValue = true;

    public InnerColumnBoolean(String string, DataGroupValues dataGroupValues, CellIdentifierModel cellIdentifierModel, int n) {
        super(string, dataGroupValues, cellIdentifierModel, n);
    }

    @Override
    public AbstractInnerColumn<Boolean> clone(DataGroupValues dataGroupValues) {
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)super.clone(dataGroupValues);
        if (this.array != null) {
            innerColumnBoolean.array = (boolean[])this.array.clone();
        }
        innerColumnBoolean.defaultValue = this.defaultValue;
        return innerColumnBoolean;
    }

    @Override
    public Class getGenericSuperClass() {
        return Boolean.class;
    }

    public void fillColumn(boolean bl) {
        if (bl == this.defaultValue) {
            this.array = null;
        } else {
            int n = this.getSize();
            for (int i = 0; i < n; ++i) {
                this.setValueBool(i, bl);
            }
        }
    }

    public boolean getDefaultValue() {
        return this.defaultValue;
    }

    public int[] getIndex(boolean bl) {
        int n = this.getNumber(bl);
        int n2 = this.getSize();
        int[] nArray = new int[n];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (this.getValueBool(i) != bl) continue;
            nArray[n3++] = i;
        }
        return nArray;
    }

    public BitSet getValues() {
        int n = this.getSize();
        BitSet bitSet = new BitSet(n);
        for (int i = 0; i < n; ++i) {
            bitSet.set(i, this.getValueBool(i));
        }
        return bitSet;
    }

    public void setValues(BitSet bitSet) {
        int n = this.getSize();
        for (int i = 0; i < n; ++i) {
            this.setValueBool(i, bitSet.get(i));
        }
    }

    public int getNumber(boolean bl) {
        int n = this.getSize();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (this.getValueBool(i) != bl) continue;
            ++n2;
        }
        return n2;
    }

    public boolean getValueBool(int n) {
        int n2 = this.getType(n);
        if (n2 == 12 || n2 == 13) {
            return false;
        }
        if (this.array == null || n < 0 || n >= this.array.length) {
            return this.defaultValue;
        }
        return this.array[n];
    }

    @Override
    public Boolean getValueLocal(int n) {
        return this.getValueBool(n);
    }

    public boolean hasUserdefinedValues() {
        return this.array != null;
    }

    @Override
    public void LoadLocal(RandomInputStream randomInputStream, int n) throws IOException {
        block3: {
            int n2;
            block2: {
                if (n != 0) break block2;
                this.array = new boolean[this.getRowsLocal()];
                for (int i = 0; i < this.array.length; ++i) {
                    this.array[i] = randomInputStream.ReadBlockBoolean();
                }
                break block3;
            }
            if (n < 1 || (n2 = randomInputStream.ReadBlockInt()) <= 0) break block3;
            this.array = new boolean[n2];
            for (int i = 0; i < n2; ++i) {
                this.array[i] = randomInputStream.ReadBlockBoolean();
            }
        }
    }

    @Override
    public void removeIndex(int[] nArray) {
        if (this.array != null) {
            boolean[] blArray = new boolean[this.array.length - nArray[nArray.length - 1]];
            for (int i = 0; i < nArray.length - 1; ++i) {
                if (nArray[i] < 0) continue;
                blArray[i - nArray[i]] = this.array[i];
            }
            this.array = blArray;
        }
    }

    @Override
    public void SaveLocal(RandomOutputStream randomOutputStream, int n) throws IOException {
        if (this.array == null) {
            randomOutputStream.WriteBlockInt(0);
        } else {
            int n2 = this.array.length;
            randomOutputStream.WriteBlockInt(n2);
            for (int i = 0; i < n2; ++i) {
                randomOutputStream.WriteBlockBoolean(this.array[i]);
            }
        }
    }

    public void setDefaultValue(boolean bl) {
        this.defaultValue = bl;
    }

    public void setValueBool(int n, boolean bl) {
        if (this.array == null && bl != this.defaultValue) {
            this.array = new boolean[this.getRowsLocal()];
            if (this.defaultValue) {
                for (int i = 0; i < this.array.length; ++i) {
                    this.array[i] = this.defaultValue;
                }
            }
        }
        if (this.array != null && n >= 0 && n < this.array.length) {
            this.array[n] = bl;
        }
    }

    @Override
    public void setValueLocal(int n, Boolean bl) {
        this.setValueBool(n, bl);
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.array = null;
    }

    @Override
    protected AbstractInnerColumn<Boolean> createNew(String string, DataGroupValues dataGroupValues, AbstractDataSource abstractDataSource, int n) {
        return new InnerColumnBoolean(string, dataGroupValues, abstractDataSource, n);
    }

    @Override
    protected FastDecimal getDoubleLocal(int n, FastDecimal fastDecimal) {
        fastDecimal.setValue(this.getValueBool(n) ? 1.0 : 0.0);
        return fastDecimal;
    }

    @Override
    protected int getSizeLocal() {
        if (this.array == null) {
            return this.getRowsLocal();
        }
        return this.array.length;
    }

    @Override
    protected void insertLocal(int n, int n2) {
        if (this.array != null) {
            boolean[] blArray = new boolean[this.array.length + n2];
            System.arraycopy(this.array, 0, blArray, 0, n);
            System.arraycopy(this.array, n, blArray, n + n2, this.array.length - n);
            if (this.defaultValue) {
                for (int i = n; i < n + n2; ++i) {
                    blArray[i] = this.defaultValue;
                }
            }
            this.array = blArray;
        }
    }

    @Override
    protected void setSizeLocal(int n) {
        if (this.array != null && this.array.length < n) {
            boolean[] blArray = new boolean[n];
            System.arraycopy(this.array, 0, blArray, 0, Math.min(n, this.array.length));
            if (this.defaultValue) {
                for (int i = this.array.length; i < blArray.length; ++i) {
                    blArray[i] = this.defaultValue;
                }
            }
            this.array = blArray;
        }
    }
}

